<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
<meta name="robots" content="index, follow">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1">

<title>Author: Harper Ellis – U.S. Investment News Reporter</title>
<meta name="title" content="Author: Harper Ellis – U.S. Investment News Reporter">
<meta name="author" content="Harper Ellis">
<meta name="description" content="Explore Harper Ellis’s U.S. investment reports on market strategy, portfolio trends, capital flows, and long-term wealth.">

<link rel="canonical" href="https://prprimespot.com/author/harper-ellis/">

<meta property="og:title" content="Author: Harper Ellis – U.S. Investment News Reporter">
<meta property="og:description" content="Explore Harper Ellis’s U.S. investment reports on market strategy, portfolio trends, capital flows, and long-term wealth.">
<meta property="og:url" content="https://prprimespot.com/author/harper-ellis/">
<meta property="og:image" content="https://prprimespot.com/uploads/harper-ellis.webp">
<meta property="og:site_name" content="PR Primespot">
<meta property="og:image:width" content="1200">
<meta property="og:image:height" content="630">
<meta property="og:type" content="profile">
<meta property="og:locale" content="en_US">

<!-- Twitter Card Meta Tags -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Author: Harper Ellis – U.S. Investment News Reporter">
<meta name="twitter:description" content="Explore Harper Ellis’s U.S. investment reports on market strategy, portfolio trends, capital flows, and long-term wealth.">
<meta name="twitter:url" content="https://prprimespot.com/author/harper-ellis/">
<meta name="twitter:image" content="https://prprimespot.com/uploads/harper-ellis.webp">
<meta name="twitter:site" content="@prprimespot">
<meta name="twitter:creator" content="@prprimespot">

<link rel="shortcut icon" href="https://prprimespot.com/assets/img/fav-icon.webp" sizes="16x16">

    <!-- css -->
    <link rel="stylesheet" href="../style.css">
    <link rel="stylesheet" href="../responsive.css">
    <link rel="stylesheet" href="../cateagory.css">
    <link rel="stylesheet" href="../author.css">








<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [
    {
      "@type": "WebPage",
      "@id": "https://prprimespot.com/author/harper-ellis/#webpage",
      "name": "Author: Harper Ellis – U.S. Investment News Reporter",
      "url": "https://prprimespot.com/author/harper-ellis/",
      "description": "Explore Harper Ellis’s U.S. investment reports on market strategy, portfolio trends, capital flows, and long-term wealth.",
      "about": {
        "@id": "https://prprimespot.com/author/harper-ellis/#person"
      }
    },

    {
      "@type": "Person",
      "@id": "https://prprimespot.com/author/harper-ellis/#person",
      "name": "Harper Ellis",
      "image": "https://prprimespot.com/uploads/harper-ellis.webp",
      "jobTitle": "U.S. Investment News Reporter",
      "description": "Harper Ellis is a U.S. investing news reporter covering market strategy, portfolio trends, investor sentiment, sector shifts, and major capital flows in U.S. and global markets.",
      "url": "https://prprimespot.com/author/harper-ellis/",
      "sameAs": [
        "https://facebook.com/",
        "https://pinterest.com/",
        "https://instagram.com/"
      ]
    },

    {
      "@type": "BreadcrumbList",
      "@id": "https://prprimespot.com/author/harper-ellis/#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://prprimespot.com/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Author: Harper Ellis",
          "item": "https://prprimespot.com/author/harper-ellis/"
        }
      ]
    },

    {
      "@type": "ItemList",
      "@id": "https://prprimespot.com/author/harper-ellis/#articles",
      "name": "Articles by Harper Ellis",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "item": {
            "@type": "NewsArticle",
            "headline": "AI Startup to Invest $50 Billion in U.S. Data Centers project",
            "articleSection": "Investment",
            "keywords": ["AI Investment", "Data Centers", "Anthropic", "Tech Infrastructure", "U.S. Technology", "Capital Investment"],
            "url": "https://prprimespot.com/investment/ai-startup-to-invest-$50-billion-in-us.php",
            "image": "https://prprimespot.com/uploads/ai-startup-to-invest-$50-billion-in-us-data-centers.webp",
            "author": { "@id": "https://prprimespot.com/author/harper-ellis/#person" },
            "datePublished": "2024-11-12"
          }
        }
      ]
    }
  ]
}
</script>












</head>

<body>
    <!-- top-section -->
    <div class="top-section">
        <div class="top-grid-section">
            <p class="top-text b"><a href="#"><img src="../images/telegram.webp" class="top-icon" alt="icon" height="15"
                        width="15">Sign Up for
                    Our
                    Newsletter</a></p>
            <p class="top-text"><span>New York 65 F</span><img src="../images/cloud.webp" class="top-icon"
                        height="15" width="15" alt="icon">overcast clouds</p>
        </div>
    </div>





    <!-- navbar -->
    <?php include '../header.php'; ?>






    <!-- Search Popup Overlay -->
    <div class="search-overlay">
        <button class="close-search">&times;</button>
        <div class="search-popup-box">
            <input type="text" class="search-input" placeholder="Search...">
        </div>
    </div>


    <!-- flash-news section -->
    <div class="news-scroll">
        <div class="news-scroll-container">
            <div class="news-scroll-container-left">
                <p class="flash-news"><img src="../images/bolt.webp" class="flash" alt="icon" height="15" width="15">
                    Newsflash:</p>
                <div class="news-box">
                    <div class="news-box-inner">
                        <p class="news"><a href="#">Julio Rodríguez Can Fly. Will His Bat Ground Him? <span>10:11
                                    am</span></a></p>
                        <p class="news"><a href="#">Julio Rodríguez Can Fly. Will His Bat Ground Him? <span>10:11
                                    am</span></a></p>
                        <p class="news"><a href="#">Tropical Storm Forecasts Show Possible Landfall <span>10:13
                                    am</span></a></p>
                        <p class="news"><a href="#">SpaceX Prepares for next-icon Starship Launch <span>10:14
                                    am</span></a>
                        </p>
                        <p class="news"><a href="#">Julio Rodríguez Can Fly. Will His Bat Ground Him? <span>10:11
                                    am</span></a></p>
                        <p class="news"><a href="#">Tropical Storm Forecasts Show Possible Landfall <span>10:13
                                    am</span></a></p>
                        <p class="news"><a href="#">SpaceX Prepares for next-icon Starship Launch <span>10:14
                                    am</span></a>
                        </p>
                        <p class="news"><a href="#">Julio Rodríguez Can Fly. Will His Bat Ground Him? <span>10:11
                                    am</span></a></p>
                        <p class="news"><a href="#">Julio Rodríguez Can Fly. Will His Bat Ground Him? <span>10:11
                                    am</span></a></p>
                        <p class="news"><a href="#">Tropical Storm Forecasts Show Possible Landfall <span>10:13
                                    am</span></a></p>
                        <p class="news"><a href="#">SpaceX Prepares for next-icon Starship Launch <span>10:14
                                    am</span></a>
                        </p>
                        <p class="news"><a href="#">Julio Rodríguez Can Fly. Will His Bat Ground Him? <span>10:11
                                    am</span></a></p>
                        <p class="news"><a href="#">Tropical Storm Forecasts Show Possible Landfall <span>10:13
                                    am</span></a></p>
                        <p class="news"><a href="#">SpaceX Prepares for next-icon Starship Launch <span>10:14
                                    am</span></a>
                        </p>
                    </div>
                </div>
            </div>
            <div class="news-scroll-container-right">
                <div class="arrow prev" role="button">
                    <svg class="arrow-icon rotate-left" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                        fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                        stroke-linejoin="round">
                        <polyline points="9 18 15 12 9 6"></polyline>
                    </svg>
                </div>
                <div class="arrow next" role="button">
                    <svg class="arrow-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                        stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <polyline points="9 18 15 12 9 6"></polyline>
                    </svg>
                </div>

            </div>
        </div>
    </div>


    <!-- Scroll to top button -->
    <div class="scroll-to-top">
        <a href="#" class="top-arrow">
            <img src="./images/top.webp" alt="icon" width="20" height="20">
        </a>
    </div>


    <!-- Slide-in Sidebar -->
    <div class="sidebar-overlay">
        <div class="sidebar-content">
            <span class="close-btn">&times;</span>
            <ul class="sidebar-menu">
                <li><a href="./index.html">Home</a></li>
                <li class="has-submenu">
                    <a href="#" class="submenu-toggle">Categories <span class="arrow-d">&#9662;</span></a>
                    <ul class="submenu">
                        <li><a href="#">Technology</a></li>
                        <li><a href="#">Health</a></li>
                        <li><a href="#">Lifestyle</a></li>
                    </ul>
                </li>

                <li><a href="./cateagory.html">Business</a></li>
                <li><a href="#">Breaking News</a></li>
                <li><a href="#">Opinion</a></li>
                <li><a href="#">Podcast</a></li>
                <li><a href="#">Video</a></li>
                <li><a href="#">For Subscribers</a></li>
                <li class="sidebar-more"><a href="#">More</a></li>
                <!-- ✅ Demos with dropdown -->
                <li class="has-submenu second-slide-option">
                    <a href="#" class="submenu-toggle">Demos <span class="arrow-d">&#9662;</span></a>
                    <ul class="submenu">
                        <li><a href="#">Home Main</a></li>
                        <li><a href="#">Home Politics</a></li>
                        <li><a href="#">Home Bussiness</a></li>
                        <li><a href="#">Home Culture</a></li>
                        <li><a href="#">Home Sports</a></li>
                        <li><a href="#">Home Tech-Sceince</a></li>
                        <li><a href="#">Home Military</a></li>
                    </ul>
                </li>

                <!-- ✅ Blog Page with dropdown -->
                <li class="has-submenu second-slide-option">
                    <a href="#" class="submenu-toggle">Blog Page <span class="arrow-d">&#9662;</span></a>
                    <ul class="submenu">
                        <li><a href="#">Blog Page 1</a></li>
                        <li><a href="#">Blog Page 2</a></li>
                        <li><a href="#">Blog Page 3</a></li>
                    </ul>
                </li>
                <li class="second-slide-option"><a href="#">Subscribe</a></li>
                <li class="second-slide-option"><a href="#">Shop</a></li>


                <li class="sidebar-more">social media</li>
                <li>
                    <div class="side-social-media">
                        <img src="./images/twitter-icon.webp" class="side-bar-social-media-icon" alt="icon" width="20"
                            height="20">
                        <img src="./images/facebook-icon.webp" class="side-bar-social-media-icon" alt="icon" width="20"
                            height="20">
                        <img src="./images/instagram-icon.webp" class="side-bar-social-media-icon" alt="icon" width="20"
                            height="20">
                    </div>
                </li>


            </ul>
        </div>
    </div>

    <!-- cateagory-body -->
    <div class="cateagory-body">
        <div class="cateagory-top">
            <p class="main-head">Author: Harper Ellis</p>
            <!-- <p class="path">Home <span>> Business</span></p> -->
        </div>
        <hr class="custom-line b">

        <div class="cateagory-body-section">
            <div class="cateagory-body-section-l">
                <div class="author-box">
                    <div class="author-image">
                        <img src="../uploads/reid-ashton.webp" alt="Adam Gordon">
                    </div>

                    <div class="author-details">
                        <h2>Harper Ellis</h2>
                        <p>
                            Harper Ellis is a U.S. investing news reporter who writes on market strategy, portfolio 
                            patterns, and big capital transfers by big companies. He looks at how investors feel,
                             how sectors change, and the financial forces that affect U.S. and global stock markets.
                             His reporting gives useful information about how to allocate assets, how to make money
                             , and long-term investment opportunities..
                        </p>

                        <div class="author-social">
                            <a href="#"><i class="fa-brands fa-facebook-f"></i></a>
                            <a href="#"><i class="fa-brands fa-pinterest-p"></i></a>
                            <a href="#"><i class="fa-brands fa-instagram"></i></a>
                        </div>
                    </div>
                </div>


                
                <hr class="custom-line b">
                <div class="third-grid-section b">
                    <div class="third-grid-section-img">
                        <a href="#"><img src="../uploads/ai-startup-to-invest-$50-billion-in-us-data-centers.webp" class="main-img b" alt="news-img"
                                width="457" height="293"></a>
                    </div>
                    <div class="third-grid-section-content">
                        <p class="main-head b"><a href="../investment/ai-startup-to-invest-$50-billion-in-us.php">AI Startup to Invest $50 Billion in U.S. Data Centers project</a></p>
                        <p class="paragraph-cateagory">AI startup Anthropic commits $50 billion to U.S. data-centers, boosting jobs, domestic 
                            infrastructure and the AI race—read what it means for tech, real-estate and investment.</p>
                        <div class="img-option b">
                            <p class="time"><img src="../images/clock.webp" class="clock" alt="icon" width="15"
                                    height="15">Nov 12</p>
                            <p class="by"><span>by</span> Harper Ellis</p>
                        </div>
                    </div>
                </div>

                
                 


            </div>
            <div class="vertical-line"></div>
            <div class="cateagory-body-section-s">
                <div class="newsletter-box">
                    <img src="../images/letter.svg" class="newsletter-icon" alt="news-img" width="46" height="50">
                    <h3 class="newsletter-title">The Reporter<br>Newsletter</h3>
                    <p class="newsletter-subtext">Expert picks and exclusive deals,<br>in your inbox.</p>

                    <input type="email" placeholder="Enter your email*" class="newsletter-input">
                    <button class="newsletter-button">Sign Up</button>
                </div>
            </div>
        </div>
    </div>


        <!--     footer -->
    <?php include '../footer.php'; ?>




    <script src="./script.js" Defer></script>

</body>

</html>