<!DOCTYPE html>
<html lang="en">

<head>
   <meta charset="utf-8">
<meta name="robots" content="index, follow">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1">

<title>Author: Casey Quinn – U.S. Technology Reporter</title>
<!-- <meta name="title" content="Author: Casey Quinn – U.S. Technology Reporter"> -->
<meta name="author" content="Casey Quinn">
<meta name="description" content="Read articles by Casey Quinn, a U.S. technology reporter covering innovation, AI, cybersecurity, digital policy, and emerging tech trends.">

<link rel="canonical" href="https://prprimespot.com/author/casey-quinn/">

<meta property="og:title" content="Author: Casey Quinn – U.S. Technology Reporter">
<meta property="og:description" content="Read articles by Casey Quinn, a U.S. technology reporter covering innovation, AI, cybersecurity, digital policy, and emerging tech trends.">
<meta property="og:url" content="https://prprimespot.com/author/casey-quinn/">
<meta property="og:image" content="https://prprimespot.com/uploads/casey-quinn.webp">
<meta property="og:site_name" content="PR Primespot">
<meta property="og:image:width" content="1200">
<meta property="og:image:height" content="630">
<meta property="og:type" content="profile">
<meta property="og:locale" content="en_US">

<!-- Twitter Card Meta Tags -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Author: Casey Quinn – U.S. Technology Reporter">
<meta name="twitter:description" content="Read articles by Casey Quinn, a U.S. technology reporter covering innovation, AI, cybersecurity, digital policy, and emerging tech trends.">
<meta name="twitter:url" content="https://prprimespot.com/author/casey-quinn/">
<meta name="twitter:image" content="https://prprimespot.com/uploads/casey-quinn.webp">
<meta name="twitter:site" content="@prprimespot">
<meta name="twitter:creator" content="@prprimespot">

<link rel="shortcut icon" href="https://prprimespot.com/assets/img/fav-icon.webp" sizes="16x16">

    <!-- css -->
    <link rel="stylesheet" href="../style.css">
    <link rel="stylesheet" href="../responsive.css">
    <link rel="stylesheet" href="../cateagory.css">
    <link rel="stylesheet" href="../author.css">








<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [
    {
      "@type": "WebPage",
      "@id": "https://prprimespot.com/author/casey-quinn/#webpage",
      "name": "Author: Casey Quinn – U.S. Technology Reporter",
      "url": "https://prprimespot.com/author/casey-quinn/",
      "description": "Read articles by Casey Quinn, a U.S. technology reporter covering innovation, AI, cybersecurity, digital policy, and emerging tech trends.",
      "about": {
        "@id": "https://prprimespot.com/author/casey-quinn/#person"
      }
    },

  {
  "@type": "Person",
  "@id": "https://prprimespot.com/author/casey-quinn/#person",
  "name": "Casey Quinn",
  "image": "https://prprimespot.com/uploads/casey-quinn.webp",
  "jobTitle": "U.S. Technology Reporter",
  "description": "Casey Quinn writes about new ideas...",
  "url": "https://prprimespot.com/author/casey-quinn/",
  "sameAs": [
    "https://www.facebook.com/CaseyQuinn",
    "https://www.pinterest.com/CaseyQuinn",
    "https://www.instagram.com/CaseyQuinn"
  ],
  "worksFor": {
    "@type": "Organization",
    "name": "PR Primespot",
    "url": "https://prprimespot.com/"
  }
},

    {
      "@type": "BreadcrumbList",
      "@id": "https://prprimespot.com/author/casey-quinn/#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://prprimespot.com/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Author: Casey Quinn",
          "item": "https://prprimespot.com/author/casey-quinn/"
        }
      ]
    },

    {
      "@type": "ItemList",
      "@id": "https://prprimespot.com/author/casey-quinn/#articles",
      "name": "Articles by Casey Quinn",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "item": {
            "@type": "NewsArticle",
            "headline": "OpenAI urges U.S. to expand Chips Act tax credit for AI infrastructure",
            "articleSection": "Technology",
             "keywords": ["AI", "Chips Act", "US Tech", "Policy"],

            "url": "https://prprimespot.com/technology/openai-urges-us-to-expand-chips-act.php",
            "image": "https://prprimespot.com/uploads/openai-urges-us-to-expand-chips-act-tax-credit.webp",
            "author": { "@id": "https://prprimespot.com/author/casey-quinn/#person" },
            "datePublished": "2024-11-07"
          }
        },
        {
          "@type": "ListItem",
          "position": 2,
          "item": {
            "@type": "NewsArticle",
            "headline": "Advanced Micro Devices (AMD) unveils strategy to lead the $1-trillion compute market",
            "articleSection":"Technology",
            "keywords": ["AMD", "Compute Market", "Semiconductors", "Data Centers", "AI Chips", "Chipmakers", "Technology Strategy", "Enterprise Computing"],

            "url": "https://prprimespot.com/technology/advanced-micro-devices-unveils-strategy.php",
            "image": "https://prprimespot.com/uploads/advanced-micro-devices-unveils-strategy-to-lead-the-1-trillion-compute-market.webp",
            "author": { "@id": "https://prprimespot.com/author/casey-quinn/#person" },
            "datePublished": "2024-11-03"
          }
        },
        {
          "@type": "ListItem",
          "position": 3,
          "item": {
            "@type": "NewsArticle",
            "headline": "U.S. Launches “Technology Prosperity Deals” with Japan & South Korea",
            "articleSection": "Technology",
            "keywords": ["US Technology Policy", "Technology Prosperity Deals", "Japan", "South Korea", "AI Collaboration", "Quantum Computing", "6G", "International Tech Agreements"],

            "url": "https://prprimespot.com/technology/us-launches-technology-prosperity-deals-with-japan.php",
            "image": "https://prprimespot.com/uploads/us-launches-technology-prosperity-deals-with-japan-and-south-korea.webp",
            "author": { "@id": "https://prprimespot.com/author/casey-quinn/#person" },
            "datePublished": "2024-11-02"
          }
        },
        {
          "@type": "ListItem",
          "position": 4,
          "item": {
            "@type": "NewsArticle",
            "headline": "Tech giants vow to defend U.S. users against government spyware threats",
            "articleSection": "Technology",
            "keywords":["Spyware", "Cybersecurity", "Government Surveillance", "Tech Giants", "Apple", "WhatsApp", "Digital Security", "User Privacy"],

            "url": "https://prprimespot.com/technology/tech-giants-vow-to-defend-us-users.php",
            "image": "https://prprimespot.com/uploads/tech-giants-vow-to-defend-us-users-against-government-spyware-threats.webp",
            "author": { "@id": "https://prprimespot.com/author/casey-quinn/#person" },
            "datePublished": "2024-11-02"
          }
        },
        {
          "@type": "ListItem",
          "position": 5,
          "item": {
            "@type": "NewsArticle",
            "headline": "Tech stocks feel heat amid valuation concerns and AI hype",
            "articleSection": "Technology",
            "keywords":["Tech Stocks", "Stock Market", "AI Hype", "Valuation Concerns", "Investor Sentiment", "Market Analysis", "Technology Sector", "Financial Markets"],

            "url": "https://prprimespot.com/technology/tech-stocks-feel-heat-amid-valuation.php",
            "image": "https://prprimespot.com/uploads/tech-stocks-feel-heat-amid-valuation-concerns-and-ai-hype.webp",
            "author": { "@id": "https://prprimespot.com/author/casey-quinn/#person" },
            "datePublished": "2024-11-02"
          }
        }
      ]
    }
  ]
}
</script>












</head>

<body>
    <!-- top-section -->
    <div class="top-section">
        <div class="top-grid-section">
            <p class="top-text b"><a href="#"><img src="../images/telegram.webp" class="top-icon" alt="icon" height="15"
                        width="15">Sign Up for
                    Our
                    Newsletter</a></p>
            <p class="top-text"><span>New York 65 F</span><img src="../images/cloud.webp" class="top-icon"
                        height="15" width="15" alt="icon">overcast clouds</p>
        </div>
    </div>





    <!-- navbar -->
    <?php include '../header.php'; ?>



    <nav class="breadcrumb" aria-label="breadcrumb">
  <ol>
    <li><a href="https://prprimespot.com/">Home</a></li>
    <li>Author: Casey Quinn</li>
  </ol>
</nav>






    <!-- Search Popup Overlay -->
    <div class="search-overlay">
        <button class="close-search">&times;</button>
        <div class="search-popup-box">
            <input type="text" class="search-input" placeholder="Search...">
        </div>
    </div>


    <!-- flash-news section -->
    <div class="news-scroll">
        <div class="news-scroll-container">
            <div class="news-scroll-container-left">
                <p class="flash-news"><img src="../images/bolt.webp" class="flash" alt="icon" height="15" width="15">
                    Newsflash:</p>
                <div class="news-box">
                    <div class="news-box-inner">
                        <p class="news"><a href="#">Julio Rodríguez Can Fly. Will His Bat Ground Him? <span>10:11
                                    am</span></a></p>
                        <p class="news"><a href="#">Julio Rodríguez Can Fly. Will His Bat Ground Him? <span>10:11
                                    am</span></a></p>
                        <p class="news"><a href="#">Tropical Storm Forecasts Show Possible Landfall <span>10:13
                                    am</span></a></p>
                        <p class="news"><a href="#">SpaceX Prepares for next-icon Starship Launch <span>10:14
                                    am</span></a>
                        </p>
                        <p class="news"><a href="#">Julio Rodríguez Can Fly. Will His Bat Ground Him? <span>10:11
                                    am</span></a></p>
                        <p class="news"><a href="#">Tropical Storm Forecasts Show Possible Landfall <span>10:13
                                    am</span></a></p>
                        <p class="news"><a href="#">SpaceX Prepares for next-icon Starship Launch <span>10:14
                                    am</span></a>
                        </p>
                        <p class="news"><a href="#">Julio Rodríguez Can Fly. Will His Bat Ground Him? <span>10:11
                                    am</span></a></p>
                        <p class="news"><a href="#">Julio Rodríguez Can Fly. Will His Bat Ground Him? <span>10:11
                                    am</span></a></p>
                        <p class="news"><a href="#">Tropical Storm Forecasts Show Possible Landfall <span>10:13
                                    am</span></a></p>
                        <p class="news"><a href="#">SpaceX Prepares for next-icon Starship Launch <span>10:14
                                    am</span></a>
                        </p>
                        <p class="news"><a href="#">Julio Rodríguez Can Fly. Will His Bat Ground Him? <span>10:11
                                    am</span></a></p>
                        <p class="news"><a href="#">Tropical Storm Forecasts Show Possible Landfall <span>10:13
                                    am</span></a></p>
                        <p class="news"><a href="#">SpaceX Prepares for next-icon Starship Launch <span>10:14
                                    am</span></a>
                        </p>
                    </div>
                </div>
            </div>
            <div class="news-scroll-container-right">
                <div class="arrow prev" role="button">
                    <svg class="arrow-icon rotate-left" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                        fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                        stroke-linejoin="round">
                        <polyline points="9 18 15 12 9 6"></polyline>
                    </svg>
                </div>
                <div class="arrow next" role="button">
                    <svg class="arrow-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none"
                        stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <polyline points="9 18 15 12 9 6"></polyline>
                    </svg>
                </div>

            </div>
        </div>
    </div>


    <!-- Scroll to top button -->
    <div class="scroll-to-top">
        <a href="#" class="top-arrow">
            <img src="./images/top.webp" alt="icon" width="20" height="20">
        </a>
    </div>


    <!-- Slide-in Sidebar -->
    <div class="sidebar-overlay">
        <div class="sidebar-content">
            <span class="close-btn">&times;</span>
            <ul class="sidebar-menu">
                <li><a href="./index.html">Home</a></li>
                <li class="has-submenu">
                    <a href="#" class="submenu-toggle">Categories <span class="arrow-d">&#9662;</span></a>
                    <ul class="submenu">
                        <li><a href="#">Technology</a></li>
                        <li><a href="#">Health</a></li>
                        <li><a href="#">Lifestyle</a></li>
                    </ul>
                </li>

                <li><a href="./cateagory.html">Business</a></li>
                <li><a href="#">Breaking News</a></li>
                <li><a href="#">Opinion</a></li>
                <li><a href="#">Podcast</a></li>
                <li><a href="#">Video</a></li>
                <li><a href="#">For Subscribers</a></li>
                <li class="sidebar-more"><a href="#">More</a></li>
                <!-- ✅ Demos with dropdown -->
                <li class="has-submenu second-slide-option">
                    <a href="#" class="submenu-toggle">Demos <span class="arrow-d">&#9662;</span></a>
                    <ul class="submenu">
                        <li><a href="#">Home Main</a></li>
                        <li><a href="#">Home Politics</a></li>
                        <li><a href="#">Home Bussiness</a></li>
                        <li><a href="#">Home Culture</a></li>
                        <li><a href="#">Home Sports</a></li>
                        <li><a href="#">Home Tech-Sceince</a></li>
                        <li><a href="#">Home Military</a></li>
                    </ul>
                </li>

                <!-- ✅ Blog Page with dropdown -->
                <li class="has-submenu second-slide-option">
                    <a href="#" class="submenu-toggle">Blog Page <span class="arrow-d">&#9662;</span></a>
                    <ul class="submenu">
                        <li><a href="#">Blog Page 1</a></li>
                        <li><a href="#">Blog Page 2</a></li>
                        <li><a href="#">Blog Page 3</a></li>
                    </ul>
                </li>
                <li class="second-slide-option"><a href="#">Subscribe</a></li>
                <li class="second-slide-option"><a href="#">Shop</a></li>


                <li class="sidebar-more">social media</li>
                <li>
                    <div class="side-social-media">
                        <img src="./images/twitter-icon.webp" class="side-bar-social-media-icon" alt="icon" width="20"
                            height="20">
                        <img src="./images/facebook-icon.webp" class="side-bar-social-media-icon" alt="icon" width="20"
                            height="20">
                        <img src="./images/instagram-icon.webp" class="side-bar-social-media-icon" alt="icon" width="20"
                            height="20">
                    </div>
                </li>


            </ul>
        </div>
    </div>

    <!-- cateagory-body -->
    <div class="cateagory-body">
        <div class="cateagory-top">
            <h1 class="main-head">Author: Casey Quinn</h1> 
            <!-- <p class="path">Home <span>> Business</span></p> -->
        </div>
        <hr class="custom-line b">

        <div class="cateagory-body-section">
            <div class="cateagory-body-section-l">
                <div class="author-box">
                    <div class="author-image">
                        <img src="../uploads/casey-quinn.webp" alt="Casey Quinn" loading="lazy">
                    </div>

                    <div class="author-details">
                        <h2>Casey Quinn</h2>
                        <p>
                            Casey Quinn is a U.S. technology reporter that writes on new ideas, digital policy, and new
                             developments in the internet business. He focuses on studying new AI technologies,
                              cybersecurity threats, and the quickly changing rules and laws that govern U.S. technology.
                               His reporting makes it easy to see how new technology, changes in the market, and decisions
                                made by policymakers affect the future of the digital economy.
                        </p>

                        <div class="author-social">
                            <a href="#"><i class="fa-brands fa-facebook-f"></i></a>
                            <a href="#"><i class="fa-brands fa-pinterest-p"></i></a>
                            <a href="#"><i class="fa-brands fa-instagram"></i></a>
                        </div>
                    </div>
                </div>
                <hr class="custom-line b">
                <div class="third-grid-section b">
                    <div class="third-grid-section-img">
                        <a href="#"><img src="../uploads/openai-urges-us-to-expand-chips-act-tax-credit.webp" class="main-img b" alt="OpenAI urges U.S. to expand Chips Act tax credit"
                                width="457" height="293"></a>
                    </div>
                    <div class="third-grid-section-content">
                        <h2 class="main-head b"><a href="../technology/openai-urges-us-to-expand-chips-act.php">OpenAI urges U.S. to expand Chips Act tax credit for AI infrastructure</a></h2>
                        <p class="paragraph-cateagory">OpenAI is urging the U.S. government to expand the tax credit
                     under the Chips Act to cover AI infrastructure — including servers, data-centers and grid 
                     components — in a bid to strengthen America’s artificial-intelligence leadership</p>
                        <div class="img-option b">
                            <p class="time"><img src="../images/clock.webp" class="clock" alt="icon" width="15"
                                    height="15">Nov 7</p>
                            <p class="by"><span>by</span> Casey Quinn</p>
                        </div>
                    </div>
                </div>
                <hr class="custom-line b">
                <div class="third-grid-section b">
                    <div class="third-grid-section-img">
                        <a href="#"><img src="../uploads/advanced-micro-devices-unveils-strategy-to-lead-the-1-trillion-compute-market.webp" class="main-img b" alt="AMD unveils strategy to lead the trillion-dollar compute market"
                                width="457" height="293"></a>
                    </div>
                    <div class="third-grid-section-content">
                        <h2 class="main-head b"><a href="../technology/advanced-micro-devices-unveils-strategy.php">Advanced Micro Devices (AMD) unveils strategy to lead the $1-trillion compute market</a></h2>
                        <p class="paragraph-cateagory">Advanced Micro Devices (AMD) unveiled a bold strategy to lead the 
                    $1 trillion compute market—targeting revenue growth of ≥35% CAGR, data-center revenue growth of >60%,
                     and non-GAAP EPS exceeding $20 within the next three to five years.</p>
                        <div class="img-option b">
                            <p class="time"><img src="../images/clock.webp" class="clock" alt="icon" width="15"
                                    height="15">Nov 3</p>
                            <p class="by"><span>by</span> Casey Quinn</p>
                        </div>
                    </div>
                </div>
                <hr class="custom-line b">
                <div class="third-grid-section b">
                    <div class="third-grid-section-img">
                        <a href="#"><img src="../uploads/us-launches-technology-prosperity-deals-with-japan-and-south-korea.webp" class="main-img b" alt="us-launches-technology-prosperity-deals-with-japan-and-south-korea"
                                width="457" height="293"></a>
                    </div>
                    <div class="third-grid-section-content">
                        <h2 class="main-head b"><a href="../technology/us-launches-technology-prosperity-deals-with-japan.php">U.S. Launches “Technology Prosperity Deals” with Japan & South Korea</a></h2>
                        <p class="paragraph-cateagory">The U.S. has signed landmark “Technology Prosperity Deals”
                     with Japan and South Korea to deepen collaboration on AI, quantum computing, biotechnology,
                      space, 6G and fusion energy—aligning innovation, standards and national-security goals.</p>
                        <div class="img-option b">
                            <p class="time"><img src="../images/clock.webp" class="clock" alt="icon" width="15"
                                    height="15">Nov 2</p>
                            <p class="by"><span>by</span> Casey Quinn</p>
                        </div>
                    </div>
                </div>
                <hr class="custom-line b">
                <div class="third-grid-section b">
                    <div class="third-grid-section-img">
                        <a href="#"><img src="../uploads/tech-giants-vow-to-defend-us-users-against-government-spyware-threats.webp" class="main-img b" alt="tech-giants-vow-to-defend-us-users-against-government-spyware-threats"
                                width="457" height="293"></a>
                    </div>
                    <div class="third-grid-section-content">
                        <h2 class="main-head b"><a href="../technology/tech-giants-vow-to-defend-us-users.php">Tech giants vow to defend U.S. users against government spyware threats</a></h2>
                        <p class="paragraph-cateagory">Major tech firms – including Apple and WhatsApp – have pledged
                     to alert U.S. users if government-linked spyware targets their devices, signaling a growing battle
                      over digital surveillance and civil liberties</p>
                        <div class="img-option b">
                            <p class="time"><img src="../images/clock.webp" class="clock" alt="icon" width="15"
                                    height="15">Nov 2</p>
                            <p class="by"><span>by</span> Casey Quinn</p>
                        </div>
                    </div>
                </div>
                  

                <hr class="custom-line b">
                <div class="third-grid-section b">
                    <div class="third-grid-section-img">
                        <a href="#"><img src="../uploads/tech-stocks-feel-heat-amid-valuation-concerns-and-ai-hype.webp" class="main-img b" alt="tech-stocks-feel-heat-amid-valuation-concerns-and-ai-hype"
                                width="457" height="293"></a>
                    </div>
                    <div class="third-grid-section-content">
                        <h2 class="main-head b"><a href="../technology/tech-stocks-feel-heat-amid-valuation.php">Tech stocks feel heat amid valuation concerns and AI hype</a></h2>
                        <p class="paragraph-cateagory">Tech stocks are falling because people are worried about high prices
                     and the growing buzz around AI. Investors are changing their minds about how major companies will
                      do because of stretched multiples and changing attitudes.</p>
                        <div class="img-option b">
                            <p class="time"><img src="../images/clock.webp" class="clock" alt="icon" width="15"
                                    height="15">Nov 2</p>
                            <p class="by"><span>by</span> Casey Quinn</p>
                        </div>
                    </div>
                </div>

                 


            </div>
            <div class="vertical-line"></div>
            <div class="cateagory-body-section-s">
                <div class="newsletter-box">
                    <img src="../images/letter.svg" class="newsletter-icon" alt="news-img" width="46" height="50">
                    <h3 class="newsletter-title">The Reporter<br>Newsletter</h3>
                    <p class="newsletter-subtext">Expert picks and exclusive deals,<br>in your inbox.</p>

                    <label for="newsletter-email" class="sr-only">Email</label>
<input id="newsletter-email" type="email" placeholder="Enter your email*" class="newsletter-input">

                    <button class="newsletter-button">Sign Up</button>
                </div>
            </div>
        </div>
    </div>


        <!--     footer -->
    <?php include '../footer.php'; ?>




    <script src="./script.js" Defer></script>

</body>

</html>