<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Erlin-News - <?php echo htmlspecialchars($news['title']); ?></title>
    <link rel="stylesheet" href="<?php echo asset('assets/css/style.css'); ?>">
    <style>
      /* Additional styles for the news article page */
      .news-article-container {
        max-width: 1200px;
        margin: 0 auto;
        padding: 20px;
      }
      
      .news-article-header {
        text-align: center;
        margin-bottom: 30px;
        border-bottom: 1px solid #eee;
        padding-bottom: 20px;
      }
      
      .news-article-title {
        font-size: 2.5rem;
        margin-bottom: 20px;
        color: #333;
      }
      
      .news-article-image {
        max-width: 100%;
        height: auto;
        margin: 20px 0;
        border-radius: 5px;
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
      }
      
      .news-article-content {
        font-size: 1.1rem;
        line-height: 1.7;
        color: #444;
        margin-bottom: 40px;
      }
      
      .news-meta {
        color: #777;
        font-size: 0.9rem;
        margin-bottom: 20px;
      }
    </style>
  </head>
  
  <body>
    <div class="s-sidebar" id="s-sidebar">
      <div class="s-logo-section">
        <h1 class="s-logo">
          <img
            src="<?php echo asset('assets/img/mainlogo.webp'); ?>"
            alt="Logo"
          >
        </h1>
        <div class="s-menu-icon" id="s-close-btn">≪</div>
      </div>

      <div class="s-section">
        <h2 class="s-section-title">HAPPY LIFE</h2>
        <div class="img-zoom-container">
          <img
            src="<?php echo asset('assets/img/img1.webp'); ?>"
            alt="Happy Life"
            class="s-main-image"
          >
        </div>
      </div>

      <div class="s-section">
        <h2 class="s-section-title">WHAT NEWS?</h2>

        <div class="s-news-item">
          <div class="img-zoom-container">
            <img
              src="<?php echo asset('assets/img/img2.webp'); ?>"
              class="s-thumb"
              alt="Scenic view"
            >
          </div>

          <p class="s-news-title">
            Lorem ipsum dolor sit amet consectetur adipisicing elit.
          </p>
        </div>
        <hr>
        <div class="s-news-item">
          <div class="img-zoom-container">
            <img
              src="<?php echo asset('assets/img/img3.webp'); ?>"
              class="s-thumb"
              alt="Road view"
            >
          </div>

          <p class="s-news-title">
            Lorem ipsum dolor sit amet consectetur adipisicing elit.
          </p>
        </div>
        <hr>
        <div class="s-news-item">
          <div class="img-zoom-container">
            <img
              src="<?php echo asset('assets/img/img4.webp'); ?>"
              class="s-thumb"
              alt="Street view"
            >
          </div>

          <p class="s-news-title">
            Lorem ipsum dolor sit amet consectetur adipisicing elit.
          </p>
        </div>

        <div class="sidebar-line-icon">
          <div class="s-icons">
            <img src="<?php echo asset('assets/img/instagram.svg'); ?>" alt="Instagram logo">
            <img src="<?php echo asset('assets/img/twitter.svg'); ?>" alt="Twitter logo">
            <img src="<?php echo asset('assets/img/substack.svg'); ?>" alt="Substack logo">
            <img src="<?php echo asset('assets/img/medium.svg'); ?>" alt="Medium logo">
          </div>
          <div class="b-divider"></div>
        </div>
        <hr>
      </div>
    </div>

    <div class="s-overlay" id="s-overlay"></div>

    <div class="header">
      <div class="left-icons">
        <button class="s-toggle-btn" id="s-toggle-btn">
          <img src="<?php echo asset('assets/img/menubar.png'); ?>" alt="menu" class="icon-img menubar">
        </button>
        <button id="light-btn" class="icon-btn">
          <img src="<?php echo asset('assets/img/sun.png'); ?>" alt="Light mode" class="icon-img sun">
        </button>
        <button id="dark-btn" class="icon-btn">
          <img src="<?php echo asset('assets/img/icons8-moon-24.png'); ?>" alt="Light mode" class="icon-img moon">
        </button>
      </div>

      <div class="right-icons">
        <img src="<?php echo asset('assets/img/instagram.svg'); ?>" alt="Instagram logo">
        <img src="<?php echo asset('assets/img/twitter.svg'); ?>" alt="Twitter logo">
        <img src="<?php echo asset('assets/img/substack.svg'); ?>" alt="Substack logo">
        <img src="<?php echo asset('assets/img/medium.svg'); ?>" alt="Medium logo">
      </div>
    </div>
    
    <div class="center-date-wrapper">
      <div class="center-date">
        <div class="month">JUL</div>
        <div class="day">29</div>
      </div>
    </div>
    
    <div class="top-header">
      <div class="header-column left">
        <h3>MEET & TALKS</h3>
        <div class="info-left">
          <i class="fas fa-location-dot"></i>
          <span>Horlington Street, 1723 – CA</span>
        </div>
        <div class="info-left">
          <i class="fas fa-envelope"></i>
          <span>Office@yourdomainoffice.com</span>
        </div>
      </div>

      <div class="header-column center">
        <img
          src="<?php echo asset('assets/img/mainlogo.webp'); ?>"
          alt="Erlin Blog Logo"
        >
        <p class="tagline">BLOG - MAGAZINE - GRID NEWS - CLASSICAL NEWSPAPER</p>
      </div>

      <div class="header-column right">
        <h3>ABOUT LIFE STYLE</h3>
        <div class="info">
          <i class="fas fa-phone"></i>
          <span>(66)2345-678, (66)098-765</span>
        </div>
        <div class="info">
          <i class="fas fa-life-ring"></i>
          <span>support@yoursupportdomain.com</span>
        </div>
      </div>
    </div>
    
    <!-- BREAKING NEWS TICKER -->
    <div class="breaking-wrapper">
      <div class="breaking-label">BREAKING</div>
      <div class="ticker">
        <div class="ticker-content">
          <a href="<?php echo route('breaking.details', 1); ?>">
            Major earthquake hits coastal region
          </a>
          <a href="<?php echo route('breaking.details', 2); ?>">
            Global stock markets fall sharply
          </a>
          <a href="<?php echo route('breaking.details', 3); ?>">
            Heavy rainfall expected in several states
          </a>
          <a href="<?php echo route('breaking.details', 4); ?>">
            New AI breakthrough announced today
          </a>
        </div>
      </div>
    </div>

    <div class="topbar">
      <div class="menu">
        MENU
        <div id="mob-toggle-btn" class="hamburger">
          <span></span><span></span><span></span>
        </div>
      </div>
    </div>

    <nav class="bottom-bar">
      <div class="menu-wrapper">
        <ul class="menu">
          <!-- HOME -->
          <li class="<?php echo request()->routeIs('home') ? 'active' : ''; ?>">
            <a href="<?php echo route('home'); ?>">HOME</a>
          </li>

          <!-- DYNAMIC CATEGORIES FROM DATABASE -->
          <?php foreach($categories as $cat): ?>
            <li class="<?php echo request()->is('category/' . $cat->category_name) ? 'active' : ''; ?>">
              <a href="<?php echo route('category.show', $cat->category_name); ?>">
                <?php echo strtoupper($cat->category_name); ?>
              </a>
            </li>
          <?php endforeach; ?>
        </ul>
      </div>
    </nav>
    
    <div class="mob-sidebar">
      <ul class="mob-menu">
        <!-- HOME -->
        <li class="<?php echo request()->routeIs('home') ? 'active' : ''; ?>">
          <a href="<?php echo route('home'); ?>">Home</a>
        </li>

        <!-- DYNAMIC CATEGORIES FROM DATABASE -->
        <?php foreach($categories as $cat): ?>
          <li class="<?php echo request()->is('category/' . $cat->category_name) ? 'active' : ''; ?>">
            <a href="<?php echo route('category.show', $cat->category_name); ?>">
              <?php echo $cat->category_name; ?>
            </a>
          </li>
        <?php endforeach; ?>
      </ul>
    </div>

    <!-- NEWS ARTICLE CONTENT -->
    <div class="news-article-container">
      <div class="news-article-header">
        <h1 class="news-article-title"><?php echo htmlspecialchars($news['title']); ?></h1>
        <div class="news-meta">
          <span>Published on: <?php echo date('F j, Y'); ?></span> | 
          <span>Category: <?php echo htmlspecialchars($news['category'] ?? 'General'); ?></span>
        </div>
      </div>
      
      <div class="news-article-content">
        <img src="<?php echo asset($news['image']); ?>" alt="<?php echo htmlspecialchars($news['title']); ?>" class="news-article-image">
        <p><?php echo nl2br(htmlspecialchars($news['description'])); ?></p>
      </div>
    </div>

    <footer class="footer-container">
      <div class="logo">Erlin-News</div>

      <div class="footer-columns">
        <div class="footer-col-l">
          <h5>About Us</h5>
          <p>
            Lorem ipsum dolor sit amet consectetur adipisicing elit.
            Exercitationem distinctio mollitia ea reprehenderit delectus
            architecto itaque dolores, fugit
          </p>
          <p>
            Lorem ipsum dolor sit amet consectetur adipisicing elit. Ratione nam
            exercitationem doloribus fuga nobis soluta quos est vel nesciunt
            nostrum
          </p>
        </div>

        <div class="footer-col">
          <div class="section-title">BLOG SCHEME</div>
          <p>Lorem ipsum dolor sit amet consectetur</p>
          <p>
            Lorem ipsum dolor sit amet consectetur adipisicing elit.
            Exercitationem, esse temporibus. Iure nemo, et, assumenda nulla
            tempore quaerat pariatur dolores perspiciatis accusantium eius
            consequuntur
          </p>
          <p>Lorem ipsum dolor sit amet consectetur</p>
        </div>

        <div class="footer-col-r">
          <h5>Theme Filosofi</h5>
          <p>
            Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officiis
            eligendi beatae quasi eum laudantium fugiat ipsam esse culpa
            consectetur voluptas
          </p>
          <p>
            Lorem ipsum dolor sit amet consectetur, adipisicing elit. Optio
            aperiam beatae assumenda ex debitis, explicabo vero eius ullam vitae
            itaque
          </p>
        </div>
      </div>

      <div class="footer-menu">
        <a href="#">Blog</a> | <a href="#">Contact Us</a> |
        <a href="#">Module</a> |
        <a href="#">Privacy Policy</a>
      </div>
    </footer>
    
    <div class="h-divider"></div>
    <div class="footer-copy">
      © Copyright 2022 - ERLINNEWS. All Rights Reserved
    </div>

    <div class="scroll-top" onclick="scrollToTop()">
      <span><i class="fas fa-chevron-up"></i></span>
    </div>
    
    <script src="<?php echo asset('assets/js/script.js'); ?>"></script>
    <script>
      document.querySelector(".ticker-content").addEventListener("mouseenter", function() {
          this.style.animationPlayState = "paused";
      });

      document.querySelector(".ticker-content").addEventListener("mouseleave", function() {
          this.style.animationPlayState = "running";
      });
    </script>
  </body>
</html><?php /**PATH C:\xampp\htdocs\erlin-newss\resources\views/news/breaking-details.blade.php ENDPATH**/ ?>