<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Erlin-News</title>
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>">
  </head>

  <body>
    <div class="s-sidebar" id="s-sidebar">
      <div class="s-logo-section">
        <h1 class="s-logo">
          <img src="<?php echo e(asset('assets/img/mainlogo.webp')); ?>" alt="Logo">
        </h1>
        <div class="s-menu-icon" id="s-close-btn">≪</div>
      </div>

      <div class="s-section">
        <h2 class="s-section-title">HAPPY LIFE</h2>
        <div class="img-zoom-container">
          <img src="<?php echo e(asset('assets/img/img1.webp')); ?>" alt="Happy Life" class="s-main-image">
        </div>
      </div>

      <div class="s-section">
        <h2 class="s-section-title">WHAT NEWS?</h2>

        <?php $__currentLoopData = $latestNews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $news): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="s-news-item">
          <div class="img-zoom-container">
            <?php if($news->photo && file_exists(storage_path('app/public/news/' . $news->photo))): ?>
              <img src="<?php echo e(asset('storage/news/' . $news->photo)); ?>" class="s-thumb" alt="<?php echo e($news->news_title); ?>">
            <?php else: ?>
              <img src="<?php echo e(asset('assets/img/img' . (($loop->iteration % 4) + 1) . '.webp')); ?>" class="s-thumb" alt="<?php echo e($news->news_title); ?>">
            <?php endif; ?>
          </div>
          <p class="s-news-title">
            <?php echo e(Str::limit($news->news_title, 50)); ?>

          </p>
        </div>
        <?php if(!$loop->last): ?>
        <hr>
        <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <div class="sidebar-line-icon">
          <div class="s-icons">
            <img src="<?php echo e(asset('assets/img/instagram.svg')); ?>" alt="Instagram logo">
            <img src="<?php echo e(asset('assets/img/twitter.svg')); ?>" alt="Twitter logo">
            <img src="<?php echo e(asset('assets/img/substack.svg')); ?>" alt="Substack logo">
            <img src="<?php echo e(asset('assets/img/medium.svg')); ?>" alt="Medium logo">
          </div>
          <div class="b-divider"></div>
        </div>
        <hr>
      </div>
    </div>

    <div class="s-overlay" id="s-overlay"></div>

    <!-- HEADER -->
    <div class="header">
      <div class="left-icons">
        <button class="s-toggle-btn" id="s-toggle-btn">
          <img src="<?php echo e(asset('assets/img/menubar.png')); ?>" alt="menu" class="icon-img menubar">
        </button>
        <button id="light-btn" class="icon-btn">
          <img src="<?php echo e(asset('assets/img/sun.png')); ?>" alt="Light mode" class="icon-img sun">
        </button>
        <button id="dark-btn" class="icon-btn">
          <img src="<?php echo e(asset('assets/img/icons8-moon-24.png')); ?>" alt="Dark mode" class="icon-img moon">
        </button>
      </div>
      <div class="right-icons">
        <img src="<?php echo e(asset('assets/img/instagram.svg')); ?>" alt="Instagram">
        <img src="<?php echo e(asset('assets/img/twitter.svg')); ?>" alt="Twitter">
        <img src="<?php echo e(asset('assets/img/substack.svg')); ?>" alt="Substack">
        <img src="<?php echo e(asset('assets/img/medium.svg')); ?>" alt="Medium">
      </div>
    </div>

    <!-- DATE SECTION -->
    <div class="center-date-wrapper">
      <div class="center-date">
        <div class="month"><?php echo e(now()->format('M')); ?></div>
        <div class="day"><?php echo e(now()->format('d')); ?></div>
      </div>
    </div>

    <!-- TOP HEADER -->
    <div class="top-header">
      <div class="header-column left">
        <h3>MEET & TALKS</h3>
        <div class="info-left">
          <i class="fas fa-location-dot"></i>
          <span>Horlington Street, 1723 – CA</span>
        </div>
        <div class="info-left">
          <i class="fas fa-envelope"></i>
          <span>Office@yourdomainoffice.com</span>
        </div>
      </div>
      <div class="header-column center">
        <img src="<?php echo e(asset('assets/img/mainlogo.webp')); ?>" alt="Logo">
        <p class="tagline">
          BLOG - MAGAZINE - GRID NEWS - CLASSICAL NEWSPAPER
        </p>
      </div>
      <div class="header-column right">
        <h3>ABOUT LIFE STYLE</h3>
        <div class="info">
          <i class="fas fa-phone"></i>
          <span>(66)2345-678, (66)098-765</span>
        </div>
        <div class="info">
          <i class="fas fa-life-ring"></i>
          <span>support@yoursupportdomain.com</span>
        </div>
      </div>
    </div>

    <!-- MENU BAR -->
    <div class="topbar">
      <div class="menu">
        MENU
        <div id="mob-toggle-btn" class="hamburger">
          <span></span><span></span><span></span>
        </div>
      </div>
    </div>

    <!-- BOTTOM BAR -->
    <nav class="bottom-bar">
      <div class="menu-wrapper">
        <ul class="menu">
          <li class="<?php echo e(request()->routeIs('home') ? 'active' : ''); ?>">
            <a href="<?php echo e(route('home')); ?>">HOME</a>
          </li>
          <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li class="<?php echo e(request()->is('category/' . $cat->category_name) ? 'active' : ''); ?>">
              <a href="<?php echo e(route('category.show', $cat->category_name)); ?>">
                <?php echo e(strtoupper($cat->category_name)); ?>

              </a>
            </li>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
      </div>
    </nav>

    <!-- MOBILE SIDEBAR -->
    <div class="mob-sidebar">
      <ul class="mob-menu">
        <li class="<?php echo e(request()->routeIs('home') ? 'active' : ''); ?>">
          <a href="<?php echo e(route('home')); ?>">Home</a>
        </li>
        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <li class="<?php echo e(request()->is('category/' . $cat->category_name) ? 'active' : ''); ?>">
            <a href="<?php echo e(route('category.show', $cat->category_name)); ?>">
              <?php echo e($cat->category_name); ?>

            </a>
          </li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </ul>
    </div>

    <div class="main-con">
      <div class="container">
        <!-- MAIN POST -->
        <?php if($featuredNews): ?>
        <div class="main-post">
          <h2 class="mob-head">
            <a href="#" class="no-link-style">
              <?php echo e($featuredNews->news_title); ?>

            </a>
          </h2>
          <div style="position: relative">
            <div class="img-zoom-container img-first">
              <?php if($featuredNews->banner && file_exists(storage_path('app/public/news/' . $featuredNews->banner))): ?>
                <img src="<?php echo e(asset('storage/news/' . $featuredNews->banner)); ?>" alt="<?php echo e($featuredNews->news_title); ?>">
              <?php else: ?>
                <img src="<?php echo e(asset('assets/img/banner-03.webp')); ?>" alt="<?php echo e($featuredNews->news_title); ?>">
              <?php endif; ?>
            </div>
            <div class="view-tag"><?php echo e(rand(500, 2000)); ?> views</div>
          </div>
          <div class="meta">
            <span class="admin">ADMIN</span>
            <span class="write">/ WRITER - <?php echo e(\Carbon\Carbon::parse($featuredNews->news_date)->format('F j, Y')); ?></span>
          </div>
          <h1>
            <a href="#" class="no-link-style">
              <?php echo e($featuredNews->news_title); ?>

            </a>
          </h1>
          <p>
            <?php echo e(Str::limit(strip_tags($featuredNews->news_content_short), 200)); ?>

          </p>
        </div>
        <?php endif; ?>

        <!-- SIDE POSTS -->
        <div class="side-posts">
          <?php $__currentLoopData = $sideNews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $news): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <div class="side-post">
            <?php if($news->photo && file_exists(storage_path('app/public/news/' . $news->photo))): ?>
              <img src="<?php echo e(asset('storage/news/' . $news->photo)); ?>" alt="<?php echo e($news->news_title); ?>">
            <?php else: ?>
              <img src="<?php echo e(asset('assets/img/img' . (($loop->iteration % 4) + 1) . '.webp')); ?>" alt="<?php echo e($news->news_title); ?>">
            <?php endif; ?>
            <div class="side-con">
              <div class="meta">
                <span class="admin">ADMIN</span>
                <span class="write">/ WRITER - <?php echo e(\Carbon\Carbon::parse($news->news_date)->format('F j, Y')); ?></span>
              </div>
              <h3>
                <a href="#" class="no-link-style">
                  <?php echo e(Str::limit($news->news_title, 70)); ?>

                </a>
              </h3>
            </div>
          </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
      </div>

      <div class="a-wrapper">
        <!-- LEFT COLUMN -->
        <div class="a-left">
          <div class="a-section-title"><span>Urban</span> Life</div>

          <?php $__currentLoopData = $urbanLifeNews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $news): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <div class="a-card">
            <div class="img-zoom-container">
              <?php if($news->photo && file_exists(storage_path('app/public/news/' . $news->photo))): ?>
                <img src="<?php echo e(asset('storage/news/' . $news->photo)); ?>" alt="<?php echo e($news->news_title); ?>">
              <?php else: ?>
                <img src="<?php echo e(asset('assets/img/img' . (($loop->iteration % 4) + 1) . '.webp')); ?>" alt="<?php echo e($news->news_title); ?>">
              <?php endif; ?>
            </div>
            <div class="a-views"><?php echo e(rand(1000, 3000)); ?> views</div>
          </div>
          <div class="a-meta">NEWS, URBAN LIFE</div>
          <div class="a-title">
            <a href="#" class="no-link-style">
              <?php echo e($news->news_title); ?>

            </a>
          </div>
          <div class="a-description">
            <?php echo e(Str::limit(strip_tags($news->news_content_short), 150)); ?>

          </div>
          <div class="a-meta">
            <span class="a-author">ADMIN</span>
            <span class="write">/ WRITER - <?php echo e(\Carbon\Carbon::parse($news->news_date)->format('F j, Y')); ?></span>
          </div>
          <?php if(!$loop->last): ?><hr><?php endif; ?>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

          <div class="a-section-title"><span>Latest</span> Updates</div>

          <div class="b-container">
            <?php $__currentLoopData = $module1dNews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $news): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="b-item">
              <div class="b-zoom">
                <?php if($news->photo && file_exists(storage_path('app/public/news/' . $news->photo))): ?>
                  <img src="<?php echo e(asset('storage/news/' . $news->photo)); ?>" alt="<?php echo e($news->news_title); ?>">
                <?php else: ?>
                  <img src="<?php echo e(asset('assets/img/img' . (($loop->iteration % 4) + 1) . '.webp')); ?>" alt="<?php echo e($news->news_title); ?>">
                <?php endif; ?>
              </div>
              <div class="b-content">
                <h6 class="b-title">
                  <a href="#" class="no-link-style">
                    <?php echo e(Str::limit($news->news_title, 50)); ?>

                  </a>
                </h6>
                <p class="b-description">
                  <?php echo e(Str::limit(strip_tags($news->news_content_short), 80)); ?>

                </p>
              </div>
            </div>
            <?php if(!$loop->last): ?>
            <hr class="b-divider">
            <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </div>
        </div>

        <!-- CENTER COLUMN -->
        <div class="a-center">
          <?php $__currentLoopData = $audioNews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $news): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <div class="featured-post">
            <div class="a-metaa">FEATURED</div>
            <h3>
              <a href="#" class="no-link-style">
                <?php echo e($news->news_title); ?>

              </a>
            </h3>
            <div class="a-meta">
              <span class="a-author">ADMIN</span>
              <div class="write">/ WRITER - <?php echo e(\Carbon\Carbon::parse($news->news_date)->format('F j, Y')); ?></div>
            </div>
            <div class="a-soundcloudd">
              <div class="img-zoom-container">
                <?php if($news->banner && file_exists(storage_path('app/public/news/' . $news->banner))): ?>
                  <img src="<?php echo e(asset('storage/news/' . $news->banner)); ?>" alt="<?php echo e($news->news_title); ?>">
                <?php else: ?>
                  <img src="<?php echo e(asset('assets/img/img6.webp')); ?>" alt="<?php echo e($news->news_title); ?>">
                <?php endif; ?>
              </div>
            </div>
            <div class="b-dropcap-container">
              <div class="b-text-columns">
                <div class="b-column-left">
                  <?php echo e(Str::limit(strip_tags($news->news_content), 300)); ?>

                </div>
                <div class="b-column-right">
                  <?php echo e(Str::limit(strip_tags($news->news_content_long ?? $news->news_content), 300)); ?>

                </div>
              </div>
              <div class="line-icon">
                <div class="b-divider"></div>
                <div class="r-icons">
                  <img src="<?php echo e(asset('assets/img/instagram.svg')); ?>" alt="Instagram logo">
                  <img src="<?php echo e(asset('assets/img/twitter.svg')); ?>" alt="Twitter logo">
                  <img src="<?php echo e(asset('assets/img/substack.svg')); ?>" alt="Substack logo">
                  <img src="<?php echo e(asset('assets/img/medium.svg')); ?>" alt="Medium logo">
                </div>
              </div>
            </div>
          </div>
          <?php if(!$loop->last): ?><br><br><?php endif; ?>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <!-- RIGHT COLUMN -->
        <div class="a-right">
          <div class="a-section-title"><span>Top</span> Stories</div>

          <div class="threegrid">
            <?php $__currentLoopData = $module13News; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $news): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="news-card">
              <div class="a-zoom">
                <?php if($news->photo && file_exists(storage_path('app/public/news/' . $news->photo))): ?>
                  <img src="<?php echo e(asset('storage/news/' . $news->photo)); ?>" alt="<?php echo e($news->news_title); ?>">
                <?php else: ?>
                  <img src="<?php echo e(asset('assets/img/img' . (($loop->iteration % 4) + 1) . '.webp')); ?>" alt="<?php echo e($news->news_title); ?>">
                <?php endif; ?>
              </div>
              <div class="views-badge"><?php echo e(rand(1000, 3000)); ?> views</div>
              <div class="category-badge">NEWS</div>
              <div class="news-title">
                <a href="#" class="no-link-style">
                  <?php echo e(Str::limit($news->news_title, 60)); ?>

                </a>
              </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </div>

          <div class="a-section-title"><span>Recent</span> Updates</div>

          <div class="b-container">
            <?php $__currentLoopData = $rightModule1dNews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $news): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="b-item">
              <div class="b-zoom">
                <?php if($news->photo && file_exists(storage_path('app/public/news/' . $news->photo))): ?>
                  <img src="<?php echo e(asset('storage/news/' . $news->photo)); ?>" alt="<?php echo e($news->news_title); ?>" class="b-image">
                <?php else: ?>
                  <img src="<?php echo e(asset('assets/img/img' . (($loop->iteration % 4) + 1) . '.webp')); ?>" alt="<?php echo e($news->news_title); ?>" class="b-image">
                <?php endif; ?>
              </div>
              <div class="b-content">
                <h6 class="b-title">
                  <a href="#" class="no-link-style">
                    <?php echo e(Str::limit($news->news_title, 50)); ?>

                  </a>
                </h6>
                <p class="b-description">
                  <?php echo e(Str::limit(strip_tags($news->news_content_short), 80)); ?>

                </p>
              </div>
            </div>
            <?php if(!$loop->last): ?>
            <hr class="b-divider">
            <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </div>
        </div>
      </div>
    </div>

    <!-- D-WRAPPER SECTION -->
    <div class="d-wrapper">
      <?php $__currentLoopData = $sideNews->take(2); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $news): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <div class="d-card">
        <div class="d-image">
          <?php if($news->photo && file_exists(storage_path('app/public/news/' . $news->photo))): ?>
            <img src="<?php echo e(asset('storage/news/' . $news->photo)); ?>" alt="<?php echo e($news->news_title); ?>">
          <?php else: ?>
            <img src="<?php echo e(asset('assets/img/img' . (($loop->iteration % 4) + 1) . '.webp')); ?>" alt="<?php echo e($news->news_title); ?>">
          <?php endif; ?>
        </div>
        <div class="d-content">
          <div class="d-category">News</div>
          <div class="d-title">
            <a href="#" class="no-link-style">
              <?php echo e($news->news_title); ?>

            </a>
          </div>
          <div class="d-description">
            <?php echo e(Str::limit(strip_tags($news->news_content_short), 100)); ?>

          </div>
        </div>
      </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <!-- MAIN-C SECTION -->
    <div class="main-c">
      <div class="aa-wrapper">
        <!-- LEFT COLUMN -->
        <div class="a-left">
          <div class="a-section-title"><span>About</span> Us</div>
          <div class="float-container">
            <img src="<?php echo e(asset('assets/img/admin_avatar.webp')); ?>" alt="Man with mustache">
            <p>
              Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit
              tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.
            </p>
            <p>
              Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit
              tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.
            </p>
          </div>

          <div class="a-card">
            <div class="img-zoom-container">
              <img src="<?php echo e(asset('assets/img/img2.webp')); ?>" alt="article">
            </div>
            <div class="a-views">1,654 views</div>
          </div>

          <div class="a-met">POLITICS</div>

          <div class="a-title">
            <a href="#" class="no-link-style">
              Lorem ipsum dolor sit amet, consectetur adipisicing elit. Pariatur
            </a>
          </div>

          <div class="a-description">
            Lorem ipsum dolor sit amet, consectetur adipisicing elit. Eos, porro
            sapiente! Officiis reiciendis eius recusandae illum adipisci maiores
            possimus sequi suscipit. Reiciendis veniam ipsam id doloremque quia
            possimus aspernatur ab?
          </div>

          <div class="a-meta">
            <span class="a-author">ADMIN</span>
            <span class="write">/ WRITER - MAY 21, 2015</span>
          </div>

          <div class="a-card">
            <div class="img-zoom-container">
              <img src="<?php echo e(asset('assets/img/img3.webp')); ?>" alt="article2">
            </div>
            <div class="a-views">1,461 views</div>
          </div>

          <div class="a-met">SPORTS</div>

          <div class="a-title">
            <a href="#" class="no-link-style">
              Lorem ipsum dolor sit amet, consectetur adipisicing elit. Pariatur
            </a>
          </div>

          <div class="a-description">
            Lorem ipsum dolor, sit amet consectetur adipisicing elit. Ut, eaque
            a maiores tempora autem soluta. Quibusdam dolorem
          </div>

          <div class="a-meta">
            <span class="a-author">ADMIN</span>
            <span class="write">/ WRITER - MAY 21, 2015</span>
          </div>

          <div class="a-section-title"><span>Latest</span> Updates</div>

          <div class="b-container">
            <div class="b-item">
              <div class="b-zoom">
                <img src="<?php echo e(asset('assets/img/img5.webp')); ?>" alt="Image 1" class="b-image">
              </div>

              <div class="b-content">
                <h6 class="b-title">
                  <a href="#" class="no-link-style">
                    Lorem ipsum dolor sit amet, consectetur
                  </a>
                </h6>

                <p class="b-description">
                  Lorem ipsum dolor sit amet consectetur adipisicing elit. Odit
                  quaerat, rem, rerum aspernatur
                </p>
              </div>
            </div>
          </div>
        </div>

        <!-- CENTER COLUMN -->
        <div class="a-center">
          <div class="featured-post">
            <div class="a-metaa">FEATURED</div>
            <h3>
              <a href="#" class="no-link-style">
                Lorem ipsum dolor sit amet. Quam illum provident elit. Quam
              </a>
            </h3>
            <div class="a-meta">
              <span class="a-author">ADMIN</span>
              <div class="write">/ WRITER - MARCH 5, 2015</div>
            </div>
            <div class="a-soundcloudd">
              <div class="img-zoom-container">
                <img src="<?php echo e(asset('assets/img/img4.webp')); ?>" alt="Vintage bike">
              </div>
            </div>
            <div class="b-dropcap-container">
              <div class="b-text-columns">
                <div class="b-column-left">
                  Lorem ipsum dolor, sit amet consectetur adipisicing elit.
                  Consequatur pariatur qui sequi possimus eius, libero accusamus
                  dolores dolor similique saepe, ipsum provident illo fugit
                  magnam, dolorem magni quas laborum ipsam.
                </div>
                <div class="b-column-right">
                  Lorem ipsum dolor sit amet consectetur adipisicing elit. Ipsa
                  maiores fugit alias deserunt eligendi pariatur quidem, error
                  aliquid eius aperiam, id officiis aliquam minima incidunt quae
                  impedit neque, sed inventore.
                </div>
              </div>
              <div class="line-icon">
                <div class="b-divider"></div>
                <div class="r-icons">
                  <img src="<?php echo e(asset('assets/img/instagram.svg')); ?>" alt="Instagram logo">
                  <img src="<?php echo e(asset('assets/img/twitter.svg')); ?>" alt="Twitter logo">
                  <img src="<?php echo e(asset('assets/img/substack.svg')); ?>" alt="Substack logo">
                  <img src="<?php echo e(asset('assets/img/medium.svg')); ?>" alt="Medium logo">
                </div>
              </div>
            </div>
          </div>

          <div class="featured-post">
            <div class="a-metaa">FEATURED</div>
            <h3>
              <a href="#" class="no-link-style">
                Lorem ipsum dolor sit amet. Quam illum provident elit. Quam
              </a>
            </h3>
            <div class="a-meta">
              <span class="a-author">ADMIN</span>
              <div class="write">/ WRITER - MARCH 5, 2015</div>
            </div>
            <div class="a-soundcloudd">
              <div class="img-zoom-container">
                <img src="<?php echo e(asset('assets/img/img5.webp')); ?>" alt="Coffee cup">
              </div>
            </div>
            <div class="b-dropcap-container">
              <div class="b-text-columns">
                <div class="b-column-left">
                  Lorem ipsum dolor sit amet consectetur adipisicing elit. Odit
                  ipsum voluptate atque corrupti. Dignissimos nihil voluptas
                  quas, laborum in atque dolorum, assumenda quod reprehenderit
                  ratione nemo sunt? Aliquam, in magnam!
                </div>
                <div class="b-column-right">
                  Lorem ipsum, dolor sit amet consectetur adipisicing elit.
                  Alias vitae consequuntur animi quo neque eius dicta voluptate
                  sapiente. Ex distinctio velit quibusdam qui assumenda nulla
                  quidem magni odit laborum recusandae!
                </div>
              </div>
              <div class="line-icon">
                <div class="b-divider"></div>
                <div class="r-icons">
                  <img src="<?php echo e(asset('assets/img/instagram.svg')); ?>" alt="Instagram logo">
                  <img src="<?php echo e(asset('assets/img/twitter.svg')); ?>" alt="Twitter logo">
                  <img src="<?php echo e(asset('assets/img/substack.svg')); ?>" alt="Substack logo">
                  <img src="<?php echo e(asset('assets/img/medium.svg')); ?>" alt="Medium logo">
                </div>
              </div>
            </div>
          </div>
        </div>

        <!-- RIGHT COLUMN -->
        <div class="a-right">
          <div class="a-section-title"><span>Top</span> Stories</div>
          <div class="threegrid">
            <div class="news-card">
              <div class="a-zoom">
                <img src="<?php echo e(asset('assets/img/img7.webp')); ?>" alt="News Image">
              </div>
              <div class="views-badge">1,653 views</div>
              <div class="category-badge">POLITICS</div>
              <div class="news-title">
                <a href="#" class="no-link-style">
                  Lorem ipsum<br>
                  dolor sit amet, consectetur<br>
                  adipisicing elit.
                </a>
              </div>
            </div>

            <div class="news-card">
              <div class="a-zoom">
                <img src="<?php echo e(asset('assets/img/img1.webp')); ?>" alt="News Image">
              </div>
              <div class="views-badge">1,653 views</div>
              <div class="category-badge">POLITICS</div>
              <div class="news-title">
                <a href="#" class="no-link-style">
                  Lorem ipsum<br>
                  dolor sit amet, consectetur<br>
                  adipisicing elit.
                </a>
              </div>
            </div>

            <div class="news-card">
              <div class="a-zoom">
                <img src="<?php echo e(asset('assets/img/img2.webp')); ?>" alt="News Image">
              </div>
              <div class="views-badge">1,653 views</div>
              <div class="category-badge">POLITICS</div>
              <div class="news-title">
                <a href="#" class="no-link-style">
                  Lorem ipsum<br>
                  dolor sit amet, consectetur<br>
                  adipisicing elit.
                </a>
              </div>
            </div>
          </div>

          <div class="a-section-title"><span>Latest</span> Updates</div>
          <div class="b-container">
            <div class="b-item">
              <div class="b-zoom">
                <img src="<?php echo e(asset('assets/img/img3.webp')); ?>" alt="Image 1" class="b-image">
              </div>
              <div class="b-content">
                <h6 class="b-title">
                  <a href="#" class="no-link-style">
                    Lorem ipsum dolor sit amet, consectetur
                  </a>
                </h6>
                <p class="b-description">
                  Lorem ipsum dolor sit amet, consectetur adipisicing elit.
                </p>
              </div>
            </div>

            <hr class="b-divider">

            <div class="b-item">
              <div class="b-zoom">
                <img src="<?php echo e(asset('assets/img/img1.webp')); ?>" alt="Image 2" class="b-image">
              </div>
              <div class="b-content">
                <h6 class="b-title">
                  <a href="#" class="no-link-style">
                    Lorem ipsum dolor sit amet, consectetur
                  </a>
                </h6>
                <p class="b-description">
                  Lorem ipsum dolor sit amet, consectetur adipisicing elit.
                </p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="h-divider"></div>

    <div class="g-grid">
      <div class="g-section">
        <div class="g-item">
          <div class="g-content">
            <div class="g-category">Politics</div>
            <div class="g-title">
              <a href="#" class="no-link-style-white">
                Lorem ipsum dolor sit amet, consectetur adipisicing elit.
                Pariatur
              </a>
            </div>
            <div class="g-description">
              Lorem ipsum dolor sit amet, consectetur adipisicing elit.
            </div>
          </div>
        </div>
        <div class="g-item">
          <div class="g-img">
            <img src="<?php echo e(asset('assets/img/img4.webp')); ?>" alt="Image 1">
          </div>
        </div>
      </div>

      <div class="g-section reverse">
        <div class="g-item">
          <div class="g-img">
            <img src="<?php echo e(asset('assets/img/img4.webp')); ?>" alt="Image 2">
          </div>
        </div>
        <div class="g-item">
          <div class="g-content">
            <div class="g-category">Gallery, Uncategorized</div>
            <div class="g-title">
              <a href="#" class="no-link-style-white">
                Lorem ipsum dolor sit amet, consectetur adipisicing elit.
                Pariatur
              </a>
            </div>
            <div class="g-description">
              Lorem ipsum dolor sit amet, consectetur adipisicing elit.
            </div>
          </div>
        </div>
      </div>

      <div class="g-section">
        <div class="g-item">
          <div class="g-content">
            <div class="g-category">Featured</div>
            <div class="g-title">
              <a href="#" class="no-link-style-white">
                Lorem ipsum dolor sit amet, consectetur adipisicing elit.
                Pariatur
              </a>
            </div>
            <div class="g-description">
              Lorem ipsum dolor sit amet, consectetur adipisicing elit.
            </div>
          </div>
        </div>
        <div class="g-item">
          <div class="g-img">
            <img src="<?php echo e(asset('assets/img/img5.webp')); ?>" alt="Image 3">
          </div>
        </div>
      </div>

      <div class="g-section">
        <div class="g-item">
          <div class="g-img">
            <img src="<?php echo e(asset('assets/img/img5.webp')); ?>" alt="Image 4">
          </div>
        </div>
        <div class="g-item">
          <div class="g-content">
            <div class="g-category">Featured</div>
            <div class="g-title">
              <a href="#" class="no-link-style-white">
                Lorem ipsum dolor sit amet, consectetur adipisicing elit.
                Pariatur
              </a>
            </div>
            <div class="g-description">
              Lorem ipsum dolor sit amet, consectetur adipisicing elit.
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- FOOTER -->
    <footer class="footer-container">
      <div class="logo">Erlin-News</div>
      <div class="footer-columns">
        <div class="footer-col-l">
          <h5>About Us</h5>
          <p>
            Lorem ipsum dolor sit amet consectetur adipisicing elit.
            Exercitationem distinctio mollitia ea reprehenderit delectus
            architecto itaque dolores, fugit
          </p>
          <p>
            Lorem ipsum dolor sit amet consectetur adipisicing elit. Ratione nam
            exercitationem doloribus fuga nobis soluta quos est vel nesciunt
            nostrum
          </p>
        </div>
        <div class="footer-col">
          <div class="section-title">BLOG SCHEME</div>
          <p>Lorem ipsum dolor sit amet consectetur</p>
          <p>
            Lorem ipsum dolor sit amet consectetur adipisicing elit. Possimus
            modi tenetur voluptatum corporis. Consectetur similique soluta vel
            deleniti excepturi architecto assumenda sint in, quo, at accusantium
            ducimus veniam delectus distinctio.
          </p>
          <p>Lorem ipsum dolor sit amet consectetur</p>
        </div>
        <div class="footer-col-r">
          <h5>Theme Filosofi</h5>
          <p>
            Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officiis
            eligendi beatae quasi eum laudantium fugiat ipsam esse culpa
            consectetur voluptas
          </p>
          <p>
            Lorem ipsum dolor sit amet consectetur, adipisicing elit. Optio
            aperiam beatae assumenda ex debitis, explicabo vero eius ullam vitae
            itaque
          </p>
        </div>
      </div>
      <div class="footer-menu">
        <a href="#">Blog</a> |
        <a href="#">Contact Us</a> |
        <a href="#">Module</a> |
        <a href="#">Privacy Policy</a>
      </div>
    </footer>

    <div class="h-divider"></div>

    <div class="footer-copy">
      © Copyright 2022 - ERLINNEWS. All Rights Reserved
    </div>

    <div class="scroll-top" onclick="scrollToTop()">
      <span><i class="fas fa-chevron-up"></i></span>
    </div>

    <script src="<?php echo e(asset('assets/js/script.js')); ?>"></script>
  </body>
</html><?php /**PATH C:\xampp\htdocs\erlin-newss\resources\views/news/index.blade.php ENDPATH**/ ?>