<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Erlin-News</title>

    <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>">
  </head>

  <body>

    <div class="s-sidebar" id="s-sidebar">
      <div class="s-logo-section">
        <h1 class="s-logo">
          <img src="<?php echo e(asset('assets/img/mainlogo.webp')); ?>" alt="Logo">
        </h1>
        <div class="s-menu-icon" id="s-close-btn">≪</div>
      </div>

      <div class="s-section">
        <h2 class="s-section-title">HAPPY LIFE</h2>
        <div class="img-zoom-container">
          <img src="<?php echo e(asset('assets/img/img1.webp')); ?>" alt="Happy Life" class="s-main-image">
        </div>
      </div>

      <div class="s-section">
        <h2 class="s-section-title">WHAT NEWS?</h2>

        <div class="s-news-item">
          <div class="img-zoom-container">
            <img src="<?php echo e(asset('assets/img/img2.webp')); ?>" class="s-thumb" alt="Scenic view">
          </div>
          <p class="s-news-title">Lorem ipsum dolor sit amet consectetur adipisicing elit.</p>
        </div>

        <hr>

        <div class="s-news-item">
          <div class="img-zoom-container">
            <img src="<?php echo e(asset('assets/img/img3.webp')); ?>" class="s-thumb" alt="Road view">
          </div>
          <p class="s-news-title">Lorem ipsum dolor sit amet consectetur adipisicing elit.</p>
        </div>

        <hr>

        <div class="s-news-item">
          <div class="img-zoom-container">
            <img src="<?php echo e(asset('assets/img/img4.webp')); ?>" class="s-thumb" alt="Street view">
          </div>
          <p class="s-news-title">Lorem ipsum dolor sit amet consectetur adipisicing elit.</p>
        </div>

        <div class="sidebar-line-icon">
          <div class="s-icons">
            <img src="<?php echo e(asset('assets/img/instagram.svg')); ?>" alt="Instagram logo">
            <img src="<?php echo e(asset('assets/img/twitter.svg')); ?>" alt="Twitter logo">
            <img src="<?php echo e(asset('assets/img/substack.svg')); ?>" alt="Substack logo">
            <img src="<?php echo e(asset('assets/img/medium.svg')); ?>" alt="Medium logo">
          </div>
          <div class="b-divider"></div>
        </div>

        <hr>
      </div>
    </div>

    <div class="s-overlay" id="s-overlay"></div>

    <div class="header">
      <div class="left-icons">
        <button class="s-toggle-btn" id="s-toggle-btn">
          <img src="<?php echo e(asset('assets/img/menubar.png')); ?>" alt="menu" class="icon-img menubar">
        </button>

        <button id="light-btn" class="icon-btn">
          <img src="<?php echo e(asset('assets/img/sun.png')); ?>" alt="Light mode" class="icon-img sun">
        </button>

        <button id="dark-btn" class="icon-btn">
          <img src="<?php echo e(asset('assets/img/icons8-moon-24.png')); ?>" alt="Dark mode" class="icon-img moon">
        </button>
      </div>

      <div class="right-icons">
        <img src="<?php echo e(asset('assets/img/instagram.svg')); ?>" alt="Instagram logo">
        <img src="<?php echo e(asset('assets/img/twitter.svg')); ?>" alt="Twitter logo">
        <img src="<?php echo e(asset('assets/img/substack.svg')); ?>" alt="Substack logo">
        <img src="<?php echo e(asset('assets/img/medium.svg')); ?>" alt="Medium logo">
      </div>
    </div>

    <div class="center-date-wrapper">
      <div class="center-date">
        <div class="month">JUL</div>
        <div class="day">29</div>
      </div>
    </div>

    <div class="top-header">

      <div class="header-column left">
        <h3>MEET & TALKS</h3>
        <div class="info-left">
          <i class="fas fa-location-dot"></i>
          <span>Horlington Street, 1723 – CA</span>
        </div>
        <div class="info-left">
          <i class="fas fa-envelope"></i>
          <span>Office@yourdomainoffice.com</span>
        </div>
      </div>

      <div class="header-column center">
        <img src="<?php echo e(asset('assets/img/mainlogo.webp')); ?>" alt="Erlin Blog Logo">
        <p class="tagline">BLOG - MAGAZINE - GRID NEWS - CLASSICAL NEWSPAPER</p>
      </div>

      <div class="header-column right">
        <h3>ABOUT LIFE STYLE</h3>
        <div class="info">
          <i class="fas fa-phone"></i>
          <span>(66)2345-678, (66)098-765</span>
        </div>
        <div class="info">
          <i class="fas fa-life-ring"></i>
          <span>support@yoursupportdomain.com</span>
        </div>
      </div>

    </div>

  <div class="topbar">
  <div class="menu">
    MENU
    <div id="mob-toggle-btn" class="hamburger">
      <span></span><span></span><span></span>
    </div>
  </div>
</div>

<nav class="bottom-bar">
  <div class="menu-wrapper">
    <ul class="menu">

      <!-- HOME -->
      <li class="<?php echo e(request()->routeIs('home') ? 'active' : ''); ?>">
        <a href="<?php echo e(route('home')); ?>">HOME</a>
      </li>

      <!-- DYNAMIC CATEGORIES -->
      <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <li class="<?php echo e(request()->is('category/' . $cat->category_name) ? 'active' : ''); ?>">
          <a href="<?php echo e(route('category.show', $cat->category_name)); ?>">
            <?php echo e(strtoupper($cat->category_name)); ?>

          </a>
        </li>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    </ul>
  </div>
</nav>

<div class="mob-sidebar">
  <ul class="mob-menu">
    <li class="<?php echo e(request()->routeIs('home') ? 'active' : ''); ?>">
      <a href="<?php echo e(route('home')); ?>">Home</a>
    </li>

    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <li class="<?php echo e(request()->is('category/' . $cat->category_name) ? 'active' : ''); ?>">
        <a href="<?php echo e(route('category.show', $cat->category_name)); ?>">
          <?php echo e($cat->category_name); ?>

        </a>
      </li>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </ul>
</div>




<div class="cat-container">
  <div class="cat-text-columns">
    <div class="cat-column-left">

      <!-- CATEGORY BANNER -->
<?php if($category->category_banner): ?>
  <img 
    src="<?php echo e(asset('assets/img/' . $category->category_banner)); ?>" 
    alt="<?php echo e($category->category_name); ?>"
    class="cat-banner-img"
    style="width:100%; height:auto; margin-bottom:20px;"
  >
<?php endif; ?>

      <!-- CATEGORY NAME -->
      <span class="cat-first-word">
        <?php echo e(strtoupper($category->category_name)); ?>

      </span>

      <!-- META TITLE -->
      <h2 class="cat-meta-title">
        <?php echo e($category->meta_title); ?>

      </h2>

      <!-- META DESCRIPTION -->
      <p class="cat-meta-description">
        <?php echo e($category->meta_description); ?>

      </p>

      <!-- META KEYWORDS -->
      <p class="cat-meta-keywords">
        <strong>Keywords:</strong> <?php echo e($category->meta_keyword); ?>

      </p>

    </div>
  </div>

  <div class="cat-divider"></div>
</div>




    <!-- Rest of your page stays EXACTLY the same -->
    <div class="cca-container">

      <div class="left-content">

        <div class="cca-main-content">
          <div class="cca-title">
            <a href="#" class="no-link-style">Lorem ipsum dolor sit amet...</a>
          </div>

          <p class="cca-subtitle"><em>Lorem ipsum dolor sit amet consectetur...</em></p>

          <div class="meta"><span class="admin">ADMIN</span>
            <span class="write">/ WRITER - APRIL 21, 2018</span>
          </div>

          <div class="cca-image-block">
            <img src="<?php echo e(asset('assets/img/img1.webp')); ?>" alt="Babies">
          </div>

          <p class="cca-description">Lorem ipsum dolor sit amet consectetur...</p>
        </div>

        <div class="cca-main-content">
          <div class="cca-title">
            <a href="#" class="no-link-style">Lorem ipsum dolor sit amet...</a>
          </div>

          <p class="cca-subtitle"><em>Lorem ipsum dolor sit amet consectetur...</em></p>

          <div class="meta"><span class="admin">ADMIN</span>
            <span class="write">/ WRITER - APRIL 21, 2018</span>
          </div>

          <div class="cca-image-block">
            <img src="<?php echo e(asset('assets/img/img2.webp')); ?>" alt="">
          </div>

          <p class="cca-description">Lorem ipsum dolor sit amet consectetur...</p>
        </div>

      </div>

      <div class="cca-sidebar">

        <div class="cca-search">
          <input type="text">
          <button><a href="./search.html" class="link">Search</a></button>
        </div>

        <div class="cca-widget">
          <h3>TOP NEWS</h3>
          <ul>
            <li>
              <h4><a href="#" class="no-link-style">Lorem ipsum dolor...</a></h4>
              <span class="cca-date">September 13, 2013</span>
            </li>
            <li>
              <h4><a href="#" class="no-link-style">Lorem ipsum dolor...</a></h4>
              <span class="cca-date">January 11, 2013</span>
            </li>
            <li>
              <h4><a href="#" class="no-link-style">Lorem ipsum dolor...</a></h4>
              <span class="cca-date">December 21, 2012</span>
            </li>
          </ul>
        </div>

        <div class="cca-widgett">
          <h3>LATEST NEWS</h3>

          <ul class="cca-latest">
            <li>
              <img src="<?php echo e(asset('assets/img/img3.webp')); ?>" alt="">
              <h4><a href="#" class="no-link-style">Lorem ipsum dolor...</a></h4>
            </li>

            <li>
              <img src="<?php echo e(asset('assets/img/img4.webp')); ?>" alt="">
              <h4><a href="#" class="no-link-style">Lorem ipsum dolor...</a></h4>
            </li>

            <li>
              <img src="<?php echo e(asset('assets/img/img5.webp')); ?>" alt="">
              <h4><a href="#" class="no-link-style">Lorem ipsum dolor...</a></h4>
            </li>
          </ul>

        </div>

        <div class="gory-container">
          <div class="gory-hot-title">HOT NEWS</div>

          <div class="javawidget6-top">
            <div class="widget14-thumbnail">
              <div class="widget14-titlebig">
                <h5><a href="#" class="no-link-style">Lorem ipsum...</a></h5>
              </div>

              <a href="#"><img src="<?php echo e(asset('assets/img/img6.webp')); ?>" alt=""></a>
            </div>
          </div>

          <div class="gory-articles-below">

            <div class="gory-article-item">
              <img src="<?php echo e(asset('assets/img/img7.webp')); ?>" class="gory-article-image">
              <div class="gory-article-title">
                <a href="#" class="no-link-style">Lorem ipsum...</a>
              </div>
            </div>

            <div class="gory-article-item">
              <img src="<?php echo e(asset('assets/img/img1.webp')); ?>" class="gory-article-image">
              <div class="gory-article-title">
                <a href="#">Lorem ipsum...</a>
              </div>
            </div>

            <div class="gory-article-item">
              <img src="<?php echo e(asset('assets/img/img2.webp')); ?>" class="gory-article-image">
              <div class="gory-article-title">
                <a href="#" class="no-link-style">Lorem ipsum...</a>
              </div>
            </div>

          </div>

        </div>

      </div>
    </div>


    <footer class="footer-container">
      <div class="logo">Erlin-News</div>

      <div class="footer-columns">
        <div class="footer-col-l">
          <h5>About Us</h5>
          <p>Lorem ipsum dolor sit amet consectetur...</p>
          <p>Lorem ipsum dolor sit amet consectetur...</p>
        </div>

        <div class="footer-col">
          <div class="section-title">BLOG SCHEME</div>
          <p>Lorem ipsum dolor sit amet consectetur</p>
          <p>Lorem ipsum dolor sit amet consectetur adipisicing elit...</p>
          <p>Lorem ipsum dolor sit amet consectetur</p>
        </div>

        <div class="footer-col-r">
          <h5>Theme Filosofi</h5>
          <p>Lorem ipsum dolor sit amet consectetur...</p>
          <p>Lorem ipsum dolor sit amet consectetur...</p>
        </div>
      </div>

      <div class="footer-menu">
        <a href="#">Blog</a> |
        <a href="#">Contact Us</a> |
        <a href="#">Module</a> |
        <a href="#">Privacy Policy</a>
      </div>
    </footer>

    <div class="h-divider"></div>

    <div class="footer-copy">© Copyright 2022 - ERLINNEWS. All Rights Reserved</div>

    <div class="scroll-top" onclick="scrollToTop()">
      <span><i class="fas fa-chevron-up"></i></span>
    </div>

    <script src="<?php echo e(asset('assets/js/script.js')); ?>"></script>

  </body>
</html>
<?php /**PATH C:\xampp\htdocs\erlin-newss\resources\views/news/category.blade.php ENDPATH**/ ?>