<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Erlin-News</title>

    <link rel="stylesheet" href="{{ asset('assets/css/style.css') }}">
  </head>

  <body>
    <div class="s-sidebar" id="s-sidebar">
      <div class="s-logo-section">
        <h1 class="s-logo">
          <img src="{{ asset('assets/img/mainlogo.webp') }}" alt="Logo">
        </h1>
        <div class="s-menu-icon" id="s-close-btn">≪</div>
      </div>

      <div class="s-section">
        <h2 class="s-section-title">HAPPY LIFE</h2>
        <div class="img-zoom-container">
          <img src="{{ asset('assets/img/img1.webp') }}" alt="Happy Life" class="s-main-image">
        </div>
      </div>

      <div class="s-section">
        <h2 class="s-section-title">WHAT NEWS?</h2>

        <div class="s-news-item">
          <div class="img-zoom-container">
            <img src="{{ asset('assets/img/img2.webp') }}" class="s-thumb" alt="Scenic view">
          </div>

          <p class="s-news-title">
            Lorem ipsum dolor sit amet consectetur adipisicing elit.
          </p>
        </div>

        <hr>

        <div class="s-news-item">
          <div class="img-zoom-container">
            <img src="{{ asset('assets/img/img3.webp') }}" class="s-thumb" alt="Road view">
          </div>

          <p class="s-news-title">
            Lorem ipsum dolor sit amet consectetur adipisicing elit.
          </p>
        </div>

        <hr>

        <div class="s-news-item">
          <div class="img-zoom-container">
            <img src="{{ asset('assets/img/img4.webp') }}" class="s-thumb" alt="Street view">
          </div>

          <p class="s-news-title">
            Lorem ipsum dolor sit amet consectetur adipisicing elit.
          </p>
        </div>

        <div class="sidebar-line-icon">
          <div class="s-icons">
            <img src="{{ asset('assets/img/instagram.svg') }}" alt="Instagram logo">
            <img src="{{ asset('assets/img/twitter.svg') }}" alt="Twitter logo">
            <img src="{{ asset('assets/img/substack.svg') }}" alt="Substack logo">
            <img src="{{ asset('assets/img/medium.svg') }}" alt="Medium logo">
          </div>

          <div class="b-divider"></div>
        </div>

        <hr>
      </div>
    </div>

    <div class="s-overlay" id="s-overlay"></div>

    <!-- HEADER -->
    <div class="header">
      <div class="left-icons">
        <button class="s-toggle-btn" id="s-toggle-btn">
          <img src="{{ asset('assets/img/menubar.png') }}" alt="menu" class="icon-img menubar">
        </button>

        <button id="light-btn" class="icon-btn">
          <img src="{{ asset('assets/img/sun.png') }}" alt="Light mode" class="icon-img sun">
        </button>

        <button id="dark-btn" class="icon-btn">
          <img src="{{ asset('assets/img/icons8-moon-24.png') }}" alt="Light mode" class="icon-img moon">
        </button>
      </div>

      <div class="right-icons">
        <img src="{{ asset('assets/img/instagram.svg') }}" alt="Facebook">
        <img src="{{ asset('assets/img/twitter.svg') }}" alt="twitter">
        <img src="{{ asset('assets/img/substack.svg') }}" alt="substack">
        <img src="{{ asset('assets/img/medium.svg') }}" alt="medium">
      </div>
    </div>

    <!-- DATE SECTION -->
    <div class="center-date-wrapper">
      <div class="center-date">
        <div class="month">JUL</div>
        <div class="day">29</div>
      </div>
    </div>

    <!-- TOP HEADER -->
    <div class="top-header">
      <div class="header-column left">
        <h3>MEET & TALKS</h3>
        <div class="info-left">
          <i class="fas fa-location-dot"></i>
          <span>Horlington Street, 1723 – CA</span>
        </div>
        <div class="info-left">
          <i class="fas fa-envelope"></i>
          <span>Office@yourdomainoffice.com</span>
        </div>
      </div>

      <div class="header-column center">
        <img src="{{ asset('assets/img/mainlogo.webp') }}" alt="Logo">

        <p class="tagline">
          BLOG - MAGAZINE - GRID NEWS - CLASSICAL NEWSPAPER
        </p>
      </div>

      <div class="header-column right">
        <h3>ABOUT LIFE STYLE</h3>
        <div class="info">
          <i class="fas fa-phone"></i>
          <span>(66)2345-678, (66)098-765</span>
        </div>
        <div class="info">
          <i class="fas fa-life-ring"></i>
          <span>support@yoursupportdomain.com</span>
        </div>
      </div>
    </div>

    <!-- MENU BAR -->
    <div class="topbar">
      <div class="menu">
        MENU
        <div id="mob-toggle-btn" class="hamburger">
          <span></span><span></span><span></span>
        </div>
      </div>
    </div>

    <!-- BOTTOM BAR -->
    <nav class="bottom-bar">
      <div class="menu-wrapper">
        <ul class="menu">
          <li class="active"><a href="./category.html">WORLD </a></li>
          <li><a href="./category.html">CULTURE</a></li>
          <li><a href="./category.html">TECHNOLOGY</a></li>
          <li><a href="./category.html">POLITICS</a></li>
          <li><a href="./category.html">BUSINESS</a></li>
          <li><a href="./category.html">TRAVEL</a></li>
          <li><a href="./category.html">ENTERTAINMENTS</a></li>
          <li><a href="./category.html">OPINIONS</a></li>
          <li><a href="./category.html">GALLERY</a></li>
          <li><a href="./category.html">LIFESTYLE</a></li>
        </ul>
      </div>
    </nav>

    <!-- MOBILE SIDEBAR -->
    <div class="mob-sidebar">
      <ul class="mob-menu">
        <li><a href="./category.html">World</a></li>
        <li><a href="./category.html">Culture</a></li>
        <li><a href="./category.html">Technology</a></li>
        <li><a href="./category.html">Politics</a></li>
        <li><a href="./category.html">Business</a></li>
        <li><a href="./category.html">Travel</a></li>
        <li><a href="./category.html">Entertainments</a></li>
        <li><a href="./category.html">Opinions</a></li>
        <li><a href="./category.html">Gallery</a></li>
        <li><a href="./category.html">Lifestyle</a></li>
      </ul>
    </div>

    <div class="main-con">
      <div class="container">

        <!-- MAIN POST -->
        <div class="main-post">
          <h2 class="mob-head">
            <a href="./detail.html" class="no-link-style">
              Lorem ipsum dolor, sit amet consectetur adipisicing elit.
            </a>
          </h2>

          <div style="position: relative">
            <div class="img-zoom-container img-first">
              <img src="{{ asset('assets/img/banner-03.webp') }}" alt="Main Image">
            </div>
            <div class="view-tag">904 views</div>
          </div>

          <div class="meta">
            <span class="admin">ADMIN</span>
            <span class="write">/ WRITER - APRIL 21, 2018</span>
          </div>

          <h1>
            <a href="./detail.html" class="no-link-style">
              Lorem ipsum dolor, sit amet consectetur adipisicing elit.
            </a>
          </h1>

          <p>
            Lorem ipsum, dolor sit amet consectetur adipisicing elit. Nostrum
            illo ipsa minus magni esse? Dolore facere cumque quisquam voluptas
            possimus quos vel at eaque ipsa! Atque repellat impedit laboriosam
            eveniet?
          </p>
        </div>

        <!-- SIDE POSTS -->
        <div class="side-posts">

          <div class="side-post">
            <img src="{{ asset('assets/img/img1.webp') }}" alt="image">
            <div class="side-con">
              <div class="meta">
                <span class="admin">ADMIN</span>
                <span class="write">/ WRITER - DECEMBER 29, 2016</span>
              </div>
              <h3>
                <a href="#" class="no-link-style">
                  Lorem ipsum dolor sit amet, consectetur adipisicing elit. Pariatur
                </a>
              </h3>
            </div>
          </div>

          <div class="side-post">
            <img src="{{ asset('assets/img/img2.webp') }}" alt="image2">
            <div class="side-con">
              <div class="meta">
                <span class="admin">ADMIN</span>
                <span class="write">/ WRITER - JUNE 1, 2016</span>
              </div>
              <h3>
                <a href="#" class="no-link-style">
                  Lorem ipsum dolor sit amet, consectetur adipisicing elit. Pariatur
                </a>
              </h3>
            </div>
          </div>

          <div class="side-post">
            <img src="{{ asset('assets/img/img3.webp') }}" alt="image3">
            <div class="side-con">
              <div class="meta">
                <span class="admin">ADMIN</span>
                <span class="write">/ WRITER - MAY 21, 2015</span>
              </div>
              <h3>
                <a href="#" class="no-link-style">
                  Lorem ipsum dolor sit amet, consectetur adipisicing elit. Pariatur
                </a>
              </h3>
            </div>
          </div>

          <div class="side-post">
            <img src="{{ asset('assets/img/img5.webp') }}" alt="image4">
            <div class="side-con">
              <div class="meta">
                <span class="admin">ADMIN</span>
                <span class="write">/ WRITER - MARCH 5, 2015</span>
              </div>
              <h3>
                <a href="#" class="no-link-style">
                  Lorem ipsum dolor sit amet, consectetur adipisicing elit. Pariatur
                </a>
              </h3>
            </div>
          </div>

        </div>

      </div>
      <div class="a-wrapper">
        <div class="a-left">

          <div class="a-section-title"><span>Urban</span> Life</div>

          <div class="a-card">
            <div class="img-zoom-container">
              <img src="{{ asset('assets/img/img1.webp') }}" alt="image5">
            </div>
            <div class="a-views">1,654 views</div>
          </div>

          <div class="a-meta">GALLERY, UNCATEGORIZED</div>

          <div class="a-title">
            <a href="#" class="no-link-style">
              Lorem ipsum dolor sit amet consectetur adipisicing elit.
            </a>
          </div>

          <div class="a-description">
            Lorem, ipsum dolor sit amet consectetur adipisicing elit. Dicta
            culpa molestias architecto illum quibusdam hic vitae,
          </div>

          <div class="a-meta">
            <span class="a-author">ADMIN</span>
            <span class="write">/ WRITER - MAY 21, 2015</span>
          </div>

          <div class="a-card">
            <div class="img-zoom-container">
              <img src="{{ asset('assets/img/img2.webp') }}" alt="image6">
            </div>
            <div class="a-views">1,461 views</div>
          </div>

          <div class="a-meta">GALLERY, UNCATEGORIZED</div>

          <div class="a-title">
            <a href="#" class="no-link-style">
              Lorem ipsum dolor sit amet, consectetur adipisicing elit. Pariatur
            </a>
          </div>

          <div class="a-description">
            Lorem ipsum dolor sit amet consectetur adipisicing elit. Aliquam
            eius voluptatibus, accusamus quisquam laudantium enim repellat porro
            delectus et ullam atque sed corrupti blanditiis labore sapiente
            numquam dolorum magni praesentium.
          </div>

          <div class="a-meta">
            <span class="a-author">ADMIN</span>
            <span class="write">/ WRITER - MAY 21, 2015</span>
          </div>

          <div class="a-section-title"><span>Module 1D</span> Subtitle</div>

          <div class="b-container">

            <div class="b-item">
              <div class="b-zoom">
                <img src="{{ asset('assets/img/img3.webp') }}" alt="Image 1">
              </div>

              <div class="b-content">
                <h6 class="b-title">
                  <a href="#" class="no-link-style">
                    Lorem ipsum dolor sit amet, consectetur
                  </a>
                </h6>

                <p class="b-description">
                  Lorem ipsum dolor sit amet consectetur adipisicing elit.
                  Nihil, voluptates?
                </p>
              </div>
            </div>

            <hr class="b-divider">

            <div class="b-item">
              <div class="b-zoom">
                <img src="{{ asset('assets/img/img4.webp') }}" alt="Image 2">
              </div>

              <div class="b-content">
                <h6 class="b-title">
                  <a href="#" class="no-link-style">
                    Lorem ipsum dolor sit amet, consectetur
                  </a>
                </h6>

                <p class="b-description">
                  Lorem ipsum dolor, sit amet consectetur adipisicing elit.
                  Repellendus facere.
                </p>
              </div>
            </div>

          </div>

        </div>

        <!-- CENTER COLUMN -->
        <div class="a-center">

          <div class="">
            <div class="a-metaa">TESTAUDIO</div>

            <h3>
              <a href="#" class="no-link-style">
                Lorem ipsum dolor sit amet. Quam illum provident elit. Quam
              </a>
            </h3>

            <div class="a-meta">
              <span class="a-author">ADMIN</span>
              <div class="write">/ WRITER - MARCH 5, 2015</div>
            </div>

            <div class="a-soundcloud">
              <div class="img-zoom-container">
                <img src="{{ asset('assets/img/img6.webp') }}" alt="Album art">
              </div>
            </div>

            <div class="b-dropcap-container">
              <div class="b-text-columns">

                <div class="b-column-left">
                  Lorem ipsum dolor sit amet consectetur adipisicing elit.
                  Tempora placeat maiores ut omnis, illo tempore quisquam iusto,
                  ipsum, aut aliquam sequi vero autem voluptas distinctio!
                  Numquam, eveniet. Cumque, laboriosam ratione.
                </div>

                <div class="b-column-right">
                  Lorem, ipsum dolor sit amet consectetur adipisicing elit.
                  Voluptates at qui dolorem assumenda aspernatur dignissimos,
                  nam, possimus vel consectetur ex iure. Ducimus molestiae
                  ratione obcaecati labore. Corporis tempora eum consequatur!
                </div>

              </div>

              <div class="line-icon">
                <div class="b-divider"></div>

                <div class="r-icons">
                  <img src="{{ asset('assets/img/instagram.svg') }}" alt="Instagram logo">
                  <img src="{{ asset('assets/img/twitter.svg') }}" alt="Twitter logo">
                  <img src="{{ asset('assets/img/substack.svg') }}" alt="Substack logo">
                  <img src="{{ asset('assets/img/medium.svg') }}" alt="Medium logo">
                </div>

              </div>

            </div>
          </div>

          <!-- SECOND AUDIO POST -->
          <div class="">
            <div class="a-metaa">TESTAUDIO</div>

            <h3>
              <a href="#" class="no-link-style">
                Lorem ipsum dolor sit amet. Quam illum provident elit. Quam
              </a>
            </h3>

            <div class="a-meta">
              <span class="a-author">ADMIN</span>
              <div class="write">/ WRITER - MARCH 5, 2015</div>
            </div>

            <div class="a-soundcloudd">
              <div class="img-zoom-container">
                <img src="{{ asset('assets/img/img1.webp') }}" alt="Video thumbnail">
              </div>
            </div>

            <div class="b-dropcap-container">
              <div class="b-text-columns">

                <div class="b-column-left">
                  Lorem ipsum dolor sit amet, consectetur adipisicing elit.
                  Beatae, quas eos blanditiis deserunt ab explicabo optio illum
                  numquam repellat voluptate, doloribus esse, consequatur sunt
                  perspiciatis ea saepe quaerat quisquam. Corrupti.
                </div>

                <div class="b-column-right">
                  Lorem ipsum, dolor sit amet consectetur adipisicing elit.
                  Atque voluptatum amet quibusdam cupiditate exercitationem
                  recusandae voluptates officia inventore, tenetur aut assumenda
                  culpa repellat, repudiandae dolor architecto in non, error
                  repellendus.
                </div>

              </div>

              <div class="line-icon">
                <div class="b-divider"></div>

                <div class="r-icons">
                  <img src="{{ asset('assets/img/instagram.svg') }}" alt="Instagram logo">
                  <img src="{{ asset('assets/img/twitter.svg') }}" alt="Twitter logo">
                  <img src="{{ asset('assets/img/substack.svg') }}" alt="Substack logo">
                  <img src="{{ asset('assets/img/medium.svg') }}" alt="Medium logo">
                </div>

              </div>
            </div>
          </div>

        </div>
        <!-- RIGHT COLUMN -->
        <div class="a-right">
          <div class="a-section-title"><span>Module 13</span> Subtitle</div>

          <div class="threegrid">
            <div class="news-card">
              <div class="a-zoom">
                <img src="{{ asset('assets/img/img1.webp') }}" alt="News Image">
              </div>
              <div class="views-badge">1,653 views</div>
              <div class="category-badge">POLITIC</div>
              <div class="news-title">
                <a href="#" class="no-link-style-white">
                  Lorem ipsum<br>
                  dolor sit amet, consectetur<br>
                  adipisicing elit.
                </a>
              </div>
            </div>

            <div class="news-card">
              <div class="a-zoom">
                <img src="{{ asset('assets/img/img5.webp') }}" alt="News Image">
              </div>
              <div class="views-badge">1,653 views</div>
              <div class="category-badge">POLITIC</div>
              <div class="news-title">
                <a href="#" class="no-link-style-white">
                  Lorem ipsum<br>
                  dolor sit amet, consectetur<br>
                  adipisicing elit.
                </a>
              </div>
            </div>

            <div class="news-card">
              <div class="a-zoom">
                <img src="{{ asset('assets/img/img6.webp') }}" alt="News Image">
              </div>
              <div class="views-badge">1,653 views</div>
              <div class="category-badge">POLITIC</div>
              <div class="news-title">
                <a href="#" class="no-link-style-white">
                  Lorem ipsum<br>
                  dolor sit amet, consectetur<br>
                  adipisicing elit.
                </a>
              </div>
            </div>
          </div>

          <div class="a-section-title"><span>Module 1D</span> Subtitle</div>

          <div class="b-container">

            <div class="b-item">
              <div class="b-zoom">
                <img src="{{ asset('assets/img/img2.webp') }}" alt="Image 1" class="b-image">
              </div>

              <div class="b-content">
                <h6 class="b-title">
                  <a href="#" class="no-link-style">Lorem ipsum dolor sit amet, consectetur</a>
                </h6>
                <p class="b-description">
                  Lorem ipsum dolor, sit amet consectetur adipisicing elit. Ex sunt, veritatis vel quibusdam
                </p>
              </div>
            </div>

            <hr class="b-divider">

            <div class="b-item">
              <div class="b-zoom">
                <img src="{{ asset('assets/img/img7.webp') }}" alt="Image 2" class="b-image">
              </div>

              <div class="b-content">
                <h6 class="b-title">
                  <a href="#" class="no-link-style">Lorem ipsum dolor sit amet, consectetur</a>
                </h6>
                <p class="b-description">
                  Lorem ipsum dolor sit, amet consectetur adipisicing elit.
                </p>
              </div>
            </div>

          </div>
        </div>
      </div>
    </div>

    <!-- D-WRAPPER SECTION -->
    <div class="d-wrapper">

      <div class="d-card">
        <div class="d-image">
          <img src="{{ asset('assets/img/img5.webp') }}" alt="News 1">
        </div>
        <div class="d-content">
          <div class="d-category">Politic</div>

          <div class="d-title">
            <a href="#" class="no-link-style-white">
              Lorem ipsum dolor sit amet, consectetur adipisicing elit. Pariatur
            </a>
          </div>

          <div class="d-description">
            Lorem ipsum dolor sit amet, consectetur adipisicing elit. Laborum similique maiores tenetur
          </div>
        </div>
      </div>

      <div class="d-card">
        <div class="d-image">
          <img src="{{ asset('assets/img/img3.webp') }}" alt="News 2">
        </div>

        <div class="d-content">
          <div class="d-category">Politic</div>

          <div class="d-title">
            <a href="#" class="no-link-style-white">
              Lorem ipsum dolor sit amet, consectetur adipisicing elit. Pariatur
            </a>
          </div>

          <div class="d-description">
            Lorem ipsum dolor sit amet, consectetur adipisicing elit. Laborum similique maiores tenetur
          </div>
        </div>
      </div>

    </div>

    <!-- MAIN-C SECTION -->
    <div class="main-c">

      <div class="aa-wrapper">

        <!-- LEFT COLUMN -->
        <div class="a-left">
          <div class="a-section-title"><span>About</span> Us</div>

          <div class="float-container">
            <img src="{{ asset('assets/img/admin_avatar.webp') }}" alt="Man with mustache">
            <p>
              Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit
              tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.
            </p>
            <p>
              Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit
              tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.
            </p>
          </div>

          <div class="a-card">
            <div class="img-zoom-container">
              <img src="{{ asset('assets/img/img2.webp') }}" alt="article">
            </div>
            <div class="a-views">1,654 views</div>
          </div>

          <div class="a-met">POLITICS</div>

          <div class="a-title">
            <a href="#" class="no-link-style">
              Lorem ipsum dolor sit amet, consectetur adipisicing elit. Pariatur
            </a>
          </div>

          <div class="a-description">
            Lorem ipsum dolor sit amet, consectetur adipisicing elit. Eos, porro
            sapiente! Officiis reiciendis eius recusandae illum adipisci maiores
            possimus sequi suscipit. Reiciendis veniam ipsam id doloremque quia
            possimus aspernatur ab?
          </div>

          <div class="a-meta">
            <span class="a-author">ADMIN</span>
            <span class="write">/ WRITER - MAY 21, 2015</span>
          </div>

          <div class="a-card">
            <div class="img-zoom-container">
              <img src="{{ asset('assets/img/img3.webp') }}" alt="article2">
            </div>
            <div class="a-views">1,461 views</div>
          </div>

          <div class="a-met">SPORTS</div>

          <div class="a-title">
            <a href="#" class="no-link-style">
              Lorem ipsum dolor sit amet, consectetur adipisicing elit. Pariatur
            </a>
          </div>

          <div class="a-description">
            Lorem ipsum dolor, sit amet consectetur adipisicing elit. Ut, eaque
            a maiores tempora autem soluta. Quibusdam dolorem
          </div>

          <div class="a-meta">
            <span class="a-author">ADMIN</span>
            <span class="write">/ WRITER - MAY 21, 2015</span>
          </div>

          <div class="a-section-title"><span>Module 1D</span> Subtitle</div>

          <div class="b-container">
            <div class="b-item">
              <div class="b-zoom">
                <img src="{{ asset('assets/img/img5.webp') }}" alt="Image 1" class="b-image">
              </div>

              <div class="b-content">
                <h6 class="b-title">
                  <a href="#" class="no-link-style">
                    Lorem ipsum dolor sit amet, consectetur
                  </a>
                </h6>

                <p class="b-description">
                  Lorem ipsum dolor sit amet consectetur adipisicing elit. Odit
                  quaerat, rem, rerum aspernatur
                </p>
              </div>
            </div>
          </div>

        </div>
        <!-- CENTER COLUMN -->
        <div class="a-center">

          <div class="">
            <div class="a-metaa">TESTAUDIO</div>

            <h3>
              <a href="#" class="no-link-style">
                Lorem ipsum dolor sit amet. Quam illum provident elit. Quam
              </a>
            </h3>

            <div class="a-meta">
              <span class="a-author">ADMIN</span>
              <div class="write">/ WRITER - MARCH 5, 2015</div>
            </div>

            <div class="a-soundcloudd">
              <div class="img-zoom-container">
                <img src="{{ asset('assets/img/img4.webp') }}" alt="Vintage bike">
              </div>
            </div>

            <div class="b-dropcap-container">
              <div class="b-text-columns">

                <div class="b-column-left">
                  Lorem ipsum dolor, sit amet consectetur adipisicing elit.
                  Consequatur pariatur qui sequi possimus eius, libero accusamus
                  dolores dolor similique saepe, ipsum provident illo fugit
                  magnam, dolorem magni quas laborum ipsam.
                </div>

                <div class="b-column-right">
                  Lorem ipsum dolor sit amet consectetur adipisicing elit. Ipsa
                  maiores fugit alias deserunt eligendi pariatur quidem, error
                  aliquid eius aperiam, id officiis aliquam minima incidunt quae
                  impedit neque, sed inventore.
                </div>

              </div>

              <div class="line-icon">
                <div class="b-divider"></div>

                <div class="r-icons">
                  <img src="{{ asset('assets/img/instagram.svg') }}" alt="Instagram logo">
                  <img src="{{ asset('assets/img/twitter.svg') }}" alt="Twitter logo">
                  <img src="{{ asset('assets/img/substack.svg') }}" alt="Substack logo">
                  <img src="{{ asset('assets/img/medium.svg') }}" alt="Medium logo">
                </div>

              </div>

            </div>

          </div>


          <div class="">
            <div class="a-metaa">TESTAUDIO</div>

            <h3>
              <a href="#" class="no-link-style">
                Lorem ipsum dolor sit amet. Quam illum provident elit. Quam
              </a>
            </h3>

            <div class="a-meta">
              <span class="a-author">ADMIN</span>
              <div class="write">/ WRITER - MARCH 5, 2015</div>
            </div>

            <div class="a-soundcloudd">
              <div class="img-zoom-container">
                <img src="{{ asset('assets/img/img5.webp') }}" alt="Coffee cup">
              </div>
            </div>

            <div class="b-dropcap-container">
              <div class="b-text-columns">

                <div class="b-column-left">
                  Lorem ipsum dolor sit amet consectetur adipisicing elit. Odit
                  ipsum voluptate atque corrupti. Dignissimos nihil voluptas
                  quas, laborum in atque dolorum, assumenda quod reprehenderit
                  ratione nemo sunt? Aliquam, in magnam!
                </div>

                <div class="b-column-right">
                  Lorem ipsum, dolor sit amet consectetur adipisicing elit.
                  Alias vitae consequuntur animi quo neque eius dicta voluptate
                  sapiente. Ex distinctio velit quibusdam qui assumenda nulla
                  quidem magni odit laborum recusandae!
                </div>

              </div>

              <div class="line-icon">
                <div class="b-divider"></div>

                <div class="r-icons">
                  <img src="{{ asset('assets/img/instagram.svg') }}" alt="Instagram logo">
                  <img src="{{ asset('assets/img/twitter.svg') }}" alt="Twitter logo">
                  <img src="{{ asset('assets/img/substack.svg') }}" alt="Substack logo">
                  <img src="{{ asset('assets/img/medium.svg') }}" alt="Medium logo">
                </div>

              </div>
            </div>
          </div>

        </div>

        <!-- RIGHT COLUMN -->
        <div class="a-right">

          <div class="a-section-title"><span>Module 13</span> Subtitle</div>

          <div class="threegrid">

            <div class="news-card">
              <div class="a-zoom">
                <img src="{{ asset('assets/img/img7.webp') }}" alt="News Image">
              </div>
              <div class="views-badge">1,653 views</div>
              <div class="category-badge">POLITIC</div>
              <div class="news-title">
                <a href="#" class="no-link-style-white">
                  Lorem ipsum<br>
                  dolor sit amet, consectetur<br>
                  adipisicing elit.
                </a>
              </div>
            </div>

            <div class="news-card">
              <div class="a-zoom">
                <img src="{{ asset('assets/img/img1.webp') }}" alt="News Image">
              </div>
              <div class="views-badge">1,653 views</div>
              <div class="category-badge">POLITIC</div>
              <div class="news-title">
                <a href="#" class="no-link-style-white">
                  Lorem ipsum<br>
                  dolor sit amet, consectetur<br>
                  adipisicing elit.
                </a>
              </div>
            </div>

            <div class="news-card">
              <div class="a-zoom">
                <img src="{{ asset('assets/img/img2.webp') }}" alt="News Image">
              </div>
              <div class="views-badge">1,653 views</div>
              <div class="category-badge">POLITIC</div>
              <div class="news-title">
                <a href="#" class="no-link-style-white">
                  Lorem ipsum<br>
                  dolor sit amet, consectetur<br>
                  adipisicing elit.
                </a>
              </div>
            </div>

          </div>

          <div class="a-section-title"><span>Module 1D</span> Subtitle</div>

          <div class="b-container">

            <div class="b-item">
              <div class="b-zoom">
                <img src="{{ asset('assets/img/img3.webp') }}" alt="Image 1" class="b-image">
              </div>
              <div class="b-content">
                <h6 class="b-title">
                  <a href="#" class="no-link-style">
                    Lorem ipsum dolor sit amet, consectetur
                  </a>
                </h6>

                <p class="b-description">
                  Lorem ipsum dolor sit amet, consectetur adipisicing elit.
                </p>
              </div>
            </div>

            <hr class="b-divider">

            <div class="b-item">
              <div class="b-zoom">
                <img src="{{ asset('assets/img/img1.webp') }}" alt="Image 2" class="b-image">
              </div>

              <div class="b-content">
                <h6 class="b-title">
                  <a href="#" class="no-link-style">
                    Lorem ipsum dolor sit amet, consectetur
                  </a>
                </h6>

                <p class="b-description">
                  Lorem ipsum dolor sit amet, consectetur adipisicing elit.
                </p>
              </div>
            </div>

          </div>

        </div>

      </div>
    </div>
    <div class="h-divider"></div>

    <div class="g-grid">

      <div class="g-section">
        <div class="g-item">
          <div class="g-content">
            <div class="g-category">Politic</div>
            <div class="g-title">
              <a href="#" class="no-link-style-white">
                Lorem ipsum dolor sit amet, consectetur adipisicing elit.
                Pariatur
              </a>
            </div>
            <div class="g-description">
              Lorem ipsum dolor sit amet, consectetur adipisicing elit.
            </div>
          </div>
        </div>

        <div class="g-item">
          <div class="g-img">
            <img src="{{ asset('assets/img/img4.webp') }}" alt="Image 1">
          </div>
        </div>
      </div>

      <div class="g-section reverse">

        <div class="g-item">
          <div class="g-img">
            <img src="{{ asset('assets/img/img4.webp') }}" alt="Image 2">
          </div>
        </div>

        <div class="g-item">
          <div class="g-content">
            <div class="g-category">Gallery, Uncategorized</div>
            <div class="g-title">
              <a href="#" class="no-link-style-white">
                Lorem ipsum dolor sit amet, consectetur adipisicing elit.
                Pariatur
              </a>
            </div>
            <div class="g-description">
              Lorem ipsum dolor sit amet, consectetur adipisicing elit.
            </div>
          </div>
        </div>

      </div>

      <div class="g-section">
        <div class="g-item">
          <div class="g-content">
            <div class="g-category">Testaudio</div>
            <div class="g-title">
              <a href="#" class="no-link-style-white">
                Lorem ipsum dolor sit amet, consectetur adipisicing elit.
                Pariatur
              </a>
            </div>
            <div class="g-description">
              Lorem ipsum dolor sit amet, consectetur adipisicing elit.
            </div>
          </div>
        </div>

        <div class="g-item">
          <div class="g-img">
            <img src="{{ asset('assets/img/img5.webp') }}" alt="Image 3">
          </div>
        </div>
      </div>

      <div class="g-section">
        <div class="g-item">
          <div class="g-img">
            <img src="{{ asset('assets/img/img5.webp') }}" alt="Image 4">
          </div>
        </div>

        <div class="g-item">
          <div class="g-content">
            <div class="g-category">Testaudio</div>
            <div class="g-title">
              <a href="#" class="no-link-style-white">
                Lorem ipsum dolor sit amet, consectetur adipisicing elit.
                Pariatur
              </a>
            </div>
            <div class="g-description">
              Lorem ipsum dolor sit amet, consectetur adipisicing elit.
            </div>
          </div>
        </div>

      </div>

    </div>

    <!-- FOOTER -->
    <footer class="footer-container">
      <div class="logo">Erlin-News</div>

      <div class="footer-columns">

        <div class="footer-col-l">
          <h5>About Us</h5>
          <p>
            Lorem ipsum dolor sit amet consectetur adipisicing elit.
            Exercitationem distinctio mollitia ea reprehenderit delectus
            architecto itaque dolores, fugit
          </p>
          <p>
            Lorem ipsum dolor sit amet consectetur adipisicing elit. Ratione nam
            exercitationem doloribus fuga nobis soluta quos est vel nesciunt
            nostrum
          </p>
        </div>

        <div class="footer-col">
          <div class="section-title">BLOG SCHEME</div>
          <p>Lorem ipsum dolor sit amet consectetur</p>
          <p>
            Lorem ipsum dolor sit amet consectetur adipisicing elit. Possimus
            modi tenetur voluptatum corporis. Consectetur similique soluta vel
            deleniti excepturi architecto assumenda sint in, quo, at accusantium
            ducimus veniam delectus distinctio.
          </p>
          <p>Lorem ipsum dolor sit amet consectetur</p>
        </div>

        <div class="footer-col-r">
          <h5>Theme Filosofi</h5>
          <p>
            Lorem ipsum dolor sit amet consectetur, adipisicing elit. Officiis
            eligendi beatae quasi eum laudantium fugiat ipsam esse culpa
            consectetur voluptas
          </p>
          <p>
            Lorem ipsum dolor sit amet consectetur, adipisicing elit. Optio
            aperiam beatae assumenda ex debitis, explicabo vero eius ullam vitae
            itaque
          </p>
        </div>

      </div>

      <div class="footer-menu">
        <a href="#">Blog</a> |
        <a href="#">Contact Us</a> |
        <a href="#">Module</a> |
        <a href="#">Privacy Policy</a>
      </div>

    </footer>

    <div class="h-divider"></div>

    <div class="footer-copy">
      © Copyright 2022 - ERLINNEWS. All Rights Reserved
    </div>

    <div class="scroll-top" onclick="scrollToTop()">
      <span><i class="fas fa-chevron-up"></i></span>
    </div>

    <script src="{{ asset('assets/js/script.js') }}"></script>
  </body>
</html>

