document.addEventListener("DOMContentLoaded", function () {
  const toggleBtn = document.getElementById("s-toggle-btn");
  const sidebar = document.getElementById("s-sidebar");
  const closeBtn = document.getElementById("s-close-btn");
  const overlay = document.getElementById("s-overlay");
  function openSidebar() {
    sidebar.classList.add("active");
    overlay.classList.add("active");
    document.body.classList.add("no-scroll");
  }
  function closeSidebar() {
    sidebar.classList.remove("active");
    overlay.classList.remove("active");
    document.body.classList.remove("no-scroll");
  }
  toggleBtn.addEventListener("click", openSidebar);
  closeBtn.addEventListener("click", closeSidebar);
  overlay.addEventListener("click", closeSidebar);
});
function scrollToTop() {
  window.scrollTo({ top: 0, behavior: "smooth" });
}
document.addEventListener("DOMContentLoaded", function () {
  const toggleBtn = document.getElementById("mob-toggle-btn");
  const sidebar = document.getElementById("mob-sidebar");

  toggleBtn.addEventListener("click", function () {
    sidebar.classList.toggle("active");
    document.body.classList.toggle("no-scroll");
  });
});
document.addEventListener("DOMContentLoaded", function () {
  const toggleBtn = document.getElementById("mob-toggle-btn");
  const sidebar = document.querySelector(".mob-sidebar");
  toggleBtn.addEventListener("click", function () {
    const isHamburger = toggleBtn.classList.contains("hamburger");
    sidebar.classList.toggle("active");
    if (isHamburger) {
      toggleBtn.classList.remove("hamburger");
      toggleBtn.classList.add("x-icon");
      toggleBtn.innerHTML = '<i class="fa-solid fa-xmark"></i>';
    } else {
      toggleBtn.classList.remove("x-icon");
      toggleBtn.classList.add("hamburger");
      toggleBtn.innerHTML = "<span></span><span></span><span></span>";
    }
  });
});
const darkBtn = document.getElementById("dark-btn");
const lightBtn = document.getElementById("light-btn");
darkBtn.addEventListener("click", () => {
  document.body.classList.add("dark-mode");
  document.body.classList.remove("light-mode");
});
lightBtn.addEventListener("click", () => {
  document.body.classList.remove("dark-mode");
  document.body.classList.add("light-mode");
});
const loadBtn = document.getElementById("loadToggle");
const loader = document.querySelector(".loader");
const extraItems = document.querySelector(".extra-items");
loadBtn.addEventListener("click", () => {
  loader.style.display = "grid";
  loadBtn.style.display = "none";
  setTimeout(() => {
    loader.style.display = "none";
    if (
      extraItems.style.display === "none" ||
      extraItems.style.display === ""
    ) {
      extraItems.style.display = "block";
      loadBtn.textContent = "Load Less";
    } else {
      extraItems.style.display = "none";
      loadBtn.textContent = "Load More";
    }
    loadBtn.style.display = "block";
  }, 500);
});
