<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\News;

class NewsController extends Controller
{
    public function index()
    {
        // MENU CATEGORIES
        $fixed = ['world'];
        $fixedCategories = Category::whereIn('category_name', $fixed)->get();
        $otherCategories = Category::whereNotIn('category_name', $fixed)
                                   ->limit(8)
                                   ->get();
        $categories = $fixedCategories->merge($otherCategories);

        // ALL NEWS
        $allLatestNews = News::orderBy('news_date', 'DESC')->get();

        // SIDEBAR NEWS
        $latestNews = $allLatestNews->take(3);

        // MAIN FEATURED
        $featuredNews = $allLatestNews->first();

        // SIDE POSTS
        $sideNews = $allLatestNews->skip(1)->take(4);

        // URBAN LIFE
        $urbanLifeNews = News::where('category_id', 11)
            ->orderBy('news_date', 'DESC')
            ->take(2)
            ->get();

        if ($urbanLifeNews->isEmpty()) {
            $urbanLifeNews = $allLatestNews->skip(5)->take(2);
        }

        // MODULES
        $module1dNews = $allLatestNews->skip(6)->take(2);
        $audioNews = $allLatestNews->skip(8)->take(2);
        $module13News = $allLatestNews->skip(10)->take(3);
        $rightModule1dNews = $allLatestNews->skip(13)->take(2);

        return view('news.index', compact(
            'categories',
            'latestNews',
            'featuredNews',
            'sideNews',
            'urbanLifeNews',
            'module1dNews',
            'audioNews',
            'module13News',
            'rightModule1dNews'
        ));
    }

    public function category($slug)
    {
        // CATEGORY OBJECT
        $category = Category::where('category_name', $slug)->firstOrFail();

        // MENU
        $fixed = ['world'];
        $fixedCategories = Category::whereIn('category_name', $fixed)->get();
        $otherCategories = Category::whereNotIn('category_name', $fixed)
                                   ->limit(8)
                                   ->get();
        $categories = $fixedCategories->merge($otherCategories);

        // CATEGORY NEWS
        $categoryNews = News::where('category_id', $category->category_id)
            ->orderBy('news_date', 'DESC')
            ->get();

        return view('news.category', compact('category', 'categories', 'categoryNews'));
    }

    public function show($id)
    {
        $news = News::findOrFail($id);

        // MENU
        $fixed = ['world'];
        $fixedCategories = Category::whereIn('category_name', $fixed)->get();
        $otherCategories = Category::whereNotIn('category_name', $fixed)
                                   ->limit(8)
                                   ->get();
        $categories = $fixedCategories->merge($otherCategories);

        return view('news.show', compact('news', 'categories'));
    }
}
