<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\News;

class HomeController extends Controller
{
    public function index()
    {
        // All categories (nav bar)
        $categories = Category::orderBy('category_name')->get();

        // 1) Latest sidebar news (3 items)
        $latestNews = News::orderBy('news_date', 'DESC')
            ->take(3)
            ->get();

        // 2) Featured main post (latest)
        $featuredNews = News::orderBy('news_date', 'DESC')->first();

        // 3) Side posts (next 4)
        $sideNews = News::orderBy('news_date', 'DESC')
            ->skip(1)
            ->take(4)
            ->get();

        // 4) Urban Life (any 2–4 posts)
        $urbanLifeNews = News::where('category_id', 11) // choose a category ID
            ->orderBy('news_date', 'DESC')
            ->take(2)
            ->get();

        // 5) Module 1D (left column)
        $module1dNews = News::orderBy('news_date', 'DESC')
            ->skip(5)
            ->take(2)
            ->get();

        // 6) Audio section (center column)
        $audioNews = News::orderBy('news_date', 'DESC')
            ->skip(7)
            ->take(2)
            ->get();

        // 7) Module 13 (right side, 3 items)
        $module13News = News::orderBy('news_date', 'DESC')
            ->skip(9)
            ->take(3)
            ->get();

        // 8) Right Module 1D (right column bottom)
        $rightModule1dNews = News::orderBy('news_date', 'DESC')
            ->skip(12)
            ->take(3)
            ->get();

        return view('index', compact(
            'categories',
            'latestNews',
            'featuredNews',
            'sideNews',
            'urbanLifeNews',
            'module1dNews',
            'audioNews',
            'module13News',
            'rightModule1dNews'
        ));
    }
}
