

<?php $__env->startSection('title', $category->meta_title ?? $category->category_name); ?>
<?php $__env->startSection('meta_description', $category->meta_description ?? ''); ?>

<?php $__env->startSection('content'); ?>

<section class="triple-news-section">
    <div class="triple-news-container">

        <!-- LEFT COLUMN -->
        <div class="triple-left">

            <!-- Breadcrumb -->
            <div class="detail-breadcrumb-card">
                Home » <?php echo e($category->category_name); ?>

            </div>
            <br>

            <!-- Category Banner -->
            <?php if($category->category_banner): ?>
                <div class="category-banner">
                    <img src="<?php echo e(asset('images/' . $category->category_banner)); ?>" alt="<?php echo e($category->category_name); ?>">
                </div>
                <br>
            <?php endif; ?>

            <!-- Category Title -->
            <h2 class="news-title">
                Category: <?php echo e($category->category_name); ?>

            </h2>
            <br>

            <!-- POSTS LOOP -->
            <?php $__empty_1 = true; $__currentLoopData = $news; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="triple-post">

                    <div class="triple-thumb">
                        <img src="<?php echo e(asset('images/' . ($item->photo ?? 'img5.webp'))); ?>" alt="">
                        <span class="triple-tag">
                            <?php echo e($category->category_name); ?>

                        </span>
                    </div>

                    <div class="triple-content">

                        <h3><?php echo e($item->news_title); ?></h3>

                        <div class="triple-meta">
                            <?php echo e($item->stitle ?? 'Admin'); ?> •
                            <?php echo e(date('F j, Y', strtotime($item->news_date))); ?> •
                            1 min
                        </div>

                        <p>
                            <?php echo e(\Illuminate\Support\Str::limit($item->news_content, 180)); ?>

                        </p>

                        <span class="read-more-btn">Read More</span>

                    </div>
                </div>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="triple-post">
                    <div class="triple-content">
                        <h3>No posts available in this category.</h3>
                    </div>
                </div>
            <?php endif; ?>


            <!-- PAGINATION -->
            <!-- <div class="pagination-wrapper">
                <?php echo e($news->links()); ?>

            </div> -->

        </div>


        <!-- MIDDLE COLUMN -->
        <div class="triple-middle">

            <h2 class="news-title">Latest News</h2>
            <br>

            <?php if(isset($latestNews) && $latestNews->count() > 0): ?>

                <?php $__currentLoopData = $latestNews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $latest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="featured-card">

                        <div class="featured-image">
                            <img src="<?php echo e(asset('images/' . ($latest->photo ?? 'img6.webp'))); ?>" alt="">
                        </div>

                        <div class="featured-content">
                            <div class="featured-category">
                                <?php echo e($latest->type ?? 'News'); ?>

                            </div>

                            <h3 class="featured-title">
                                <?php echo e($latest->news_title); ?>

                            </h3>
                        </div>

                    </div>
                    <br>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <?php endif; ?>

        </div>


        <!-- RIGHT SIDEBAR -->
        <div class="triple-sidebar">

            <h2 class="news-title">Find Me On</h2>
            <br>

            <!-- Social Icons -->
            <div class="sidebar-box">
                <div class="sidebar-social">
                    <img src="<?php echo e(asset('images/footer-instagram.webp')); ?>">
                    <img src="<?php echo e(asset('images/footer-twitter.webp')); ?>">
                    <img src="<?php echo e(asset('images/footer-substack.webp')); ?>">
                    <img src="<?php echo e(asset('images/footer-youtube.webp')); ?>">
                </div>
            </div>

            <!-- Advertisement -->
            <div class="sidebar-box">
                <img src="<?php echo e(asset('images/img5.webp')); ?>" class="sidebar-ad" alt="Ad">
            </div>

            <!-- Hot News -->
            <h2 class="news-title">Hot News</h2>
            <br>

            <div class="sidebar-box">

                <?php if(isset($latestNews) && $latestNews->count() > 0): ?>

                    <?php $hot = $latestNews->first(); ?>

                    <div class="sidebar-card">

                        <div class="sidebar-card-img">
                            <img src="<?php echo e(asset('images/' . ($hot->photo ?? 'img7.webp'))); ?>" alt="">
                            <span class="sidebar-tag">
                                <?php echo e($hot->type ?? 'News'); ?>

                            </span>
                        </div>

                        <h4 class="sidebar-card-title">
                            <?php echo e($hot->news_title); ?>

                        </h4>

                        <div class="sidebar-card-date">
                            <?php echo e(date('F j, Y', strtotime($hot->news_date))); ?>

                        </div>

                    </div>

                <?php endif; ?>

            </div>

        </div>

    </div>
</section>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\news-sitee\resources\views/category-business.blade.php ENDPATH**/ ?>