<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>@yield('title', 'Digital Newspaper')</title>
<link rel="stylesheet" href="{{ asset('css/style.css') }}">
@stack('styles')
</head>
<body>

<!-- Top Bar -->
<div class="top-bar">
    <div class="top-left">
        <img src="{{ asset('images/clock.webp') }}" class="clock-icon">
        <span id="time">14:30:05</span>
        <span>February 18, 2026</span>
    </div>

    <div class="top-right">
        <img src="{{ asset('images/footer-instagram.webp') }}">
        <img src="{{ asset('images/footer-substack.webp') }}">
        <img src="{{ asset('images/footer-twitter.webp') }}">
    </div>
</div>

<!-- Header -->
<header class="main-header">

    <div class="logo">
        <img src="{{ asset('images/logo.svg') }}">
    </div>

    <!-- Desktop Nav -->
    <nav class="desktop-nav">
        <ul>
            <li class="active"><li class="active">            
                <a href="{{ route('home') }}">Business</a>
            </li>
        </li>
            <li>World</li>
            <li>US</li>
            <li>Politics</li>
            <li>Sports</li>
            <li>Entertainment</li>
            <li>
                <a href="{{ route('category.show', 'business') }}">Business</a>
            </li>
            <li>Science</li>
            <li>Fact Check</li>
            <li>Oddities</li>
        </ul>
    </nav>

    <!-- Mobile Bar -->
    <div class="mobile-bar">
        <div class="mobile-menu" id="mobileMenuToggle">
            <img src="{{ asset('images/menu.webp') }}">
            <span>MENU</span>
        </div>

        <div class="mobile-search">
            <img src="{{ asset('images/search.webp') }}">
        </div>
    </div>

</header>

<!-- Dropdown Menu -->
<nav class="dropdown-menu" id="dropdownMenu">
    <ul>
        <li class="active">            
            <a href="{{ route('home') }}">Business</a>
        </li>
        <li>World</li>
        <li>US</li>
        <li>Politics</li>
        <li>Sports</li>
        <li>Entertainment</li>
        <li>
            <a href="{{ route('category.show', 'business') }}">Business</a>
        </li>        
        <li>Science</li>
        <li>Fact Check</li>
        <li>Oddities</li>
        <li>More</li>
    </ul>
</nav>

<main>
    @yield('content')
</main>

<!-- Footer -->
<footer class="footer-dark">

    <div class="footer-top">
        <div class="footer-wrapper">

            <!-- About Us -->
            <div class="footer-box">
                <h3>About Us</h3>
                <div class="footer-card">
                    <p>
                        We deliver accurate, timely, and unbiased news from around the world.
                        Click below to learn more about our mission and editorial values.
                    </p>
                </div>
                <div class="footer-card list-card">
                    <ul>
                        <li><a href="{{ route('about') }}">Read more.........</a></li>
                    </ul>
                </div>                
            </div>

            <!-- Authors -->
            <div class="footer-box">
                <h3>Authors</h3>
                <div class="footer-card list-card">
                    <ul>
                        @foreach($footerAuthors as $author)
                            <li>
                                <a href="{{ route('author.show', $author->slug) }}">
                                    {{ $author->name }}
                                </a>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>

            <!-- Categories -->
            <div class="footer-box">
                <h3>Categories</h3>
                <div class="footer-card list-card">
                    <ul>
                        <li>
                            <a href="{{ route('category.show', 'business') }}">Business</a>
                        </li>
                        <li>Fashion</li>
                        <li>Politics</li>
                        <li>Science</li>
                        <li>Technology</li>
                    </ul>
                </div>
            </div>

            <!-- Privacy Policy -->
            <div class="footer-box">
                <h3>Privacy Policy</h3>
                <div class="footer-card list-card">
                    <ul>
                        <li><a href="{{ route('privacy') }}">View Privacy Policy</a></li>
                    </ul>
                </div>
            </div>

        </div>
    </div>

    <div class="footer-bottom-area">

        <div class="footer-social">
            <img src="{{ asset('images/footer-substack.webp') }}">
            <img src="{{ asset('images/footer-instagram.webp') }}">
            <img src="{{ asset('images/footer-twitter.webp') }}">
            <img src="{{ asset('images/footer-substack.webp') }}">
            <img src="{{ asset('images/footer-instagram.webp') }}">
        </div>

        <div class="footer-bottom-row">

            <div class="footer-copy">
                © 2026 Digital Newspaper. Powered by YourSite.
            </div>

            <div class="footer-links">
                <span>License</span>
                <span>Privacy Policy</span>
            </div>

        </div>

    </div>

</footer>

<script src="{{ asset('js/script.js') }}"></script>
@stack('scripts')

</body>
</html>