@extends('layouts.app')

@section('title', isset($mainNews) && $mainNews->meta_title ? $mainNews->meta_title : 'Digital Newspaper')
@section('meta_description', isset($mainNews) && $mainNews->meta_description ? $mainNews->meta_description : '')

@section('content')

<!-- ================= Headlines Section ================= -->
<section class="headline-panel-section">
    <div class="headline-panel">

        <!-- Top Bar -->
        <div class="headline-panel-top">
            <div class="headline-panel-label">HEADLINES</div>
        </div>

        <!-- Scrolling Area -->
        <div class="headline-panel-wrapper">
            <div class="headline-panel-track">

                {{-- Latest 5 Headlines --}}
                @forelse($headlineNews as $news)
                <div class="headline-panel-item">
                    <!-- <img src="{{ asset('images/' . ($news->photo ?? 'img1.webp')) }}" alt=""> -->
                    <img src="{{ asset('images/img6.webp') }}" class="social-icon">

                    <div class="headline-panel-text">
                        <div class="headline-panel-date">
                            {{ $news->news_date ? date('F j, Y', strtotime($news->news_date)) : '' }}
                        </div>

                        <div class="headline-panel-title">
                            <a href="{{ url('news/'.$news->news_id) }}">
                                {{ $news->news_title }}
                            </a>
                        </div>
                    </div>
                </div>
                @empty
                <div class="headline-panel-item">
                    <div class="headline-panel-text">
                        <div class="headline-panel-title">
                            No headlines available
                        </div>
                    </div>
                </div>
                @endforelse


                {{-- Duplicate for smooth infinite scroll --}}
                @foreach($headlineNews as $news)
                <div class="headline-panel-item">
                    <img src="{{ asset('images/' . ($news->photo ?? 'img1.webp')) }}" alt="">

                    <div class="headline-panel-text">
                        <div class="headline-panel-date">
                            {{ $news->news_date ? date('F j, Y', strtotime($news->news_date)) : '' }}
                        </div>

                        <div class="headline-panel-title">
                            <a href="{{ url('news/'.$news->news_id) }}">
                                {{ $news->news_title }}
                            </a>
                        </div>
                    </div>
                </div>
                @endforeach

            </div>
        </div>
    


        <!-- 2nd section -->
        <section class="news-combo-section">
            <div class="news-combo-container">
                <!-- LEFT : Latest News -->
                <div class="combo-left">
                    <h3 class="combo-title">Latest News</h3>
                    @if(isset($latestNews) && $latestNews->count() > 0)
                        @foreach($latestNews->take(3) as $news)
                        <div class="latest-card">
                            <a href="#">
                                <img src="{{ asset('images/img1.webp') }}" class="social-icon">
                            </a>
                            <div class="latest-overlay">
                                {{ $news->news_title ?? 'NASA Sets Coverage for Two Spacewalks Outside Space…' }}
                            </div>
                        </div>
                        @endforeach
                    @else
                        <div class="latest-card">
                            <img src="{{ asset('images/img1.webp') }}" alt="">
                            <div class="latest-overlay">NASA Sets Coverage for Two Spacewalks Outside Space…</div>
                        </div>
                        <div class="latest-card">
                            <img src="{{ asset('images/img7.webp') }}" alt="">
                            <div class="latest-overlay">Google’s Self-Designed Tensor Chips will Power Its…</div>
                        </div>
                        <div class="latest-card">
                            <img src="{{ asset('images/img8.webp') }}" alt="">
                            <div class="latest-overlay">Fashion Exhibitions Around The World To See In 2023</div>
                        </div>
                    @endif
                </div>


                <!-- CENTER : Main Featured -->
                <div class="combo-center">
                    @if(isset($mainNews) && !is_null($mainNews))
                    <img src="{{ asset('images/img7.webp') }}" class="social-icon">
                    <div class="center-overlay">
                        <div class="center-meta">
                            <span class="center-category">{{ $mainNews->type ?? 'Fashion' }}</span>
                            <span class="center-date">{{ isset($mainNews->news_date) ? date('F j, Y', strtotime($mainNews->news_date)) : 'December 7, 2023' }}</span>
                        </div>
                        <h2 class="center-title">{{ $mainNews->news_title ?? '18 Top Fall Fashion Trends from New York Fashion' }}</h2>
                        <p class="center-text">{{ $mainNews->news_content_short ?? (isset($mainNews->news_content) ? Str::limit($mainNews->news_content, 100) : 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.') }}</p>
                        <ul class="center-links">
                            @if(isset($latestNews) && $latestNews->count() > 0)
                                @foreach($latestNews->take(3) as $news)
                                <li>{{ $news->news_title ?? 'Fashion Exhibitions Around The World To See In 2023' }}</li><br>
                                @endforeach
                            @else
                                <li>Fashion Exhibitions Around The World To See In 2023</li><br>
                                <li>New Milan Hot Spots for the Fashion Crowd – WWD</li><br>
                                <li>Angelina Jolie’s Cape Is Quite the Fashion Flashback</li>
                            @endif
                        </ul>
                    </div>
                    @else
                    <img src="{{ asset('images/img5.webp') }}" alt="" class="center-image">
                    <div class="center-overlay">
                        <div class="center-meta">
                            <span class="center-category">Fashion</span>
                            <span class="center-date">December 7, 2023</span>
                        </div>
                        <h2 class="center-title">18 Top Fall Fashion Trends from New York Fashion</h2>
                        <p class="center-text">Lorem Ipsum is simply dummy text of the printing and typesetting industry.</p>
                        <ul class="center-links">
                            <li>Fashion Exhibitions Around The World To See In 2023</li><br>
                            <li>New Milan Hot Spots for the Fashion Crowd – WWD</li><br>
                            <li>Angelina Jolie’s Cape Is Quite the Fashion Flashback</li>
                        </ul>
                    </div>
                    @endif
                </div>


                <!-- RIGHT : Popular News -->
                <div class="combo-right">
                    <h3 class="combo-title">Popular News</h3>
                    @if(isset($popularNews) && $popularNews->count() > 0)
                        @foreach($popularNews->take(2) as $news)
                        <div class="latest-card">
                                <img src="{{ asset('images/img8.webp') }}" class="social-icon">
                            <div class="latest-overlay">{{ $news->news_title ?? 'Fashion Exhibitions Around The World To See In 2023' }}</div>
                        </div>
                        @endforeach
                        @foreach($popularNews->skip(2)->take(3) as $news)
                        <div class="popular-item">
                            <h4>{{ $news->news_title ?? 'Exported electricity worth nearly Rs 2 billion to Europe' }}</h4>
                            <div class="featured-meta">
                                <span class="featured-author"><img src="{{ asset('images/clock.webp') }}" alt=""> {{ $news->stitle ?? 'Blaze' }}</span>
                                <span class="featured-date"><img src="{{ asset('images/clock.webp') }}" alt=""> {{ isset($news->news_date) ? date('F j, Y', strtotime($news->news_date)) : 'December 7, 2023' }}</span>
                            </div>
                        </div>
                        @endforeach
                    @else
                        <div class="latest-card">
                            <img src="{{ asset('images/img8.webp') }}" alt="">
                            <div class="latest-overlay">Fashion Exhibitions Around The World To See In 2023</div>
                        </div>
                        <div class="popular-item">
                            <h4>Exported electricity worth nearly Rs 2 billion to Europe</h4>
                            <div class="featured-meta">
                                <span class="featured-author"><img src="{{ asset('images/clock.webp') }}" alt=""> Blaze</span>
                                <span class="featured-date"><img src="{{ asset('images/clock.webp') }}" alt=""> December 7, 2023</span>
                            </div>
                        </div>
                        <div class="popular-item">
                            <h4>How Science Failed to Unlock The Mysteries of the Human Brain</h4>
                            <div class="featured-meta">
                                <span class="featured-author"><img src="{{ asset('images/clock.webp') }}" alt=""> Blaze</span>
                                <span class="featured-date"><img src="{{ asset('images/clock.webp') }}" alt=""> December 7, 2023</span>
                            </div>
                        </div>
                        <div class="popular-item">
                            <h4>NASA Sets Coverage for Two Spacewalks Outside Space Station</h4>
                            <div class="featured-meta">
                                <span class="featured-author"><img src="{{ asset('images/clock.webp') }}" alt=""> Blaze</span>
                                <span class="featured-date"><img src="{{ asset('images/clock.webp') }}" alt=""> December 7, 2023</span>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </section>


        <!-- 3rd section -->
        <section class="featured-section">
            <div class="featured-container">
                <div class="featured-header">
                    <h2>Featured Posts</h2>
                </div>
                <div class="featured-grid">
                    @if(isset($featuredNews) && $featuredNews->count() > 0)
                        @foreach($featuredNews->take(4) as $news)
                        <div class="featured-card">
                            <div class="featured-image">
                                <!-- <img src="{{ asset('images/' . ($news->photo ?? 'img6.webp')) }}" alt=""> -->
                                <img src="{{ asset('images/img8.webp') }}" class="social-icon">
                            </div>
                            <div class="featured-content">
                                <div class="featured-category">{{ $news->type ?? 'Fashion • Politics' }}</div>
                                <h3 class="featured-title">{{ $news->news_title ?? 'Fashion Exhibitions Around The World To See In 2023' }}</h3>
                                <div class="featured-meta">
                                    <span class="featured-author"><img src="{{ asset('images/clock.webp') }}" alt=""> {{ $news->stitle ?? 'Blaze' }}</span>
                                    <span class="featured-date"><img src="{{ asset('images/clock.webp') }}" alt=""> {{ isset($news->news_date) ? date('F j, Y', strtotime($news->news_date)) : 'December 7, 2023' }}</span>
                                </div>
                                <p class="featured-text">{{ $news->news_content_short ?? (isset($news->news_content) ? Str::limit($news->news_content, 100) : 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.') }}</p>
                            </div>
                        </div>
                        @endforeach
                    @else
                        <div class="featured-card">
                            <div class="featured-image"><img src="{{ asset('images/img6.webp') }}" alt=""></div>
                            <div class="featured-content">
                                <div class="featured-category">Fashion • Politics</div>
                                <h3 class="featured-title">Fashion Exhibitions Around The World To See In 2023</h3>
                                <div class="featured-meta">
                                    <span class="featured-author"><img src="{{ asset('images/clock.webp') }}" alt=""> Blaze</span>
                                    <span class="featured-date"><img src="{{ asset('images/clock.webp') }}" alt=""> December 7, 2023</span>
                                </div>
                                <p class="featured-text">Lorem Ipsum is simply dummy text of the printing and typesetting industry.</p>
                            </div>
                        </div>
                        <div class="featured-card">
                            <div class="featured-image"><img src="{{ asset('images/img5.webp') }}" alt=""></div>
                            <div class="featured-content">
                                <div class="featured-category">Fashion • Politics</div>
                                <h3 class="featured-title">Fashion Exhibitions Around The World To See In 2023</h3>
                                <div class="featured-meta">
                                    <span class="featured-author"><img src="{{ asset('images/clock.webp') }}" alt=""> Blaze</span>
                                    <span class="featured-date"><img src="{{ asset('images/clock.webp') }}" alt=""> December 7, 2023</span>
                                </div>
                                <p class="featured-text">Lorem Ipsum is simply dummy text of the printing and typesetting industry.</p>
                            </div>
                        </div>
                        <div class="featured-card">
                            <div class="featured-image"><img src="{{ asset('images/img7.webp') }}" alt=""></div>
                            <div class="featured-content">
                                <div class="featured-category">Fashion • Politics</div>
                                <h3 class="featured-title">Fashion Exhibitions Around The World To See In 2023</h3>
                                <div class="featured-meta">
                                    <span class="featured-author"><img src="{{ asset('images/clock.webp') }}" alt=""> Blaze</span>
                                    <span class="featured-date"><img src="{{ asset('images/clock.webp') }}" alt=""> December 7, 2023</span>
                                </div>
                                <p class="featured-text">Lorem Ipsum is simply dummy text of the printing and typesetting industry.</p>
                            </div>
                        </div>
                        <div class="featured-card">
                            <div class="featured-image"><img src="{{ asset('images/img8.webp') }}" alt=""></div>
                            <div class="featured-content">
                                <div class="featured-category">Fashion • Politics</div>
                                <h3 class="featured-title">Fashion Exhibitions Around The World To See In 2023</h3>
                                <div class="featured-meta">
                                    <span class="featured-author"><img src="{{ asset('images/clock.webp') }}" alt=""> Blaze</span>
                                    <span class="featured-date"><img src="{{ asset('images/clock.webp') }}" alt=""> December 7, 2023</span>
                                </div>
                                <p class="featured-text">Lorem Ipsum is simply dummy text of the printing and typesetting industry.</p>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </section>

        <!-- 4th section -->
        <section class="ad-banner-section">
            <div class="ad-banner-wrap">
                <!-- <img src="{{ asset('images/ad.webp') }}" alt="Advertisement"> -->
                <img src="{{ asset('images/img3.webp') }}" class="social-icon">
            </div>
        </section>


        <!-- 5th section -->
        <section class="post-news-section">
            <div class="post-news-container">
                <!-- LEFT SIDE -->
                <div class="post-area">
                    <div class="post-header">
                        <h2>Latest Posts</h2>
                        <div class="post-filter">
                            <span class="active">All</span>
                            <span>Technology</span>
                            <span>Science</span>
                        </div>
                    </div>
                    <div class="post-layout">
                        <!-- Big Post -->
                        <div class="post-main">
                            @if(isset($mainNews) && !is_null($mainNews))
                            <!-- <img src="{{ asset('images/' . ($mainNews->banner ?? $mainNews->photo ?? 'img5.webp')) }}" alt=""> -->
                            <img src="{{ asset('images/img2.webp') }}" class="social-icon">
                            <h3>{{ $mainNews->news_title ?? 'Fashion Exhibitions Around The World To See In 2023' }}</h3>
                            <div class="post-meta"> 🕓 {{ isset($mainNews->news_date) ? date('F j, Y', strtotime($mainNews->news_date)) : 'December 7, 2023' }} • 0</div>
                            <p>{{ $mainNews->news_content_short ?? (isset($mainNews->news_content) ? Str::limit($mainNews->news_content, 100) : 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.') }}</p>
                            @else
                            <img src="{{ asset('images/img5.webp') }}" alt="">
                            <h3>Fashion Exhibitions Around The World To See In 2023</h3>
                            <div class="post-meta"> 🕓 December 7, 2023 • 0</div>
                            <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry.</p>
                            @endif
                        </div>
                        <!-- Post List -->
                        <div class="post-list">
                            @if(isset($latestNews) && $latestNews->count() > 0)
                                @foreach($latestNews->take(4) as $news)
                                <div class="post-item">
                                    <!-- <img src="{{ asset('images/' . ($news->photo ?? 'img6.webp')) }}" alt=""> -->
                                    <img src="{{ asset('images/img5.webp') }}" class="social-icon">
                                    <div>
                                        <h4>{{ $news->news_title ?? 'Tech Weapons We Need To Combat Global Warming' }}</h4>
                                        <div class="post-meta"> 🕓 {{ isset($news->news_date) ? date('F j, Y', strtotime($news->news_date)) : 'December 7, 2023' }} • 0</div>
                                    </div>
                                </div>
                                @endforeach
                            @else
                                <div class="post-item">
                                    <img src="{{ asset('images/img6.webp') }}" alt="">
                                    <div><h4>Tech Weapons We Need To Combat Global Warming</h4><div class="post-meta"> 🕓 December 7, 2023 • 0</div></div>
                                </div>
                                <div class="post-item">
                                    <img src="{{ asset('images/img7.webp') }}" alt="">
                                    <div><h4>New Milan Hot Spots for the Fashion Crowd – WWD</h4><div class="post-meta">🕓 December 7, 2023 • 0</div></div>
                                </div>
                                <div class="post-item">
                                    <img src="{{ asset('images/img8.webp') }}" alt="">
                                    <div><h4>Angelina Jolie’s Cape Is Quite the Fashion Flashback</h4><div class="post-meta">🕓 December 7, 2023 • 0</div></div>
                                </div>
                                <div class="post-item">
                                    <img src="{{ asset('images/img1.webp') }}" alt="">
                                    <div><h4>Apple Unveils Smartwatch With a Focus on Fitness</h4><div class="post-meta">🕓 December 7, 2023 • 0</div></div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
                <!-- RIGHT SIDE -->
                <div class="news-area">
                    <h2 class="news-title">Latest News</h2>
                    <div class="news-grid">
                        @if(isset($latestNews) && $latestNews->count() > 0)
                            @foreach($latestNews->take(4) as $news)
                            <div class="news-card">
                                <div class="news-thumb">
                                    <!-- <img src="{{ asset('images/' . ($news->photo ?? 'img5.webp')) }}" alt=""> -->
                                    <img src="{{ asset('images/img1.webp') }}" class="social-icon">
                                    <span>{{ $news->type ?? 'Fashion' }}</span>
                                </div>
                                <h4>{{ $news->news_title ?? 'Fashion Exhibitions Around The World To See In 2023' }}</h4>
                            </div>
                            @endforeach
                        @else
                            <div class="news-card">
                                <div class="news-thumb"><img src="{{ asset('images/img5.webp') }}" alt=""><span>Fashion</span></div>
                                <h4>Fashion Exhibitions Around The World To See In 2023</h4>
                            </div>
                            <div class="news-card">
                                <div class="news-thumb"><img src="{{ asset('images/img6.webp') }}" alt=""><span>Science</span></div>
                                <h4>Tech Weapons We Need To Combat Global Warming</h4>
                            </div>
                            <div class="news-card">
                                <div class="news-thumb"><img src="{{ asset('images/img7.webp') }}" alt=""><span>Fashion</span></div>
                                <h4>New Milan Hot Spots for the Fashion Crowd – WWD</h4>
                            </div>
                            <div class="news-card">
                                <div class="news-thumb"><img src="{{ asset('images/img8.webp') }}" alt=""><span>Fashion</span></div>
                                <h4>Angelina Jolie’s Cape Is Quite the Fashion Flashback</h4>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </section>


<!-- 6th section -->
<section class="triple-news-section">
    <div class="triple-news-container">
        <!-- LEFT COLUMN -->
        <div class="triple-left">
            @if(isset($techNews) && $techNews->count() > 0)
                @foreach($techNews->take(6) as $news)
                <div class="triple-post">
                    <div class="triple-thumb">
                        <!-- <img src="{{ asset('images/' . ($news->photo ?? 'img5.webp')) }}" alt=""> -->
                        <img src="{{ asset('images/img1.webp') }}" class="social-icon">
                        <span class="triple-tag">{{ $news->type ?? 'Technology' }}</span>
                    </div>
                    <div class="triple-content">
                        <h3>{{ $news->news_title ?? 'Tech Weapons We Need To Combat Global Warming' }}</h3>
                        <div class="triple-meta">{{ $news->stitle ?? 'Blaze' }} • {{ isset($news->news_date) ? date('F j, Y', strtotime($news->news_date)) : 'December 7, 2023' }} • 1 min</div>
                        <p>{{ $news->news_content_short ?? (isset($news->news_content) ? Str::limit($news->news_content, 100) : 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.') }}</p>
                        <a href="#">Read More</a>
                    </div>
                </div>
                @endforeach
            @else
                <div class="triple-post">
                    <div class="triple-thumb"><img src="{{ asset('images/img5.webp') }}" alt=""><span class="triple-tag">Fashion</span></div>
                    <div class="triple-content">
                        <h3>Fashion Exhibitions Around The World To See In 2023</h3>
                        <div class="triple-meta">Blaze • December 7, 2023 • 1 min</div>
                        <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry.</p>
                        <a href="#">Read More</a>
                    </div>
                </div>
                <div class="triple-post">
                    <div class="triple-thumb"><img src="{{ asset('images/img6.webp') }}" alt=""><span class="triple-tag">Science</span></div>
                    <div class="triple-content">
                        <h3>Tech Weapons We Need To Combat Global Warming</h3>
                        <div class="triple-meta">Blaze • December 7, 2023 • 1 min</div>
                        <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry.</p>
                        <a href="#">Read More</a>
                    </div>
                </div>
            @endif
        </div>
        <!-- MIDDLE COLUMN -->
        <!-- <div class="triple-middle">
            <h2 class="news-title">Latest News</h2><br>
            @if(isset($scienceNews) && $scienceNews->count() > 0)
                @foreach($scienceNews->take(5) as $news)
                <div class="featured-card">
                    <div class="featured-image"><img src="{{ asset('images/' . ($news->photo ?? 'img6.webp')) }}" alt=""></div>
                    <div class="featured-content">
                        <div class="featured-category">{{ $news->type ?? 'Science' }}</div>
                        <h3 class="featured-title">{{ $news->news_title ?? 'Science News' }}</h3>
                    </div>
                </div>
                <br>
                @endforeach
            @else
                <div class="featured-card">
                    <div class="featured-image"><img src="{{ asset('images/img6.webp') }}" alt=""></div>
                    <div class="featured-content"><div class="featured-category">Fashion • Politics</div><h3 class="featured-title">Fashion Exhibitions Around The World To See In 2023</h3></div>
                </div><br>
                <div class="featured-card">
                    <div class="featured-image"><img src="{{ asset('images/img5.webp') }}" alt=""></div>
                    <div class="featured-content"><div class="featured-category">Fashion • Politics</div><h3 class="featured-title">Fashion Exhibitions Around The World To See In 2023</h3></div>
                </div>
            @endif
        </div> -->
        <!-- RIGHT SIDEBAR -->
        <div class="triple-sidebar">
            <h2 class="news-title">Find Me On</h2><br>
            <div class="sidebar-box">
                <div class="sidebar-social">
                    <a href="#"><img src="{{ asset('images/footer-instagram.webp') }}"></a>
                    <a href="#">
                        <img src="{{ asset('images/footer-twitter.webp') }}" class="social-icon">
                    <a href="#">
                        <img src="{{ asset('images/footer-youtube.webp') }}" class="social-icon">
                    <a href="#">
                        <img src="{{ asset('images/footer-substrack.webp') }}" class="social-icon">
                    </a>                
                </div>
            </div>
            <div class="sidebar-box">
                @if(isset($mainNews) && !is_null($mainNews))
                <img src="{{ asset('images/' . ($mainNews->banner ?? 'img5.webp')) }}" class="sidebar-ad" alt="Ad">
                @else
                <img src="{{ asset('images/img5.webp') }}" class="sidebar-ad" alt="Ad">
                @endif
            </div>
            <h2 class="news-title">Hot News</h2><br>
            <div class="sidebar-box">
                @if(isset($popularNews) && $popularNews->count() > 0)
                    @foreach($popularNews->take(1) as $news)
                    <div class="sidebar-card">
                        <div class="sidebar-card-img">
                            <!-- <img src="{{ asset('images/' . ($news->photo ?? 'img7.webp')) }}" alt=""> -->
                            <img src="{{ asset('images/img1.webp') }}" class="social-icon">
                            <span class="sidebar-tag">{{ $news->type ?? 'Fashion' }}</span>
                        </div>
                        <h4 class="sidebar-card-title">{{ $news->news_title ?? 'New Milan Hot Spots for the Fashion Crowd – WWD' }}</h4>
                        <div class="sidebar-card-date">{{ isset($news->news_date) ? date('F j, Y', strtotime($news->news_date)) : 'December 7, 2023' }}</div>
                    </div>
                    @endforeach
                @else
                    <div class="sidebar-card">
                        <div class="sidebar-card-img"><img src="{{ asset('images/img7.webp') }}" alt=""><span class="sidebar-tag">Fashion</span></div>
                        <h4 class="sidebar-card-title">New Milan Hot Spots for the Fashion Crowd – WWD</h4>
                        <div class="sidebar-card-date">December 7, 2023</div>
                    </div>
                @endif
            </div>
        </div>
    </div>
</section>


<!-- 7th section -->
<!-- <section class="stories-panel">
    <div class="stories-inner">
        <div class="stories-heading">
            <h2>Top Stories</h2>
        </div>
        <div class="stories-grid">
            @if(isset($topStories) && $topStories->count() > 0)
                @foreach($topStories->take(4) as $news)
                <div class="story-box">
                    <img src="{{ asset('images/' . ($news->photo ?? 'img1.webp')) }}" alt="">
                    <div class="story-overlay">
                        <span class="story-label">{{ $news->type ?? 'Technology' }}</span>
                        <h3 class="story-title">{{ $news->news_title ?? 'Google’s Self-Designed Tensor Chips will Power Its Next Pixel' }}</h3>
                        <div class="story-meta">
                            <div class="meta-left"><img src="{{ asset('images/clock.webp') }}" alt=""><span>{{ $news->stitle ?? 'Blaze' }}</span></div>
                            <div class="meta-right"><img src="{{ asset('images/clock.webp') }}" alt=""><span>{{ isset($news->news_date) ? date('F j, Y', strtotime($news->news_date)) : 'Dec 7, 2023' }}</span></div>
                        </div>
                    </div>
                </div>
                @endforeach
            @else
                <div class="story-box">
                    <img src="{{ asset('images/img1.webp') }}" alt="">
                    <div class="story-overlay">
                        <span class="story-label">Technology</span>
                        <h3 class="story-title">Google’s Self-Designed Tensor Chips will Power Its Next Pixel</h3>
                        <div class="story-meta">
                            <div class="meta-left"><img src="{{ asset('images/clock.webp') }}" alt=""><span>Blaze</span></div>
                            <div class="meta-right"><img src="{{ asset('images/clock.webp') }}" alt=""><span>Dec 7, 2023</span></div>
                        </div>
                    </div>
                </div>
                <div class="story-box">
                    <img src="{{ asset('images/img2.webp') }}" alt="">
                    <div class="story-overlay">
                        <span class="story-label">Technology</span>
                        <h3 class="story-title">Sony WF-10XM4: Headphones Are Our Absolute Favorite</h3>
                        <div class="story-meta">
                            <div class="meta-left"><img src="{{ asset('images/clock.webp') }}" alt=""><span>Blaze</span></div>
                            <div class="meta-right"><img src="{{ asset('images/clock.webp') }}" alt=""><span>Dec 7, 2023</span></div>
                        </div>
                    </div>
                </div>
                <div class="story-box">
                    <img src="{{ asset('images/img3.webp') }}" alt="">
                    <div class="story-overlay">
                        <span class="story-label">Politics</span>
                        <h3 class="story-title">What Is Women’s Equality Day and Why Is It Celebrated?</h3>
                        <div class="story-meta">
                            <div class="meta-left"><img src="{{ asset('images/clock.webp') }}" alt=""><span>Blaze</span></div>
                            <div class="meta-right"><img src="{{ asset('images/clock.webp') }}" alt=""><span>Dec 7, 2023</span></div>
                        </div>
                    </div>
                </div>
                <div class="story-box">
                    <img src="{{ asset('images/img4.webp') }}" alt="">
                    <div class="story-overlay">
                        <span class="story-label">Science</span>
                        <h3 class="story-title">How Science Failed to Unlock the Mysteries of the Human</h3>
                        <div class="story-meta">
                            <div class="meta-left"><img src="{{ asset('images/clock.webp') }}" alt=""><span>Blaze</span></div>
                            <div class="meta-right"><img src="{{ asset('images/clock.webp') }}" alt=""><span>Dec 7, 2023</span></div>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
</section> -->

    </div>
</section>



@endsection