@extends('layouts.app')

@section('title', $category->meta_title ?? $category->category_name)
@section('meta_description', $category->meta_description ?? '')

@section('content')

<section class="triple-news-section">
    <div class="triple-news-container">

        <!-- LEFT COLUMN -->
        <div class="triple-left">

            <!-- Breadcrumb -->
            <div class="detail-breadcrumb-card">
                Home » {{ $category->category_name }}
            </div>
            <br>

            <!-- Category Banner -->
            @if($category->category_banner)
                <div class="category-banner">
                    <img src="{{ asset('images/' . $category->category_banner) }}" alt="{{ $category->category_name }}">
                </div>
                <br>
            @endif

            <!-- Category Title -->
            <h2 class="news-title">
                Category: {{ $category->category_name }}
            </h2>
            <br>

            <!-- POSTS LOOP -->
            @forelse($news as $item)
                <div class="triple-post">

                    <div class="triple-thumb">
                        <img src="{{ asset('images/' . ($item->photo ?? 'img5.webp')) }}" alt="">
                        <span class="triple-tag">
                            {{ $category->category_name }}
                        </span>
                    </div>

                    <div class="triple-content">

                        <h3>{{ $item->news_title }}</h3>

                        <div class="triple-meta">
                            {{ $item->stitle ?? 'Admin' }} •
                            {{ date('F j, Y', strtotime($item->news_date)) }} •
                            1 min
                        </div>

                        <p>
                            {{ \Illuminate\Support\Str::limit($item->news_content, 180) }}
                        </p>

                        <span class="read-more-btn">Read More</span>

                    </div>
                </div>

            @empty
                <div class="triple-post">
                    <div class="triple-content">
                        <h3>No posts available in this category.</h3>
                    </div>
                </div>
            @endforelse


            <!-- PAGINATION -->
            <!-- <div class="pagination-wrapper">
                {{ $news->links() }}
            </div> -->

        </div>


        <!-- MIDDLE COLUMN -->
        <div class="triple-middle">

            <h2 class="news-title">Latest News</h2>
            <br>

            @if(isset($latestNews) && $latestNews->count() > 0)

                @foreach($latestNews as $latest)
                    <div class="featured-card">

                        <div class="featured-image">
                            <img src="{{ asset('images/' . ($latest->photo ?? 'img6.webp')) }}" alt="">
                        </div>

                        <div class="featured-content">
                            <div class="featured-category">
                                {{ $latest->type ?? 'News' }}
                            </div>

                            <h3 class="featured-title">
                                {{ $latest->news_title }}
                            </h3>
                        </div>

                    </div>
                    <br>
                @endforeach

            @endif

        </div>


        <!-- RIGHT SIDEBAR -->
        <div class="triple-sidebar">

            <h2 class="news-title">Find Me On</h2>
            <br>

            <!-- Social Icons -->
            <div class="sidebar-box">
                <div class="sidebar-social">
                    <img src="{{ asset('images/footer-instagram.webp') }}">
                    <img src="{{ asset('images/footer-twitter.webp') }}">
                    <img src="{{ asset('images/footer-substack.webp') }}">
                    <img src="{{ asset('images/footer-youtube.webp') }}">
                </div>
            </div>

            <!-- Advertisement -->
            <div class="sidebar-box">
                <img src="{{ asset('images/img5.webp') }}" class="sidebar-ad" alt="Ad">
            </div>

            <!-- Hot News -->
            <h2 class="news-title">Hot News</h2>
            <br>

            <div class="sidebar-box">

                @if(isset($latestNews) && $latestNews->count() > 0)

                    @php $hot = $latestNews->first(); @endphp

                    <div class="sidebar-card">

                        <div class="sidebar-card-img">
                            <img src="{{ asset('images/' . ($hot->photo ?? 'img7.webp')) }}" alt="">
                            <span class="sidebar-tag">
                                {{ $hot->type ?? 'News' }}
                            </span>
                        </div>

                        <h4 class="sidebar-card-title">
                            {{ $hot->news_title }}
                        </h4>

                        <div class="sidebar-card-date">
                            {{ date('F j, Y', strtotime($hot->news_date)) }}
                        </div>

                    </div>

                @endif

            </div>

        </div>

    </div>
</section>

@endsection