<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class News extends Model
{
    // Define the table name if it's not the plural of model name
    protected $table = 'tbl_news';
    
    // Define primary key if it's not 'id'
    protected $primaryKey = 'news_id';
    
    // Disable timestamps if your table doesn't have created_at/updated_at
    public $timestamps = false;
    
    // Define which fields can be mass assigned
    protected $fillable = [
        'news_title',
        'news_content',
        'news_content_short',
        'news_date',
        'photo',
        'banner',
        'category_id',
        'comment',
        'meta_title',
        'meta_keyword',
        'meta_description',
        'lang_id',
        'stitle',
        'title',
        'img_alt',
        'domain_id',
        'encode_title',
        'type'
    ];
    
    // Optional: Accessor for formatted date
    public function getFormattedDateAttribute()
    {
        return date('F j, Y', strtotime($this->news_date));
    }
}