<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Comment extends Model
{
    protected $table = 'tbl_comment';
    protected $primaryKey = 'comment_id';
    public $timestamps = false;

    protected $fillable = [
        'code_body',
        'code_main'
    ];

    // Relationship with news
    public function news()
    {
        return $this->belongsTo(News::class, 'news_id', 'news_id');
    }
}