<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    protected $table = 'tbl_category';
    protected $primaryKey = 'category_id';
    public $timestamps = false;

    protected $fillable = [
        'category_name',
        'category_banner',
        'meta_title',
        'meta_keyword',
        'meta_description',
        'type',
        'lang_id'
    ];

    // Relationship with news
    public function news()
    {
        return $this->hasMany(News::class, 'category_id', 'category_id');
    }
}