<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\News;
use App\Models\Author;

use Illuminate\Http\Request;

class NewsController extends Controller
{
    public function index(Request $request)
    {
        $query = $request->q;

        if ($query) {
            $searchResults = News::where(function ($q) use ($query) {
                    $q->where('news_title', 'LIKE', "%{$query}%")
                    ->orWhere('news_content', 'LIKE', "%{$query}%")
                    ->orWhere('type', 'LIKE', "%{$query}%");
                })
                ->orderBy('news_date', 'desc')
                ->paginate(10);

            return view('index', compact('searchResults', 'query'));
        }

        $mainNews = News::latest('news_date')->first();

        $headlineNews = News::latest('news_id')
            ->take(5)
            ->get();

        $latestNews = News::when($mainNews, function ($q) use ($mainNews) {
                $q->where('news_id', '!=', $mainNews->news_id);
            })
            ->latest('news_date')
            ->take(10)
            ->get();

        $featuredNews = News::where('type', 'featured')
            ->latest('news_date')
            ->take(4)
            ->get();

        if ($featuredNews->isEmpty()) {
            $featuredNews = News::latest('news_date')->take(4)->get();
        }

        $popularNews = News::latest('news_date')->take(5)->get();

        $topStories = News::whereIn('type', ['story', 'top'])
            ->latest('news_date')
            ->take(4)
            ->get();

        $techNews = News::where(function ($q) {
                $q->where('category_id', 1)
                ->orWhere('type', 'technology');
            })
            ->latest('news_date')
            ->take(6)
            ->get();

        $scienceNews = News::where(function ($q) {
                $q->where('category_id', 2)
                ->orWhere('type', 'science');
            })
            ->latest('news_date')
            ->take(6)
            ->get();

        return view('index', compact(
            'headlineNews',
            'mainNews',
            'latestNews',
            'featuredNews',
            'popularNews',
            'topStories',
            'techNews',
            'scienceNews'
        ));
    }
    // public function index(Request $request)
    // {
    //     $query = $request->q;

    //     // Search on homepage if keyword exists
    //     if ($query) {
    //         $searchResults = News::where('news_title', 'LIKE', "%{$query}%")
    //             ->orWhere('news_content', 'LIKE', "%{$query}%")
    //             ->orWhere('type', 'LIKE', "%{$query}%")
    //             ->orderBy('news_date', 'desc')
    //             ->get();

    //         return view('index', compact('searchResults', 'query'));
    //     }

    //     // Get the first news record from the database (lowest ID or most recent)
    //     $headlineNews = News::orderBy('news_id', 'desc')->take(5)->get();

    //     // dd($mainNews);
    //     // OR use this to get the most recent:
    //     $mainNews = News::orderBy('news_date', 'desc')->first(); // Gets the most recent
    //     // Get other news items (excluding the main one if it exists)
    //     $latestNews = News::query();
    //     if ($mainNews) {
    //         $latestNews = $latestNews->where('news_id', '!=', $mainNews->news_id);
    //     }
    //     $latestNews = $latestNews->orderBy('news_date', 'desc')
    //         ->take(10)
    //         ->get();
            
    //     // Featured news - if type field is used for this
    //     $featuredNews = News::where('type', 'featured')
    //         ->orderBy('news_date', 'desc')
    //         ->take(4)
    //         ->get();
        
    //     // If no featured news, get some recent ones
    //     if ($featuredNews->isEmpty()) {
    //         $featuredNews = News::orderBy('news_date', 'desc')
    //             ->take(4)
    //             ->get();
    //     }
        
    //     // Popular news - you might want to define your own logic
    //     // For now, just get recent news
    //     $popularNews = News::orderBy('news_date', 'desc')
    //         ->take(5)
    //         ->get();
            
    //     // Top stories
    //     $topStories = News::whereIn('type', ['story', 'top'])
    //         ->orderBy('news_date', 'desc')
    //         ->take(4)
    //         ->get();
        
    //     if ($topStories->isEmpty()) {
    //         $topStories = News::orderBy('news_date', 'desc')
    //             ->take(4)
    //             ->get();
    //     }
        
    //     // Tech news - based on category_id or type
    //     $techNews = News::where('category_id', 1)
    //         ->orWhere('type', 'technology')
    //         ->orderBy('news_date', 'desc')
    //         ->take(6)
    //         ->get();
        
    //     if ($techNews->isEmpty()) {
    //         $techNews = News::orderBy('news_date', 'desc')
    //             ->take(6)
    //             ->get();
    //     }
        
    //     // Science news
    //     $scienceNews = News::where('category_id', 2)
    //         ->orWhere('type', 'science')
    //         ->orderBy('news_date', 'desc')
    //         ->take(6)
    //         ->get();
        
    //     if ($scienceNews->isEmpty()) {
    //         $scienceNews = News::orderBy('news_date', 'desc')
    //             ->take(6)
    //             ->get();
    //     }

    //         // dd($mainNews, $latestNews,$featuredNews,$popularNews,$scienceNews);

        
    //     return view('index', compact(
    //         'headlineNews',
    //         'mainNews',
    //         'latestNews',
    //         'featuredNews',
    //         'popularNews',
    //         'topStories',
    //         'techNews',
    //         'scienceNews'
    //     ));
    // }

    /**
     * Show the category page
     */
    public function category($slug)
    {
        // Get category using slug
        $category = Category::where('slug', $slug)->firstOrFail();

        // Get news under this category
        $news = News::where('category_id', $category->category_id)
            ->orderBy('news_date', 'desc')
            ->paginate(10);

        // Sidebar latest news (optional)
        $latestNews = News::latest('news_date')
            ->take(5)
            ->get();

        return view('category-business', compact(
            'category',
            'news',
            'latestNews'
        ));
    }
   
    /**
     * Show the author page
     */
    public function show($slug)
    {
        $author = Author::where('slug', $slug)->firstOrFail();

        return view('author', compact('author'));
    }
    /**
     * Show the about page
     */
    public function about()
    {
        return view('about');
    }
    /**
     * Show the about page
     */
    public function privacy()
    {
        return view('privacy_policy');
    }
}