document.addEventListener('DOMContentLoaded', function () {
  const hamburger = document.querySelector('.hamburger');
  const sidebar = document.getElementById('mobileSidebar');
  const closeBtn = document.querySelector('.sidebar-close');

  if (!hamburger || !sidebar || !closeBtn) return;

  // Open sidebar
  hamburger.addEventListener('click', function (e) {
    e.stopPropagation();
    sidebar.classList.add('active');
    sidebar.setAttribute('aria-hidden', 'false');
  });

  // Close sidebar button
  closeBtn.addEventListener('click', function () {
    closeSidebar();
  });

  // Close on outside click
  document.addEventListener('click', function (e) {
    if (
      sidebar.classList.contains('active') &&
      !sidebar.contains(e.target) &&
      !hamburger.contains(e.target)
    ) {
      closeSidebar();
    }
  });

  function closeSidebar() {
    sidebar.classList.remove('active');
    sidebar.setAttribute('aria-hidden', 'true');
  }
});
