<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Foxiz - Latest news, celebrity gossip, fashion trends, sports updates, and business insights. Stay informed with our comprehensive coverage.">
    <meta name="keywords" content="news, celebrity, fashion, sports, business, entertainment, lifestyle">
    <meta name="author" content="Foxiz">
    <meta property="og:title" content="Foxiz - Your Daily Dose of News & Entertainment">
    <meta property="og:description" content="Stay updated with the latest trends in celebrity, fashion, sports, and business.">
    <meta property="og:type" content="website">
    <meta property="og:url" content="https://foxiz.io">
    <meta property="og:image" content="https://foxiz.io/images/og-image.webp">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="canonical" href="https://foxiz.io/">
    <link rel="icon" type="image/x-icon" href="favicon.ico">
    
    <title>Foxiz - Latest News, Celebrity, Fashion, Sports & Business Updates</title>
    
    <!-- Preload critical assets -->
    <link rel="preload" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" as="style">
    <link rel="stylesheet" href="style.css">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    
    <!-- Google Fonts for better typography -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Rajdhani:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Schema.org structured data -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "NewsMediaOrganization",
        "name": "Foxiz",
        "url": "https://foxiz.io",
        "logo": "https://foxiz.io/logo.png",
        "sameAs": [
            "https://facebook.com/foxiz",
            "https://twitter.com/foxiz",
            "https://youtube.com/foxiz"
        ]
    }
    </script>
</head>
<body>
    
    <div class="main-content">
        <?php include 'header.php'; ?>
        
        <!-- Your page content goes here -->
        <main class="page-content">
            <div class="editorial-layout">
                <!-- COLUMN 1: FEATURED CARD (YOUR ORIGINAL DESIGN) -->
                <div class="editorial-featured">
                    <article class="fashion-card">
                        <div class="fashion-image">
                            <img src="uploads/bz102-860x573.webp" alt="Fashion editorial">
                        </div>

                        <div class="fashion-content">
                            <span class="fashion-category">FASHION</span>

                            <h2 class="fashion-title">
                                Simple Styling Tricks That Fashion Insiders Swear By Every Day
                            </h2>

                            <span class="fashion-divider"></span>

                            <p class="fashion-description">
                                Discover how simple adjustments in fit, layers, and accessories can transform
                                basic outfits into polished looks that feel effortless yet refined…
                            </p>
                        </div>
                    </article>
                </div>

                <!-- COLUMN 2: STACKED SMALL CARDS -->
                <div class="news-column">

                <!-- News Card -->
                <article class="news-card">
                    <div class="news-image">
                    <img src="uploads/image-fashion.webp" alt="Fashion shopping couple" >
                    </div>

                    <div class="news-meta">
                    <span class="news-category fashion">FASHION</span>
                    <span class="news-separator">//</span>
                    <span class="news-date">August 2, 2025</span>
                    </div>

                    <h2 class="news-title">
                    Chic Outfit Ideas for Days When You Feel Uninspired
                    </h2>
                </article>

                <!-- News Card -->
                <article class="news-card">
                    <div class="news-image">
                    <img src="uploads/image-politics.webp" alt="Minimum wage protest">
                    </div>

                    <div class="news-meta">
                    <span class="news-category politics">POLITICS</span>
                    <span class="news-separator">//</span>
                    <span class="news-date">August 1, 2025</span>
                    </div>

                    <h2 class="news-title">
                    $15 Minimum Wage Could Raise Pay for Over 20 Million Workers
                    </h2>
                </article>

                </div>

                <!-- COLUMN 3: SIDEBAR (AS PER YOUR IMAGE) -->
                <aside class="editorial-sidebar">
                    <h3 class="sidebar-title">WHAT'S HOT</h3>
                    <ol class="whats-hot-list">
                        <li>
                            <h4 class="whats-hot-title">Simple Styling Tricks That Fashion Insiders Swear By Every Day</h4>
                        </li>
                        <div class="sidebar-ad">
                            <span class="ad-label">Advertisement</span>
                                <div class="ad-content">
                                    <img src="uploads/advert.webp" width="250" height="285"/>
                                </div>
                        </div>
                        <li>
                            <h4 class="whats-hot-title">Protecting Yourself Against Excessive Blue Light</h4>
                        </li>
                        <li>
                            <h4 class="whats-hot-title">These 5 Smart Inventions Started as Internet Projects</h4>
                        </li>
                    </ol>
                </aside>
            </div>
            <div class="news-row-horizontal">

                <!-- NEWS CARD 1 -->
            <article class="row-card">
                    <div class="row-image">
                    <img src="uploads/Two-Anti-Lockdown-Leaders-Arrested-as-Protests-Held-Across-Valinor-860x573.webp" alt="Police arrest protesters during anti-lockdown demonstrations">
                    </div>

                    <div class="row-meta">
                    <span class="row-category">POLITICS</span>
                    <span class="row-separator">//</span>
                    <span class="row-date">August 1, 2025</span>
                    </div>

                    <h3 class="row-title">
                    Two Anti-Lockdown Leaders Arrested as Protests Held Across Valinor
                    </h3>
            </article>

                <!-- NEWS CARD 2 -->
            <article class="row-card">
                    <div class="row-image">
                    <img src="uploads/bz111-860x573.webp" alt="Fashion models posing in studio">
                    </div>

                    <div class="row-meta">
                    <span class="row-category">CELEBRITY</span>
                    <span class="row-separator">//</span>
                    <span class="row-date">August 1, 2025</span>
                    </div>

                    <h3 class="row-title">
                    Skylar Monroe’s Rise: Behind the Breakout Action Hit
                    </h3>
            </article>

                <!-- NEWS CARD 3 -->
            <article class="row-card">
                    <div class="row-image">
                    <img src="uploads/csacwe.webp" alt="Person using smartphone app interface">
                    </div>

                    <div class="row-meta">
                    <span class="row-category">TECHNOLOGY</span>
                    <span class="row-separator">//</span>
                    <span class="row-date">August 1, 2025</span>
                    </div>

                    <h3 class="row-title">
                    Hands-On With the iPhone 27, Pro, Max, and Mini
                    </h3>
            </article>

                <!-- NEWS CARD 4 -->
            <article class="row-card">
                    <div class="row-image">
                    <img src="uploads/bz106-860x573.webp" alt="Man holding coffee wearing blazer near waterfront">
                    </div>

                    <div class="row-meta">
                    <span class="row-category">FASHION</span>
                    <span class="row-separator">//</span>
                    <span class="row-date">July 30, 2025</span>
                    </div>

                    <h3 class="row-title">
                    Simple Styling Tricks That Fashion Insiders Swear By Every Day
                    </h3>
            </article>

                <!-- NEWS CARD 5 -->
            <article class="row-card">
                    <div class="row-image">
                    <img src="uploads/vcvjhsa.webp" alt="Woman walking on street wearing casual outfit">
                    </div>

                    <div class="row-meta">
                    <span class="row-category">CELEBRITY</span>
                    <span class="row-separator">//</span>
                    <span class="row-date">July 30, 2025</span>
                    </div>

                    <h3 class="row-title">
                    Clara Evermore Returns to Stage After Mental Health Break
                    </h3>
            </article>

            </div>
            <!-- Advertisement Label -->
            <div class="ad-label-top">- Advertisement -</div>

            <!-- Ad Banner -->
            <section class="promo-ad">
                <div class="promo-bg">
                    <!-- Background image -->
                    <img src="uploads/wide-banner-w.webp" alt="Promotional background image">
                </div>
            </section>
            <!-- News Section Div -->
            <div class="news-section">
                <div class="news-banner">More News</div>
                <a href="#" class="explore-link">Explore Blog...</a>
            </div>
            <div class="homepage-news-layout">

                <!-- LEFT COLUMN -->
                <div class="homepage-left-column">

                    <div class="custom-news-card">
                        <div class="custom-category-text">Technology</div>
                        <div class="custom-news-title">
                            Streaming Platforms Battle Over Next-Gen Spatial Audio Features
                        </div>
                    </div>

                    <!-- Smaller News Cards -->
                    <div class="news-cards-container">

                        <!-- News Item 1 -->
                        <div class="news-cards">
                            <div class="news-card-image" style="background-image: url('uploads/bz120-860x516.webp');"></div>
                            <div class="news-card-content">
                                <div class="card-category">Celebrity</div>
                                <div class="card-date">July 30, 2025</div>
                                <div class="card-title">
                                    Levi Kingston Reveals Massive Income From Live Streams
                                </div>
                            </div>
                        </div>

                        <!-- News Item 2 -->
                        <div class="news-cards">
                            <div class="news-card-image" style="background-image: url('uploads/bz100-860x573.webp');"></div>
                            <div class="news-card-content">
                                <div class="card-category">Fashion</div>
                                <div class="card-date">July 29, 2025</div>
                                <div class="card-title">
                                    Iconic 90s Trends That Are Making a Huge Comeback
                                </div>
                            </div>
                        </div>

                    </div>
                </div>

                <!-- RIGHT COLUMN (FIXED POSITION) -->
                <div class="homepage-right-column">

                    <!-- News Articles Container -->
                    <div class="article-list">

                        <!-- News Article 1 -->
                        <div class="article-card">
                            <div class="article-image" style="background-image: url('uploads/Is-Bad-Bunny-the-New-Face-of-Genderless-Fashion-860x573.webp');"></div>
                            <div class="article-details">
                                <div class="card-category">Fashion</div>
                                <div class="article-date">July 20, 2025</div>
                                <div class="article-heading">
                                    Is Bad Bunny the New Face of Genderless Fashion?
                                </div>
                            </div>
                        </div>

                        <!-- News Article 2 -->
                        <div class="article-card">
                            <div class="article-image" style="background-image: url('uploads/bz103-860x573.webp');"></div>
                            <div class="article-details">
                                <div class="card-category">Fashion</div>
                                <div class="article-date">July 4, 2025</div>
                                <div class="article-heading">
                                    Fashion Influencers to Follow for Daily Style Inspiration
                                </div>
                            </div>
                        </div>

                        <!-- News Article 3 -->
                        <div class="article-card">
                            <div class="article-image" style="background-image: url('uploads/bz119-860x573.webp');"></div>
                            <div class="article-details">
                                <div class="card-category">Technology</div>
                                <div class="article-date">June 16, 2025</div>
                                <div class="article-heading">
                                    If You Love Music, These Headphones Will Blow Your Mind
                                </div>
                            </div>
                        </div>

                        <!-- News Article 4 -->
                        <div class="article-card">
                            <div class="article-image" style="background-image: url('uploads/bz113-860x573.webp');"></div>
                            <div class="article-details">
                                <div class="card-category">Technology</div>
                                <div class="article-date">June 16, 2025</div>
                                <div class="article-heading">
                                    Global Chip Shortage to Hurt Computer Firms During Festive
                                </div>
                            </div>
                        </div>

                        <!-- News Article 5 -->
                        <div class="article-card">
                            <div class="article-image" style="background-image: url('uploads/Exclusive-Here-Are-the-4-Cheapest-Electric-Vehicles-You-Can-Buy-860x573.webp');"></div>
                            <div class="article-details">
                                <div class="card-category">Technology</div>
                                <div class="article-date">June 16, 2025</div>
                                <div class="article-heading">
                                    Exclusive: Here Are the 4 Cheapest Electric Vehicles You Can Buy
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="newsletter-box">
            <div class="logo-container">
                <!--<img src="uploads/logo.png" alt="Logo" class="logos">-->
            </div>
            
            <div class="content">
                <h2>Fast, reliable updates that keep you in the know!</h2>
                
                <div class="input-container">
                <input type="email" placeholder="Your email address" class="email-input">
                </div>
                
                <div class="terms">
                <input type="checkbox" id="terms" class="terms-checkbox">
                <label for="terms">I have read and agree to the terms & conditions</label>
                </div>
                
                <button class="sign-up-btn">Sign Up Now</button>
            </div>
            </div>
            <div class="custom-container">
                <!-- Left Column -->
                <div class="custom-left-column">
                    <!-- Image Box with Text -->
                    <div class="custom-image-box">
                    <img src="uploads/cat-1.webp" alt="Category Image" class="custom-category-image">
                    <div class="custom-catogory-text">Fashion</div>
                    </div>

                    <!-- Trending Section -->
                    <div class="custom-trending">
                    <h3 class="custom-section-title">Trending</h3>
                    <ol class="custom-trending-list">
                        <li class="custom-trending-item">Two Anti-Lockdown Leaders Arrested as Protests Held Across Valinor</li>
                        <li class="custom-trending-item">Skylar Monroe’s Rise: Behind the Breakout Action Hit</li>
                        <li class="custom-trending-item">Hands-On With the iPhone 27, Pro, Max, and Mini</li>
                        <li class="custom-trending-item">Simple Styling Tricks That Fashion Insiders Swear By Every Day</li>
                    </ol>
                    </div>
                </div>

                <!-- Right Column -->
                <div class="custom-right-column">
                    <div class="custom-category-banner">
                        <span class="custom-category-title">Most Recent</span>
                        <!--<a href="#" class="custom-view-category">View Category</a>-->
                    </div>

                    <div class="custom-news-grid">
                    <!-- News Item 1 -->
                        <div class="custm-news-card">
                            <img src="uploads/bz133-860x574.webp" alt="News Image" class="custom-news-image">
                            <div class="custom-news-content">
                            <span class="news-category fashion">Outfit Ideas</span>
                            <span class="custom-news-date">June 15, 2025</span>
                            <h3 class="custm-news-title">Can the Fashion Industry Ever Be Truly Inclusive?</h3>
                            </div>
                        </div>

                        <!-- Repeat News Item 2 to 6 here -->
                        <!-- News Item 2 -->
                        <div class="custm-news-card">
                            <img src="uploads/bz109-860x573.webp" alt="News Image" class="custom-news-image">
                            <div class="custom-news-content">
                            <span class="news-category fashion">Fashion History</span>
                            <span class="custom-news-date">June 15, 2025</span>
                            <h3 class="custm-news-title">Bold Colors and Patterns That Are Trending This Season</h3>
                            </div>
                        </div>
                        <div class="custm-news-card">
                            <img src="uploads/bz108-860x572.webp" alt="News Image" class="custom-news-image">
                            <div class="custom-news-content">
                            <span class="news-category fashion">Fashion History</span>
                            <span class="custom-news-date">June 15, 2025</span>
                            <h3 class="custm-news-title">Bold Colors and Patterns That Are Trending This Season</h3>
                            </div>
                        </div>
                        <div class="custm-news-card">
                            <img src="uploads/Fashions-Obsession-with-the-90s-Has-Gone-Too-Far-860x573.webp" alt="News Image" class="custom-news-image">
                            <div class="custom-news-content">
                            <span class="news-category fashion">Fashion History</span>
                            <span class="custom-news-date">June 15, 2025</span>
                            <h3 class="custm-news-title">Bold Colors and Patterns That Are Trending This Season</h3>
                            </div>
                        </div>
                        <div class="custm-news-card">
                            <img src="uploads/These-Ugly-Shoes-Are-Now-a-Status-Symbol-860x573.webp" alt="News Image" class="custom-news-image">
                            <div class="custom-news-content">
                            <span class="news-category fashion">Fashion History</span>
                            <span class="custom-news-date">June 15, 2025</span>
                            <h3 class="custm-news-title">Bold Colors and Patterns That Are Trending This Season</h3>
                            </div>
                        </div>
                        <div class="custm-news-card">
                            <img src="uploads/bz104-860x573.webp" alt="News Image" class="custom-news-image">
                            <div class="custom-news-content">
                            <span class="news-category fashion">Fashion History</span>
                            <span class="custom-news-date">June 15, 2025</span>
                            <h3 class="custm-news-title">Bold Colors and Patterns That Are Trending This Season</h3>
                        </div>
                    </div>
                </div>
            </div>
        </div>
                <div class="social-media-bar">
                <div class="social-icons">
                    <i class="fab fa-facebook-f"></i>
                    <span>Facebook</span>
                </div>
                <div class="social-icons">
                    <i class="fab fa-x"></i>
                    <span>Like</span>
                </div>
                <div class="social-icons">
                    <i class="fab fa-instagram"></i>
                    <span>Follow</span>
                </div>
                <div class="social-icons">
                    <i class="fab fa-youtube"></i>
                    <span>Subscribe</span>
                </div>
                </div>  
                <div class="custom-container">
                <!-- Left Column -->
                <div class="custom-left-column">
                    <!-- Image Box with Text -->
                    <div class="custom-image-box">
                    <img src="uploads/travel.webp" alt="Category Image" class="custom-category-image">
                    <div class="custom-catogory-text">Travel</div>
                    </div>

                    <!-- Trending Section -->
                    <div class="custom-trending">
                    <h3 class="custom-section-title">Trending</h3>
                    <ol class="custom-trending-list">
                        <li class="custom-trending-item">Two Anti-Lockdown Leaders Arrested as Protests Held Across Valinor</li>
                        <li class="custom-trending-item">Skylar Monroe’s Rise: Behind the Breakout Action Hit</li>
                        <li class="custom-trending-item">Hands-On With the iPhone 27, Pro, Max, and Mini</li>
                        <li class="custom-trending-item">Simple Styling Tricks That Fashion Insiders Swear By Every Day</li>
                    </ol>
                    </div>
                </div>

                <!-- Right Column -->
                <div class="custom-right-column">
                    <div class="custom-category-banner">
                        <span class="custom-category-title">Most Recent</span>
                        <!--<a href="#" class="custom-view-category">View Category</a>-->
                    </div>

                    <div class="custom-news-grid">
                    <!-- News Item 1 -->
                        <div class="custm-news-card">
                            <img src="uploads/ggyu.webp" alt="News Image" class="custom-news-image">
                            <div class="custom-news-content">
                            <span class="news-category fashion">Outfit Ideas</span>
                            <span class="custom-news-date">June 15, 2025</span>
                            <h3 class="custm-news-title">Can the Fashion Industry Ever Be Truly Inclusive?</h3>
                            </div>
                        </div>

                        <!-- Repeat News Item 2 to 6 here -->
                        <!-- News Item 2 -->
                        <div class="custm-news-card">
                            <img src="uploads/vhvhg.webp" alt="News Image" class="custom-news-image">
                            <div class="custom-news-content">
                            <span class="news-category fashion">Fashion History</span>
                            <span class="custom-news-date">June 15, 2025</span>
                            <h3 class="custm-news-title">Bold Colors and Patterns That Are Trending This Season</h3>
                            </div>
                        </div>
                        <div class="custm-news-card">
                            <img src="uploads/gccg.webp" alt="News Image" class="custom-news-image">
                            <div class="custom-news-content">
                            <span class="news-category fashion">Fashion History</span>
                            <span class="custom-news-date">June 15, 2025</span>
                            <h3 class="custm-news-title">Bold Colors and Patterns That Are Trending This Season</h3>
                            </div>
                        </div>
                        <div class="custm-news-card">
                            <img src="uploads/vhgvb.webp" alt="News Image" class="custom-news-image">
                            <div class="custom-news-content">
                            <span class="news-category fashion">Fashion History</span>
                            <span class="custom-news-date">June 15, 2025</span>
                            <h3 class="custm-news-title">Bold Colors and Patterns That Are Trending This Season</h3>
                            </div>
                        </div>
                        <div class="custm-news-card">
                            <img src="uploads/hv.webp" alt="News Image" class="custom-news-image">
                            <div class="custom-news-content">
                            <span class="news-category fashion">Fashion History</span>
                            <span class="custom-news-date">June 15, 2025</span>
                            <h3 class="custm-news-title">Bold Colors and Patterns That Are Trending This Season</h3>
                            </div>
                        </div>
                        <div class="custm-news-card">
                            <img src="uploads/vv.webp" alt="News Image" class="custom-news-image">
                            <div class="custom-news-content">
                            <span class="news-category fashion">Fashion History</span>
                            <span class="custom-news-date">June 15, 2025</span>
                            <h3 class="custm-news-title">Bold Colors and Patterns That Are Trending This Season</h3>
                        </div>
                    </div>
                </div>
            </div>
        </div>
                    <!-- Advertisement Label -->
            <div class="ad-label-top">- Advertisement -</div>

            <!-- Ad Banner -->
            <section class="promo-ad">
                <div class="promo-bg">
                    <!-- Background image -->
                    <img src="uploads/gvvg.webp" alt="Promotional background image">
                </div>
            </section>
                <div class="custom-container">
                <!-- Left Column -->
                <div class="custom-left-column">
                    <!-- Image Box with Text -->
                    <div class="custom-image-box">
                    <img src="uploads/travel.webp" alt="Category Image" class="custom-category-image">
                    <div class="custom-catogory-text">Travel</div>
                    </div>

                    <!-- Trending Section -->
                    <div class="custom-trending">
                    <h3 class="custom-section-title">Trending</h3>
                    <ol class="custom-trending-list">
                        <li class="custom-trending-item">Two Anti-Lockdown Leaders Arrested as Protests Held Across Valinor</li>
                        <li class="custom-trending-item">Skylar Monroe’s Rise: Behind the Breakout Action Hit</li>
                        <li class="custom-trending-item">Hands-On With the iPhone 27, Pro, Max, and Mini</li>
                        <li class="custom-trending-item">Simple Styling Tricks That Fashion Insiders Swear By Every Day</li>
                    </ol>
                    </div>
                </div>

                <!-- Right Column -->
                <div class="custom-right-column">
                    <div class="custom-category-banner">
                        <span class="custom-category-title">Most Recent</span>
                        <!--<a href="#" class="custom-view-category">View Category</a>-->
                    </div>

                    <div class="custom-news-grid">
                    <!-- News Item 1 -->
                        <div class="custm-news-card">
                            <img src="uploads/ggyu.webp" alt="News Image" class="custom-news-image">
                            <div class="custom-news-content">
                            <span class="news-category fashion">Outfit Ideas</span>
                            <span class="custom-news-date">June 15, 2025</span>
                            <h3 class="custm-news-title">Can the Fashion Industry Ever Be Truly Inclusive?</h3>
                            </div>
                        </div>

                        <!-- Repeat News Item 2 to 6 here -->
                        <!-- News Item 2 -->
                        <div class="custm-news-card">
                            <img src="uploads/vhvhg.webp" alt="News Image" class="custom-news-image">
                            <div class="custom-news-content">
                            <span class="news-category fashion">Fashion History</span>
                            <span class="custom-news-date">June 15, 2025</span>
                            <h3 class="custm-news-title">Bold Colors and Patterns That Are Trending This Season</h3>
                            </div>
                        </div>
                        <div class="custm-news-card">
                            <img src="uploads/gccg.webp" alt="News Image" class="custom-news-image">
                            <div class="custom-news-content">
                            <span class="news-category fashion">Fashion History</span>
                            <span class="custom-news-date">June 15, 2025</span>
                            <h3 class="custm-news-title">Bold Colors and Patterns That Are Trending This Season</h3>
                            </div>
                        </div>
                        <div class="custm-news-card">
                            <img src="uploads/vhgvb.webp" alt="News Image" class="custom-news-image">
                            <div class="custom-news-content">
                            <span class="news-category fashion">Fashion History</span>
                            <span class="custom-news-date">June 15, 2025</span>
                            <h3 class="custm-news-title">Bold Colors and Patterns That Are Trending This Season</h3>
                            </div>
                        </div>
                        <div class="custm-news-card">
                            <img src="uploads/hv.webp" alt="News Image" class="custom-news-image">
                            <div class="custom-news-content">
                            <span class="news-category fashion">Fashion History</span>
                            <span class="custom-news-date">June 15, 2025</span>
                            <h3 class="custm-news-title">Bold Colors and Patterns That Are Trending This Season</h3>
                            </div>
                        </div>
                        <div class="custm-news-card">
                            <img src="uploads/vv.webp" alt="News Image" class="custom-news-image">
                            <div class="custom-news-content">
                            <span class="news-category fashion">Fashion History</span>
                            <span class="custom-news-date">June 15, 2025</span>
                            <h3 class="custm-news-title">Bold Colors and Patterns That Are Trending This Season</h3>
                        </div>
                    </div>
                </div>
            </div>
        </div>
            <div class="ad-label-top">- Advertisement -</div>

            <!-- Ad Banner -->
            <section class="promo-ad">
                <div class="promo-bg">
                    <!-- Background image -->
                    <img src="uploads/wide-banner-w.webp" alt="Promotional background image">
                </div>
            </section>
                        <!-- News Section Div -->
            <div class="news-section">
                <div class="news-banner">More News</div>
                <a href="#" class="explore-link">Explore Blog...</a>
            </div>
            <div class="homepege-news-layout">

                <!-- LEFT COLUMN -->
                <div class="homepege-left-column">
                <div class="editorial-featured">
                    <article class="fashion-card">
                        <div class="fashion-image">
                            <img src="uploads/The-Comeback-That-Silenced-Every-Critic.webp" alt="Fashion editorial">
                        </div>

                        <div class="fashion-content">
                            <span class="fashion-category">SPORTS</span>

                            <h2 class="fashion-title">
                                Simple Styling Tricks That Fashion Insiders Swear By Every Day
                            </h2>

                            <span class="fashion-divider"></span>

                            <p class="fashion-description">
                                Discover how simple adjustments in fit, layers, and accessories can transform
                                basic outfits into polished looks that feel effortless yet refined…
                            </p>
                        </div>
                    </article>
                </div>
                </div>
                <div class="homepege-right-column">
                <div class="editorial-featured">
                    <article class="fashion-card">
                        <div class="fashion-image">
                            <img src="uploads/Unprecedented-Coalitions-Forming-Ahead-of-General-Elections.webp" alt="Fashion editorial">
                        </div>

                        <div class="fashion-content">
                            <span class="fashion-category">BUSINESS</span>

                            <h2 class="fashion-title">
                                Simple Styling Tricks That Fashion Insiders Swear By Every Day
                            </h2>

                            <span class="fashion-divider"></span>

                            <p class="fashion-description">
                                Discover how simple adjustments in fit, layers, and accessories can transform
                                basic outfits into polished looks that feel effortless yet refined…
                            </p>
                        </div>
                    </article>
                </div>
                </div>  
                </div>
            <div class="news-row-horizont">

                <!-- NEWS CARD 1 -->
            <article class="row-card">
                    <div class="row-image">
                    <img src="uploads/Two-Anti-Lockdown-Leaders-Arrested-as-Protests-Held-Across-Valinor-860x573.webp" alt="Police arrest protesters during anti-lockdown demonstrations">
                    </div>

                    <div class="row-meta">
                    <span class="row-category">POLITICS</span>
                    <span class="row-separator">//</span>
                    <span class="row-date">August 1, 2025</span>
                    </div>

                    <h3 class="row-title">
                    Two Anti-Lockdown Leaders Arrested as Protests Held Across Valinor
                    </h3>
            </article>

                <!-- NEWS CARD 2 -->
            <article class="row-card">
                    <div class="row-image">
                    <img src="uploads/bz111-860x573.webp" alt="Fashion models posing in studio">
                    </div>

                    <div class="row-meta">
                    <span class="row-category">CELEBRITY</span>
                    <span class="row-separator">//</span>
                    <span class="row-date">August 1, 2025</span>
                    </div>

                    <h3 class="row-title">
                    Skylar Monroe’s Rise: Behind the Breakout Action Hit
                    </h3>
            </article>

                <!-- NEWS CARD 3 -->
            <article class="row-card">
                    <div class="row-image">
                    <img src="uploads/csacwe.webp" alt="Person using smartphone app interface">
                    </div>

                    <div class="row-meta">
                    <span class="row-category">TECHNOLOGY</span>
                    <span class="row-separator">//</span>
                    <span class="row-date">August 1, 2025</span>
                    </div>

                    <h3 class="row-title">
                    Hands-On With the iPhone 27, Pro, Max, and Mini
                    </h3>
            </article>

                <!-- NEWS CARD 4 -->
            <article class="row-card">
                    <div class="row-image">
                    <img src="uploads/bz106-860x573.webp" alt="Man holding coffee wearing blazer near waterfront">
                    </div>

                    <div class="row-meta">
                    <span class="row-category">FASHION</span>
                    <span class="row-separator">//</span>
                    <span class="row-date">July 30, 2025</span>
                    </div>

                    <h3 class="row-title">
                    Simple Styling Tricks That Fashion Insiders Swear By Every Day
                    </h3>
            </article>

                <!-- NEWS CARD 5 -->
            <article class="row-card">
                    <div class="row-image">
                    <img src="uploads/vcvjhsa.webp" alt="Woman walking on street wearing casual outfit">
                    </div>

                    <div class="row-meta">
                    <span class="row-category">CELEBRITY</span>
                    <span class="row-separator">//</span>
                    <span class="row-date">July 30, 2025</span>
                    </div>

                    <h3 class="row-title">
                    Clara Evermore Returns to Stage After Mental Health Break
                    </h3>
            </article>
</div>
            <div class="news-row-horizont">

                <!-- NEWS CARD 1 -->
            <article class="row-card">
                    <div class="row-image">
                    <img src="uploads/Two-Anti-Lockdown-Leaders-Arrested-as-Protests-Held-Across-Valinor-860x573.webp" alt="Police arrest protesters during anti-lockdown demonstrations">
                    </div>

                    <div class="row-meta">
                    <span class="row-category">POLITICS</span>
                    <span class="row-separator">//</span>
                    <span class="row-date">August 1, 2025</span>
                    </div>

                    <h3 class="row-title">
                    Two Anti-Lockdown Leaders Arrested as Protests Held Across Valinor
                    </h3>
            </article>

                <!-- NEWS CARD 2 -->
            <article class="row-card">
                    <div class="row-image">
                    <img src="uploads/bz111-860x573.webp" alt="Fashion models posing in studio">
                    </div>

                    <div class="row-meta">
                    <span class="row-category">CELEBRITY</span>
                    <span class="row-separator">//</span>
                    <span class="row-date">August 1, 2025</span>
                    </div>

                    <h3 class="row-title">
                    Skylar Monroe’s Rise: Behind the Breakout Action Hit
                    </h3>
            </article>

                <!-- NEWS CARD 3 -->
            <article class="row-card">
                    <div class="row-image">
                    <img src="uploads/csacwe.webp" alt="Person using smartphone app interface">
                    </div>

                    <div class="row-meta">
                    <span class="row-category">TECHNOLOGY</span>
                    <span class="row-separator">//</span>
                    <span class="row-date">August 1, 2025</span>
                    </div>

                    <h3 class="row-title">
                    Hands-On With the iPhone 27, Pro, Max, and Mini
                    </h3>
            </article>

                <!-- NEWS CARD 4 -->
            <article class="row-card">
                    <div class="row-image">
                    <img src="uploads/bz106-860x573.webp" alt="Man holding coffee wearing blazer near waterfront">
                    </div>

                    <div class="row-meta">
                    <span class="row-category">FASHION</span>
                    <span class="row-separator">//</span>
                    <span class="row-date">July 30, 2025</span>
                    </div>

                    <h3 class="row-title">
                    Simple Styling Tricks That Fashion Insiders Swear By Every Day
                    </h3>
            </article>

                <!-- NEWS CARD 5 -->
            <article class="row-card">
                    <div class="row-image">
                    <img src="uploads/vcvjhsa.webp" alt="Woman walking on street wearing casual outfit">
                    </div>

                    <div class="row-meta">
                    <span class="row-category">CELEBRITY</span>
                    <span class="row-separator">//</span>
                    <span class="row-date">July 30, 2025</span>
                    </div>

                    <h3 class="row-title">
                    Clara Evermore Returns to Stage After Mental Health Break
                    </h3>
            </article>
</div>
        </main>
    </div>    
    <?php include 'footer.php'; ?>
    <script src="script.js" defer></script>
</body>
</html>