<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Foxiz - Latest news, celebrity gossip, fashion trends, sports updates, and business insights. Stay informed with our comprehensive coverage.">
    <meta name="keywords" content="news, celebrity, fashion, sports, business, entertainment, lifestyle">
    <meta name="author" content="Foxiz">
    <meta property="og:title" content="Foxiz - Your Daily Dose of News & Entertainment">
    <meta property="og:description" content="Stay updated with the latest trends in celebrity, fashion, sports, and business.">
    <meta property="og:type" content="website">
    <meta property="og:url" content="https://foxiz.io">
    <meta property="og:image" content="https://foxiz.io/images/og-image.webp">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="canonical" href="https://foxiz.io/">
    <link rel="icon" type="image/x-icon" href="favicon.ico">
    
    <title>Foxiz - Category</title>
    
    <!-- Preload critical assets -->
    <link rel="preload" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" as="style">
    <link rel="stylesheet" href="style.css">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    
    <!-- Google Fonts for better typography -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@700&display=swap" rel="stylesheet">
    
    <!-- Schema.org structured data -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "NewsMediaOrganization",
        "name": "Foxiz",
        "url": "https://foxiz.io",
        "logo": "https://foxiz.io/logo.png",
        "sameAs": [
            "https://facebook.com/foxiz",
            "https://twitter.com/foxiz",
            "https://youtube.com/foxiz"
        ]
    }
    </script>
</head>
<body>
<div class="main-content">
<?php include 'header.php'; ?>
<main class="page-content">
    <div class="category-container">
        <div class="category-content">
            <div class="category-title">Fashion</div>
            <div class="category-description">
                From catwalk critiques to street style evolutions, our fashion coverage captures the pulse of personal expression and industry trends. We spotlight designers, movements, and the cultural forces shaping what we wear and why it matters.
            </div>
        </div>
    </div> 
            <div class="homepege-news-layout">

                <!-- LEFT COLUMN -->
                <div class="homepege-left-column">
                <div class="editorial-featured">
                    <article class="fashion-card">
                        <div class="fashion-image">
                            <img src="uploads/bz102-860x573.webp" alt="Fashion editorial">
                        </div>

                        <div class="fashion-content">
                            <span class="fashion-category">SPORTS</span>

                            <h2 class="fashion-title">
                                Simple Styling Tricks That Fashion Insiders Swear By Every Day
                            </h2>

                            <span class="fashion-divider"></span>

                            <p class="fashion-description">
                                Discover how simple adjustments in fit, layers, and accessories can transform
                                basic outfits into polished looks that feel effortless yet refined…
                            </p>
                        </div>
                    </article>
                </div>
                </div>
                <div class="homepege-right-column">
                <div class="editorial-featured">
                    <article class="fashion-card">
                        <div class="fashion-image">
                            <img src="uploads/The-Comeback-That-Silenced-Every-Critic.webp" alt="Fashion editorial">
                        </div>

                        <div class="fashion-content">
                            <span class="fashion-category">BUSINESS</span>

                            <h2 class="fashion-title">
                                Simple Styling Tricks That Fashion Insiders Swear By Every Day
                            </h2>

                            <span class="fashion-divider"></span>

                            <p class="fashion-description">
                                Discover how simple adjustments in fit, layers, and accessories can transform
                                basic outfits into polished looks that feel effortless yet refined…
                            </p>
                        </div>
                    </article>
                </div>
                </div>  
                </div>
            <!-- Advertisement Label -->
            <div class="ad-label-top">- Advertisement -</div>
                            <!-- Ad Banner -->
            <section class="promo-ad">
                <div class="promo-bg">
                    <!-- Background image -->
                    <img src="uploads/wide-banner-w.webp" alt="Promotional background image">
                </div>
            </section>
            <div class="news-row-horizont">

                <!-- NEWS CARD 1 -->
            <article class="row-card">
                    <div class="row-image">
                    <img src="uploads/Two-Anti-Lockdown-Leaders-Arrested-as-Protests-Held-Across-Valinor-860x573.webp" alt="Police arrest protesters during anti-lockdown demonstrations">
                    </div>

                    <div class="row-meta">
                    <span class="row-category">POLITICS</span>
                    <span class="row-separator">//</span>
                    <span class="row-date">August 1, 2025</span>
                    </div>

                    <h3 class="row-title">
                    Two Anti-Lockdown Leaders Arrested as Protests Held Across Valinor
                    </h3>
            </article>

                <!-- NEWS CARD 2 -->
            <article class="row-card">
                    <div class="row-image">
                    <img src="uploads/bz111-860x573.webp" alt="Fashion models posing in studio">
                    </div>

                    <div class="row-meta">
                    <span class="row-category">CELEBRITY</span>
                    <span class="row-separator">//</span>
                    <span class="row-date">August 1, 2025</span>
                    </div>

                    <h3 class="row-title">
                    Skylar Monroe’s Rise: Behind the Breakout Action Hit
                    </h3>
            </article>

                <!-- NEWS CARD 3 -->
            <article class="row-card">
                    <div class="row-image">
                    <img src="uploads/csacwe.webp" alt="Person using smartphone app interface">
                    </div>

                    <div class="row-meta">
                    <span class="row-category">TECHNOLOGY</span>
                    <span class="row-separator">//</span>
                    <span class="row-date">August 1, 2025</span>
                    </div>

                    <h3 class="row-title">
                    Hands-On With the iPhone 27, Pro, Max, and Mini
                    </h3>
            </article>

                <!-- NEWS CARD 4 -->
            <article class="row-card">
                    <div class="row-image">
                    <img src="uploads/bz106-860x573.webp" alt="Man holding coffee wearing blazer near waterfront">
                    </div>

                    <div class="row-meta">
                    <span class="row-category">FASHION</span>
                    <span class="row-separator">//</span>
                    <span class="row-date">July 30, 2025</span>
                    </div>

                    <h3 class="row-title">
                    Simple Styling Tricks That Fashion Insiders Swear By Every Day
                    </h3>
            </article>

                <!-- NEWS CARD 5 -->
            <article class="row-card">
                    <div class="row-image">
                    <img src="uploads/vcvjhsa.webp" alt="Woman walking on street wearing casual outfit">
                    </div>

                    <div class="row-meta">
                    <span class="row-category">CELEBRITY</span>
                    <span class="row-separator">//</span>
                    <span class="row-date">July 30, 2025</span>
                    </div>

                    <h3 class="row-title">
                    Clara Evermore Returns to Stage After Mental Health Break
                    </h3>
            </article>
</div>
</main>
</div>
    <?php include 'footer.php'; ?>
    <script src="script.js" defer></script>
</body>
</html>        