<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>U.S. Expands Subcritical Nuclear Tests Amid Tensions</title>
    <meta name="title" content="U.S. Expands Subcritical Nuclear Tests Amid Tensions">

    <meta name="author" content="Jordan Lee">

    <meta name="description"
        content="The U.S. expands subcritical nuclear tests at the Nevada site as global tensions rise with Russia and China, while explosive nuclear testing remains banned.">
    
    <link rel="canonical" href="https://www.progresskingdom.com/usnews/u-s-expands-subcritical-nuclear-tests.php">
    
    <meta name="keywords"
        content="U.S nuclear tests, subcritical testing, Nevada National Security Site, nuclear modernization, Russia tensions, China nuclear program, U.S. security, arms control updates">

    <meta property="og:title" content="U.S. Expands Subcritical Nuclear Tests Amid Tensions">
    <meta property="og:description"
        content="The U.S. expands subcritical nuclear tests at the Nevada site as global tensions rise with Russia and China, while explosive nuclear testing remains banned.">
    <meta property="og:url" content="https://www.progresskingdom.com/usnews/u-s-expands-subcritical-nuclear-tests.php">
    <meta property="og:image" content="https://www.progresskingdom.com/images/u-s-expands-subcritical-nuclear-tests.webp">
    <meta property="og:site_name" content="Progress Kingdom">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:type" content="article">
    <meta property="og:locale" content="en_US">

    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="U.S. Expands Subcritical Nuclear Tests Amid Tensions">
    <meta name="twitter:description"
        content="The U.S. expands subcritical nuclear tests at the Nevada site as global tensions rise with Russia and China, while explosive nuclear testing remains banned.">
    <meta name="twitter:url" content="https://www.progresskingdom.com/usnews/u-s-expands-subcritical-nuclear-tests.php">
    <meta name="twitter:image" content="https://www.progresskingdom.com/images/u-s-expands-subcritical-nuclear-tests.webp">
    <meta name="twitter:site" content="@progresskingdom">
    <meta name="twitter:creator" content="@progresskingdom">

    <link rel="stylesheet" href="../style.css">
    
    <link rel="icon" href="../images/icon.svg">

    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "WebSite",
      "@id": "https://www.progresskingdom.com/#website",
      "url": "https://www.progresskingdom.com/",
      "name": "Progress Kingdom",
      "publisher": {
        "@id": "https://www.progresskingdom.com/#publisher"
      }
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.progresskingdom.com/#publisher",
      "name": "Progress Kingdom",
      "url": "https://www.progresskingdom.com/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.progresskingdom.com/images/logo.svg",
        "width": 512,
        "height": 512
      }
    },

    {
      "@type": "Person",
      "@id": "https://www.progresskingdom.com/#jordanlee",
      "name": "Jordan Lee",
      "url": "https://www.progresskingdom.com/author/jordan-lee.php",
      "jobTitle": "U.S. News Reporter",
      "worksFor": {
        "@id": "https://www.progresskingdom.com/#publisher"
      },
      "sameAs": [
        "https://medium.com/@jordanlee_",
        "https://substack.com/@jordanlee929",
        "https://www.instagram.com/jordan_lee_757/"
      ]
    },

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.progresskingdom.com/usnews/u-s-expands-subcritical-nuclear-tests.php#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.progresskingdom.com/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "U.S News",
          "item": "https://www.progresskingdom.com/usnews/"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "name": "U.S. Expands Subcritical Nuclear Tests Amid Tensions",
          "item": "https://www.progresskingdom.com/usnews/u-s-expands-subcritical-nuclear-tests.php"
        }
      ]
    },

    {
      "@type": "WebPage",
      "@id": "https://www.progresskingdom.com/usnews/u-s-expands-subcritical-nuclear-tests.php#webpage",
      "url": "https://www.progresskingdom.com/usnews/u-s-expands-subcritical-nuclear-tests.php",
      "name": "U.S. Expands Subcritical Nuclear Tests Amid Tensions",
      "description": "The U.S. expands subcritical nuclear tests at the Nevada site as global tensions rise with Russia and China, while explosive nuclear testing remains banned.",
      "inLanguage": "en-US",
      "primaryImageOfPage": {
        "@type": "ImageObject",
        "url": "https://www.progresskingdom.com/images/u-s-expands-subcritical-nuclear-tests.webp",
        "width": 1200,
        "height": 630
      },
      "breadcrumb": {
        "@id": "https://www.progresskingdom.com/usnews/u-s-expands-subcritical-nuclear-tests.php#breadcrumb"
      },
      "isPartOf": {
        "@id": "https://www.progresskingdom.com/#website"
      }
    },

    {
      "@type": "NewsArticle",
      "@id": "https://www.progresskingdom.com/usnews/u-s-expands-subcritical-nuclear-tests.php#article",
      "headline": "U.S. Expands Subcritical Nuclear Tests Amid Tensions",
      "description": "The U.S. expands subcritical nuclear tests amid rising tensions with Russia and China, while explosive nuclear testing remains banned.",
      "articleSection": "U.S News",
      "datePublished": "2025-11-04",
      "dateModified": "2025-11-04",
      "inLanguage": "en-US",
      "author": {
        "@id": "https://www.progresskingdom.com/#jordanlee"
      },
      "publisher": {
        "@id": "https://www.progresskingdom.com/#publisher"
      },
      "image": {
  "@type": "ImageObject",
  "url": "https://www.progresskingdom.com/images/u-s-expands-subcritical-nuclear-tests.webp",
  "width": 1200,
  "height": 630
},
      "mainEntityOfPage": {
        "@id": "https://www.progresskingdom.com/usnews/u-s-expands-subcritical-nuclear-tests.php#webpage"
      }
    }

  ]
}
</script>

</head>

<body>

  <!-- header -->
  <?php include ('../header.php'); ?>



    <main>
<!-- sixth section -->
 <div class="featured-container expose">


  <div class="featured-grid">
    <!-- Left Large Video -->
    <div class="featured-left">
         <div class="post-wrapper">
    <div class="post-inner">

      <div class="post-tag">U.S News</div>

      <h1 class="post-heading">U.S. Expands Subcritical Nuclear Tests as Global Tensions Rise</h1>

      <div class="post-description">
    The United States continues subcritical nuclear experiments at the Nevada National Security Site, reflecting rising concerns over China and Russia’s nuclear modernization — but explosive nuclear testing remains banned.
  </div>

      <div class="post-info">
        <div class="post-author">BY <span>JORDAN LEE</span></div>
        <div class="post-date">NOVEMBER 4, 2025</div>
      </div>

      <!-- social content -->
       <?php include ('../social-content.php'); ?>
      
  </div>

   <div class="">
       <img loading="lazy" src="../images/u-s-expands-subcritical-nuclear-tests.webp" alt="U.S. Expands Subcritical Nuclear Tests as Global Tensions Rise" class="featured-main-img">

        <p class="trend-text sety" >
     The United States is expanding its use of subcritical nuclear tests, experiments that study nuclear materials without producing an explosion, as geopolitical tensions with Russia and China continue to grow. The tests, conducted at the Nevada National Security Site, are part of a long-standing U.S. effort to ensure that aging nuclear warheads remain reliable without violating the country’s decades-long moratorium on underground nuclear detonations.
</p>
         <p class="trend-text sety" >
     U.S. officials say the increased testing focus reflects concerns over Russia’s moves away from arms-control agreements and China’s rapid expansion of its nuclear program. The National Nuclear Security Administration confirmed that new subcritical experiments were carried out in 2023 and 2024, using updated diagnostic technologies to monitor how plutonium behaves under extreme pressure.
     </p>
    
    
    <div class="quates">
        <p>“These experiments help us maintain the safety and effectiveness of the stockpile without returning to explosive testing,” the NNSA said in a public statement, noting that the work complies with the Comprehensive Nuclear-Test-Ban Treaty because it does not produce a self-sustaining chain reaction.</p>
      </div>


      <p class="trend-text sety loco">
        The Biden administration has reiterated that it does not support resuming explosive nuclear testing and will continue relying on advanced modeling, scientific simulations, and subcritical experiments. Officials say these tools are sufficient to evaluate the aging stockpile, but some lawmakers have pushed for expanded testing capabilities in response to China’s rapid 
    </p>

     <img loading="lazy" src="../images/experts-say-that-the-arms-control-framework.webp" alt="Experts say that the arms control framework is being weakened by modern nuclear powers" class="featured-main-img">

     <h2 class="post-heading">Experts say that the arms control framework is being weakened by modern nuclear powers.</h2>
     <p class="trend-text sety loco">
        Experts in arms control say that the US's continued use of computer simulations and subcritical testing to keep its old nuclear weapons up to date is making the world less stable.   People are worried that the long-standing ban on nuclear testing may be in danger because China is building nuclear plants and Russia decided to take back its ratification of the Comprehensive Nuclear-Test-Ban Treaty (CTBT) in 2023.
      </p>
        <p class="trend-text sety">
        According to experts on nonproliferation, the US is now negotiating in a less stable environment than it has been since the Cold War ended. Analysts say that it is harder to keep things stable over time when major enemies don't sign agreements. Washington has said again that it will not test nuclear weapons in the meantime.
      </p>
         <p class="trend-text sety">
        The U.S. stockpile stewardship program still uses advanced modeling, scientific diagnosis, and testing that doesn't use explosives.   Officials say that this method gets rid of the need for a lot of testing and keeps nuclear reliability at a high level.
      </p>
     
        <div class="footerArea_x91">
    

    <!-- AUTHOR SECTION -->
    <?php include ('../authorss/us-author.php'); ?>

    <!-- COMMENT SECTION -->
    <?php include ('../comment.php'); ?>

  </div>

   </div>

    </div>

    <!-- Right Smaller Videos -->
    <?php include ('../side-content.php'); ?>

<!-- trending news section -->
<div class="trend-wrapper">
  <h3 class="trend-heading">U.S News</h3>

  <div class="trend-grid">

    <!-- Post 1 -->
    <div class="trend-card">
      <img loading="lazy" src="../images/u-s-tightens-china-trade-policy.webp" width="140" height="110" alt="U.S. Tightens China Trade Policy" class="trend-image">
      <h2 class="trend-title">
        <a href="../usnews/u-s-tightens-china-trade-policy.php" title="U.S. Tightens China Trade Policy as Tariff Review Continues Into 2025<">U.S. Tightens China Trade Policy as Tariff Review Continues Into 2025</a>
      </h2>
      <p class="trend-text">
       The Biden administration continues its formal review of China tariffs imposed since 2018, with U.S. officials signaling tougher enforcement rather than rollback as tensions persist.
       <p class="trend-info">
        <span class="trend-cat">U.S News</span> BY <span class="trend-author">JORDAN LEE</span> NOVEMBER 3, 2025
      </p>
    </div>

    <!-- Post 2 -->
    <div class="trend-card">
      <img loading="lazy" src="../images/budget-stalemates-strain-u-s-science-agencies.webp" width="140" height="110" alt="Budget Stalemates Strain U.S. Science Agencies" class="trend-image">
      <h2 class="trend-title">
        <a href="../usnews/budget-stalemates-strain-u-s-science-agencies.php" title="Budget Stalemates Strain U.S. Science Agencies">Budget Stalemates Strain U.S. Science Agencies</a>
      </h2>
      <p class="trend-text">
      Ongoing budget disputes in Washington are creating staffing challenges and delayed projects at agencies like NASA and the EPA, raising concerns among researchers about long-term scientific capacity.
      </p>
      <p class="trend-info">
        <span class="trend-cat">U.S News</span> BY <span class="trend-author">JORDAN LEE</span> NOVEMBER 3, 2025
      </p>
    </div>

    <!-- Post 3 -->
    <div class="trend-card">
      <img loading="lazy" src="../images/climate-tech-and-geoengineering-backlash.webp" alt="Climate Tech and Geoengineering Face Growing Bipartisan Backlash" class="trend-image">
      <h2 class="trend-title">
        <a href="../usnews/climate-tech-and-geoengineering-backlash.php" title="Climate Tech and Geoengineering Face Growing Two-party Backlash">Climate Tech and Geoengineering Face Growing Two-party Backlash</a>
      </h2>
      <p class="trend-text">
      Because lawmakers want more oversight and public responsibility, new climate solutions like carbon removal, solar geoengineering, and atmospheric interventions are facing opposition from both parties.
    </p>
      <p class="trend-info">
        <span class="trend-cat">U.S News</span> BY <span class="trend-author">JORDAN LEE</span> NOVEMBER 5, 2025
      </p>
    </div>

  </div>
</div>



    </main>

  <!-- footer -->
  <?php include ('../footer.php'); ?>

  <!-- JS -->
  <script defer>
    const sidebar = document.getElementById('sidebar_x91');
    const openMenu = document.getElementById('openMenu_x91');
    const closeMenu = document.getElementById('closeMenu_x91');
    const overlay = document.getElementById('overlay_x91');

    openMenu.addEventListener('click', () => {
      sidebar.classList.add('active_x91');
      overlay.classList.add('show_x91');
    });

    closeMenu.addEventListener('click', () => {
      sidebar.classList.remove('active_x91');
      overlay.classList.remove('show_x91');
    });

    overlay.addEventListener('click', () => {
      sidebar.classList.remove('active_x91');
      overlay.classList.remove('show_x91');
    });
  </script>
  <script defer>
  const customMenuBtn = document.getElementById('customMenuBtn');
  const customSidebar = document.getElementById('customSidebar');

  customMenuBtn.addEventListener('click', () => {
    customSidebar.classList.toggle('custom-active');
  });
</script>

</body>
</html>