<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>The U.S. government has been closed for the longest time</title>
    <meta name="title" content="The U.S. government has been closed for the longest time">

    <meta name="author" content="Jordan Lee">

    <meta name="description"
          content="The U.S. government shutdown enters a record 36 days as Senate negotiations stall, federal workers face uncertainty, and key services brace for major disruptions.">
    <link rel="canonical" href="https://www.progresskingdom.com/usnews/the-u-s-government-has-been-closed-for-the-longest-time.php">
    <meta name="keywords"
          content="U.S. government shutdown, longest shutdown, federal workers furlough, Senate negotiations, government funding crisis, Washington budget deadlock">

    <!-- Open Graph -->
    <meta property="og:title" content="The U.S. government has been closed for the longest time">
    <meta property="og:description" content="The U.S. government shutdown enters a record 36 days as Senate negotiations stall, federal workers face uncertainty, and key services brace for major disruptions.">
    <meta property="og:url" content="https://www.progresskingdom.com/usnews/the-u-s-government-has-been-closed-for-the-longest-time.php">
    <meta property="og:image" content="https://www.progresskingdom.com/images/the-u-s-government-has-been-closed-for-the-longest-time.webp">
    <meta property="og:site_name" content="Progress Kingdom">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:type" content="article">
    <meta property="og:locale" content="en_US">

    <!-- Twitter -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="The U.S. government has been closed for the longest time">
    <meta name="twitter:description" content="The U.S. government shutdown enters a record 36 days as Senate negotiations stall, federal workers face uncertainty, and key services brace for major disruptions.">
    <meta name="twitter:url" content="https://www.progresskingdom.com/usnews/the-u-s-government-has-been-closed-for-the-longest-time.php">
    <meta name="twitter:image" content="https://www.progresskingdom.com/images/the-u-s-government-has-been-closed-for-the-longest-time.webp">
    <meta name="twitter:site" content="@progresskingdom">
    <meta name="twitter:creator" content="@progresskingdom">

    <link rel="stylesheet" href="../style.css">
    
    <link rel="icon" href="../images/icon.svg">

<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "WebSite",
      "@id": "https://www.progresskingdom.com/#website",
      "url": "https://www.progresskingdom.com/",
      "name": "Progress Kingdom",
      "publisher": {
        "@id": "https://www.progresskingdom.com/#publisher"
      }
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.progresskingdom.com/#publisher",
      "name": "Progress Kingdom",
      "url": "https://www.progresskingdom.com/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.progresskingdom.com/images/logo.svg",
        "width": 512,
        "height": 512
      }
    },

    {
      "@type": "Person",
      "@id": "https://www.progresskingdom.com/#jordanlee",
      "name": "Jordan Lee",
      "url": "https://www.progresskingdom.com/author/jordan-lee.php",
      "jobTitle": "U.S. News Reporter",
      "worksFor": {
        "@id": "https://www.progresskingdom.com/#publisher"
      },
      "sameAs": [
        "https://medium.com/@jordanlee_",
        "https://substack.com/@jordanlee929",
        "https://www.instagram.com/jordan_lee_757/"
      ]
    },

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.progresskingdom.com/usnews/the-u-s-government-has-been-closed-for-the-longest-time.php#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.progresskingdom.com/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "U.S. News",
          "item": "https://www.progresskingdom.com/usnews/"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "name": "The U.S. government has been closed for the longest time",
          "item": "https://www.progresskingdom.com/usnews/the-u-s-government-has-been-closed-for-the-longest-time.php"
        }
      ]
    },

    {
      "@type": "WebPage",
      "@id": "https://www.progresskingdom.com/usnews/the-u-s-government-has-been-closed-for-the-longest-time.php#webpage",
      "url": "https://www.progresskingdom.com/usnews/the-u-s-government-has-been-closed-for-the-longest-time.php",
      "name": "The U.S. government has been closed for the longest time",
      "description": "The U.S. government shutdown enters a record 36 days as Senate negotiations stall and federal services brace for major disruptions.",
      "inLanguage": "en-US",
      "isPartOf": {
        "@id": "https://www.progresskingdom.com/#website"
      },
      "primaryImageOfPage": {
        "@type": "ImageObject",
        "url": "https://www.progresskingdom.com/images/the-u-s-government-has-been-closed-for-the-longest-time.webp",
        "width": 1200,
        "height": 630
      },
      "breadcrumb": {
        "@id": "https://www.progresskingdom.com/usnews/the-u-s-government-has-been-closed-for-the-longest-time.php#breadcrumb"
      }
    },

    {
      "@type": "NewsArticle",
      "@id": "https://www.progresskingdom.com/usnews/the-u-s-government-has-been-closed-for-the-longest-time.php#article",
      "headline": "The U.S. government has been closed for the longest time",
      "description": "The U.S. government shutdown extends to 36 days as Senate negotiations continue, federal workers face uncertainty, and key agencies brace for disruptions.",
      "datePublished": "2025-11-04",
      "dateModified": "2025-11-04",
      "articleSection": "U.S. News",
      "inLanguage": "en-US",
      "image": [
        "https://www.progresskingdom.com/images/the-u-s-government-has-been-closed-for-the-longest-time.webp"
      ],
      "author": {
        "@id": "https://www.progresskingdom.com/#jordanlee"
      },
      "publisher": {
        "@id": "https://www.progresskingdom.com/#publisher"
      },
      "mainEntityOfPage": {
        "@id": "https://www.progresskingdom.com/usnews/the-u-s-government-has-been-closed-for-the-longest-time.php#webpage"
      }
    }

  ]
}
</script>


</head>
<body>

  <!-- header -->
  <?php include ('../header.php'); ?>



    <main>
<!-- sixth section -->
 <div class="featured-container expose">


  <div class="featured-grid">
    <!-- Left Large Video -->
    <div class="featured-left">
         <div class="post-wrapper">
    <div class="post-inner">

      <div class="post-tag">U.S News</div>

      <h1 class="post-heading">The U.S. government has been closed for the longest time.</h1>

      <div class="post-description">
        The federal government has been shut down for 36 days, which is a new record, because the US Senate has once again failed to pass any laws.
      </div>

      <div class="post-info">
        <div class="post-author">BY <span>JORDAN LEE</span></div>
        <div class="post-date">NOVEMBER 4, 2025</div>
      </div>

      <!-- social content -->
       <?php include ('../social-content.php'); ?>
      
  </div>

   <div class="">
       <img loading="lazy" src="../images/the-u-s-government-has-been-closed-for-the-longest-time.webp" alt="The U.S. government has been closed for the longest time" class="featured-main-img">

      <p class="trend-text sety "  >
    The U.S. government has not had full funding for 36 days in a row because the Senate did not pass a continuing resolution. The fourteenth vote, which was the most recent, did not get enough support to start up government operations again. As the longest shutdown in U.S. history comes to an end, agencies are getting ready for more service interruptions, more stress on federal workers' finances, and more worries about national security and air traffic control.
    </p>
    <p class="trend-text sety "  >
    Politicians from both sides say that talks have gotten more serious in the last few days, with top senators quietly hinting that a funding framework is starting to take shape.  Disagreements over funding for transportation, public health, and border security are still slowing things down.  As the shutdown nears its sixth week without a deal, federal workers are still worried, agencies are having more trouble getting things done, and public pressure is rising.
  </p>
    <p class="trend-text sety "  >
    Air transport officials say that if funding problems last too long, airports may have to limit traffic or close because they can't hire enough staff or keep people safe.  Community groups say that more people are asking for emergency food and shelter. At the same time, small businesses that depend on federal contracts are laying off workers and having trouble making ends meet.  
  </p>
        

        <div class="quates">
        <p>“We are closer to an agreement than we were a week ago, but we’re not there yet,” said one senior senator who requested anonymity. “Both sides know this shutdown cannot continue indefinitely.”</p>
      </div>


      <p class="trend-text sety loco">
        Federal employees are still dealing with uncertainty in the meantime. While some people go to work without pay, thousands are still on furlough.   According to air traffic officials, if funding is not restored quickly, extended shortages may result in some airports temporarily closing or operating at reduced capacity. 
      </p>
        <p class="trend-text sety">
        The shutdown is starting to hurt small businesses that depend on federal contracts. Some have to cut back on hours or let people go.
      </p>
         
     <img loading="lazy" src="../images/the-u-s-government-has-been-closed-for-the-longest-time-2.webp" alt="Senators Intensify Talks as Public Pressure Grows" class="featured-main-img">

     <h2 class="post-heading">Senators Intensify Talks as Public Pressure Grows</h2>
     <p class="trend-text sety loco">
        Lawmakers from both parties say that private talks have increased, and several senior senators said they were cautiously hopeful that a solution "could emerge within days."   There hasn't been an announcement of a deal yet, and there are still big differences about how to spend the money.
      </p>
        <p class="trend-text sety">
        Senate negotiators are said to be talking behind closed doors about how much money to give to programs that help people with transportation, healthcare, and food.  These are the problems that have stopped the shutdown from moving forward.
      </p>
         <p class="trend-text sety">
        In the meantime, federal workers are still dealing with uncertainty.   Some people go to work without pay, but thousands are still on leave.   Air traffic officials say that if funding isn't restored quickly, some airports may have to close temporarily or run at a lower capacity for a long time.
      </p>
      <p class="trend-text sety">
        Community groups say that more people are asking for emergency help and food assistance because unpaid workers are having trouble paying for basic needs.   The shutdown is starting to have an effect on small businesses that rely on federal contracts. Some of them have had to cut back on hours or fire workers.
      </p>
         
     
        <div class="footerArea_x91">
    

    <!-- AUTHOR SECTION -->
    <?php include ('../authorss/us-author.php'); ?>

    <!-- COMMENT SECTION -->
    <?php include ('../comment.php'); ?>

  </div>

   </div>

    </div>

    <!-- Right Smaller Videos -->
    <?php include ('../side-content.php'); ?>

<!-- trending news section -->
<div class="trend-wrapper">
  <h3 class="trend-heading">U.S News</h3>

  <div class="trend-grid">

    <!-- Post 2 -->
    <div class="trend-card">
      <img loading="lazy" src="../images/a-big-winter-storm-hits-the-northeastern-u.s.webp" width="140" height="110" alt="A big winter storm hits the Northeastern U.S" class="trend-image">
      <h2 class="trend-title">
        <a href="../usnews/a-big-winter-storm-hits-the-northeastern-u.s.php" title="The U.S. government has been closed for the longest time.">The U.S. government has been closed for the longest time.</a>
      </h2>
      <p class="trend-text">
      In the Northeast, a strong snowstorm made conditions like a blizzard, which made travel difficult and forced schools to close in several states.
      <p class="trend-info">
        <span class="trend-cat">U.S. News</span> BY <span class="trend-author">JORDAN LEE</span> OCTOBER 11, 2025
      </p>
    </div>

    <!-- Post 3 -->
    <div class="trend-card">
      <img loading="lazy" src="../images/the-u-s-stock-market-also-goes-down-when-tech-stocks-go-down.webp" alt="The U.S. stock market also goes down when tech stocks go down" class="trend-image">
      <h2 class="trend-title">
        <a href="../usnews/the-u-s-stock-market-also-goes-down-when-tech-stocks-go-down.php" title="The U.S. stock market also goes down when tech stocks go down">The U.S. stock market also goes down when tech stocks go down</a>
      </h2>
      <p class="trend-text">
        Wall Street fell today because investors were worried about interest rates and earnings forecasts. Big tech companies saw big drops.
      </p>
      <p class="trend-info">
        <span class="trend-cat">U.S. News</span> BY <span class="trend-author">JORDAN LEE</span> OCTOBER 25, 2025
      </p>
    </div>

    <!-- Post 1 -->
    <div class="trend-card">
      <img loading="lazy" src="../images/u-s-officials-say-that-rail-safety-across-the-country-has-gotten-better.webp" width="140" height="110" alt="U.S. officials say that rail safety across the country has gotten better" class="trend-image">
      <h2 class="trend-title">
        <a href="../usnews/u-s-officials-say-that-rail-safety-across-the-country-has-gotten-better.php" title="U.S. officials say that rail safety across the country has gotten better">U.S. officials say that rail safety across the country has gotten better</a>
      </h2>
      <p class="trend-text">
       Federal transportation leaders announced a detailed plan to make rail travel safer after a number of high-profile derailments in the last few months.
       <p class="trend-info">
        <span class="trend-cat">U.S. News</span> BY <span class="trend-author">JORDAN LEE</span> OCTOBER 11, 2025
      </p>
    </div>
  </div>
</div>



    </main>

  <!-- footer -->
  <?php include ('../footer.php'); ?>

  <!-- JS -->
  <script defer>
    const sidebar = document.getElementById('sidebar_x91');
    const openMenu = document.getElementById('openMenu_x91');
    const closeMenu = document.getElementById('closeMenu_x91');
    const overlay = document.getElementById('overlay_x91');

    openMenu.addEventListener('click', () => {
      sidebar.classList.add('active_x91');
      overlay.classList.add('show_x91');
    });

    closeMenu.addEventListener('click', () => {
      sidebar.classList.remove('active_x91');
      overlay.classList.remove('show_x91');
    });

    overlay.addEventListener('click', () => {
      sidebar.classList.remove('active_x91');
      overlay.classList.remove('show_x91');
    });
  </script>
  <script defer>
  const customMenuBtn = document.getElementById('customMenuBtn');
  const customSidebar = document.getElementById('customSidebar');

  customMenuBtn.addEventListener('click', () => {
    customSidebar.classList.toggle('custom-active');
  });
</script>

</body>
</html>