<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Privacy Policy | Progress Kingdom News</title>

    <meta name="description" content="Read the Progress Kingdom Privacy Policy to understand how we collect, use, protect, and handle your information across our U.S. news platform.">

    <!-- Canonical -->
    <link rel="canonical" href="https://www.progresskingdom.com/privacy-policy.php">

    <!-- Open Graph -->
    <meta property="og:title" content="Privacy Policy | Progress Kingdom News">
    <meta property="og:description" content="Read the Progress Kingdom Privacy Policy to understand how we collect, use, protect, and handle your information across our U.S. news platform.">
    <meta property="og:url" content="https://www.progresskingdom.com/privacy-policy.php">
    <meta property="og:image" content="https://www.progresskingdom.com/images/progresskingdom.webp">
    <meta property="og:site_name" content="Progress Kingdom">
    <meta property="og:locale" content="en_US">
    <meta property="og:type" content="website">

    <!-- Twitter -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Privacy Policy | Progress Kingdom News">
    <meta name="twitter:description" content="Read the Progress Kingdom Privacy Policy and learn how we handle your data across our independent U.S. news platform.">
    <meta name="twitter:url" content="https://www.progresskingdom.com/privacy-policy.php">
    <meta name="twitter:image" content="https://www.progresskingdom.com/images/progresskingdom.webp">
    <meta name="twitter:site" content="@progresskingdom">
    <meta name="twitter:creator" content="@progresskingdom">

    <link rel="stylesheet" href="style.css">
    
    <link rel="icon" href="images/icon.svg">

<!-- JSON-LD Structured Data -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.progresskingdom.com/privacy-policy.php#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.progresskingdom.com/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Privacy Policy",
          "item": "https://www.progresskingdom.com/privacy-policy.php"
        }
      ]
    },

    {
      "@type": "Organization",
      "@id": "https://www.progresskingdom.com/#organization",
      "name": "Progress Kingdom",
      "url": "https://www.progresskingdom.com/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.progresskingdom.com/images/logo.svg",
        "width": 512,
        "height": 512
      },
      "description": "Progress Kingdom is an independent digital newsroom delivering high-quality journalism across politics, business, technology, sports, and local community news.",
      "sameAs": [
        "https://twitter.com/progresskingdom"
      ]
    },

    {
      "@type": "WebPage",
      "@id": "https://www.progresskingdom.com/privacy-policy.php#webpage",
      "name": "Privacy Policy | Progress Kingdom News",
      "url": "https://www.progresskingdom.com/privacy-policy.php",
      "inLanguage": "en-US",
      "description": "Official privacy policy for Progresskingdom explaining how we collect, use, protect, and manage data across our U.S. news platform.",
      "isPartOf": {
        "@id": "https://www.progresskingdom.com/#organization"
      },
      "mainEntity": {
        "@type": "PrivacyPolicy",
        "@id": "https://www.progresskingdom.com/#privacy-policy",
        "name": "Progress Kingdom Privacy Policy"
      }
    }

  ]
}
</script>

<style>
.featured-left p {
    line-height: 1.7;
    margin: 12px 0;
}

.featured-left h3 {
    margin-top: 28px;
    margin-bottom: 10px;
    font-size: 1.4rem;
    font-weight: 700;
}

.featured-left h4 {
    margin-top: 20px;
    margin-bottom: 10px;
    font-size: 1.2rem;
    font-weight: 600;
}

.featured-left ul {
    margin: 10px 0 20px 20px;
    line-height: 1.7;
}

.featured-left li {
    margin-bottom: 6px;
}
</style>


</head>

<body>
 
<!-- nav bar -->
<?php include 'indexheader.php'; ?>

<main>

<div class="featured-container expose">
  <div class="featured-header categorysec">
      <h1 class="featured-main-title">Privacy Policy</h1>
  </div>

  <div class="featured-grid">

    <div class="featured-left">

      <h2 class="featured-main-title">Progress Kingdom Privacy Policy</h2>
<p>Last Updated: November 2025</p>

<p>
Progress Kingdom collects, uses, distributes, and protects personal information on our U.S.–based digital news platform, including our website, mobile-accessible pages, and any service that links to this Privacy Policy. You agree to this Privacy Policy by using our Services.
</p>

<h3>1. Privacy Policy Scope</h3>
<p>
This Privacy Policy covers any information gathered whether you read articles, submit forms, contact us, comment, interact with adverts, or visit our website.
<strong> Not </strong> covered by this policy:  
</p>
<ul>
  <li>Information acquired offline or by phone unless stated.</li>
  <li>Websites, social platforms, and apps that link to or integrate with our Services process data.</li>
  <li>Content or data covered by different agreements.</li>
</ul>

<h3>2. The information we collect</h3>

<h4>A. Your Direct Information</h4>
<p> If you want to, we might ask for the following personal information:</p>
<ul>
  <li><strong> Contact Information:</strong> Name, email, and phone number</li>
  <li><strong> Account or subscription data:</strong> User name and password for the account (if you have them)</li>
  <li><strong> Comments & submissions:</strong> Messages, comments, and form submissions</li>
  <li><strong> Newsletters:</strong> Email preferences for newsletters and subscriptions</li>
</ul>

<h4>B. Data That Is Collected Automatically</h4>
<p>When you use our Services, we automatically collect:</p>
<ul>
  <li>IP and general location</li>
  <li>Details about the browser, device, and OS</li>
  <li>Page views, scrolling, and clicking</li>
  <li>Links for referrals</li>
  <li>Length of session</li>
  <li>Data from cookies and analytics</li>
</ul>

<h4>C. Data from Other Sources</h4>
<ul>
  <li><strong> Analytics partners </strong>Analytics services (like Google Analytics)</li>
  <li><strong> Advertising partners </strong>Networks for advertising</li>
  <li><strong> Social media platforms </strong>Interacting with our pages on social media</li>
</ul>

<h3>3. What We Do with Your Information</h3>
<p>We use the information we collect:</p>
<ul>
  <li>Keep our site up and running</li>
  <li>Publishing and distributing news</li>
  <li>Make the site work better and be easier to use</li>
  <li>Look at the traffic and engagement</li>
  <li>Respond to messages and questions</li>
  <li>Stay away from fraud and illegal activity</li>
  <li>Make ads and content your own</li>
  <li>Enforcement of the Terms of Use and the law</li>
</ul>

<h3>4. Sharing Information</h3>
<p> <strong> No </strong> one sells personal information.  
We might share information with:</p>

<ul>
  <li> <strong> Service providers: </strong> Website hosts and companies that keep them safe</li>
  <li> <strong> Advertising partners: </strong> Analytics and performance</li>
  <li> <strong> Legal entities: </strong> Partners for distributing and measuring ads</li>
  <li> <strong> Business transfers: </strong> When necessary, legal authorities Partners in a merger or acquisition in Progresskingdom</li>
</ul>

<h3>5. Cookies and Tracking Technologies</h3>
<p>We use cookies and trackers to:</p>
<ul>
  <li>Improve how the site works</li>
  <li>How to measure engagement</li>
  <li>Ads that are tailored to you</li>
  <li>What you like to buy</li>
</ul>

<p>You can turn off cookies, but some features may not work.</p>

<h3>6. Your rights to privacy</h3>
<p>Depending on where you are, you can ask for:</p>
<ul>
  <li>Get to personal data</li>
  <li>Remove your data</li>
  <li>Correct incorrect data</li>
  <li>Don't click on ads that are tailored to you.</li>
  <li>Limit the data used for targeted ads</li>
</ul>

<p>Email <strong> privacy@progresskingdom.com </strong> </p>

<h3>7. Protect data</h3>
<p>
Encryption, monitoring, firewalls, and access limits keep your data safe.
There is no safe system; sending data is dangerous.
</p>

<h3>8. Links and services from outside</h3>
<p>
Our platform might link to or include tools from other companies.
 We are not responsible, so we suggest that you look at their privacy policies.
</p>

<h3>9. Privacy for Kids</h3>
<p>
Not knowingly getting personal information from kids under 13.
If found, the data will be deleted.
</p>

<h3>10. Users from other countries</h3>
<p>
We run Progresskingdom from the United States.
If you use our Services from outside the U.S., your data may be subject to U.S. privacy laws.
</p>

<h3>11. Keep Data</h3>
<p>
We only keep personal data for as long as we need it:
</p>
<ul>
  <li>Provide services</li>
  <li>Following the law</li>
  <li>Settle arguments</li>
  <li>Be safe</li>
  <li>Different types of data stay around for different amounts of time.</li>
</ul>

<h3>12. Changes to the Privacy Policy</h3>
<p>
Policy may change from time to time.
The "Last Updated" date shows when the last change was made.
By using our services, you agree to the new policy.
</p>

<h3>13. Get in Touch</h3>
<p>Send an email to privacy@progresskingdom.com</p>
<p>Address: U.S. Editorial Division of Progress Kingdom News</p>

    </div>

  </div>
</div>

</main>

<!-- footer -->
<?php include 'indexfooter.php'; ?>

<!-- JS -->
<script defer>
    const sidebar = document.getElementById('sidebar_x91');
    const openMenu = document.getElementById('openMenu_x91');
    const closeMenu = document.getElementById('closeMenu_x91');
    const overlay = document.getElementById('overlay_x91');

    openMenu.addEventListener('click', () => {
      sidebar.classList.add('active_x91');
      overlay.classList.add('show_x91');
    });

    closeMenu.addEventListener('click', () => {
      sidebar.classList.remove('active_x91');
      overlay.classList.remove('show_x91');
    });

    overlay.addEventListener('click', () => {
      sidebar.classList.remove('active_x91');
      overlay.classList.remove('show_x91');
    });
</script>

<script defer>
  const customMenuBtn = document.getElementById('customMenuBtn');
  const customSidebar = document.getElementById('customSidebar');

  customMenuBtn.addEventListener('click', () => {
    customSidebar.classList.toggle('custom-active');
  });
</script>

</body>
</html>
