<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">

    <!-- Robots -->
    <meta name="robots" content="index, follow">

    <!-- Compatibility -->
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <!-- Viewport -->
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Primary Title -->
    <title>Politics News – U.S. Government, Elections & Policy Updates</title>

    <!-- SEO Meta -->
    <meta name="description" content="Get the latest U.S. politics news, including government actions, congressional battles, election developments, policy debates, Supreme Court updates, and major political events.">
    <meta name="author" content="Progress Kingdom News">
    <link rel="canonical" href="https://www.progresskingdom.com/politics/politics.php">

    <!-- Open Graph -->
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_US">
    <meta property="og:title" content="Politics News – U.S. Government, Elections & Policy Updates">
    <meta property="og:description" content="Get the latest U.S. politics news, including government actions, congressional battles, election developments, policy debates, Supreme Court updates, and major political events.">
    <meta property="og:url" content="https://www.progresskingdom.com/politics/politics.php">
    <meta property="og:site_name" content="Progress Kingdom">
    <meta property="og:image" content="https://www.progresskingdom.com/images/progresskingdom.webp">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta http-equiv="last-modified" content="2025-01-01T12:00:00+00:00">

    <!-- Twitter -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Politics News – U.S. Government, Elections & Policy Updates">
    <meta name="twitter:description" content="Get the latest U.S. politics news, including government actions, congressional battles, election developments, policy debates, Supreme Court updates, and major political events.">
    <meta name="twitter:image" content="https://www.progresskingdom.com/images/progresskingdom.webp">
    <meta name="twitter:site" content="@progresskingdom">
    <meta name="twitter:creator" content="@progresskingdom">

    <!-- Favicon -->
    <link rel="icon" href="../images/icon.svg">

    <!-- Stylesheet -->
    <link rel="stylesheet" href="../style.css">

    <!-- JSON-LD Structured Data -->
    <script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@graph": [

        {
          "@type": "WebSite",
          "@id": "https://www.progresskingdom.com/#website",
          "url": "https://www.progresskingdom.com/",
          "name": "Progress Kingdom",
          "publisher": {
            "@id": "https://www.progresskingdom.com/#publisher"
          }
        },

        {
          "@type": "NewsMediaOrganization",
          "@id": "https://www.progresskingdom.com/#publisher",
          "name": "Progress Kingdom",
          "url": "https://www.progresskingdom.com/",
          "logo": {
            "@type": "ImageObject",
            "url": "https://www.progresskingdom.com/images/logo.svg",
            "width": 512,
            "height": 512
          }
        },

        {
          "@type": "BreadcrumbList",
          "@id": "https://www.progresskingdom.com/politics/politics.php#breadcrumb",
          "itemListElement": [
            {
              "@type": "ListItem",
              "position": 1,
              "name": "Home",
              "item": "https://www.progresskingdom.com/"
            },
            {
              "@type": "ListItem",
              "position": 2,
              "name": "Politics",
              "item": "https://www.progresskingdom.com/politics/politics.php"
            }
          ]
        },

        {
          "@type": "CollectionPage",
          "@id": "https://www.progresskingdom.com/politics/politics.php#collection",
          "name": "Politics News – U.S. Government, Elections & Policy Updates",
          "description": "Get the latest U.S. politics news, including government actions, congressional battles, election developments, policy debates, Supreme Court updates, and major political events.",
          "url": "https://www.progresskingdom.com/politics/politics.php",
          "inLanguage": "en-US",
          "isPartOf": { "@id": "https://www.progresskingdom.com/#website" }
        },

        {
          "@type": "WebPage",
          "@id": "https://www.progresskingdom.com/politics/politics.php#webpage",
          "url": "https://www.progresskingdom.com/politics/politics.php",
          "name": "Politics News – U.S. Government, Elections & Policy Updates",
          "description": "Politics news including U.S. government actions, Congress, elections, Supreme Court developments, policy updates, and major political events.",
          "primaryImageOfPage": {
            "@type": "ImageObject",
            "url": "https://www.progresskingdom.com/images/progresskingdom.webp",
            "width": 1200,
            "height": 630
          },
          "breadcrumb": { "@id": "https://www.progresskingdom.com/politics/politics.php#breadcrumb" },
          "inLanguage": "en-US",
          "isPartOf": { "@id": "https://www.progresskingdom.com/#website" }
        },

        {
          "@type": "ItemList",
          "@id": "https://www.progresskingdom.com/politics/politics.php#itemlist",
          "name": "Politics News Articles",
          "itemListOrder": "https://schema.org/ItemListOrderDescending",
          "itemListElement": [
            {
              "@type": "ListItem",
              "position": 1,
              "item": {
                "@type": "NewsArticle",
                "headline": "Kevin McCarthy Ousted as House Speaker in Historic Vote",
                "url": "https://www.progresskingdom.com/politics/kevin-mccarthy-ousted-as-house-speaker.php",
                "image": "https://www.progresskingdom.com/images/kevin-mccarthy-ousted.webp"
              }
            },
            {
              "@type": "ListItem",
              "position": 2,
              "item": {
                "@type": "NewsArticle",
                "headline": "Democrats are facing a growing grassroots uprising one year after Trump came back to power",
                "url": "https://www.progresskingdom.com/politics/democrats-are-facing-a-growing-grassroots-uprising.php",
                "image": "https://www.progresskingdom.com/images/democrats-are-facing-a-growing-grassroots-uprising.webp"
              }
            },
            {
              "@type": "ListItem",
              "position": 3,
              "item": {
                "@type": "NewsArticle",
                "headline": "The Supreme Court will not hear Trump's case about tariffs",
                "url": "https://www.progresskingdom.com/politics/the-supreme-court-will-not-hear-trump-caseon-tariffs.php",
                "image": "https://www.progresskingdom.com/images/the-supreme-court-will-not-hear-trump-case-about-tariffs.webp"
              }
            },
            {
              "@type": "ListItem",
              "position": 4,
              "item": {
                "@type": "NewsArticle",
                "headline": "U.S. Senate Blocks Border-Ukraine-Israel Aid Package",
                "url": "https://www.progresskingdom.com/politics/u-s-senate-blocks-border-ukraine-israel-aid-package.php",
                "image": "https://www.progresskingdom.com/images/u-s-senate-blocks-border-ukraine-israel-aid.webp"
              }
            },
            {
              "@type": "ListItem",
              "position": 5,
              "item": {
                "@type": "NewsArticle",
                "headline": "Congress Passes Temporary Spending Bill to Avoid Early 2025 Shutdown",
                "url": "https://www.progresskingdom.com/politics/congress-passes-temporary-spending-bill.php",
                "image": "https://www.progresskingdom.com/images/congress-passes-temporary-spending-bill.webp"
              }
            }
          ]
        }

      ]
    }
    </script>
</head>


<body>
   <!-- header -->
  <?php include '../header.php'; ?>

    <main>
<!-- sixth section -->
 <div class="featured-container expose">
  <div class="featured-header categorysec">
    <div class="sgatyy">
        <a href="../index.php" title="home page">Home</a>
        <a href="../politics/politics.php" title="politics page">Politics</a>
        
    </div>
    <h1 class="featured-title">Politics</h1>
  </div>

  <div class="featured-grid">
    <!-- Left Large Video -->
    <div class="featured-left">
   <div class="">
       <img src="../images/kevin-mccarthy-ousted.webp" width="1200" height="630" alt="Kevin McCarthy Ousted as House Speaker news coverage" class="featured-main-img">
      <h2 class="featured-main-title"><a href="../politics/kevin-mccarthy-ousted-as-house-speaker.php" title="Kevin McCarthy Ousted as House Speaker in Historic Vote">Kevin McCarthy Ousted as House Speaker in Historic Vote</a></h2>
      <p class="featured-main-desc">
        The House kicked out its speaker for the first time in American history after a GOP mutiny joined Democrats in a historic and dramatic vote.
    </p>
   </div>
  <div class="maryy2">
        <img loading="lazy" src="../images/democrats-are-facing-a-growing-grassroots-uprising.webp" alt="Democrats are facing a growing grassroots" class="featured-main-img">
      <h2 class="featured-main-title"><a href="../politics/democrats-are-facing-a-growing-grassroots-uprising.php" title="Democrats are facing a growing grassroots uprising one year after Trump came back to power">Democrats are facing a growing grassroots uprising one year after Trump came back to power.</a></h2>
      <p class="featured-main-desc">
        As complaints from inside the party grow after Trump's reelection, younger voters and progressive groups are pushing Democratic leaders to work toward affordable housing, fairer economics, and big changes.
    </p>
  </div>
   <div class="maryy2">
        <img loading="lazy" src="../images/the-supreme-court-will-not-hear-trump-case-about-tariffs.webp" alt="The Supreme Court will not hear Trump's case about tariffs" class="featured-main-img">
      <h2 class="featured-main-title"><a href="../politics/the-supreme-court-will-not-hear-trump-caseon-tariffs.php" title="The Supreme Court will not hear Trump's case about tariffs. But his Secretary of the Treasury will be there">The Supreme Court will not hear Trump's case about tariffs. But his Secretary of the Treasury will be there.</a></h2>
      <p class="featured-main-desc">
        Scott Bessent, the Secretary of the Treasury, is going to the Supreme Court to see if the president can use emergency economic powers to impose big tariffs.
    </p>
  </div>
   <div class="maryy2">
        <img loading="lazy" src="../images/u-s-senate-blocks-border-ukraine-israel-aid.webp" alt="U.S. Senate Blocks Border-Ukraine-Israel Aid Package" class="featured-main-img">
      <h2 class="featured-main-title"><a href="../politics/u-s-senate-blocks-border-ukraine-israel-aid-package.php" title="U.S. Senate Blocks Border-Ukraine-Israel Aid Package">U.S. Senate Blocks Border-Ukraine-Israel Aid Package</a></h2>
      <p class="featured-main-desc">
       A major Senate package linking border security funding with Ukraine and Israel aid failed to move forward after Republicans and Democrats remained divided over immigration provisions.
    </p>
  </div>
  <div class="maryy2">
        <img loading="lazy" src="../images/congress-passes-temporary-spending-bill.webp" alt="Congress Passes Temporary Spending Bill" class="featured-main-img">
      <h2 class="featured-main-title"><a href="../politics/congress-passes-temporary-spending-bill.php" title="Congress Passes Temporary Spending Bill to Avoid Early 2025 Shutdown">Congress Passes Temporary Spending Bill to Avoid Early 2025 Shutdown</a></h2>
      <p class="featured-main-desc">
       Lawmakers approved a stopgap bill to keep the government funded into March, avoiding an immediate shutdown.
    </p>
  </div>
 
    </div>

    <!-- Right Smaller Videos -->
    <?php include ('../side-content.php'); ?>
  </div>
</div>


<!-- seventh section -->





    </main>

      <!-- footer -->
  <?php include '../footer.php'; ?>
  
  <!-- JS -->
  <script defer>
    const sidebar = document.getElementById('sidebar_x91');
    const openMenu = document.getElementById('openMenu_x91');
    const closeMenu = document.getElementById('closeMenu_x91');
    const overlay = document.getElementById('overlay_x91');

    openMenu.addEventListener('click', () => {
      sidebar.classList.add('active_x91');
      overlay.classList.add('show_x91');
    });

    closeMenu.addEventListener('click', () => {
      sidebar.classList.remove('active_x91');
      overlay.classList.remove('show_x91');
    });

    overlay.addEventListener('click', () => {
      sidebar.classList.remove('active_x91');
      overlay.classList.remove('show_x91');
    });
  </script>
  <script defer>
  const customMenuBtn = document.getElementById('customMenuBtn');
  const customSidebar = document.getElementById('customSidebar');

  customMenuBtn.addEventListener('click', () => {
    customSidebar.classList.toggle('custom-active');
  });
</script>
</body>
</html>