<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>LA Schools Expand Tutoring to Boost Reading Skills</title>
    <meta name="title" content="LA Schools Expand Tutoring to Boost Reading Skills">

    <meta name="description"
        content="Los Angeles schools are expanding free after-school tutoring programs to help thousands of students improve reading and math skills as the district works to close post-pandemic learning gaps.">

    <meta name="keywords"
        content="LAUSD tutoring, Los Angeles schools, reading improvement, after-school programs, student learning, education news, academic support">

    <meta name="author" content="Samuel Foster">

    <link rel="canonical" href="https://www.progresskingdom.com/local/los-angeles-schools-add-after-school-tutoring.php">

    <!-- Open Graph -->
    <meta property="og:title" content="LA Schools Expand Tutoring to Boost Reading Skills">
    <meta property="og:description"
        content="Los Angeles schools are expanding free after-school tutoring programs to help thousands of students improve reading and math skills as the district works to close post-pandemic learning gaps.">
    <meta property="og:url" content="https://www.progresskingdom.com/local/los-angeles-schools-add-after-school-tutoring.php">
    <meta property="og:image" content="https://www.progresskingdom.com/images/los-angeles-schools-add-after-school-tutoring.webp">
    <meta property="og:site_name" content="Progress Kingdom">
    <meta property="og:type" content="article">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:locale" content="en_US">

    <!-- Twitter -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="LA Schools Expand Tutoring to Boost Reading Skills">
    <meta name="twitter:description"
        content="Los Angeles schools are expanding free after-school tutoring programs to help thousands of students improve reading and math skills as the district works to close post-pandemic learning gaps.">
    <meta name="twitter:url" content="https://www.progresskingdom.com/local/los-angeles-schools-add-after-school-tutoring.php">
    <meta name="twitter:image" content="https://www.progresskingdom.com/images/los-angeles-schools-add-after-school-tutoring.webp">
    <meta name="twitter:site" content="@progresskingdom">
    <meta name="twitter:creator" content="@progresskingdom">

    <!-- Stylesheet + Favicon -->
    <link rel="stylesheet" href="../style.css">
    <link rel="icon" href="../images/icon.svg">

    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "WebSite",
      "@id": "https://www.progresskingdom.com/#website",
      "name": "Progress Kingdom",
      "url": "https://www.progresskingdom.com/"
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.progresskingdom.com/#publisher",
      "name": "Progress Kingdom",
      "url": "https://www.progresskingdom.com/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.progresskingdom.com/images/logo.svg",
        "width": 512,
        "height": 512
      },
      "sameAs": [
        "https://twitter.com/progresskingdom"
      ]
    },

    {
      "@type": "Person",
      "@id": "https://www.progresskingdom.com/#samuelfoster",
      "name": "Samuel Foster",
      "url": "https://www.progresskingdom.com/author/samuel-foster.php",
      "jobTitle": "Local Reporter",
      "worksFor": {
        "@id": "https://www.progresskingdom.com/#publisher"
      },
      "sameAs": [
        "https://medium.com/@samuelfoster_",
        "https://substack.com/@samuelfoster212"
      ]
    }, 

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.progresskingdom.com/local/los-angeles-schools-add-after-school-tutoring.php#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.progresskingdom.com/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Local News",
          "item": "https://www.progresskingdom.com/local/"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "name": "Los Angeles Schools Add After-School Tutoring to Boost Reading Levels",
          "item": "https://www.progresskingdom.com/local/los-angeles-schools-add-after-school-tutoring.php"
        }
      ]
    },

    {
      "@type": "WebPage",
      "@id": "https://www.progresskingdom.com/local/los-angeles-schools-add-after-school-tutoring.php#webpage",
      "url": "https://www.progresskingdom.com/local/los-angeles-schools-add-after-school-tutoring.php",
      "name": "LA Schools Expand Tutoring to Boost Reading Skills",
      "description": "Los Angeles schools expand free after-school tutoring programs to help thousands of students improve reading and math, addressing post-pandemic learning gaps.",
      "inLanguage": "en-US",
      "isPartOf": {
        "@id": "https://www.progresskingdom.com/#website"
      },
      "breadcrumb": {
        "@id": "https://www.progresskingdom.com/local/los-angeles-schools-add-after-school-tutoring.php#breadcrumb"
      },
      "dateModified": "2025-11-08",
      "primaryImageOfPage": {
        "@type": "ImageObject",
        "url": "https://www.progresskingdom.com/images/los-angeles-schools-add-after-school-tutoring.webp",
        "width": 1200,
        "height": 630
      }
    },

    {
      "@type": "NewsArticle",
      "@id": "https://www.progresskingdom.com/local/los-angeles-schools-add-after-school-tutoring.php#article",
      "headline": "Los Angeles Schools Add After-School Tutoring to Boost Reading Levels",
      "description": "LAUSD expands its after-school tutoring program to support students struggling with reading and math, with new centers and partnerships across Los Angeles.",
      "image": [
        "https://www.progresskingdom.com/images/los-angeles-schools-add-after-school-tutoring.webp",
        "https://www.progresskingdom.com/images/addressing-learning-gaps-after-the-pandemic.webp"
      ],
      "datePublished": "2025-11-08",
      "dateModified": "2025-11-08",
      "articleSection": "Local News",
      "inLanguage": "en-US",
      "author": {
        "@id": "https://www.progresskingdom.com/#samuelfoster"
      },
      "publisher": {
        "@id": "https://www.progresskingdom.com/#publisher"
      },
      "mainEntityOfPage": {
        "@id": "https://www.progresskingdom.com/local/los-angeles-schools-add-after-school-tutoring.php#webpage"
      }
    }

  ]
}
</script>

</head>

<body>
 
  <!-- header -->
  <?php include ('../header.php'); ?>



    <main>
<!-- sixth section -->
 <div class="featured-container expose">


  <div class="featured-grid">
    <!-- Left Large Video -->
    <div class="featured-left">
         <div class="post-wrapper">
    <div class="post-inner">

      <div class="post-tag">LOCAL NEWS</div>

      <h1 class="post-heading">Los Angeles Schools Add After-School Tutoring to Boost Reading Levels</h1>

      <div class="post-description">
 <p> LAUSD expanded after-school tutoring programs to support students struggling with reading and math.</p>
      </div>

      <div class="post-info">
        <div class="post-author">BY <span>SAMUEL FOSTER</span></div>
        <div class="post-date">NOVEMBER 8, 2025</div>
      </div>

      <!-- social content -->
       <?php include ('../social-content.php'); ?>
      
  </div>

   <div class="">
       <img src="../images/los-angeles-schools-add-after-school-tutoring.webp" alt="Los Angeles Schools Add After School Tutoring" class="featured-main-img">

      <p class="trend-text sety "  >
  The Los Angeles Unified School District (LAUSD), which has the second-largest school system in the country, announced this week that it will greatly expand its after-school tutoring program for kids in grades three through eight to help them get better at reading and math.
    </p>
        <p class="trend-text sety" >
     The program is part of a district-wide plan to improve academics. It expands partnerships with educational charities and opens hundreds of new tutoring locations where students can get free, one-on-one help. According to test results from all over the state, the expansion comes at a time when kids are still losing ground in their studies because of the pandemic, especially low-income and English-learning kids.
    </p>
              
    <div class="quates">
        <p>
          “We’re making sure every child has access to the extra help they need,” said LAUSD Superintendent Alberto Carvalho at a press conference on Monday. “This is about ensuring students not only catch up but thrive.”
        </p>
    </div>
  <p class="trend-text sety" >
 Starting in December, the district will offer small-group tutoring sessions on weekends and after school at more than 450 schools. The lessons' main goals are to help students get ready for tests, learn basic math skills, and understand what they read.
    </p>
    <p class="trend-text sety" >
 Tutors will be volunteers from local groups, certified teachers, and college students who have the right skills. Parents can sign their kids up for school online or by calling the school office.
   </p>


     <img loading="lazy" src="../images/addressing-learning-gaps-after-the-pandemic.webp" alt="Addressing Learning Gaps After the Pandemic" class="featured-main-img">

     <h2 class="post-heading">Addressing Learning Gaps After the Pandemic</h2>
     <p class="trend-text sety loco">
        The most recent state exam results show that only 38% of LAUSD students met expectations in math and 46% of students met grade-level standards in English language arts. Carvalho said that the district's extended program is meant to stop those trends by giving students regular academic help after school.
    </p>
        <p class="trend-text sety">
          The district's expanded tutoring sessions, which started in the spring of 2024, had about 15,000 kids take part. By the middle of 2026, the program will have grown to about 60,000 students, mostly in the San Fernando Valley, East L.A., and South L.A.
        </p>

        <p class="trend-text sety">
         The expansion will be paid for by federal Elementary and Secondary School Emergency Relief (ESSER) grants and partnerships with local groups like Reading Partners and the YMCA of Greater Los Angeles.
        </p>
        
        <div class="footerArea_x91">
    

    <!-- AUTHOR SECTION -->
    <?php include ('../authorss/local-news-author.php'); ?>

    <!-- COMMENT SECTION -->
    <?php include ('../comment.php'); ?>

  </div>

   </div>

    </div>

    <!-- Right Smaller Videos -->
    <?php include ('../side-content.php'); ?>

<!-- trending news section -->
<div class="trend-wrapper">
  <h3 class="trend-heading">Local News</h3>

  <div class="trend-grid">

    <!-- Post 2 -->
    <div class="trend-card">
      <img loading="lazy" src="../images/new-public-park-opens-on-chicago.webp" alt="New Public Park Opens on Chicago’s West Side" class="trend-image">
      <h2 class="trend-title">
        <a href="../local/new-public-park-opens-on-chicago.php" title="New Public Park Opens on Chicago’s West Side">New Public Park Opens on Chicago’s West Side</a>
      </h2>
      <p class="trend-text">
      Chicago city officials opened a new 12-acre community park featuring walking trails, playgrounds, and green space for local families.
    </p>
      <p class="trend-info">
        <span class="trend-cat">LOCAL NEWS</span> BY <span class="trend-author">SAMUEL FOSTER</span> NOVEMBER 9, 2025
      </p>
    </div>


    <!-- Post 1 -->
    <div class="trend-card">
      <img loading="lazy" src="../images/the-big-ten-gets-former-pac-12-powerhouses-oregon.webp" alt="The Big Ten gets former Pac-12 powerhouses Oregon" class="trend-image">
      <h2 class="trend-title">
        <a href="../local/the-big-ten-gets-former-pac-12-powerhouses-oregon.php" title="The Big Ten gets former Pac-12 powerhouses Oregon, USC, Washington, and UCLA to join them">The Big Ten gets former Pac-12 powerhouses Oregon, USC, Washington, and UCLA to join them</a>
      </h2>
      <p class="trend-text">
    Old Pac-12 teams  Oregon, Washington, USC, and UCLA are getting used to the league's run-heavy style and doing well with better rushing and more balanced play a year after joining the Big Ten Conference.</p>
        </p>
      <p class="trend-info">
        <span class="trend-cat">LOCAL NEWS</span> BY <span class="trend-author">SAMUEL FOSTER</span> NOVEMBER 7, 2025
      </p>
    </div>

  </div>
</div>



    </main>

  <!-- footer -->
  <?php include ('../footer.php'); ?>

  <!-- JS -->
  <script defer>
    const sidebar = document.getElementById('sidebar_x91');
    const openMenu = document.getElementById('openMenu_x91');
    const closeMenu = document.getElementById('closeMenu_x91');
    const overlay = document.getElementById('overlay_x91');

    openMenu.addEventListener('click', () => {
      sidebar.classList.add('active_x91');
      overlay.classList.add('show_x91');
    });

    closeMenu.addEventListener('click', () => {
      sidebar.classList.remove('active_x91');
      overlay.classList.remove('show_x91');
    });

    overlay.addEventListener('click', () => {
      sidebar.classList.remove('active_x91');
      overlay.classList.remove('show_x91');
    });
  </script>
  <script defer>
  const customMenuBtn = document.getElementById('customMenuBtn');
  const customSidebar = document.getElementById('customSidebar');

  customMenuBtn.addEventListener('click', () => {
    customSidebar.classList.toggle('custom-active');
  });
</script>

</body>
</html>