<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Local News – Community Updates, City Events & Regional Stories</title>

    <meta name="title" content="Local News – Community Updates, City Events & Regional Stories">

    <meta name="description"
        content="Stay updated with the latest local news, community events, city developments, education updates, sports highlights, and regional stories from across the U.S.">

    <meta name="keywords"
        content="local news, community updates, city news, regional stories, local events, U.S. cities, education news, local sports, neighborhood updates">

    <!-- Canonical -->
    <link rel="canonical" href="https://www.progresskingdom.com/local/local.php">

    <!-- Open Graph -->
    <meta property="og:title" content="Local News – Community Updates, City Events & Regional Stories">
    <meta property="og:description"
          content="Stay updated with the latest local news, community events, city developments, education updates, sports highlights, and regional stories from across the U.S.">
    <meta property="og:url" content="https://www.progresskingdom.com/local/local.php">
    <meta property="og:image" content="https://www.progresskingdom.com/images/progresskingdom.webp">
    <meta property="og:site_name" content="Progress Kingdom">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_US">

    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Local News – Community Updates, City Events & Regional Stories">
    <meta name="twitter:description"
          content="Stay updated with the latest local news, community events, city developments, education updates, sports highlights, and regional stories from across the U.S.">
    <meta name="twitter:url" content="https://www.progresskingdom.com/local/local.php">
    <meta name="twitter:image" content="https://www.progresskingdom.com/images/progresskingdom.webp">
    <meta name="twitter:site" content="@progresskingdom">
    <meta name="twitter:creator" content="@progresskingdom">

    <link rel="stylesheet" href="../style.css">
    <link rel="icon" href="../images/icon.svg">

    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "WebSite",
      "@id": "https://www.progresskingdom.com/#website",
      "url": "https://www.progresskingdom.com/",
      "name": "Progress Kingdom",
      "publisher": {
        "@id": "https://www.progresskingdom.com/#publisher"
      }
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.progresskingdom.com/#publisher",
      "name": "Progress Kingdom",
      "url": "https://www.progresskingdom.com/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.progresskingdom.com/images/logo.svg",
        "width": 512,
        "height": 512
      }
    },

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.progresskingdom.com/local/local.php#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.progresskingdom.com/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Local",
          "item": "https://www.progresskingdom.com/local/local.php"
        }
      ]
    },

    {
      "@type": "CollectionPage",
      "@id": "https://www.progresskingdom.com/local/local.php#collection",
      "name": "Local News – Community Updates, City Events & Regional Stories",
      "description": "Stay updated with the latest local news, community events, city developments, education updates, sports highlights, and regional stories from across the U.S.",
      "url": "https://www.progresskingdom.com/local/local.php",
      "inLanguage": "en-US",
      "isPartOf": { "@id": "https://www.progresskingdom.com/#website" }
    },

    {
      "@type": "WebPage",
      "@id": "https://www.progresskingdom.com/local/local.php#webpage",
      "url": "https://www.progresskingdom.com/local/local.php",
      "name": "Local News – Community Updates, City Events & Regional Stories",
      "description": "Local U.S. news including community updates, city announcements, education improvements, sports developments, and regional stories.",
      "inLanguage": "en-US",
      "primaryImageOfPage": {
        "@type": "ImageObject",
        "url": "https://www.progresskingdom.com/images/progresskingdom.webp",
        "width": 1200,
        "height": 630
      },
      "breadcrumb": { "@id": "https://www.progresskingdom.com/local/local.php#breadcrumb" },
      "isPartOf": { "@id": "https://www.progresskingdom.com/#website" }
    },

    {
      "@type": "ItemList",
      "@id": "https://www.progresskingdom.com/local/local.php#itemlist",
      "name": "Local News Articles",
      "itemListOrder": "http://schema.org/ItemListOrderDescending",
      "itemListElement": [

        {
          "@type": "ListItem",
          "position": 1,
          "url": "https://www.progresskingdom.com/local/new-public-park-opens-on-chicago.php",
          "name": "New Public Park Opens on Chicago’s West Side"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "url": "https://www.progresskingdom.com/local/los-angeles-schools-add-after-school-tutoring.php",
          "name": "Los Angeles Schools Add After-School Tutoring to Boost Reading Levels"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "url": "https://www.progresskingdom.com/local/the-big-ten-gets-former-pac-12-powerhouses-oregon.php",
          "name": "The Big Ten gets former Pac-12 powerhouses Oregon, USC, Washington, and UCLA to join them"
        }

      ]
    }

  ]
}
</script>

</head>

<body>
   <!-- header -->
  <?php include '../header.php'; ?>

    <main>
<!-- sixth section -->
 <div class="featured-container expose">
  <div class="featured-header categorysec">
    <div class="sgatyy">
        <a href="../index.php" title="home page">Home</a>
        <a href="../local/local.php" title="local page">Local</a>
        
    </div>
    <h1 class="featured-title">Local</h1>
  </div>

  <div class="featured-grid">
    <!-- Left Large Video -->
    <div class="featured-left">
   <div class="">
       <img src="../images/new-public-park-opens-on-chicago.webp" alt="New Public Park Opens on Chicago’s West Side" class="featured-main-img">
      <h2 class="featured-main-title"><a href="../local/new-public-park-opens-on-chicago.php" title="New Public Park Opens on Chicago’s West Side">New Public Park Opens on Chicago’s West Side</a></h2>
      <p class="featured-main-desc">
       Chicago city officials opened a new 12-acre community park with playgrounds, walking paths, and green space for families in the area.
    </p>
   </div>
  <div class="maryy2">
        <img loading="lazy" src="../images/los-angeles-schools-add-after-school-tutoring.webp" alt="Los Angeles Schools Add After-School Tutoring" class="featured-main-img">
      <h2 class="featured-main-title"><a href="../local/los-angeles-schools-add-after-school-tutoring.php" title="Los Angeles Schools Add After-School Tutoring to Boost Reading Levels">Los Angeles Schools Add After-School Tutoring to Boost Reading Levels</a></h2>
      <p class="featured-main-desc">
         LAUSD expanded after-school tutoring programs to support students struggling with reading and math.</p>
     </p>
  </div>
   <div class="maryy2">
        <img loading="lazy" src="../images/the-big-ten-gets-former-pac-12-powerhouses-oregon.webp" alt="The Big Ten gets former Pac-12 powerhouses Oregon" class="featured-main-img">
      <h2 class="featured-main-title"><a href="../local/the-big-ten-gets-former-pac-12-powerhouses-oregon.php" title="The Big Ten gets former Pac-12 powerhouses Oregon, USC, Washington, and UCLA to join them">The Big Ten gets former Pac-12 powerhouses Oregon, USC, Washington, and UCLA to join them.</a></h2>
      <p class="featured-main-desc">
        Old Pac-12 teams  Oregon, Washington, USC, and UCLA are getting used to the league's run-heavy style and doing well with better rushing and more balanced play a year after joining the Big Ten Conference.</p>
        </p>
  </div>
   
 
    </div>

    <!-- Right Smaller Videos -->
    <?php include ('../side-content.php'); ?>
  </div>
</div>


<!-- seventh section -->





    </main>

      <!-- footer -->
  <?php include '../footer.php'; ?>
  
  <!-- JS -->
  <script defer>
    const sidebar = document.getElementById('sidebar_x91');
    const openMenu = document.getElementById('openMenu_x91');
    const closeMenu = document.getElementById('closeMenu_x91');
    const overlay = document.getElementById('overlay_x91');

    openMenu.addEventListener('click', () => {
      sidebar.classList.add('active_x91');
      overlay.classList.add('show_x91');
    });

    closeMenu.addEventListener('click', () => {
      sidebar.classList.remove('active_x91');
      overlay.classList.remove('show_x91');
    });

    overlay.addEventListener('click', () => {
      sidebar.classList.remove('active_x91');
      overlay.classList.remove('show_x91');
    });
  </script>
  <script defer>
  const customMenuBtn = document.getElementById('customMenuBtn');
  const customSidebar = document.getElementById('customSidebar');

  customMenuBtn.addEventListener('click', () => {
    customSidebar.classList.toggle('custom-active');
  });
</script>
</body>
</html>