<!DOCTYPE html>
<html lang="en">
<head> 
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Progress Kingdom – Breaking U.S. News, Politics, Business & Technology</title>
    <meta name="title" content="Progress Kingdom – Breaking U.S. News, Politics, Business & Technology">

    <meta name="description" content="Progress Kingdom delivers the latest U.S. news, political updates, business insights, tech innovations, and local reporting across the nation">

    <!-- Canonical URL -->
    <link rel="canonical" href="https://www.progresskingdom.com/">

    <meta property="og:title" content="Progress Kingdom – Breaking U.S. News, Politics, Business & Technology">
    <meta property="og:description" content="Progress Kingdom delivers the latest U.S. news, political updates, business insights, tech innovations, and local reporting across the nation">
    <meta property="og:url" content="https://www.progresskingdom.com/">
    <meta property="og:image" content="https://www.progresskingdom.com/images/logo.webp">
    <meta property="og:site_name" content="Progress Kingdom">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_US">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">


    <!-- Twitter Cards -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Progress Kingdom – Breaking U.S. News, Politics, Business & Technology">
    <meta name="twitter:description" content="Progress Kingdom delivers the latest U.S. news, political updates, business insights, tech innovations, and local reporting across the nation">
    <meta name="twitter:url" content="https://www.progresskingdom.com/">
    <meta name="twitter:image" content="https://www.progresskingdom.com/images/logo.webp">

    <!-- Preload Fonts for Speed -->
    <link rel="preload" href="fonts/Anton-Regular.woff2" as="font" type="font/woff2" crossorigin>
    <link rel="preload" href="fonts/Poppins-Regular.woff2" as="font" type="font/woff2" crossorigin>

    <link rel="preload" as="image" href="images/trump-criticizes-mamdani-and-signals-support-for-cuomo.webp">
    <link rel="preload" as="image" href="images/u-s-officials-say-that-rail-safety-across-the-country-has-gotten-better.webp">


    <!-- Stylesheet -->
    <link rel="preload" href="style.css" as="style">
    <link rel="stylesheet" href="style.css">

    <!-- Favicon -->
     <link rel="icon" href="images/icon.svg">
    


<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
  "@type": "WebSite",
  "@id": "https://www.progresskingdom.com/#website",
  "url": "https://www.progresskingdom.com/",
  "name": "Progress Kingdom",
  "inLanguage": "en-US"
},


    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.progresskingdom.com/#publisher",
      "name": "Progress Kingdom",
      "url": "https://www.progresskingdom.com/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.progresskingdom.com/images/logo.svg",
        "width": 512,
        "height": 512
      },
      "sameAs": [
        "https://twitter.com/progresskingdom"
      ],
      "foundingDate": "2025-01-01",
      "description": "Progress Kingdom delivers the latest U.S. news, political updates, business insights, tech innovations, and local reporting across the nation"
    },


    {
      "@type": "Person",
      "@id": "https://www.progresskingdom.com/author/jordan-lee.php",
      "name": "Jordan Lee",
      "jobTitle": "U.S. News Reporter",
      "worksFor": { "@id": "https://www.progresskingdom.com/#publisher" }
    },
    {
      "@type": "Person",
      "@id": "https://www.progresskingdom.com/author/sam-hunter.php",
      "name": "Sam Hunter",
      "jobTitle": "Politics Journalist",
      "worksFor": { "@id": "https://www.progresskingdom.com/#publisher" }
    },
    {
      "@type": "Person",
      "@id": "https://www.progresskingdom.com/author/riley-carter.php",
      "name": "Riley Carter",
      "jobTitle": "Business Journalist",
      "worksFor": { "@id": "https://www.progresskingdom.com/#publisher" }
    },
    {
      "@type": "Person",
      "@id": "https://www.progresskingdom.com/author/casey-nolan.php",
      "name": "Casey Nolan",
      "jobTitle": "Technology Journalist",
      "worksFor": { "@id": "https://www.progresskingdom.com/#publisher" }
    },
    {
      "@type": "Person",
      "@id": "https://www.progresskingdom.com/author/samuel-foster.php",
      "name": "Samuel Foster",
      "jobTitle": "Local News Reporter",
      "worksFor": { "@id": "https://www.progresskingdom.com/#publisher" }
    },


    {
      "@type": "WebPage",
      "@id": "https://www.progresskingdom.com/#webpage",
      "url": "https://www.progresskingdom.com/",
      "name": "Progress Kingdom – Breaking U.S. News, Politics, Business & Technology",
      "isPartOf": { "@id": "https://www.progresskingdom.com/#website" },
      "about": { "@id": "https://www.progresskingdom.com/#publisher" },
      "dateModified": "2025-11-10",
      "description": "Progress Kingdom delivers the latest U.S. news, political updates, business insights, tech innovations, and local reporting across the nation",
      "breadcrumb": {
        "@type": "BreadcrumbList",
        "itemListElement": [
          {
            "@type": "ListItem",
            "position": 1,
            "name": "Home",
            "item": "https://www.progresskingdom.com/"
          }
        ]
      },
      "inLanguage": "en-US",
      "publisher": { "@id": "https://www.progresskingdom.com/#publisher" }
    },


    {
      "@type": "ItemList",
      "@id": "https://www.progresskingdom.com/#topnews",
      "name": "Top Headlines",
      "itemListOrder": "Descending",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "item": {
            "@type": "NewsArticle",
            "headline": "Trump Criticizes Mamdani and Signals Support for Cuomo",
            "url": "https://www.progresskingdom.com/usnews/trump-criticizes-mamdani-and-signals-support-for-cuomo.php",
            "image": "https://www.progresskingdom.com/images/trump-criticizes-mamdani-and-signals-support-for-cuomo.webp",
            "datePublished": "2025-11-04",
            "author": { "@id": "https://www.progresskingdom.com/author/jordan-lee.php" }
          }
        },
        {
          "@type": "ListItem",
          "position": 2,
          "item": {
            "@type": "NewsArticle",
            "headline": "The U.S. government has been closed for the longest time",
            "url": "https://www.progresskingdom.com/usnews/the-u-s-government-has-been-closed-for-the-longest-time.php",
            "image": 
            {
              "@type": "ImageObject",
              "url": "https://www.progresskingdom.com/images/the-u-s-government-has-been-closed-for-the-longest-time.webp",
              "width": 1200,
              "height": 630
            },
            "datePublished": "2025-11-04",
            "author": { "@id": "https://www.progresskingdom.com/author/jordan-lee.php" }
          }
        },
        {
          "@type": "ListItem",
          "position": 3,
          "item": {
            "@type": "NewsArticle",
            "headline": "A big winter storm hits the Northeastern U.S.",
            "url": "https://www.progresskingdom.com/usnews/a-big-winter-storm-hits-the-northeastern-u.s.php",
            "image": 
            {
              "@type": "ImageObject",
              "url": "https://www.progresskingdom.com/images/a-big-winter-storm-hits-the-northeastern-u.s.webp",
              "width": 1200,
              "height": 630
            },
            "datePublished": "2025-10-11",
            "author": { "@id": "https://www.progresskingdom.com/author/jordan-lee.php" }
          }
        }
      ]
    },

    {
      "@type": "ItemList",
      "@id": "https://www.progresskingdom.com/#recent",
      "name": "Most Recent Articles",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "item": {
            "@type": "NewsArticle",
            "headline": "U.S. Senate Blocks Border-Ukraine-Israel Aid Package",
            "url": "https://www.progresskingdom.com/politics/u-s-senate-blocks-border-Ukraine-Israel-aid-package.php",
            "image": 
            {
              "@type": "ImageObject",
              "url": "https://www.progresskingdom.com/images/u-s-senate-blocks-Border-Ukraine-Israel-aid.webp",
              "width": 1200,
              "height": 630
            },

            "datePublished": "2025-10-08",
            "author": { "@id": "https://www.progresskingdom.com/author/sam-hunter.php" }
          }
        }
      ]
    },


    {
      "@type": "ItemList",
      "@id": "https://www.progresskingdom.com/#business",
      "name": "Business Section",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "item": {
            "@type": "NewsArticle",
            "headline": "Funding Standoff Forces Flight Cuts",
            "url": "https://www.progresskingdom.com/business/funding-standoff-forces-flight-cuts.php",
            "image": 
            {
              "@type": "ImageObject",
              "url": "https://www.progresskingdom.com/images/funding-standoff-forces-flight-cuts.webp",
              "width": 1200,
              "height": 630
            },
            "datePublished": "2025-11-09",
            "author": { "@id": "https://www.progresskingdom.com/author/riley-carter.php" }
          }
        }
      ]
    },

    {
      "@type": "ItemList",
      "@id": "https://www.progresskingdom.com/#technology",
      "name": "Technology Section",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "item": {
            "@type": "NewsArticle",
            "headline": "Nexperia Crisis Affects the Chipmaker Industry",
            "url": "https://www.progresskingdom.com/technology/nexperia-crisis-affects-the-chipmaker-industry.php",
            "image": 
            {
              "@type": "ImageObject",
              "url": "https://www.progresskingdom.com/images/nexperia-crisis-affects-the-chipmaker-industry.webp",
              "width": 1200,
              "height": 630
            },

            "datePublished": "2025-11-09",
            "author": { "@id": "https://www.progresskingdom.com/author/casey-nolan.php" }
          }
        }
      ]
    }

  ]
}
</script>




</head>

<body>

<!-- nav bar -->
 <?php include 'indexheader.php'; ?>


<main>

  <div class="container">

    <!-- LEFT COLUMN -->
    <div class="main-content">

      <div class="article">
        <img width="284" height="185" src="images/trump-criticizes-mamdani-and-signals-support-for-cuomo.webp" alt="Trump Criticizes Mamdani and Signals Support for Cuomo in Heated NYC Mayoral Race" fetchpriority="high" >
        <div class="article-info">
          <h2><a href="usnews/trump-criticizes-mamdani-and-signals-support-for-cuomo.php" title="Trump Criticizes Mamdani and Signals Support for Cuomo in Heated NYC Mayoral Race">Trump Criticizes Mamdani and Signals Support for Cuomo in Heated NYC Mayoral Race.</a></h2>
          <p class="meta">BY <span>JORDAN LEE</span> NOVEMBER 4, 2025</p>
        </div>
      </div>

      <div class="article">
        <img width="284" height="185" src="images/the-u-s-government-has-been-closed-for-the-longest-time.webp" alt="The U.S. government has been closed for the longest time">
        <div class="article-info">
          <h2><a href="usnews/the-u-s-government-has-been-closed-for-the-longest-time.php" title="The U.S. government has been closed for the longest time">The U.S. government has been closed for the longest time.</a></h2>
          <p class="meta">BY <span>JORDAN LEE</span> NOVEMBER 4, 2025</p>
        </div>
      </div>

      <div class="article">
        <img loading="lazy" width="284" height="185" src="images/a-big-winter-storm-hits-the-northeastern-u.s.webp" alt="A big winter storm hits the Northeastern U.S">
        <div class="article-info">
          <h2><a href="usnews/a-big-winter-storm-hits-the-northeastern-u.s.php" title="A big winter storm hits the Northeastern U.S">A big winter storm hits the Northeastern U.S.</a></h2>
          <p class="meta">BY <span>JORDAN LEE</span> OCTOBER 11, 2025</p>
        </div>
      </div>

      <div class="article">
        <img loading="lazy" width="284" height="185" src="images/the-u-s-stock-market-also-goes-down-when-tech-stocks-go-down.webp" alt="The U.S. stock market also goes down when tech stocks go down">
        <div class="article-info">
          <h2><a href="usnews/the-u-s-stock-market-also-goes-down-when-tech-stocks-go-down.php" title="The U.S. stock market also goes down when tech stocks go down">The U.S. stock market also goes down when tech stocks go down.</a></h2>
          <p class="meta">BY <span>JORDAN LEE</span> OCTOBER 25, 2025</p>
        </div>
      </div>

    </div>

    <!-- CENTER FEATURED ARTICLE -->
    <div class="featured">

      <div>
        <img width="284" height="185"  src="images/u-s-officials-say-that-rail-safety-across-the-country-has-gotten-better.webp" alt="U.S. officials say that rail safety across the country has gotten better">
        <div class="featured-text">
          <h1><a href="usnews/u-s-officials-say-that-rail-safety-across-the-country-has-gotten-better.php" title="U.S. officials say that rail safety across the country has gotten better">U.S. officials say that rail safety across the country has gotten better.</a></h1>
          <p>Federal transportation leaders announced a detailed plan to make rail travel safer after a number of high-profile derailments in the last few months.</p>
          <p class="meta">IN <span>U.S NEWS</span> BY <span>JORDAN LEE</span> OCTOBER 11, 2025</p>
        </div>
      </div>

      <div>
        <img  src="images/democrats-see-mixed-results-in-2025.webp" alt="Democrats See Mixed Results in 2025 Off-Year Elections as Parties Gauge Early 2026 Momentum">
        <div class="featured-text">
          <h2><a href="usnews/democrats-see-mixed-results-in-2025.php" title="Democrats See Mixed Results in 2025 Off-Year Elections">Democrats See Mixed Results in 2025 Off-Year Elections as Parties Gauge Early 2026 Momentum</a></h2>
          <p>Democrats secured several statewide wins in 2025 off-year elections, while Republicans expanded gains in key local contests as both parties look ahead to the 2026 midterms.</p>
          <p class="meta">IN <span>U.S NEWS</span> BY <span>JORDAN LEE</span> NOVEMBER 4, 2025</p>
        </div>
      </div>

    </div>

    <!-- RIGHT SIDEBAR -->
    <aside class="sidebar">
      <h3>Today’s Pick</h3>

      <div class="side-article">
        <img  width="115" height="105" src="images/u-s-expands-subcritical-nuclear-tests.webp" alt="U.S. Expands Subcritical Nuclear Tests as Global Tensions Rise">
        <div>
          <p class="category">U.S NEWS</p>
          <h4><a href="usnews/u-s-expands-subcritical-nuclear-tests.php" title="U.S. Expands Subcritical Nuclear Tests as Global Tensions Rise">U.S. Expands Subcritical Nuclear Tests as Global Tensions Rise</a></h4>
          <p class="meta"><span>JORDAN LEE</span> NOVEMBER 4, 2025</p>
        </div>
      </div>

      <div class="side-article">
        <img width="115" height="105" src="images/u-s-tightens-china-trade-policy.webp" alt="U.S. Tightens China Trade Policy">
        <div>
          <p class="category">U.S NEWS</p>
          <h4><a href="usnews/u-s-tightens-china-trade-policy.php" title="U.S. Tightens China Trade Policy">U.S. Tightens China Trade Policy as Tariff Review Continues Into 2025</a></h4>
          <p class="meta"><span>JORDAN LEE</span> NOVEMBER 3, 2025</p>
        </div>
      </div>

      <div class="side-article">
        <img  width="115" height="105" src="images/budget-stalemates-strain-u-s-science-agencies.webp" alt="Budget Stalemates Strain U.S. Science Agencies">
        <div>
          <p class="category">U.S NEWS</p>
          <h4><a href="usnews/budget-stalemates-strain-u-s-science-agencies.php" title="Budget Stalemates Strain U.S. Science Agencies">Budget Stalemates Strain U.S. Science Agencies</a></h4>
          <p class="meta"><span>JORDAN LEE</span> NOVEMBER 3, 2025</p>
        </div>
      </div>

      <div class="side-article">
        <img  width="115" height="105" src="images/climate-tech-and-geoengineering-backlash.webp" alt="Climate Tech and Geoengineering Face Growing Backlash">
        <div>
          <p class="category">U.S NEWS</p>
          <h4><a href="usnews/climate-tech-and-geoengineering-backlash.php" title="Climate Tech and Geoengineering Face Growing Two-party Backlash">Climate Tech and Geoengineering Face Growing Two-party Backlash</a></h4>
          <p class="meta"><span>JORDAN LEE</span> NOVEMBER 5, 2025</p>
        </div>
      </div>

      <div class="side-article">
        <img loading="lazy" width="115" height="105" src="images/u-s-executive-orders-signal-sharp-shift.webp" alt="U.S. Executive Orders Signal Sharp Shift in Environment and Trade Policy">
        <div>
          <p class="category">U.S NEWS</p>
          <h4><a href="usnews/u-s-executive-orders-signal-sharp-shift.php" title="U.S. Executive Orders Signal Sharp Shift in Environment and Trade Policy">U.S. Executive Orders Signal Sharp Shift in Environment and Trade Policy</a></h4>
          <p class="meta"><span>JORDAN LEE</span> NOVEMBER 1, 2025</p>
        </div>
      </div>

      <div class="add">
        <img loading="lazy"  src="img/b3.webp" alt="">
      </div>

    </aside>

  </div>

  <!-- second section -->

  <div class="content-wrapper">

    <!-- Left side: Top Picks -->
    <div class="pick-list">
      <h3 class="section-title">Today’s Pick</h3>

      <div class="pick-entry">
        <div class="pick-number">1</div>
        <div class="pick-content">
          <h2 class="pick-title"><a href="politics/kevin-mccarthy-ousted-as-house-speaker.php" title="Kevin McCarthy Ousted as House Speaker in Historic Vote">Kevin McCarthy Ousted as House Speaker in Historic Vote</a></h2>
          <p class="pick-meta">BY <span class="author">SAM HUNTER</span> OCTOBER 18, 2025</p>
        </div>
      </div>

      <div class="pick-entry">
        <div class="pick-number">2</div>
        <div class="pick-content">
          <h2 class="pick-title"><a href="politics/democrats-are-facing-a-growing-grassroots-uprising.php" title="Democrats are facing a growing grassroots uprising">Democrats are facing a growing grassroots uprising one year after Trump came back to power.</a></h2>
          <p class="pick-meta">BY <span class="author">SAM HUNTER</span> NOVEMBER 5, 2025</p>
        </div>
      </div>

      <div class="pick-entry">
        <div class="pick-number">3</div>
        <div class="pick-content">
          <h2 class="pick-title"><a href="politics/the-supreme-court-will-not-hear-trump-caseon-tariffs.php" title="The Supreme Court will not hear Trump's case about tariffs">The Supreme Court will not hear Trump's case about tariffs. But his Secretary of the Treasury will be there.</a></h2>
          <p class="pick-meta">BY <span class="author">SAM HUNTER</span> OCTOBER 3, 2025</p>
        </div>
      </div>

    </div>

    <!-- Right side: Recent Articles -->
    <div class="recent-articles-wrapper">
      <h3 class="section-title">Most Recent</h3>

      <div class="recent-articles">

        <article class="recent-article">
          <img loading="lazy" src="images/u-s-senate-blocks-border-ukraine-israel-aid.webp" alt="U.S. Senate Blocks Border-Ukraine-Israel Aid Package" class="recent-img">
          <div class="recent-text">
            <h2 class="recent-title"><a href="politics/u-s-senate-blocks-border-ukraine-israel-aid-package.php" title="U.S. Senate Blocks Border-Ukraine-Israel Aid Package">U.S. Senate Blocks Border-Ukraine-Israel Aid Package</a></h2>
            <p class="recent-summary">A major Senate package linking border security funding with Ukraine and Israel aid failed to move forward after Republicans and Democrats remained divided over immigration provisions.</p>
            <p class="recent-meta"><strong class="category">POLITICS</strong> BY <span class="author">SAM HUNTER</span> OCTOBER 8, 2025</p>
          </div>
        </article>

        <article class="recent-article">
          <img loading="lazy" src="images/congress-passes-temporary-spending-bill.webp" alt="Congress Passes Temporary Spending Bill to Avoid Early 2025 Shutdown" class="recent-img">
          <div class="recent-text">
            <h2 class="recent-title"><a href="politics/congress-passes-temporary-spending-bill.php" title="Congress Passes Temporary Spending Bill">Congress Passes Temporary Spending Bill to Avoid Early 2025 Shutdown</a></h2>
            <p class="recent-summary">Lawmakers approved a stopgap bill to keep the government funded into March, avoiding an immediate shutdown.</p>
            <p class="recent-meta"><strong class="category">POLITICS</strong> BY <span class="author">SAM HUNTER</span> NOVEMBER 9, 2025</p>
          </div>
        </article>

      </div>
    </div>

  </div>


  <!-- Business Section -->
  <h3 class="editor-heading">Business</h3>
  <div class="editor-choice-container">

    <div class="editor-left">

      <div class="editor-article">
        <div class="editor-text">
          <h2 class="editor-title"><a href="business/funding-standoff-forces-flight-cuts.php" title="Funding Standoff Forces Flight Cuts">Funding Standoff Forces Flight Cuts, Straining U.S. Supply Chain</a></h2>
          <p class="editor-desc">Officials say that the U.S. supply chain is already weak because of labor shortages and delayed shipments, and it is now even more strained because of federal job shortages that have led to fewer flights at airports.</p>
          <p class="editor-meta"><span class="editor-cat">BUSINESS</span> BY <span class="editor-author">RILEY CARTER</span> NOVEMBER 9, 2025</p>
        </div>
        <div class="editor-image">
          <img loading="lazy" width="384" height="249" src="images/funding-standoff-forces-flight-cuts.webp" alt="Funding Standoff Forces Flight Cuts">
        </div>
      </div>

      <div class="editor-article">
        <div class="editor-text">
          <h2 class="editor-title"><a href="business/u-s-retailers-expect-record-holiday-sales.php" title="U.S. Retailers Expect Record Holiday Sales">U.S. Retailers Expect Record Holiday Sales as NRF Forecasts First-Ever $1 Trillion Season</a></h2>
          <p class="editor-desc">The National Retail Federation says that holiday sales will reach a record $1 trillion this year because eager shoppers are taking advantage of early discounts and strong consumer demand.</p>
          <p class="editor-meta"><span class="editor-cat">BUSINESS</span> BY <span class="editor-author">RILEY CARTER</span> NOVEMBER 7, 2025</p>
        </div>
        <div class="editor-image">
          <img loading="lazy" width="384" height="249" src="images/u-s-retailers-expect-record-holiday-sales.webp" alt="U.S. Retailers Expect Record Holiday Sales">
        </div>
      </div>

      <div class="editor-article">
        <div class="editor-text">
          <h2 class="editor-title"><a href="business/google-unveils-major-investment-in-germany.php" title="Google Unveils Major Investment in Germany">Google Unveils Major Investment in Germany: Data Centers & Renewable Energy</a></h2>
          <p class="editor-desc">Google LLC is about to announce its biggest investment in Germany to date. It will focus on data centers, infrastructure, and renewable energy projects.</p>
          <p class="editor-meta"><span class="editor-cat">BUSINESS</span> BY <span class="editor-author">RILEY CARTER</span> NOVEMBER 6, 2025</p>
        </div>
        <div class="editor-image">
          <img loading="lazy" width="384" height="249" src="images/google-unveils-major-investment-in-germany.webp" alt="Google Unveils Major Investment in Germany">
        </div>
      </div>

    </div>

    <div class="editor-right">
      <h3 class="editor-heading">Most Read Articles</h3>

      <div class="right-article">
        <div class="right-img">
          <img loading="lazy" src="images/ubs-pauses-credit-suisse-wealth-transfers.webp" alt="UBS Pauses Credit Suisse Wealth Transfers">
        </div>
        <div class="right-text">
          <h4 class="right-title"><a href="business/ubs-pauses-credit-suisse-wealth-transfers.php" title="UBS Pauses Credit Suisse Wealth Transfers">UBS Pauses Credit Suisse Wealth Transfers Amid Integration Challenges</a></h4>
          <p class="right-meta"><span class="editor-author">RILEY CARTER</span> NOVEMBER 6, 2025</p>
        </div>
      </div>

      <div class="right-article">
        <div class="right-img">
          <img loading="lazy" src="images/swiss-watch-stocks-climb.webp" alt="Swiss Watch Stocks Climb">
        </div>
        <div class="right-text">
          <h4 class="right-title"><a href="business/swiss-watch-stocks-climb-as-investors-bet.php" title="Swiss Watch Stocks Climb">Swiss Watch Stocks Climb as Investors Bet on Softer U.S. Tariff Policy</a></h4>
          <p class="right-meta"><span class="editor-author">RILEY CARTER</span> NOVEMBER 7, 2025</p>
        </div>
      </div>

      <div class="right-article">
        <div class="right-img">
          <img loading="lazy" src="images/warren-buffett-says-age-is-catching-up.webp" alt="Warren Buffett Says Age Is Catching Up">
        </div>
        <div class="right-text">
          <h4 class="right-title"><a href="business/warren-buffett-says-age-is-catching-up.php" title="Warren Buffett Says Age Is Catching Up">Warren Buffett Says Age Is Catching Up but Reaffirms Confidence in Berkshire’s Next CEO</a></h4>
          <p class="right-meta"><span class="editor-author">RILEY CARTER</span> NOVEMBER 11, 2025</p>
        </div>
      </div>

    </div>
  </div>


  <!-- Technology Section -->
  <div class="articles-container">
    <h3 class="articles-heading">Technology</h3>

    <div class="articles-grid">

      <div class="article-card">
        <div class="article-img"><img loading="lazy" src="images/nexperia-crisis-affects-the-chipmaker-industry.webp" alt="Nexperia Crisis Affects Chipmaker Industry"></div>
        <div class="article-content">
          <h2 class="article-title"><a href="technology/nexperia-crisis-affects-the-chipmaker-industry.php" title="Nexperia Crisis Affects Chipmaker Industry">Nexperia Crisis Affects the Chipmaker Industry, Leading to Auto Shutdowns</a></h2>
          <p class="article-meta">BY <span class="article-author">CASEY NOLAN</span> NOVEMBER 9, 2025</p>
        </div>
      </div>

      <div class="article-card">
        <div class="article-img"><img loading="lazy" src="images/softbank-sells-nvidia-stake-shifts-to-openai.webp" alt="SoftBank Sells Nvidia Stake"></div>
        <div class="article-content">
          <h2 class="article-title"><a href="technology/softbank-sells-nvidia-stake-shifts-to-openai.php" title="SoftBank Sells Nvidia Stake">SoftBank Sells Nvidia Stake for $5.8 Billion as It Shifts Investment Focus to OpenAI</a></h2>
          <p class="article-meta">BY <span class="article-author">CASEY NOLAN</span> NOVEMBER 10, 2025</p>
        </div>
      </div>

      <div class="article-card">
        <div class="article-img"><img loading="lazy" src="images/watchdog-group-urges-openai-to-pull-sora-2-app.webp" alt="Watchdog Group Urges OpenAI to Pull Sora 2 App"></div>
        <div class="article-content">
          <h2 class="article-title"><a href="technology/watchdog-group-urges-openai-to-pull-sora-2-app.php" title="Watchdog Group Urges OpenAI to Pull Sora 2 App">Watchdog Group Urges OpenAI to Pull Sora 2 App</a></h2>
          <p class="article-meta">BY <span class="article-author">CASEY NOLAN</span> NOVEMBER 11, 2025</p>
        </div>
      </div>

      <!-- News Letter -->
      <?php include 'newsletter.php'; ?>

    </div>
  </div>


  <!-- Local News -->
  <div class="popular-container">
    <h3 class="popular-heading">Local News</h3>

    <div class="popular-top-grid">

      <div class="popular-main">
        <img loading="lazy" src="images/new-public-park-opens-on-chicago.webp" alt="New Public Park Opens in Chicago">
        <h2 class="popular-title"><a href="local/new-public-park-opens-on-chicago.php" title="New Public Park Opens on Chicago’s West Side">New Public Park Opens on Chicago’s West Side</a></h2>
        <p class="popular-desc">Chicago city officials opened a new 12-acre community park with playgrounds, walking paths, and green space for families in the area.</p>
        <p class="popular-meta">IN <span class="popular-cat">LOCAL NEWS</span> BY <span class="popular-author">SAMUEL FOSTER</span> NOVEMBER 9, 2025</p>
      </div>

      <div class="popular-right">

        <div class="popular-right-item">
          <div class="right-text">
            <h2 class="popular-title"><a href="local/los-angeles-schools-add-after-school-tutoring.php" title="Los Angeles Schools Add After-School Tutoring">Los Angeles Schools Add After-School Tutoring to Boost Reading Levels</a></h2>
            <p class="popular-desc">LAUSD expanded after-school tutoring programs to support students struggling with reading and math.</p>
            <p class="popular-meta"><span class="popular-cat">LOCAL NEWS</span> BY <span class="popular-author">SAMUEL FOSTER</span> NOVEMBER 8, 2025</p>
          </div>
          <div class="right-img2"><img loading="lazy" src="images/los-angeles-schools-add-after-school-tutoring.webp" alt="LA Schools Tutoring"></div>
        </div>

        <div class="divider"></div>

        <div class="popular-right-item">
          <div class="right-text">
            <h2 class="popular-title"><a href="local/the-big-ten-gets-former-pac-12-powerhouses-oregon.php" title="The Big Ten gets former Pac-12 powerhouses">The Big Ten gets former Pac-12 powerhouses Oregon, USC, Washington, and UCLA to join them.</a></h2>
            <p class="popular-desc">Old Pac-12 teams Oregon, Washington, USC, and UCLA are getting used to the league's run-heavy style and doing well with better rushing and more balanced play a year after joining the Big Ten Conference.</p>
            <p class="popular-meta"><span class="popular-cat">LOCAL NEWS</span> BY <span class="popular-author">SAMUEL FOSTER</span> NOVEMBER 7, 2025</p>
          </div>
          <div class="right-img2"><img loading="lazy" src="images/the-big-ten-gets-former-pac-12-powerhouses-oregon.webp" alt="Big Ten Adds Former Pac-12 Teams"></div>
        </div>

      </div>
    </div>

  </div>

   <div class="featured-container">
<div class="featured-header">
  <h2 class="featured-title">Investigation News</h2>
  <a href="investigation/investigation.php" class="featured-link" title="investigation page">See All</a>
</div>

<div class="featured-grid">
  <!-- Left Large Video -->
  <div class="featured-left">
    <img loading="lazy" src="images/train-safety-failures-persist.webp" alt="Train Safety Failures Persist as Federal Oversight Struggles to Keep Up" class="featured-main-img">
    <h3 class="featured-main-title">
      <a href="investigation/train-safety-failures-persist-as-federal-oversight.php" title="Train Safety Failures Persist as Federal Oversight Struggles to Keep Up">Train Safety Failures Persist as Federal Oversight Struggles to Keep Up</a>
    </h3>
    <p class="featured-main-desc">
      A nationwide investigation finds recurring rail safety lapses as outdated equipment, staff shortages, and slow federal inspections continue into 2025.
    </p>
    <p><span class="featured-author">JANE M. CARTER</span> NOVEMBER 6, 2025</p>
  </div>

  <!-- Right Smaller Videos -->
  <div class="featured-right">
    <div class="featured-item">
      <img loading="lazy" src="images/retail-theft-rings-expand-nationwide.webp" alt="Retail Theft Rings Expand Nationwide">
      <div class="featured-item-text">
        <h4 class="featured-item-title">
          <a href="investigation/retail-theft-rings-expand-nationwide.php" title="Retail Theft Rings Expand Nationwide">Retail Theft Rings Expand Nationwide</a>
        </h4>
        <p><span class="featured-author">Jane M. Carter</span> NOVEMBER 7, 2025</p>
      </div>
    </div>

    <div class="featured-item">
      <img loading="lazy" src="images/warehouse-slowdowns-reveal-hidden.webp" alt="Warehouse Slowdowns Reveal Hidden Weakness in U.S. Supply Chains">
      <div class="featured-item-text">
        <h4 class="featured-item-title">
          <a href="investigation/warehouse-slowdowns-reveal-hidden-weakness.php" title="Warehouse Slowdowns Reveal Hidden Weakness">Warehouse Slowdowns Reveal Hidden Weakness in U.S. Supply Chains</a>
        </h4>
        <p><span class="featured-author">Jane M. Carter</span> NOVEMBER 5, 2025</p>
      </div>
    </div>

    <div class="featured-item">
      <img loading="lazy" src="images/chemical-leaks-persist-as-states.webp" alt="Chemical Leaks Persist as States Struggle to Monitor High-Risk Sites">
      <div class="featured-item-text">
        <h4 class="featured-item-title">
          <a href="investigation/chemical-leaks-persist-as-states.php" title="Chemical Leaks Persist as States Struggle to Monitor High-Risk Sites">Chemical Leaks Persist as States Struggle to Monitor High-Risk Sites</a>
        </h4>
        <p><span class="featured-author">Jane M. Carter</span> NOVEMBER 3, 2025</p>
      </div>
    </div>
  </div>
</div>

</div>





      </div>
    </div>
  </div>

</main>


  <!-- footer -->
  <?php include 'indexfooter.php'; ?>

  <!-- JS -->
  <script defer>
    const sidebar = document.getElementById('sidebar_x91');
    const openMenu = document.getElementById('openMenu_x91');
    const closeMenu = document.getElementById('closeMenu_x91');
    const overlay = document.getElementById('overlay_x91');

    openMenu.addEventListener('click', () => {
      sidebar.classList.add('active_x91');
      overlay.classList.add('show_x91');
    });

    closeMenu.addEventListener('click', () => {
      sidebar.classList.remove('active_x91');
      overlay.classList.remove('show_x91');
    });

    overlay.addEventListener('click', () => {
      sidebar.classList.remove('active_x91');
      overlay.classList.remove('show_x91');
    });
  </script>
  <script defer>
  const customMenuBtn = document.getElementById('customMenuBtn');
  const customSidebar = document.getElementById('customSidebar');

  customMenuBtn.addEventListener('click', () => {
    customSidebar.classList.toggle('custom-active');
  });
</script>

</body>
</html>