<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Authors | Progress Kingdom News</title>

    <meta name="description" content="Discover all Progress Kingdom authors covering U.S. news, politics, business, technology, investigations, sports, and local reporting across the country.">
 
    <!-- Canonical -->
    <link rel="canonical" href="https://www.progresskingdom.com/authors.php">

    <!-- Open Graph -->
    <meta property="og:title" content="Authors | Progress Kingdom News">
    <meta property="og:description" content="Meet the writers behind Progress Kingdom’s independent journalism across U.S. news, politics, business, technology, local news, and investigations.">
    <meta property="og:url" content="https://www.progresskingdom.com/authors.php">
    <meta property="og:image" content="https://www.progresskingdom.com/images/progresskingdom.webp">
    <meta property="og:site_name" content="Progress Kingdom">
    <meta property="og:locale" content="en_US">
    <meta property="og:type" content="website">

    <!-- Twitter -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Authors | Progress Kingdom News">
    <meta name="twitter:description" content="Meet the Progress Kingdom News authors responsible for quality reporting across major U.S. topics.">
    <meta name="twitter:url" content="https://www.progresskingdom.com/authors.php">
    <meta name="twitter:image" content="https://www.progresskingdom.com/images/progresskingdom.webp">
    <meta name="twitter:site" content="@progresskingdom">
    <meta name="twitter:creator" content="@progresskingdom">

    <link rel="stylesheet" href="style.css">
    
    <link rel="icon" href="images/icon.svg">

<!-- JSON-LD Structured Data -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.progresskingdom.com/authors.php#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.progresskingdom.com/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Authors",
          "item": "https://www.progresskingdom.com/authors.php"
        }
      ]
    },

    {
      "@type": "Organization",
      "@id": "https://www.progresskingdom.com/#organization",
      "name": "Progress Kingdom",
      "url": "https://www.progresskingdom.com/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.progresskingdom.com/images/logo.svg",
        "width": 512,
        "height": 512
      },
      "sameAs": [
        "https://twitter.com/progresskingdom"
      ]
    },

    {
      "@type": "WebPage",
      "@id": "https://www.progresskingdom.com/authors.php#webpage",
      "name": "Authors | Progress Kingdom News",
      "url": "https://www.progresskingdom.com/authors.php",
      "inLanguage": "en-US",
      "description": "Browse all Progress Kingdom News authors covering U.S. news, politics, business, technology, sports, investigations, and local stories.",
      "isPartOf": {
        "@id": "https://www.progresskingdom.com/#organization"
      },
      "mainEntity": {
        "@type": "ItemList",
        "name": "Progress Kingdom Authors",
        "itemListOrder": "Ascending",
        "numberOfItems": 7
      }
    }

  ]
}
</script>

</head>

<body>
   <!-- header -->
  <?php include 'indexheader.php'; ?>

  

    <main>
<!-- sixth section -->
 <div class="featured-container expose">
  <div class="featured-header categorysec">
    <div class="sgatyy">
      <a href="index.php" title="home page">Home</a>
      <a href="authors.php" title="authors">Authors</a>
    </div>
  </div>

  <?php include ('us-author.php'); ?>
    <?php include ('politices-author.php'); ?>
    <?php include ('business-author.php'); ?>
    <?php include ('technology-author.php'); ?>
    <?php include ('local-news-author.php'); ?>
    <?php include ('investigation-news-author.php'); ?>
    <?php include ('sports-author.php'); ?>
  
</div>



    </main>

      <!-- footer -->
  <?php include 'indexfooter.php'; ?>
  
  <!-- JS -->
  <script defer>
    const sidebar = document.getElementById('sidebar_x91');
    const openMenu = document.getElementById('openMenu_x91');
    const closeMenu = document.getElementById('closeMenu_x91');
    const overlay = document.getElementById('overlay_x91');

    openMenu.addEventListener('click', () => {
      sidebar.classList.add('active_x91');
      overlay.classList.add('show_x91');
    });

    closeMenu.addEventListener('click', () => {
      sidebar.classList.remove('active_x91');
      overlay.classList.remove('show_x91');
    });

    overlay.addEventListener('click', () => {
      sidebar.classList.remove('active_x91');
      overlay.classList.remove('show_x91');
    });
  </script>
  <script defer>
  const customMenuBtn = document.getElementById('customMenuBtn');
  const customSidebar = document.getElementById('customSidebar');

  customMenuBtn.addEventListener('click', () => {
    customSidebar.classList.toggle('custom-active');
  });
</script>
</body>
</html>