<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- SEO Title (55 characters exact) -->
    <title>Sam Hunter – Politics Journalist at Progress Kingdom</title>

    <!-- Meta Description (155 characters exact) -->
    <meta name="description" content="Read political coverage by Sam Hunter on Congress, Supreme Court actions, GOP and Democratic tensions, spending bills, immigration debates, and major U.S. government decisions.">

    <link rel="canonical" href="https://www.progresskingdom.com/author/sam-hunter.php">

    <!-- Open Graph -->
    <meta property="og:title" content="Sam Hunter – Politics Journalist at Progress Kingdom">
    <meta property="og:description" content="Read political coverage by Sam Hunter on Congress, Supreme Court actions, GOP and Democratic tensions, spending bills, immigration debates, and major U.S. government decisions.">
    <meta property="og:url" content="https://www.progresskingdom.com/author/sam-hunter.php">
    <meta property="og:image" content="https://www.progresskingdom.com/images/sam-hunter.webp">
    <meta property="og:site_name" content="Progress Kingdom">
    <meta property="og:locale" content="en_US">
    <meta property="og:type" content="profile">

    <!-- Twitter -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Sam Hunter – Politics Journalist at Progress Kingdom">
    <meta name="twitter:description" content="Read political coverage by Sam Hunter on Congress, Supreme Court actions, GOP and Democratic tensions, spending bills, immigration debates, and major U.S. government decisions.">
    <meta name="twitter:url" content="https://www.progresskingdom.com/author/sam-hunter.php">
    <meta name="twitter:image" content="https://www.progresskingdom.com/images/sam-hunter.webp">
    <meta name="twitter:site" content="@progresskingdom">
    <meta name="twitter:creator" content="@progresskingdom">

    <link rel="stylesheet" href="../style.css">
    <link rel="icon" href="../images/icon.svg">

<!-- JSON-LD Structured Data -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.progresskingdom.com/author/sam-hunter.php#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.progresskingdom.com/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Authors",
          "item": "https://www.progresskingdom.com/authors.php"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "name": "Sam Hunter",
          "item": "https://www.progresskingdom.com/author/sam-hunter.php"
        }
      ]
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.progresskingdom.com/#publisher",
      "name": "Progress Kingdom",
      "url": "https://www.progresskingdom.com/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.progresskingdom.com/images/logo.svg",
        "width": 512,
        "height": 512
      },
      "sameAs": [
        "https://twitter.com/progresskingdom"
      ]
    },

    {
      "@type": "Person",
      "@id": "https://www.progresskingdom.com/author/sam-hunter.php#author",
      "name": "Sam Hunter",
      "description": "Read political coverage by Sam Hunter on Congress, Supreme Court actions, GOP and Democratic tensions, spending bills, immigration debates, and major U.S. government decisions.",
      "url": "https://www.progresskingdom.com/author/sam-hunter.php",
      "image": "https://www.progresskingdom.com/images/sam-hunter.webp",
      "jobTitle": "Politics Journalist",
      "worksFor": {
        "@id": "https://www.progresskingdom.com/#publisher"
      },
      "sameAs": [
        "https://medium.com/@samhunter_9",
        "https://substack.com/@samhunter121"
      ]
    },

    {
      "@type": "WebPage",
      "@id": "https://www.progresskingdom.com/author/sam-hunter.php#webpage",
      "name": "Sam Hunter – Politics Journalist at Progress Kingdom",
      "description": "Read political coverage by Sam Hunter on Congress, Supreme Court actions, GOP and Democratic tensions, spending bills, immigration debates, and major U.S. government decisions.",
      "url": "https://www.progresskingdom.com/author/sam-hunter.php",
      "inLanguage": "en-US",
      "isPartOf": {
        "@id": "https://www.progresskingdom.com/#publisher"
      },
      "dateModified": "2025-11-10",
      "mainEntity": {
        "@id": "https://www.progresskingdom.com/author/sam-hunter.php#author"
      }
    },

    {
      "@type": "ItemList",
      "@id": "https://www.progresskingdom.com/author/sam-hunter.php#articles",
      "name": "Articles by Sam Hunter",
      "itemListOrder": "Descending",
      "itemListElement": [

        {
          "@type": "ListItem",
          "position": 1,
          "url": "https://www.progresskingdom.com/politics/kevin-mcCarthy-ousted-as-house-speaker.php"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "url": "https://www.progresskingdom.com/politics/democrats-are-facing-a-growing-grassroots-uprising.php"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "url": "https://www.progresskingdom.com/politics/the-supreme-court-will-not-hear-trump-caseon-tariffs.php"
        },
        {
          "@type": "ListItem",
          "position": 4,
          "url": "https://www.progresskingdom.com/politics/u-s-senate-blocks-border-Ukraine-Israel-aid-package.php"
        },
        {
          "@type": "ListItem",
          "position": 5,
          "url": "https://www.progresskingdom.com/politics/congress-passes-temporary-spending-bill.php"
        }

      ]
    }

  ]
}
</script>

</head>

<body>
   <!-- header -->
  <?php include '../header.php'; ?>

  

    <main>
<!-- sixth section -->
 <div class="featured-container expose">
  <div class="featured-header categorysec">
    <div class="sgatyy">
        <a href="../index.php" title="home page">Home</a>
        <a href="../authors.php" title="authors">Authors</a>
        <a href="../author/sam-hunter.php" title="sam hunter">Sam Hunter</a>
    </div>
    
  </div>
<!-- AUTHOR SECTION -->
    <?php include ('../authorss/politices-author.php'); ?>
 <div class="featured-grid">
  
    <!-- Left Large Video -->
    <div class="featured-left">
   <div class="">
       <img src="../images/kevin-mccarthy-ousted.webp" alt="Kevin McCarthy Ousted as House Speaker in Historic Vote" class="featured-main-img">
      <h2 class="featured-main-title"><a href="../politics/kevin-mcCarthy-ousted-as-house-speaker.php" title="Kevin McCarthy Ousted as House Speaker in Historic Vote">Kevin McCarthy Ousted as House Speaker in Historic Vote</a></h2>
      <p class="featured-main-desc">
        The House kicked out its speaker for the first time in American history after a GOP mutiny joined Democrats in a historic and dramatic vote.
    </p>
   </div>
  <div class="maryy2">
        <img loading="lazy" src="../images/democrats-are-facing-a-growing-grassroots-uprising.webp" alt="Democrats are facing a growing grassroots" class="featured-main-img">
      <h2 class="featured-main-title"><a href="../politics/democrats-are-facing-a-growing-grassroots-uprising.php" title="Democrats are facing a growing grassroots uprising one year after Trump came back to power">Democrats are facing a growing grassroots uprising one year after Trump came back to power.</a></h2>
      <p class="featured-main-desc">
        As complaints from inside the party grow after Trump's reelection, younger voters and progressive groups are pushing Democratic leaders to work toward affordable housing, fairer economics, and big changes.
    </p>
  </div>
   <div class="maryy2">
        <img loading="lazy" src="../images/the-supreme-court-will-not-hear-trump-case-about-tariffs.webp" alt="The Supreme Court will not hear Trump's case about tariffs" class="featured-main-img">
      <h2 class="featured-main-title"><a href="../politics/the-supreme-court-will-not-hear-trump-caseon-tariffs.php" title="The Supreme Court will not hear Trump's case about tariffs. But his Secretary of the Treasury will be there">The Supreme Court will not hear Trump's case about tariffs. But his Secretary of the Treasury will be there.</a></h2>
      <p class="featured-main-desc">
        Scott Bessent, the Secretary of the Treasury, is going to the Supreme Court to see if the president can use emergency economic powers to impose big tariffs.
    </p>
  </div>
   <div class="maryy2">
        <img loading="lazy" src="../images/u-s-senate-blocks-border-ukraine-israel-aid.webp" alt="U.S. Senate Blocks Border-Ukraine-Israel Aid Package" class="featured-main-img">
      <h2 class="featured-main-title"><a href="../politics/u-s-senate-blocks-border-ukraine-israel-aid-package.php" title="U.S. Senate Blocks Border-Ukraine-Israel Aid Package">U.S. Senate Blocks Border-Ukraine-Israel Aid Package</a></h2>
      <p class="featured-main-desc">
       A major Senate package linking border security funding with Ukraine and Israel aid failed to move forward after Republicans and Democrats remained divided over immigration provisions.
    </p>
  </div>
  <div class="maryy2">
        <img loading="lazy" src="../images/congress-passes-temporary-spending-bill.webp" alt="Congress Passes Temporary Spending Bill" class="featured-main-img">
      <h2 class="featured-main-title"><a href="../politics/congress-passes-temporary-spending-bill.php" title="Congress Passes Temporary Spending Bill to Avoid Early 2025 Shutdown">Congress Passes Temporary Spending Bill to Avoid Early 2025 Shutdown</a></h2>
      <p class="featured-main-desc">
       Lawmakers approved a stopgap bill to keep the government funded into March, avoiding an immediate shutdown.
    </p>
  </div>
 
    </div>


  </div>
</div>




      


    </main>

      <!-- footer -->
  <?php include '../footer.php'; ?>
  
  <!-- JS -->
  <script defer>
    const sidebar = document.getElementById('sidebar_x91');
    const openMenu = document.getElementById('openMenu_x91');
    const closeMenu = document.getElementById('closeMenu_x91');
    const overlay = document.getElementById('overlay_x91');

    openMenu.addEventListener('click', () => {
      sidebar.classList.add('active_x91');
      overlay.classList.add('show_x91');
    });

    closeMenu.addEventListener('click', () => {
      sidebar.classList.remove('active_x91');
      overlay.classList.remove('show_x91');
    });

    overlay.addEventListener('click', () => {
      sidebar.classList.remove('active_x91');
      overlay.classList.remove('show_x91');
    });
  </script>
  <script defer>
  const customMenuBtn = document.getElementById('customMenuBtn');
  const customSidebar = document.getElementById('customSidebar');

  customMenuBtn.addEventListener('click', () => {
    customSidebar.classList.toggle('custom-active');
  });
</script>
</body>
</html>