<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- SEO Title (55 characters exact) -->
    <title>Riley Carter – Business Journalist at Progress Kingdom</title>

    <!-- Meta Description (155 characters exact) -->
    <meta name="description" content="Read business reports by Riley Carter covering supply chains, retail trends, global investments, tariffs, corporate strategy, market shifts, and major economic developments nationwide.">

    <link rel="canonical" href="https://www.progresskingdom.com/author/riley-carter.php">

    <!-- Open Graph -->
    <meta property="og:title" content="Riley Carter – Business Journalist at Progress Kingdom">
    <meta property="og:description" content="Read business reports by Riley Carter covering supply chains, retail trends, global investments, tariffs, corporate strategy, market shifts, and major economic developments nationwide.">
    <meta property="og:url" content="https://www.progresskingdom.com/author/riley-carter.php">
    <meta property="og:image" content="https://www.progresskingdom.com/images/riley-carter.webp">
    <meta property="og:site_name" content="Progress Kingdom">
    <meta property="og:locale" content="en_US">
    <meta property="og:type" content="profile">

    <!-- Twitter -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Riley Carter – Business Journalist at Progress Kingdom">
    <meta name="twitter:description" content="Read business reports by Riley Carter covering supply chains, retail trends, global investments, tariffs, corporate strategy, market shifts, and major economic developments nationwide.">
    <meta name="twitter:url" content="https://www.progresskingdom.com/author/riley-carter.php">
    <meta name="twitter:image" content="https://www.progresskingdom.com/images/riley-carter.webp">
    <meta name="twitter:site" content="@progresskingdom">
    <meta name="twitter:creator" content="@progresskingdom">

    <link rel="stylesheet" href="../style.css">
    <link rel="icon" href="../images/icon.svg">

<!-- JSON-LD Structured Data -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.progresskingdom.com/author/riley-carter.php#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.progresskingdom.com/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Authors",
          "item": "https://www.progresskingdom.com/authors.php"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "name": "Riley Carter",
          "item": "https://www.progresskingdom.com/author/riley-carter.php"
        }
      ]
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.progresskingdom.com/#publisher",
      "name": "Progress Kingdom",
      "url": "https://www.progresskingdom.com/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.progresskingdom.com/images/logo.svg",
        "width": 512,
        "height": 512
      },
      "sameAs": [
        "https://twitter.com/progresskingdom"
      ]
    },

    {
      "@type": "Person",
      "@id": "https://www.progresskingdom.com/author/riley-carter.php#author",
      "name": "Riley Carter",
      "description": "Read business reports by Riley Carter covering supply chains, retail trends, global investments, tariffs, corporate strategy, market shifts, and major economic developments nationwide.",
      "url": "https://www.progresskingdom.com/author/riley-carter.php",
      "image": "https://www.progresskingdom.com/images/riley-carter.webp",
      "jobTitle": "Business Journalist",
      "worksFor": {
        "@id": "https://www.progresskingdom.com/#publisher"
      },
      "sameAs": [
        "https://medium.com/@rileycarter_",
        "https://substack.com/@rielycarter"
      ]
    },

    {
      "@type": "WebPage",
      "@id": "https://www.progresskingdom.com/author/riley-carter.php#webpage",
      "name": "Riley Carter – Business Journalist at Progress Kingdom",
      "description": "Read business reports by Riley Carter covering supply chains, retail trends, global investments, tariffs, corporate strategy, market shifts, and major economic developments nationwide.",
      "url": "https://www.progresskingdom.com/author/riley-carter.php",
      "inLanguage": "en-US",
      "isPartOf": {
        "@id": "https://www.progresskingdom.com/#publisher"
      },
      "dateModified": "2025-11-10",
      "mainEntity": {
        "@id": "https://www.progresskingdom.com/author/riley-carter.php#author"
      }
    },

    {
      "@type": "ItemList",
      "@id": "https://www.progresskingdom.com/author/riley-carter.php#articles",
      "name": "Articles by Riley Carter",
      "itemListOrder": "Descending",
      "itemListElement": [

        {
          "@type": "ListItem",
          "position": 1,
          "url": "https://www.progresskingdom.com/business/funding-standoff-forces-flight-cuts.php"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "url": "https://www.progresskingdom.com/business/u-s-retailers-expect-record-holiday-sales.php"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "url": "https://www.progresskingdom.com/business/google-unveils-major-investment-in-germany.php"
        },
        {
          "@type": "ListItem",
          "position": 4,
          "url": "https://www.progresskingdom.com/business/ubs-pauses-credit-suisse-wealth-transfers.php"
        },
        {
          "@type": "ListItem",
          "position": 5,
          "url": "https://www.progresskingdom.com/business/swiss-watch-stocks-climb-as-investors-bet.php"
        },
        {
          "@type": "ListItem",
          "position": 6,
          "url": "https://www.progresskingdom.com/business/warren-buffett-says-age-is-catching-up.php"
        }

      ]
    }

  ]
}
</script>

</head>

<body>
   <!-- header -->
  <?php include '../header.php'; ?>

  

    <main>
<!-- sixth section -->
 <div class="featured-container expose">
  <div class="featured-header categorysec">
    <div class="sgatyy">
        <a href="../index.php" title="home page">Home</a>
        <a href="../authors.php" title="authors">Authors</a>
        <a href="../author/riley-carter.php" title="riley carter">Riley Carter</a>
    </div>
    
  </div>
<!-- AUTHOR SECTION -->
    <?php include ('../authorss/business-author.php'); ?>
 <div class="featured-grid">
  
    <!-- Left Large Video -->
    <div class="featured-left">
   <div class="">
       <img src="../images/funding-standoff-forces-flight-cuts.webp" alt="Funding Standoff Forces Flight Cuts, Straining U.S. Supply Chain" class="featured-main-img">
      <h2 class="featured-main-title"><a href="../business/funding-standoff-forces-flight-cuts.php" title="Funding Standoff Forces Flight Cuts, Straining U.S. Supply Chain">Funding Standoff Forces Flight Cuts, Straining U.S. Supply Chain</a></h2>
      <p class="featured-main-desc">
       Officials say that the U.S. supply chain is already weak because of labor shortages and delayed shipments, and it is now even more strained because of federal job shortages that have led to fewer flights at airports.
        </p>
   </div>
  <div class="maryy2">
        <img loading="lazy" src="../images/u-s-retailers-expect-record-holiday-sales.webp" alt="U.S. Retailers Expect Record Holiday Sales" class="featured-main-img">
      <h2 class="featured-main-title"><a href="../business/u-s-retailers-expect-record-holiday-sales.php" title="U.S. Retailers Expect Record Holiday Sales as NRF Forecasts First-Ever $1 Trillion Season">U.S. Retailers Expect Record Holiday Sales as NRF Forecasts First-Ever $1 Trillion Season</a></h2>
      <p class="featured-main-desc">
        The National Retail Federation says that holiday sales will reach a record $1 trillion this year because eager shoppers are taking advantage of early discounts and strong consumer demand.
        </p>
  </div>
   <div class="maryy2">
        <img loading="lazy" src="../images/google-unveils-major-investment-in-germany.webp" alt="Google Unveils Major Investment in Germany" class="featured-main-img">
      <h2 class="featured-main-title"><a href="../business/google-unveils-major-investment-in-germany.php" title="Google Unveils Major Investment in Germany: Data Centers & Renewable Energy">Google Unveils Major Investment in Germany: Data Centers & Renewable Energy</a></h2>
      <p class="featured-main-desc">
        Google LLC is about to announce its biggest investment in Germany to date. It will focus on data centers, infrastructure, and renewable energy projects.
        </p>
  </div>
   <div class="maryy2">
        <img loading="lazy" src="../images/ubs-pauses-credit-suisse-wealth-transfers.webp" alt="UBS Pauses Credit Suisse Wealth" class="featured-main-img">
      <h2 class="featured-main-title"><a href="../business/ubs-pauses-credit-suisse-wealth-transfers.php" title="UBS Pauses Credit Suisse Wealth Transfers Amid Integration Challenges">UBS Pauses Credit Suisse Wealth Transfers Amid Integration Challenges</a></h2>
      <p class="featured-main-desc">
      Financial insiders who know what's going on say that UBS has put off moving some very wealthy Credit Suisse customers to its platform because of problems with technology and management.</p>
  </div>
  <div class="maryy2">
        <img loading="lazy" src="../images/swiss-watch-stocks-climb.webp" alt="Swiss Watch Stocks Climb as Investors Bet on Softer U.S. Tariff Policy" class="featured-main-img">
      <h2 class="featured-main-title"><a href="../business/swiss-watch-stocks-climb-as-investors-bet.php" title="Swiss Watch Stocks Climb as Investors Bet on Softer U.S. Tariff Policy">Swiss Watch Stocks Climb as Investors Bet on Softer U.S. Tariff Policy</a></h2>
      <p class="featured-main-desc">
       The stock prices of major Swiss watchmakers went up as investors became more optimistic that the US might lower some import taxes, which would ease the pressure on luxury exports.
    </p>
  </div>
  <div class="maryy2">
        <img loading="lazy" src="../images/warren-buffett-says-age-is-catching-up.webp" alt="Warren Buffett Says Age Is Catching Up Berkshire’s Next CEO" class="featured-main-img">
      <h2 class="featured-main-title"><a href="../business/warren-buffett-says-age-is-catching-up.php" title="Warren Buffett Says Age Is Catching Up but Reaffirms Confidence in Berkshire’s Next CEO">Warren Buffett Says Age Is Catching Up but Reaffirms Confidence in Berkshire’s Next CEO</a></h2>
      <p class="featured-main-desc">
       Warren Buffett, who is 95 years old, told shareholders that "Father Time" is now catching up with him as he gets ready to leave his job as CEO of Berkshire Hathaway in January. He did say, though, that Greg Abel is more than qualified to lead the company.
     </p>
  </div>
 
    </div>


  </div>
</div>




      


    </main>

      <!-- footer -->
  <?php include '../footer.php'; ?>
  
  <!-- JS -->
  <script defer>
    const sidebar = document.getElementById('sidebar_x91');
    const openMenu = document.getElementById('openMenu_x91');
    const closeMenu = document.getElementById('closeMenu_x91');
    const overlay = document.getElementById('overlay_x91');

    openMenu.addEventListener('click', () => {
      sidebar.classList.add('active_x91');
      overlay.classList.add('show_x91');
    });

    closeMenu.addEventListener('click', () => {
      sidebar.classList.remove('active_x91');
      overlay.classList.remove('show_x91');
    });

    overlay.addEventListener('click', () => {
      sidebar.classList.remove('active_x91');
      overlay.classList.remove('show_x91');
    });
  </script>
  <script defer>
  const customMenuBtn = document.getElementById('customMenuBtn');
  const customSidebar = document.getElementById('customSidebar');

  customMenuBtn.addEventListener('click', () => {
    customSidebar.classList.toggle('custom-active');
  });
</script>
</body>
</html>