<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- SEO Title (55 characters exact) -->
    <title>Jane M Carter – Investigative Journalist at Progress Kingdom</title>

    <!-- Meta Description (155 characters exact) -->
    <meta name="description" content="Read investigative reports by Jane M Carter covering rail safety, retail crime rings, warehouse failures, chemical leak oversight issues, and nationwide regulatory breakdowns.">

    <link rel="canonical" href="https://www.progresskingdom.com/author/jane-m-carter.php">

    <!-- Open Graph -->
    <meta property="og:title" content="Jane M Carter – Investigative Journalist at Progress Kingdom">
    <meta property="og:description" content="Read investigative reports by Jane M Carter covering rail safety, retail crime rings, warehouse failures, chemical leak oversight issues, and nationwide regulatory breakdowns.">
    <meta property="og:url" content="https://www.progresskingdom.com/author/jane-m-carter.php">
    <meta property="og:image" content="https://www.progresskingdom.com/images/jane-m-carter.webp">
    <meta property="og:site_name" content="Progress Kingdom">
    <meta property="og:locale" content="en_US">
    <meta property="og:type" content="profile">

    <!-- Twitter -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Jane M Carter – Investigative Journalist at Progress Kingdom">
    <meta name="twitter:description" content="Read investigative reports by Jane M Carter covering rail safety, retail crime rings, warehouse failures, chemical leak oversight issues, and nationwide regulatory breakdowns.">
    <meta name="twitter:url" content="https://www.progresskingdom.com/author/jane-m-carter.php">
    <meta name="twitter:image" content="https://www.progresskingdom.com/images/jane-m-carter.webp">
    <meta name="twitter:site" content="@progresskingdom">
    <meta name="twitter:creator" content="@progresskingdom">

    <link rel="stylesheet" href="../style.css">
    <link rel="icon" href="../images/icon.svg">

<!-- JSON-LD Structured Data -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.progresskingdom.com/author/jane-m-carter.php#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.progresskingdom.com/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Authors",
          "item": "https://www.progresskingdom.com/authors.php"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "name": "Jane M Carter",
          "item": "https://www.progresskingdom.com/author/jane-m-carter.php"
        }
      ]
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.progresskingdom.com/#publisher",
      "name": "Progress Kingdom",
      "url": "https://www.progresskingdom.com/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.progresskingdom.com/images/logo.svg",
        "width": 512,
        "height": 512
      },
      "sameAs": [
        "https://twitter.com/progresskingdom"
      ]
    },

    {
      "@type": "Person",
      "@id": "https://www.progresskingdom.com/author/jane-m-carter.php#author",
      "name": "Jane M Carter",
      "description": "Read investigative reports by Jane M Carter covering rail safety, retail crime rings, warehouse failures, chemical leak oversight issues, and nationwide regulatory breakdowns.",
      "url": "https://www.progresskingdom.com/author/jane-m-carter.php",
      "image": "https://www.progresskingdom.com/images/jane-m-carter.webp",
      "jobTitle": "Investigative Reporter",
      "worksFor": {
        "@id": "https://www.progresskingdom.com/#publisher"
      },
      "sameAs": [
        "https://medium.com/@janemcarter_",
        "https://substack.com/@janemcarter929",
        "https://www.instagram.com/janemcarter_/"
      ]
    },

    {
      "@type": "WebPage",
      "@id": "https://www.progresskingdom.com/author/jane-m-carter.php#webpage",
      "name": "Jane M Carter – Investigative Journalist at Progress Kingdom",
      "description": "Read investigative reports by Jane M Carter covering rail safety, retail crime rings, warehouse failures, chemical leak oversight issues, and nationwide regulatory breakdowns.",
      "url": "https://www.progresskingdom.com/author/jane-m-carter.php",
      "inLanguage": "en-US",
      "isPartOf": {
        "@id": "https://www.progresskingdom.com/#publisher"
      },
      "dateModified": "2025-11-10",
      "mainEntity": {
        "@id": "https://www.progresskingdom.com/author/jane-m-carter.php#author"
      }
    },

    {
      "@type": "ItemList",
      "@id": "https://www.progresskingdom.com/author/jane-m-carter.php#articles",
      "name": "Articles by Jane M Carter",
      "itemListOrder": "Descending",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "url": "https://www.progresskingdom.com/investigation/train-safety-failures-persist-as-federal-oversight.php"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "url": "https://www.progresskingdom.com/investigation/retail-theft-rings-expand-nationwide.php"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "url": "https://www.progresskingdom.com/investigation/warehouse-slowdowns-reveal-hidden-weakness.php"
        },
        {
          "@type": "ListItem",
          "position": 4,
          "url": "https://www.progresskingdom.com/investigation/chemical-leaks-persist-as-states.php"
        }
      ]
    }

  ]
}
</script>

</head>

<body>
   <!-- header -->
  <?php include '../header.php'; ?>

  

    <main>
<!-- sixth section -->
 <div class="featured-container expose">
  <div class="featured-header categorysec">
    <div class="sgatyy">
        <a href="../index.php" title="home page">Home</a>
        <a href="../authors.php" title="authors">Authors</a>
        <a href="../author/jane-m-carter.php" title="jane m carter">Jane M Carter</a>
    </div>
    
  </div>
<!-- AUTHOR SECTION -->
    <?php include ('../authorss/investigation-news-author.php'); ?>
 <div class="featured-grid">
  
    <!-- Left Large Video -->
    <div class="featured-left">
   <div class="">
       <img src="../images/train-safety-failures-persist.webp" alt="Train Safety Failures Persist as Federal Oversight Struggles to Keep Up" class="featured-main-img">
      <h2 class="featured-main-title"><a href="../investigation/train-safety-failures-persist-as-federal-oversight.php" title="Train Safety Failures Persist as Federal Oversight Struggles to Keep Up">Train Safety Failures Persist as Federal Oversight Struggles to Keep Up</a></h2>
      <p class="featured-main-desc">
        A nationwide investigation finds recurring rail safety lapses as outdated equipment, staff shortages, and slow federal inspections continue into 2025.
     </p>
   </div>
  <div class="maryy2">
        <img loading="lazy" src="../images/retail-theft-rings-expand-nationwide.webp" alt="Retail Theft Rings Expand Nationwide" class="featured-main-img">
      <h2 class="featured-main-title"><a href="../investigation/retail-theft-rings-expand-nationwide.php" title="Retail Theft Rings Expand Nationwide">Retail Theft Rings Expand Nationwide</a></h2>
      <p class="featured-main-desc">
        A national study found that law enforcement is having a hard time keeping up with how smart organized retail crime networks are getting.
    </p>
  </div>
   <div class="maryy2">
        <img loading="lazy" src="../images/warehouse-slowdowns-reveal-hidden.webp" alt="Warehouse Slowdowns Reveal Hidden Weakness in U.S. Supply Chains" class="featured-main-img">
      <h2 class="featured-main-title"><a href="../investigation/warehouse-slowdowns-reveal-hidden-weakness.php" title="Warehouse Slowdowns Reveal Hidden Weakness in U.S. Supply Chains">Warehouse Slowdowns Reveal Hidden Weakness in U.S. Supply Chains</a></h2>
      <p class="featured-main-desc">
        An investigation finds major U.S. warehouses facing severe staffing shortages and outdated systems, creating silent bottlenecks across national supply chains.</p>
  </div>
   <div class="maryy2">
        <img loading="lazy" src="../images/chemical-leaks-persist-as-states.webp" alt="Chemical Leaks Persist as States Struggle to Monitor High-Risk Sites" class="featured-main-img">
      <h2 class="featured-main-title"><a href="../investigation/chemical-leaks-persist-as-states.php" title="Chemical Leaks Persist as States Struggle to Monitor High-Risk Sites">Chemical Leaks Persist as States Struggle to Monitor High-Risk Sites</a></h2>
      <p class="featured-main-desc">
      A nationwide investigation finds that old industrial sites have had repeated chemical leaks and contamination events, showing that federal and state monitoring is not strong enough.
    </div>
  
 
    </div>


  </div>
</div>




      


    </main>

      <!-- footer -->
  <?php include '../footer.php'; ?>
  
  <!-- JS -->
  <script defer>
    const sidebar = document.getElementById('sidebar_x91');
    const openMenu = document.getElementById('openMenu_x91');
    const closeMenu = document.getElementById('closeMenu_x91');
    const overlay = document.getElementById('overlay_x91');

    openMenu.addEventListener('click', () => {
      sidebar.classList.add('active_x91');
      overlay.classList.add('show_x91');
    });

    closeMenu.addEventListener('click', () => {
      sidebar.classList.remove('active_x91');
      overlay.classList.remove('show_x91');
    });

    overlay.addEventListener('click', () => {
      sidebar.classList.remove('active_x91');
      overlay.classList.remove('show_x91');
    });
  </script>
  <script defer>
  const customMenuBtn = document.getElementById('customMenuBtn');
  const customSidebar = document.getElementById('customSidebar');

  customMenuBtn.addEventListener('click', () => {
    customSidebar.classList.toggle('custom-active');
  });
</script>
</body>
</html>