<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- SEO Title (55 characters exact) -->
    <title>Connor K Reeves – Sports Journalist at Progress Kingdom</title>

    <!-- Meta Description (155 characters exact) -->
    <meta name="description" content="Read the latest sports articles by Connor K Reeves, covering baseball, football, basketball, athlete performance, league updates, and in-depth sports analysis at Progress Kingdom.">

    <link rel="canonical" href="https://www.progresskingdom.com/author/connor-k-reeves.php">

    <!-- Open Graph -->
    <meta property="og:title" content="Connor K Reeves – Sports Journalist at Progress Kingdom">
    <meta property="og:description" content="Read the latest sports articles by Connor K Reeves, covering baseball, football, basketball, athlete performance, league updates, and in-depth sports analysis at Progress Kingdom.">
    <meta property="og:url" content="https://www.progresskingdom.com/author/connor-k-reeves.php">
    <meta property="og:image" content="https://www.progresskingdom.com/images/connor-k-reeves.webp">
    <meta property="og:site_name" content="Progress Kingdom">
    <meta property="og:locale" content="en_US">
    <meta property="og:type" content="profile">

    <!-- Twitter -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Connor K Reeves – Sports Journalist at Progress Kingdom">
    <meta name="twitter:description" content="Read the latest sports articles by Connor K Reeves, covering baseball, football, basketball, athlete performance, league updates, and in-depth sports analysis at Progress Kingdom.">
    <meta name="twitter:url" content="https://www.progresskingdom.com/author/connor-k-reeves.php">
    <meta name="twitter:image" content="https://www.progresskingdom.com/images/connor-k-reeves.webp">
    <meta name="twitter:site" content="@progresskingdom">
    <meta name="twitter:creator" content="@progresskingdom">

    <link rel="stylesheet" href="../style.css">
    <link rel="icon" href="../images/icon.svg">


<!-- JSON-LD Structured Data -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.progresskingdom.com/author/connor-k-reeves.php#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.progresskingdom.com/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Authors",
          "item": "https://www.progresskingdom.com/authors.php"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "name": "Connor K Reeves",
          "item": "https://www.progresskingdom.com/author/connor-k-reeves.php"
        }
      ]
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.progresskingdom.com/#publisher",
      "name": "Progress Kingdom",
      "url": "https://www.progresskingdom.com/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.progresskingdom.com/images/logo.svg",
        "width": 512,
        "height": 512
      },
      "sameAs": [
        "https://twitter.com/progresskingdom"
      ]
    },

    {
      "@type": "Person",
      "@id": "https://www.progresskingdom.com/author/connor-k-reeves.php#author",
      "name": "Connor K Reeves",
      "description": "Read the latest sports articles by Connor K Reeves, covering baseball, football, basketball, athlete performance, league updates, and in-depth sports analysis at Progress Kingdom.",
      "url": "https://www.progresskingdom.com/author/connor-k-reeves.php",
      "image": "https://www.progresskingdom.com/images/connor-k-reeves.webp",
      "jobTitle": "Sports Journalist",
      "worksFor": {
        "@id": "https://www.progresskingdom.com/#publisher"
      },
      "sameAs": [
        "https://x.com/conner_k_reeves",
        "https://www.instagram.com/connerkreeves/",
        "https://substack.com/@connerkreeves?",
        "https://medium.com/@connerkreeves"
      ]
    },

    {
      "@type": "WebPage",
      "@id": "https://www.progresskingdom.com/author/connor-k-reeves.php#webpage",
      "name": "Connor K Reeves – Sports Journalist at Progress Kingdom",
      "description": "Read the latest sports articles by Connor K Reeves, covering baseball, football, basketball, athlete performance, league updates, and in-depth sports analysis at Progress Kingdom.",
      "url": "https://www.progresskingdom.com/author/connor-k-reeves.php",
      "inLanguage": "en-US",
      "isPartOf": {
        "@id": "https://www.progresskingdom.com/#publisher"
      },
      "dateModified": "2025-11-10",
      "mainEntity": {
        "@id": "https://www.progresskingdom.com/author/connor-k-reeves.php#author"
      }
    },

    {
      "@type": "ItemList",
      "@id": "https://www.progresskingdom.com/author/connor-k-reeves.php#articles",
      "name": "Articles by Connor K Reeves",
      "itemListOrder": "Descending",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "url": "https://www.progresskingdom.com/sports/skenes-and-skubal-win-cy-young-awards.php"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "url": "https://www.progresskingdom.com/sports/kyren-williams-adopts-smarter-not-harder-approach.php"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "url": "https://www.progresskingdom.com/sports/the-nuggets-beat-the-clippers-who-are-short-handed.php"
        }
      ]
    }

  ]
}
</script>

</head>

<body>
   <!-- header -->
  <?php include '../header.php'; ?>

  

    <main>
<!-- sixth section -->
 <div class="featured-container expose">
  <div class="featured-header categorysec">
    <div class="sgatyy">
        <a href="../index.php" title="home page">Home</a>
        <a href="../authors.php" title="authors">Authors</a>
        <a href="../author/connor-k-reeves.php" title="connor k reeves">Connor K Reeves</a>
    </div>
    
  </div>
<!-- AUTHOR SECTION -->
    <?php include ('../authorss/sports-author.php'); ?>
 <div class="featured-grid">
  
    <!-- Left Large Video -->
    <div class="featured-left">
   <div class="">
       <img src="../images/skenes-and-skubal-win-cy-young-awards.webp" alt="Skenes and Skubal Win Cy Young Awards as Future Uncertainty Grows" class="featured-main-img">
      <h2 class="featured-main-title"><a href="../sports/skenes-and-skubal-win-cy-young-awards.php" title="Skenes and Skubal Win Cy Young Awards as Future Uncertainty Grows">Skenes and Skubal Win Cy Young Awards as Future Uncertainty Grows</a></h2>
      <p class="featured-main-desc">
       Tarik Skubal wins the AL Cy Young award and Paul Skenes wins the NL Cy Young award, but it's still unclear what the future holds for both pitchers with their teams.
    </p>
   </div>
  <div class="maryy2">
        <img loading="lazy" src="../images/kyren-williams-adopts-smarter-not-harder-approach.webp" alt="Kyren Williams Adopts Smarter Not Harder Approach" class="featured-main-img">
      <h2 class="featured-main-title"><a href="../sports/kyren-williams-adopts-smarter-not-harder-approach.php"  title="Kyren Williams Adopts ‘Smarter, Not Harder’ Approach as Rams Reshape Backfield Role">Kyren Williams Adopts ‘Smarter, Not Harder’ Approach as Rams Reshape Backfield Role</a></h2>
      <p class="featured-main-desc">
      Kyren Williams, the Rams' running back, is accepting a lighter workload as the team switches to a two-back system in order to stay fresh and keep producing.
    </p>
  </div>
   <div class="maryy2">
        <img loading="lazy" src="../images/the-nuggets-beat-the-clippers-who-are-short-handed.webp" alt="The Nuggets beat the Clippers, who are short-handed for the sixth time in a row." class="featured-main-img">
      <h2 class="featured-main-title"><a href="../sports/the-nuggets-beat-the-clippers-who-are-short-handed.php" title="The Nuggets beat the Clippers, who are short-handed, for the sixth time in a row. Jokic scores 55 points">The Nuggets beat the Clippers, who are short-handed, for the sixth time in a row. Jokic scores 55 points</a></h2>
      <p class="featured-main-desc">
      With a season-high 55 points from Denver star Nikola Jokic, the Nuggets defeated the undermanned Clippers 130-116 to win six straight games.
    </p>
  </div>
   
 
    </div>


  </div>
</div>




      


    </main>

      <!-- footer -->
  <?php include '../footer.php'; ?>
  
  <!-- JS -->
  <script defer>
    const sidebar = document.getElementById('sidebar_x91');
    const openMenu = document.getElementById('openMenu_x91');
    const closeMenu = document.getElementById('closeMenu_x91');
    const overlay = document.getElementById('overlay_x91');

    openMenu.addEventListener('click', () => {
      sidebar.classList.add('active_x91');
      overlay.classList.add('show_x91');
    });

    closeMenu.addEventListener('click', () => {
      sidebar.classList.remove('active_x91');
      overlay.classList.remove('show_x91');
    });

    overlay.addEventListener('click', () => {
      sidebar.classList.remove('active_x91');
      overlay.classList.remove('show_x91');
    });
  </script>
  <script defer>
  const customMenuBtn = document.getElementById('customMenuBtn');
  const customSidebar = document.getElementById('customSidebar');

  customMenuBtn.addEventListener('click', () => {
    customSidebar.classList.toggle('custom-active');
  });
</script>
</body>
</html>