<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- SEO Title (55 characters exact) -->
    <title>Casey Nolan – Technology Journalist at Progress Kingdom</title>

    <!-- Meta Description (155 characters exact) -->
    <meta name="description" content="Read the latest articles by Casey Nolan, a technology journalist covering AI, chipmakers, cybersecurity, and global industry trends at Progress Kingdom.">

    <link rel="canonical" href="https://www.progresskingdom.com/author/casey-nolan.php">

    <!-- Open Graph -->
    <meta property="og:title" content="Casey Nolan – Technology Journalist at Progress Kingdom">
    <meta property="og:description" content="Read the latest articles by Casey Nolan, a technology journalist covering AI, chipmakers, cybersecurity, and global industry trends at Progress Kingdom.">
    <meta property="og:url" content="https://www.progresskingdom.com/author/casey-nolan.php">
    <meta property="og:image" content="https://www.progresskingdom.com/images/casey-nolan.webp">
    <meta property="og:site_name" content="Progress Kingdom">
    <meta property="og:locale" content="en_US">
    <meta property="og:type" content="profile">

    <!-- Twitter -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Casey Nolan – Technology Journalist at Progresskingdom">
    <meta name="twitter:description" content="Read the latest articles by Casey Nolan, a technology journalist covering AI, chipmakers, cybersecurity, and global industry trends at Progress Kingdom.">
    <meta name="twitter:url" content="https://www.progresskingdom.com/author/casey-nolan.php">
    <meta name="twitter:image" content="https://www.progresskingdom.com/images/casey-nolan.webp">
    <meta name="twitter:site" content="@progresskingdom">
    <meta name="twitter:creator" content="@progresskingdom">

    <link rel="stylesheet" href="../style.css">
    <link rel="icon" href="../images/icon.svg">


<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.progresskingdom.com/author/casey-nolan.php#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.progresskingdom.com/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Authors",
          "item": "https://www.progresskingdom.com/authors.php"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "name": "Casey Nolan",
          "item": "https://www.progresskingdom.com/author/casey-nolan.php"
        }
      ]
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.progresskingdom.com/#publisher",
      "name": "Progress Kingdom",
      "url": "https://www.progresskingdom.com/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.progresskingdom.com/images/logo.svg",
        "width": 512,
        "height": 512
      },
      "sameAs": [
        "https://twitter.com/progresskingdom"
      ]
    },

    {
      "@type": "Person",
      "@id": "https://www.progresskingdom.com/author/casey-nolan.php#author",
      "name": "Casey Nolan",
      "description": "Read the latest articles by Casey Nolan, a technology journalist covering AI, chipmakers, cybersecurity, and global industry trends at Progress Kingdom.",
      "url": "https://www.progresskingdom.com/author/casey-nolan.php",
      "image": "https://www.progresskingdom.com/images/casey-nolan.webp",
      "jobTitle": "Technology Journalist",
      "worksFor": {
        "@id": "https://www.progresskingdom.com/#publisher"
      },
      "sameAs": [
        "https://x.com/casey_nolan_",
        https://www.instagram.com/_casey_nolan/,
        "https://substack.com/@caseynolan3?",
        "https://medium.com/@caseynolan_61243"
      ]
    },

    {
      "@type": "WebPage",
      "@id": "https://www.progresskingdom.com/author/casey-nolan.php#webpage",
      "name": "Casey Nolan – Technology Journalist at Progress Kingdom",
      "description": "Read the latest articles by Casey Nolan, a technology journalist covering AI, chipmakers, cybersecurity, and global industry trends at Progress Kingdom.",
      "url": "https://www.progresskingdom.com/author/casey-nolan.php",
      "isPartOf": {
        "@id": "https://www.progresskingdom.com/#publisher"
      },
      "inLanguage": "en-US",
      "dateModified": "2025-11-10",
      "mainEntity": {
        "@id": "https://www.progresskingdom.com/author/casey-nolan.php#author"
      }
    },

    {
      "@type": "ItemList",
      "@id": "https://www.progresskingdom.com/author/casey-nolan.php#articles",
      "name": "Articles by Casey Nolan",
      "itemListOrder": "Descending",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "url": "https://www.progresskingdom.com/technology/nexperia-crisis-affects-the-chipmaker-industry.php"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "url": "https://www.progresskingdom.com/technology/softbank-sells-nvidia-stake-shifts-to-openai.php"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "url": "https://www.progresskingdom.com/technology/watchdog-group-urges-openai-to-pull-sora-2-app.php"
        }
      ]
    }

  ]
}
</script>

</head>

<body>
   <!-- header -->
  <?php include '../header.php'; ?>

  

    <main>
<!-- sixth section -->
 <div class="featured-container expose">
  <div class="featured-header categorysec">
    <div class="sgatyy">
        <a href="../index.php" title="home page">Home</a>
        <a href="../authors.php" title="authors">Authors</a>
        <a href="../author/casey-nolan.php" title="casey nolan">Casey Nolan</a>
    </div>
    
  </div>
<!-- AUTHOR SECTION -->
    <?php include ('../authorss/technology-author.php'); ?>
 <div class="featured-grid">
  
    <!-- Left Large Video -->
    <div class="featured-left">
   <div class="">
       <img src="../images/nexperia-crisis-affects-the-chipmaker-industry.webp" alt="Nexperia Crisis Affects the Chipmaker Industry, Leading to Auto Shutdowns" class="featured-main-img">
      <h2 class="featured-main-title"><a href="../technology/nexperia-crisis-affects-the-chipmaker-industry.php" title="Nexperia Crisis Affects the Chipmaker Industry, Leading to Auto Shutdowns">Nexperia Crisis Affects the Chipmaker Industry, Leading to Auto Shutdowns</a></h2>
      <p class="featured-main-desc">
       A fight over leadership at Nexperia, a Dutch chipmaker owned by China, has messed up car supply chains all over the world and forced Honda to stop making cars at a key plant in Mexico.
      </p>
   </div>
  <div class="maryy2">
        <img loading="lazy" src="../images/softbank-sells-nvidia-stake-shifts-to-openai.webp" alt="SoftBank Sells Nvidia Stake for $5.8B, Shifts Focus to OpenAI" class="featured-main-img">
      <h2 class="featured-main-title"><a href="../technology/softbank-sells-nvidia-stake-shifts-to-openai.php"  title="SoftBank Sells Nvidia Stake for $5.8 Billion as It Shifts Investment Focus to OpenAI">SoftBank Sells Nvidia Stake for $5.8 Billion as It Shifts Investment Focus to OpenAI</a></h2>
      <p class="featured-main-desc">
       SoftBank made a lot more money in the first half of its fiscal year after selling its entire stake in Nvidia for $5.8 billion. This was part of a strategic shift toward OpenAI.
       </p>
  </div>
   <div class="maryy2">
        <img loading="lazy" src="../images/watchdog-group-urges-openai-to-pull-sora-2-app.webp" alt="Watchdog Group Urges OpenAI to Pull Sora 2 App" class="featured-main-img">
      <h2 class="featured-main-title"><a href="../technology/watchdog-group-urges-openai-to-pull-sora-2-app.php" title="Watchdog Group Urges OpenAI to Pull Sora 2 App">Watchdog Group Urges OpenAI to Pull Sora 2 App</a></h2>
      <p class="featured-main-desc">
       Public Citizen told OpenAI to take down their Sora 2 video program because they were worried that the AI-powered app would violate people's rights to their likeness, spread deepfakes online, and endanger democracy.
      </p>
  </div>
   
 
    </div>


  </div>
</div>




      


    </main>

      <!-- footer -->
  <?php include '../footer.php'; ?>
  
  <!-- JS -->
  <script defer>
    const sidebar = document.getElementById('sidebar_x91');
    const openMenu = document.getElementById('openMenu_x91');
    const closeMenu = document.getElementById('closeMenu_x91');
    const overlay = document.getElementById('overlay_x91');

    openMenu.addEventListener('click', () => {
      sidebar.classList.add('active_x91');
      overlay.classList.add('show_x91');
    });

    closeMenu.addEventListener('click', () => {
      sidebar.classList.remove('active_x91');
      overlay.classList.remove('show_x91');
    });

    overlay.addEventListener('click', () => {
      sidebar.classList.remove('active_x91');
      overlay.classList.remove('show_x91');
    });
  </script>
  <script defer>
  const customMenuBtn = document.getElementById('customMenuBtn');
  const customSidebar = document.getElementById('customSidebar');

  customMenuBtn.addEventListener('click', () => {
    customSidebar.classList.toggle('custom-active');
  });
</script>
</body>
</html>