<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>About | Progress Kingdom News</title>

    <meta name="description" content="Progress Kingdom delivers accurate, ethical journalism across politics, business, technology, sports, and community news with a commitment to public interest.">

    <!-- Canonical -->
    <link rel="canonical" href="https://www.progresskingdom.com/about.php">

    <!-- Open Graph -->
    <meta property="og:title" content="About | Progress Kingdom News">
    <meta property="og:description" content="Progress Kingdom delivers accurate, ethical journalism across politics, business, technology, sports, and community news with a commitment to public interest.">
    <meta property="og:url" content="https://www.progresskingdom.com/about.php">
    <meta property="og:image" content="https://www.progresskingdom.com/images/progresskingdom.webp">
    <meta property="og:site_name" content="Progress Kingdom">
    <meta property="og:locale" content="en_US">
    <meta property="og:type" content="website">

    <!-- Twitter -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="About | Progress Kingdom News">
    <meta name="twitter:description" content="Progress Kingdom delivers accurate, ethical journalism across politics, business, technology, sports, and community news with a commitment to public interest.">
    <meta name="twitter:url" content="https://www.progresskingdom.com/about.php">
    <meta name="twitter:image" content="https://www.progresskingdom.com/images/progresskingdom.webp">
    <meta name="twitter:site" content="@progresskingdom">
    <meta name="twitter:creator" content="@progresskingdom">

    <link rel="stylesheet" href="style.css">
    
    <link rel="icon" href="images/icon.svg">

<!-- JSON-LD Structured Data -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.progresskingdom.com/about.php#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.progresskingdom.com/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "About",
          "item": "https://www.progresskingdom.com/about.php"
        }
      ]
    },

    {
      "@type": "Organization",
      "@id": "https://www.progresskingdom.com/#organization",
      "name": "Progress Kingdom",
      "url": "https://www.progresskingdom.com/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.progresskingdom.com/images/logo.svg",
        "width": 512,
        "height": 512
      },
      "description": "Progress Kingdom is an independent newsroom delivering accurate, ethical journalism across politics, business, technology, sports, and local community news.",
      "sameAs": [
        "https://twitter.com/progresskingdom"
      ]
    },

    {
      "@type": "WebPage",
      "@id": "https://www.progresskingdom.com/about.php#webpage",
      "name": "About | Progress Kingdom News",
      "url": "https://www.progresskingdom.com/about.php",
      "inLanguage": "en-US",
      "description": "Progress Kingdom delivers accurate, ethical journalism across politics, business, technology, sports, and community news with a commitment to public interest.",
      "isPartOf": {
        "@id": "https://www.progresskingdom.com/#organization"
      },
      "mainEntity": {
        "@id": "https://www.progresskingdom.com/#organization"
      }
    }

  ]
}
</script>

</head>

<body>
 
<!-- nav bar -->
 <?php include 'indexheader.php'; ?>

    <main>
<!-- sixth section -->
 <div class="featured-container expose">
  <div class="featured-header categorysec">

      <h2 class="featured-main-title">About</h2>
    
  </div>

  <div class="featured-grid">
    
    <!-- Left Large Video -->
    <div class="featured-left">
      <h2 class="featured-main-title">Progress Kingdom</h2>
          <p class="featured-main-desc">
       We do fair and accurate reporting in our newsroom, which lets us do high-quality journalism in the US and around the world. We report on politics, business, technology, sports, and community news in a way that is accurate, responsible, and in the public interest.
      </p>
      <br>
      <p class="featured-main-desc">
        Our reporters and editors come from a variety of backgrounds and want to help readers understand the problems they face in their lives. Every article has to go through fact-checking, source verification, and ethical reporting steps.
      </p>
      <br>
      <img src="images/progresskingdom.webp" alt="progresskingdom" class="featured-main-img">
      <br>
      <p class="featured-main-desc">
        We believe that journalism should:
      </p>
      <br>
      <p class="featured-main-desc">
        Give the public clear and relevant information
      </p>
      <p class="featured-main-desc">
        Hold those in power accountable
      </p>
      <p class="featured-main-desc">
        Bring attention to underreported topics and communities
      </p>
      <p class="featured-main-desc">
        Encourage critical debate and civic participation
      </p>
       <br>
       <p class="featured-main-desc">
        As an independent digital news source, we value honesty and openness. We want to earn your trust by giving you breaking news, investigative reporting, and long-form commentary.
      </p>
      <br>
      <p class="featured-main-desc">
        We appreciate that you read and support our work.
      </p>
      
      
      
          <!-- COMMENT SECTION -->
    <div class="commentArea_x91 fwloey">
      <h2 class="featured-main-title">Contact Us</h2>
      <form class="commentForm_x91" action="contact-submit.php" method="post">
        <div class="commentRow_x91">
          <input type="text" placeholder="Enter Name" required />
          <input type="email" placeholder="Enter Email" required />
        </div>
        <input type="text" placeholder="Enter Website" />
        <textarea rows="6" placeholder="Enter Comments"></textarea>
        <button type="submit" class="commentButton_x91">Post Comment</button>
      </form>
    </div>
    </div>


</div>

  </div>
</div>



    </main>

      <!-- footer -->
  <?php include 'indexfooter.php'; ?>
 
  <!-- JS -->
  <script defer>
    const sidebar = document.getElementById('sidebar_x91');
    const openMenu = document.getElementById('openMenu_x91');
    const closeMenu = document.getElementById('closeMenu_x91');
    const overlay = document.getElementById('overlay_x91');

    openMenu.addEventListener('click', () => {
      sidebar.classList.add('active_x91');
      overlay.classList.add('show_x91');
    });

    closeMenu.addEventListener('click', () => {
      sidebar.classList.remove('active_x91');
      overlay.classList.remove('show_x91');
    });

    overlay.addEventListener('click', () => {
      sidebar.classList.remove('active_x91');
      overlay.classList.remove('show_x91');
    });
  </script>
  <script defer>
  const customMenuBtn = document.getElementById('customMenuBtn');
  const customSidebar = document.getElementById('customSidebar');

  customMenuBtn.addEventListener('click', () => {
    customSidebar.classList.toggle('custom-active');
  });
</script>
</body>
</html>