<!DOCTYPE html>
<html lang="en">


<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- SEO -->
    <title>Bulgaria Government Resigns After Mass Anti-Corruption Protests</title>
    <meta name="title" content="Bulgaria Government Resigns After Mass Anti-Corruption Protests">
    <meta name="description"
        content="Bulgaria’s government has resigned following weeks of mass anti-corruption protests, deepening political instability as the country prepares to join the eurozone.">

    <!-- Canonical -->
    <link rel="canonical" href="https://www.morenews.org/world/amid-widespread-anti-corruption-demonstrations-bulgarias-government-resigns">

    <meta name="author" content="Sophie Caldwell">
    <!-- Open Graph -->
    <meta property="og:title" content="Bulgaria Government Resigns After Mass Anti-Corruption Protests">
    <meta property="og:description"
        content="Bulgaria’s government has resigned following weeks of mass anti-corruption protests, deepening political instability as the country prepares to join the eurozone.">
    <meta property="og:url" content="https://www.morenews.org/world/amid-widespread-anti-corruption-demonstrations-bulgarias-government-resigns">
    <meta property="og:image" content="https://www.morenews.org/images/amid-widespread-anti-corruption-demonstrations-bulgarias-government-resigns-first-image.webp">
    <meta property="og:site_name" content="More News">
    <meta property="og:type" content="article">
    <meta property="og:locale" content="en_GB">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">

    <!-- Twitter -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Bulgaria Government Resigns After Mass Anti-Corruption Protests">
    <meta name="twitter:description"
        content="Bulgaria’s government has resigned following weeks of mass anti-corruption protests, deepening political instability as the country prepares to join the eurozone.">
    <meta name="twitter:image" content="https://www.morenews.org/images/amid-widespread-anti-corruption-demonstrations-bulgarias-government-resigns-first-image.webp">
    <meta name="twitter:url" content="https://www.morenews.org/world/amid-widespread-anti-corruption-demonstrations-bulgarias-government-resigns">
    <meta name="twitter:site" content="@morenews">
    <meta name="twitter:creator" content="@morenews">

    <!-- Styles -->
    <link rel="preload" href="../css/style.css" as="style">
    <link rel="stylesheet" href="../css/style.css">

    <!-- Google Fonts Optimized -->
    <link rel="preload" href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" as="style">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" rel="stylesheet">

    <!-- Font Awesome (Optimized) -->
    <link rel="preload" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css" as="style">
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css"
          media="print"
          onload="this.media='all'">
    <noscript>
        <link rel="stylesheet"
              href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
    </noscript>

    <!-- Favicon -->
    <link rel="shortcut icon" href="../favicon.ico" type="image/x-icon">

    <!-- Schema -->
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "WebSite",
      "@id": "https://www.morenews.org/#website",
      "url": "https://www.morenews.org/",
      "name": "More News"
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.morenews.org/#publisher",
      "name": "More News",
      "url": "https://www.morenews.org/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/logo.webp",
        "width": 512,
        "height": 512
      },
      "address": {
        "@type": "PostalAddress",
        "addressCountry": "GB"
      }
    },

    {
      "@type": "Person",
      "@id": "https://www.morenews.org/author/sophie-caldwell#author",
      "name": "Sophie Caldwell",
      "worksFor": {
        "@id": "https://www.morenews.org/#publisher"
      }
    },

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.morenews.org/world/amid-widespread-anti-corruption-demonstrations-bulgarias-government-resigns#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.morenews.org/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "World",
          "item": "https://www.morenews.org/world/world"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "name": "Bulgaria Government Resigns After Mass Anti-Corruption Protests",
          "item": "https://www.morenews.org/world/amid-widespread-anti-corruption-demonstrations-bulgarias-government-resigns"
        }
      ]
    },

    {
      "@type": "NewsArticle",
      "@id": "https://www.morenews.org/world/amid-widespread-anti-corruption-demonstrations-bulgarias-government-resigns#article",
      "headline": "Bulgaria Government Resigns After Mass Anti-Corruption Protests",
      "description": "Bulgaria’s government has resigned following weeks of mass anti-corruption protests, deepening political instability as the country prepares to join the eurozone.",
      "datePublished": "2025-12-13",
      "dateModified": "2025-12-13",
      "articleSection": "World",
      "inLanguage": "en-GB",
      "author": {
        "@id": "https://www.morenews.org/author/sophie-caldwell#author"
      },
      "publisher": {
        "@id": "https://www.morenews.org/#publisher"
      },
      "image": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/amid-widespread-anti-corruption-demonstrations-bulgarias-government-resigns-first-image.webp",
        "width": 1200,
        "height": 630
      },
      "mainEntityOfPage": {
        "@id": "https://www.morenews.org/world/amid-widespread-anti-corruption-demonstrations-bulgarias-government-resigns"
      }
    }

  ]
}
</script>

<style>
  /* Apply styles to center the content */
.writer-block {
    font-family: "Noto Serif JP", serif;
  max-width: 540px;
  margin: 15px auto 10px auto;
  padding: 0px 0px;
  line-height: 1.7;
  color: #222;
}

/* Additional styles for mobile and desktop responsiveness */
.writer-date,
.writer-credit {
    margin-top: 10px;
    margin-bottom: 10px;
}

/* Optional: Adjustments for mobile view */
@media screen and (max-width: 768px) {
    .writer-block {
        padding: 10px;
    }
}

</style>

</head>


<body>

<!-- header -->
<?php include '../header.php'; ?>


    <div class="main-container">
        
        <section class="headline-rail">       
        </section>
        <div class="article-header">
            <h1 class="article-headline">
               Amid widespread anti-corruption demonstrations, Bulgaria's government resigns
            </h1>

            <div class="article-breadcrumb">
                <a href="../world/world.php" title="world" class="crumb-link">World</a> ›
                <span class="crumb-current">Amid widespread anti-corruption demonstrations, Bulgaria's government resigns</span>
            </div>

            <!--socail icon-->
            <?php include '../social.php'; ?>
            <div class="writer-block">
            <div class="author-info">
                <?php include '../world-author.php'; ?>
            </div>
            <div class="writer-date" itemprop="datePublished" content="2025-12-13">Published Date: 13 December 2025</div>
            </div>
            
        </div>
        <div class="image-wrapper">
            <img src="../images/amid-widespread-anti-corruption-demonstrations-bulgarias-government-resigns-first-image.webp" alt="Amid widespread anti-corruption demonstrations Bulgarias government resigns first image">
        </div>
        <div class="writer-block">
       

            <div class="story-text-wrap">
               
                <p>
                   Bulgaria has been thrown into a fresh political crisis after Prime Minister Rosen Zhelyazkov and his centre-right government resigned on 11 December, bowing to weeks of mounting public anger over corruption and economic hardship. The decision came shortly before MPs were due to hold a no-confidence vote that analysts widely expected the government to lose — a dramatic turn of events for a country preparing to join the eurozone next year.
                </p>

                <p>
                The resignation followed some of the largest street demonstrations Bulgaria has witnessed in recent years. For much of the autumn, thousands of protesters crowded into central Sofia and rallied in towns across the country, demanding an end to entrenched graft and calling for long-promised reforms. Young people, anti-corruption activists and opposition supporters were heavily represented among the crowds, many of whom accused those in power of failing to address everyday financial pressures facing Bulgarian households.
                </p>
 
                <p>
                Critics said the government had become increasingly disconnected from voters, citing long-standing concerns over public-sector transparency and weak institutional oversight. Bulgaria’s ongoing struggles with low wages and rising living costs only fuelled frustration, with many arguing that ministers had not acted quickly or decisively enough to protect families from economic strain.
                </p>

            </div>

        </div>
        <div class="image-wrapper">
            <img loading="lazy" src="../images/amid-widespread-anti-corruption-demonstrations-bulgarias-government-resigns-second-image.webp" alt="Amid widespread anti-corruption demonstrations Bulgarias government resigns second image">
        </div>
        <div class="writer-block">

            <div class="story-text-wrap">
                <p>
                The government’s collapse comes at a particularly sensitive moment. Bulgaria — the European Union’s poorest member state — is due to adopt the euro on 1 January 2026. Officials have long portrayed the move as a crucial step towards greater economic stability and deeper integration with the EU. 
                </p>

                <p>
                He will first seek to determine whether any group of parties can form a viable coalition, although deep divisions within the fragmented parliament suggest this may be unlikely. Should talks fail, Bulgaria could face another caretaker government and possibly yet another early election — continuing a cycle of instability that has plagued national politics for several years.
                </p>
                <p>
                For many Bulgarians, the coming weeks will reveal whether political leaders can finally deliver meaningful reform or whether the latest turmoil will further erode public trust in the country’s governing institutions.
                </p>
            </div>

        </div>
        
        
        <div class="writer-block">
            
            <div class="suggested-box">
                <h3 class="suggested-heading">World</h3>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/ioc-encourages-youth-athletes-from-Belarus-and-russia-to-reintegrate-first-image.webp"
                            alt="IOC Encourages Youth Athletes from Belarus and Russia to Reintegrate first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../world/ioc-encourages-youth-athletes-from-Belarus-and-russia-to-reintegrate.php" title="IOC Encourages Youth Athletes from Belarus and Russia to Reintegrate" class="suggested-title">IOC Encourages Youth Athletes from Belarus and Russia to Reintegrate</a>
                        <span class="suggested-date">12 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/a-big-international-interpol-operation-saves-almost-30000-animals-first-image.webp"
                            alt="A big international Interpol operation saves almost 30,000 animals that were trafficked" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../world/a-big-international-interpol-operation-saves-almost-30000-animals.php"
                         title="A big international Interpol operation saves almost 30,000 animals that were trafficked." class="suggested-title">A big international Interpol operation saves almost 30,000 animals that were trafficked</a>
                        <span class="suggested-date">12 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/head-of-nato-warns-Europe-to-get-ready-for-a-potential-conflict-with-russia-first-image.webp"
                            alt="Head of NATO warns Europe to get ready for a potential conflict with Russia first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../world/head-of-nato-warns-Europe-to-get-ready-for-a-potential-conflict-with-russia.php" title="Head of NATO warns Europe to get ready for a potential conflict with Russia" class="suggested-title">Head of NATO warns Europe to get ready for a potential conflict with Russia</a>
                        <span class="suggested-date">12 December 2025</span>
                    </div>
                </div>
            </div>

            
        </div>
        
<!-- popular and other news -->
     <?php include '../popular-other-news.php'; ?>

<!-- footer -->
<?php include '../footer.php'; ?>

    </div>
    <button onclick="window.scrollTo({top:0, behavior:'smooth'});" class="scrollup-btn" aria-label="Scroll to top">
    <i class="fa-solid fa-chevron-up" aria-hidden="true"></i>
    </button>
    <!-- <script src="../js/style.js"></script> -->
</body>

</html>