<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- SEO Title -->
    <title>Revolut Failed to Notify UK Regulators of CEO UAE Residency</title>
    <meta name="title" content="Revolut Failed to Notify UK Regulators of CEO UAE Residency">

    <!-- Meta Description -->
    <meta name="description"
        content="Revolut faces regulatory scrutiny after failing to notify UK authorities that its chief executive was listed as a UAE resident during licensing talks.">

        <meta name="author" content="James Thornton">
    <!-- Canonical -->
    <link rel="canonical"
        href="https://www.morenews.org/uk/when-the-ceo-was-listed-as-a-uae-resident-revolut-failed-to-notify-uk-regulators">

    <!-- Open Graph -->
    <meta property="og:title" content="Revolut Failed to Notify UK Regulators of CEO UAE Residency">
    <meta property="og:description"
        content="Revolut faces regulatory scrutiny after failing to notify UK authorities that its chief executive was listed as a UAE resident during licensing talks.">
    <meta property="og:url"
        content="https://www.morenews.org/uk/when-the-ceo-was-listed-as-a-uae-resident-revolut-failed-to-notify-uk-regulators">
    <meta property="og:image"
        content="https://www.morenews.org/images/when-the-ceo-was-listed-as-a-uae-resident-revolut-failed-to-notify-uk-regulators-first-image.webp">
    <meta property="og:site_name" content="More News">
    <meta property="og:type" content="article">
    <meta property="og:locale" content="en_GB">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">

    <!-- Twitter Cards -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Revolut Failed to Notify UK Regulators of CEO UAE Residency">
    <meta name="twitter:description"
        content="Revolut faces regulatory scrutiny after failing to notify UK authorities that its chief executive was listed as a UAE resident during licensing talks.">
    <meta name="twitter:url"
        content="https://www.morenews.org/uk/when-the-ceo-was-listed-as-a-uae-resident-revolut-failed-to-notify-uk-regulators">
    <meta name="twitter:image"
        content="https://www.morenews.org/images/when-the-ceo-was-listed-as-a-uae-resident-revolut-failed-to-notify-uk-regulators-first-image.webp">
    <meta name="twitter:site" content="@morenews">
    <meta name="twitter:creator" content="@morenews">

    <!-- Styles -->
    <link rel="preload" href="../css/style.css" as="style">
    <link rel="stylesheet" href="../css/style.css">

    <!-- Google Fonts Optimized -->
    <link rel="preload" href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" as="style">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" rel="stylesheet">

    <!-- Font Awesome (Optimized) -->
    <link rel="preload" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css" as="style">
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css"
          media="print"
          onload="this.media='all'">
    <noscript>
        <link rel="stylesheet"
              href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
    </noscript>

    <!-- Favicon -->
    <link rel="shortcut icon" href="../favicon.ico" type="image/x-icon">

    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "WebSite",
      "@id": "https://www.morenews.org/#website",
      "url": "https://www.morenews.org/",
      "name": "More News"
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.morenews.org/#publisher",
      "name": "More News",
      "url": "https://www.morenews.org/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/logo.webp",
        "width": 512,
        "height": 512
      },
      "address": {
        "@type": "PostalAddress",
        "addressCountry": "GB"
      }
    },

    {
      "@type": "Person",
      "@id": "https://www.morenews.org/author/uk-author#author",
      "name": "UK Reporter",
      "worksFor": {
        "@id": "https://www.morenews.org/#publisher"
      }
    },

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.morenews.org/uk/when-the-ceo-was-listed-as-a-uae-resident-revolut-failed-to-notify-uk-regulators#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.morenews.org/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "UK",
          "item": "https://www.morenews.org/uk/uk"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "name": "Revolut Failed to Notify UK Regulators of CEO UAE Residency",
          "item": "https://www.morenews.org/uk/when-the-ceo-was-listed-as-a-uae-resident-revolut-failed-to-notify-uk-regulators"
        }
      ]
    },
    {
      "@type": "Person",
      "@id": "https://www.morenews.org/author/james-thornton#author",
      "name": "James Thornton",
      "url": "https://www.morenews.org/author/james-thornton",
      "jobTitle": "UK Reporter",
      "worksFor": {
        "@id": "https://www.morenews.org/#publisher"
      }
    },

    {
      "@type": "WebPage",
      "@id": "https://www.morenews.org/uk/when-the-ceo-was-listed-as-a-uae-resident-revolut-failed-to-notify-uk-regulators#webpage",
      "url": "https://www.morenews.org/uk/when-the-ceo-was-listed-as-a-uae-resident-revolut-failed-to-notify-uk-regulators",
      "name": "Revolut Failed to Notify UK Regulators of CEO UAE Residency",
      "description": "Revolut faces regulatory scrutiny after failing to notify UK authorities that its chief executive was listed as a UAE resident during licensing talks.",
      "inLanguage": "en-GB",
      "isPartOf": {
        "@id": "https://www.morenews.org/#website"
      },
      "primaryImageOfPage": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/when-the-ceo-was-listed-as-a-uae-resident-revolut-failed-to-notify-uk-regulators-first-image.webp",
        "width": 1200,
        "height": 630
      },
      "breadcrumb": {
        "@id": "https://www.morenews.org/uk/when-the-ceo-was-listed-as-a-uae-resident-revolut-failed-to-notify-uk-regulators#breadcrumb"
      }
    },

    {
      "@type": "NewsArticle",
      "@id": "https://www.morenews.org/uk/when-the-ceo-was-listed-as-a-uae-resident-revolut-failed-to-notify-uk-regulators#article",
      "headline": "Revolut Failed to Notify UK Regulators of CEO UAE Residency",
      "description": "Revolut faces regulatory scrutiny after failing to notify UK authorities that its chief executive was listed as a UAE resident during licensing talks.",
      "datePublished": "2025-12-01",
      "dateModified": "2025-12-01",
      "articleSection": "UK",
      "inLanguage": "en-GB",
      "author": {
        "@id": "https://www.morenews.org/author/uk-author#author"
      },
      "publisher": {
        "@id": "https://www.morenews.org/#publisher"
      },
      "image": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/when-the-ceo-was-listed-as-a-uae-resident-revolut-failed-to-notify-uk-regulators-first-image.webp",
        "width": 1200,
        "height": 630
      },
      "mainEntityOfPage": {
        "@id": "https://www.morenews.org/uk/when-the-ceo-was-listed-as-a-uae-resident-revolut-failed-to-notify-uk-regulators#webpage"
      }
    }

  ]
}
</script>

<style>
  /* Apply styles to center the content */
.writer-block {
    font-family: "Noto Serif JP", serif;
  max-width: 540px;
  margin: 15px auto 10px auto;
  padding: 0px 0px;
  line-height: 1.7;
  color: #222;
}

/* Additional styles for mobile and desktop responsiveness */
.writer-date,
.writer-credit {
    margin-top: 10px;
    margin-bottom: 10px;
}

/* Optional: Adjustments for mobile view */
@media screen and (max-width: 768px) {
    .writer-block {
        padding: 10px;
    }
}

</style>

</head>


<body>

<!-- header -->
<?php include '../header.php'; ?>


    <div class="main-container">
        
        <section class="headline-rail">
        </section>
        <div class="article-header">
            <h1 class="article-headline">
               When the CEO was listed as a UAE resident, Revolut failed to notify UK regulators
            </h1>

            <div class="article-breadcrumb">
                <a href="../uk/uk.php" title="uk" class="crumb-link">UK</a> ›
                <span class="crumb-current">When the CEO was listed as a UAE resident, Revolut failed to notify UK regulators</span>
            </div>

            <!--socail icon-->
            <?php include '../social.php'; ?>
            <div class="writer-block">
            <div class="author-info">
                <?php include '../uk-author.php'; ?>
            </div>
            <div class="writer-date" itemprop="datePublished" content="2025-12-01">Published Date: 1 December 2025</div>
            </div>
            
        </div>
        <div class="image-wrapper">
            <img src="../images/when-the-ceo-was-listed-as-a-uae-resident-revolut-failed-to-notify-uk-regulators-first-image.webp" alt="When the CEO was listed as a UAE resident, Revolut failed to notify UK regulators">
        </div>
        <div class="writer-block">
       

            <div class="story-text-wrap">
                
                <p>
                  Revolut has come under renewed regulatory pressure after it emerged that chief executive and co-founder Nik Storonsky has been formally registered as a resident of the United Arab Emirates — a development UK authorities say was not disclosed to them in advance. The information surfaced not through a regulatory update, but through a Companies House filing linked to Storonsky’s family office, prompting questions about transparency at one of Britain’s most prominent fintech firms.
                </p>

                <p>
                Although Revolut continues to list Storonsky’s official address in the UK, the discrepancy has drawn the attention of the Financial Conduct Authority, the Bank of England and the Treasury. Regulators expect senior executives, especially those seeking a UK banking licence, to inform them promptly of any significant changes to their personal circumstances, including residency. The absence of notification has raised concerns about whether Revolut’s leadership is maintaining the level of openness expected of firms striving for full banking authorisation.
                </p>
                <p>
                  A filing submitted in October 2025 stated that Storonsky’s family office shifted its official base to the UAE almost a year earlier, on 16 October 2024. According to people familiar with the matter, UK regulators only became aware of the move after the documents were made public. The revelation has led to broader questions about governance at Revolut and whether the firm remains firmly under UK regulatory oversight.
                </p>
                <p>
                  Storonsky is known to divide his time between London, Dubai and other locations, but officials examining the issue say a change in residency may influence Revolut’s risk profile at a critical moment. The company is still awaiting the final stage of approval for a full UK banking licence, following conditional authorisation granted in 2024. As part of the process, the Prudential Regulation Authority has been assessing whether Revolut’s risk management, internal controls and global structure meet the standards expected of a regulated bank.
                </p>
                
            </div>

        </div>
        <div class="image-wrapper">
            <img loading="lazy" src="../images/when-the-ceo-was-listed-as-a-uae-resident-revolut-failed-to-notify-uk-regulators-second-image.webp" alt="When the CEO was listed as a UAE resident, Revolut failed to notify UK regulators">
        </div>
        <div class="writer-block">

            <div class="story-text-wrap">
                <p>
                  The uncertainty around Storonsky’s residency has contributed to the PRA’s cautious approach. Some in the fintech sector have criticised the length of the approval process, but regulators insist they must be satisfied that Revolut has robust oversight mechanisms in place — including clarity around where its most senior executives are based and how they exercise authority.
                </p>

                <p>
                 Revolut has stressed that the residency disclosure relates solely to Storonsky’s family office and does not affect his responsibilities within the company. A spokesperson said the firm continues to operate from London and remains committed to the UK market, despite its rapid international expansion. They also said Storonsky continues to fulfil his duties from Britain and is still recorded as a UK resident in the company’s own internal filings.
                </p>
                <p>
                    Even so, regulators are seeking explicit confirmation that governance requirements are being fully met and that customer protections will not be affected. Without those assurances, the delay in Revolut’s banking licence could stretch further — and in a worst-case scenario, approval could be withheld entirely.
                </p>
                
            </div>

        </div>
        

        
        <div class="writer-block">
            <div class="suggested-box">
                <h3 class="suggested-heading">UK News</h3>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/us-and-uk-agree-to-zero-pharmaceutical-tariffs-first-image.webp"
                         alt="US and UK agree to zero pharmaceutical tariffs first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../uk/us-and-uk-agree-to-zero-pharmaceutical-tariffs.php" title="US and UK agree to zero pharmaceutical tariffs" class="suggested-title">US and UK agree to zero pharmaceutical tariffs</a>
                        <span class="suggested-date">1 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/uk-wanted-to-rejoin-erasmus-student-exchange-first-image.webp" 
                        alt="UK wanted to rejoin Erasmus student exchange first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../uk/uk-wanted-to-rejoin-erasmus-student-exchange.php" title="UK wanted to rejoin Erasmus student exchange" class="suggested-title">UK wanted to rejoin Erasmus student exchange</a>
                        <span class="suggested-date">1 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/uk-rail-strike-talks-resume-as-christmas-travel-disruption-looms-first-image.webp" 
                    alt="UK Rail Strike Talks Resume as Christmas Travel Disruption Looms first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../uk/uk-rail-strike-talks-resume-as-christmas-travel-disruption-looms.php" title="UK Rail Strike Talks Resume as Christmas Travel Disruption Looms" class="suggested-title">UK Rail Strike Talks Resume as Christmas Travel Disruption Looms</a>
                        <span class="suggested-date">15 December 2025</span>
                    </div>
                </div>
            </div>

            
        </div>
        
        <!-- popular and other news -->
     <?php include '../popular-other-news.php'; ?>

<!-- footer -->
<?php include '../footer.php'; ?>

    </div>
    <button onclick="window.scrollTo({top:0, behavior:'smooth'});" class="scrollup-btn" aria-label="Scroll to top">
    <i class="fa-solid fa-chevron-up" aria-hidden="true"></i>
    </button>
    <!-- <script src="../js/style.js"></script> -->
</body>

</html>