<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Title -->
    <title>UK seeks return to Erasmus student exchange programme</title>
    <meta name="title" content="UK seeks return to Erasmus student exchange programme">

    <meta name="author" content="James Thornton">
    <!-- Meta Description -->
    <meta name="description"
        content="UK ministers have confirmed the government wants to rejoin the Erasmus student exchange scheme, reopening talks with the EU on education cooperation.">

    <!-- Canonical -->
    <link rel="canonical"
        href="https://www.morenews.org/uk/uk-wanted-to-rejoin-erasmus-student-exchange">

    <!-- Open Graph -->
    <meta property="og:title" content="UK seeks return to Erasmus student exchange programme">
    <meta property="og:description"
        content="UK ministers have confirmed the government wants to rejoin the Erasmus student exchange scheme, reopening talks with the EU on education cooperation.">
    <meta property="og:url"
        content="https://www.morenews.org/uk/uk-wanted-to-rejoin-erasmus-student-exchange">
    <meta property="og:image"
        content="https://www.morenews.org/images/uk-wanted-to-rejoin-erasmus-student-exchange-first-image.webp">
    <meta property="og:site_name" content="More News">
    <meta property="og:type" content="article">
    <meta property="og:locale" content="en_GB">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">

    <!-- Twitter Cards -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="UK seeks return to Erasmus student exchange programme">
    <meta name="twitter:description"
        content="UK ministers have confirmed the government wants to rejoin the Erasmus student exchange scheme, reopening talks with the EU on education cooperation.">
    <meta name="twitter:image"
        content="https://www.morenews.org/images/uk-wanted-to-rejoin-erasmus-student-exchange-first-image.webp">
    <meta name="twitter:url"
        content="https://www.morenews.org/uk/uk-wanted-to-rejoin-erasmus-student-exchange">
    <meta name="twitter:site" content="@morenews">
    <meta name="twitter:creator" content="@morenews">

    <!-- Styles -->
    <link rel="preload" href="../css/style.css" as="style">
    <link rel="stylesheet" href="../css/style.css">

    <!-- Google Fonts Optimized -->
    <link rel="preload" href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" as="style">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" rel="stylesheet">

    <!-- Font Awesome (Optimized) -->
    <link rel="preload" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css" as="style">
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css"
          media="print"
          onload="this.media='all'">
    <noscript>
        <link rel="stylesheet"
              href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
    </noscript>

    <!-- Favicon -->
    <link rel="shortcut icon" href="../favicon.ico" type="image/x-icon">

    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "WebSite",
      "@id": "https://www.morenews.org/#website",
      "url": "https://www.morenews.org/",
      "name": "More News"
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.morenews.org/#publisher",
      "name": "More News",
      "url": "https://www.morenews.org/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/logo.webp",
        "width": 512,
        "height": 512
      },
      "address": {
        "@type": "PostalAddress",
        "addressCountry": "GB"
      }
    },

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.morenews.org/uk/uk-wanted-to-rejoin-erasmus-student-exchange#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.morenews.org/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "UK",
          "item": "https://www.morenews.org/uk/uk"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "name": "UK seeks return to Erasmus student exchange programme",
          "item": "https://www.morenews.org/uk/uk-wanted-to-rejoin-erasmus-student-exchange"
        }
      ]
    },
    {
      "@type": "Person",
      "@id": "https://www.morenews.org/author/james-thornton#author",
      "name": "James Thornton",
      "url": "https://www.morenews.org/author/james-thornton",
      "jobTitle": "UK Reporter",
      "worksFor": {
        "@id": "https://www.morenews.org/#publisher"
      }
    },

    {
      "@type": "WebPage",
      "@id": "https://www.morenews.org/uk/uk-wanted-to-rejoin-erasmus-student-exchange#webpage",
      "url": "https://www.morenews.org/uk/uk-wanted-to-rejoin-erasmus-student-exchange",
      "name": "UK seeks return to Erasmus student exchange programme",
      "description": "UK ministers have confirmed the government wants to rejoin the Erasmus student exchange scheme, reopening talks with the EU on education cooperation.",
      "inLanguage": "en-GB",
      "isPartOf": {
        "@id": "https://www.morenews.org/#website"
      },
      "primaryImageOfPage": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/uk-wanted-to-rejoin-erasmus-student-exchange-first-image.webp",
        "width": 1200,
        "height": 630
      },
      "breadcrumb": {
        "@id": "https://www.morenews.org/uk/uk-wanted-to-rejoin-erasmus-student-exchange#breadcrumb"
      }
    },

    {
      "@type": "NewsArticle",
      "@id": "https://www.morenews.org/uk/uk-wanted-to-rejoin-erasmus-student-exchange#article",
      "headline": "UK seeks return to Erasmus student exchange programme",
      "description": "UK ministers have confirmed the government wants to rejoin the Erasmus student exchange scheme, reopening talks with the EU on education cooperation.",
      "datePublished": "2025-12-01",
      "dateModified": "2025-12-01",
      "articleSection": "UK",
      "inLanguage": "en-GB",
      "publisher": {
        "@id": "https://www.morenews.org/#publisher"
      },
      "image": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/uk-wanted-to-rejoin-erasmus-student-exchange-first-image.webp",
        "width": 1200,
        "height": 630
      },
      "mainEntityOfPage": {
        "@id": "https://www.morenews.org/uk/uk-wanted-to-rejoin-erasmus-student-exchange#webpage"
      }
    }

  ]
}
</script>

<style>
  /* Apply styles to center the content */
.writer-block {
    font-family: "Noto Serif JP", serif;
  max-width: 540px;
  margin: 15px auto 10px auto;
  padding: 0px 0px;
  line-height: 1.7;
  color: #222;
}

/* Additional styles for mobile and desktop responsiveness */
.writer-date,
.writer-credit {
    margin-top: 10px;
    margin-bottom: 10px;
}

/* Optional: Adjustments for mobile view */
@media screen and (max-width: 768px) {
    .writer-block {
        padding: 10px;
    }
}

</style>

</head>


<body>

<!-- header -->
<?php include '../header.php'; ?>


    <div class="main-container">
        
        <section class="headline-rail">       
        </section>
        <div class="article-header">
            <h1 class="article-headline">
               UK wanted to rejoin Erasmus student exchange
            </h1>

            <div class="article-breadcrumb">
                <a href="../uk/uk.php" title="uk" class="crumb-link">UK</a> ›
                <span class="crumb-current">UK wanted to rejoin Erasmus student exchange</span>
            </div>

            <!--socail icon-->
            <?php include '../social.php'; ?>
            <div class="writer-block">
            <div class="author-info">
                <?php include '../uk-author.php'; ?>
            </div>
            <div class="writer-date" itemprop="datePublished" content="2025-12-01">Published Date: 1 December 2025</div>
            </div>
            
        </div>
        <div class="image-wrapper">
            <img src="../images/uk-wanted-to-rejoin-erasmus-student-exchange-first-image.webp" alt="UK wanted to rejoin Erasmus student exchange first image">
        </div>
        <div class="writer-block">
            

            <div class="story-text-wrap">
                
                <p>
                    For the next three years, British pharmaceutical exports will be free of tariffs under a new trade agreement between the US and the UK. In return, the UK government promised to raise the NHS's willingness to pay for drugs, which would be the largest adjustment to its drug-pricing structure in nearly two decades.
                </p>

                <p>
                  Pressure from Washington, where President Donald Trump has threatened to levy tariffs of up to 100% on branded drugs imported into the United States, has resulted in the deal. One of Britain's most prosperous export sectors, pharmaceuticals were shipped to the US for about £11 billion in the year that ended in September, according to figures from the Department for Business and Trade.
                 </p>
                <p>
                    The deal "guarantees that UK pharmaceutical exports worth at least £5 billion annually will continue to enter the US without tariffs," said Peter Kyle, the secretary of business and trade. He continued by saying that the plan will promote investment and help maintain highly skilled jobs in the UK's bio sciences sector.
                </p>
            </div>

        </div>
        <div class="image-wrapper">
            <img loading="lazy" src="../images/uk-wanted-to-rejoin-erasmus-student-exchange-second-image.webp" alt="UK wanted to rejoin Erasmus student exchange second image">
        </div>
        <div class="writer-block">

            <div class="story-text-wrap">
                <h3>What the United Kingdom has decided to alter</h3>
                <p>
                    The agreement calls for a 25% increase in the NHS's cost-effectiveness criterion for new medications. Additionally, NHS spending on drugs will rise from 0.3% to 0.6% of GDP during the next ten years. The rebate rate that pharmaceutical companies are required to pay when NHS spending exceeds agreed-upon limitations will also be set at 15%, down from nearly 20% the previous year.
                </p>

                <p>
                    According to officials, the goal of these changes is to expedite patients' access to cutting-edge medications. The national pharmaceuticals regulator, NICE, anticipates that the modifications may result in an extra three to five approvals annually in addition to its regular evaluations.
                </p>
            </div>

        </div>
        <div class="image-wrapper">
            <img loading="lazy" src="../images/uk-wanted-to-rejoin-erasmus-student-exchange-third-image.webp" alt="UK wanted to rejoin Erasmus student exchange third image">
        </div>
        <div class="writer-block">
            <div class="story-text-wrap">
                <h3>Why the US pursued the agreement</h3>
                <p>
                   US officials have long maintained that while other wealthy nations enjoy lower prices, American patients pay a disproportionate amount of the cost of global medication development. Trump has frequently criticized reliance on foreign manufacture, even though pharmaceuticals were not specifically targeted in his previous tariff actions.
                </p>

                <p>
                    The UK deal, according to White House spokesperson Kush Desai, is a "historic step" that guarantees other wealthy countries "contribute their fair share" to the price of introducing innovative medications to the market. According to US Health Secretary Robert Kennedy Jr., the agreement improves the equilibrium of the pharmaceutical trade between the US and the UK.</p>
            </div>

        </div>
        
        <div class="writer-block">
            
            <div class="suggested-box">
                <h3 class="suggested-heading">UK News</h3>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/uk-rail-strike-talks-resume-as-christmas-travel-disruption-looms-first-image.webp" 
                    alt="UK Rail Strike Talks Resume as Christmas Travel Disruption Looms first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../uk/uk-rail-strike-talks-resume-as-christmas-travel-disruption-looms.php" title="UK Rail Strike Talks Resume as Christmas Travel Disruption Looms" class="suggested-title">UK Rail Strike Talks Resume as Christmas Travel Disruption Looms</a>
                        <span class="suggested-date">15 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/darren-jones-defends-rachel-reeves-for-misrepresenting-first-image.webp"
                        alt="Darren Jones defends Rachel Reeves for misrepresenting tax increases to cabinet" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../uk/darren-jones-defends-rachel-reeves-for-misrepresenting-tax-increases-to-cabinet.php" title="Darren Jones defends Rachel Reeves for misrepresenting tax increases to cabinet" class="suggested-title">Darren Jones defends Rachel Reeves for misrepresenting tax increases to cabinet</a>
                        <span class="suggested-date">1 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/uk-special-forces-accused-of-policy-to-kill-afghan-first-image.webp"
                            alt="UK special forces accused of policy to kill Afghan fighting-age men" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../uk/uk-special-forces-accused-of-policy-to-kill-afghan-fighting-age-men.php" title="UK special forces accused of policy to kill Afghan fighting-age men" class="suggested-title">UK special forces accused of policy to kill Afghan fighting-age men</a>
                        <span class="suggested-date">1 December 2025</span>
                    </div>
                </div>
            </div>

            
        </div>
        
        <!-- popular and other news -->
     <?php include '../popular-other-news.php'; ?>

<!-- footer -->
<?php include '../footer.php'; ?>

    </div>
    <button onclick="window.scrollTo({top:0, behavior:'smooth'});" class="scrollup-btn" aria-label="Scroll to top">
    <i class="fa-solid fa-chevron-up" aria-hidden="true"></i>
    </button>
    <!-- <script src="../js/style.js"></script> -->
</body>

</html>