<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Title -->
    <title>Starmer and Reeves deny misleading cabinet over budget</title>
    <meta name="title" content="Starmer and Reeves deny misleading cabinet over budget">

    <meta name="author" content="James Thornton">
    <!-- Meta Description -->
    <meta name="description"
        content="Keir Starmer and Rachel Reeves reject claims they misled cabinet ministers or voters over the true state of public finances ahead of the 2025 Budget.">

    <!-- Canonical -->
    <link rel="canonical"
        href="https://www.morenews.org/uk/starmer-reeves-the-pm-denies-misleading-the-cabinet-or-voters">

    <!-- Open Graph -->
    <meta property="og:title" content="Starmer and Reeves deny misleading cabinet over budget">
    <meta property="og:description"
        content="Keir Starmer and Rachel Reeves reject claims they misled cabinet ministers or voters over the true state of public finances ahead of the 2025 Budget.">
    <meta property="og:url"
        href="https://www.morenews.org/uk/starmer-reeves-the-pm-denies-misleading-the-cabinet-or-voters">
    <meta property="og:image"
        content="https://www.morenews.org/images/starmer-reeves-the-pm-denies-misleading-the-cabinet-first-image.webp">
    <meta property="og:site_name" content="More News">
    <meta property="og:type" content="article">
    <meta property="og:locale" content="en_GB">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">

    <!-- Twitter Cards -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Starmer and Reeves deny misleading cabinet over budget">
    <meta name="twitter:description"
        content="Keir Starmer and Rachel Reeves reject claims they misled cabinet ministers or voters over the true state of public finances ahead of the 2025 Budget.">
    <meta name="twitter:image"
        content="https://www.morenews.org/images/starmer-reeves-the-pm-denies-misleading-the-cabinet-first-image.webp">
    <meta name="twitter:url"
        content="https://www.morenews.org/uk/starmer-reeves-the-pm-denies-misleading-the-cabinet-or-voters">
    <meta name="twitter:site" content="@morenews">
    <meta name="twitter:creator" content="@morenews">

    <!-- Styles -->
    <link rel="preload" href="../css/style.css" as="style">
    <link rel="stylesheet" href="../css/style.css">

    <!-- Google Fonts Optimized -->
    <link rel="preload" href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" as="style">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" rel="stylesheet">

    <!-- Font Awesome (Optimized) -->
    <link rel="preload" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css" as="style">
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css"
          media="print"
          onload="this.media='all'">
    <noscript>
        <link rel="stylesheet"
              href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
    </noscript>

    <!-- Favicon -->
    <link rel="shortcut icon" href="../favicon.ico" type="image/x-icon">

    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "WebSite",
      "@id": "https://www.morenews.org/#website",
      "url": "https://www.morenews.org/",
      "name": "More News"
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.morenews.org/#publisher",
      "name": "More News",
      "url": "https://www.morenews.org/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/logo.webp",
        "width": 512,
        "height": 512
      },
      "address": {
        "@type": "PostalAddress",
        "addressCountry": "GB"
      }
    },

    {
      "@type": "Person",
      "@id": "https://www.morenews.org/author/james-thornton#author",
      "name": "James Thornton",
      "url": "https://www.morenews.org/author/james-thornton",
      "jobTitle": "UK Reporter",
      "worksFor": {
        "@id": "https://www.morenews.org/#publisher"
      }
    },

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.morenews.org/uk/starmer-reeves-the-pm-denies-misleading-the-cabinet-or-voters#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.morenews.org/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "UK",
          "item": "https://www.morenews.org/uk/uk"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "name": "Starmer and Reeves deny misleading cabinet over budget",
          "item": "https://www.morenews.org/uk/starmer-reeves-the-pm-denies-misleading-the-cabinet-or-voters"
        }
      ]
    },

    {
      "@type": "WebPage",
      "@id": "https://www.morenews.org/uk/starmer-reeves-the-pm-denies-misleading-the-cabinet-or-voters#webpage",
      "url": "https://www.morenews.org/uk/starmer-reeves-the-pm-denies-misleading-the-cabinet-or-voters",
      "name": "Starmer and Reeves deny misleading cabinet over budget",
      "description": "Keir Starmer and Rachel Reeves reject claims they misled cabinet ministers or voters over the true state of public finances ahead of the 2025 Budget.",
      "inLanguage": "en-GB",
      "isPartOf": {
        "@id": "https://www.morenews.org/#website"
      },
      "primaryImageOfPage": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/starmer-reeves-the-pm-denies-misleading-the-cabinet-first-image.webp",
        "width": 1200,
        "height": 630
      },
      "breadcrumb": {
        "@id": "https://www.morenews.org/uk/starmer-reeves-the-pm-denies-misleading-the-cabinet-or-voters#breadcrumb"
      }
    },

    {
      "@type": "NewsArticle",
      "@id": "https://www.morenews.org/uk/starmer-reeves-the-pm-denies-misleading-the-cabinet-or-voters#article",
      "headline": "Starmer and Reeves deny misleading cabinet over budget",
      "description": "Keir Starmer and Rachel Reeves reject claims they misled cabinet ministers or voters over the true state of public finances ahead of the 2025 Budget.",
      "datePublished": "2025-12-01",
      "dateModified": "2025-12-01",
      "articleSection": "UK",
      "inLanguage": "en-GB",
      "author": {
        "@id": "https://www.morenews.org/author/uk-reporter#author"
      },
      "publisher": {
        "@id": "https://www.morenews.org/#publisher"
      },
      "image": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/starmer-reeves-the-pm-denies-misleading-the-cabinet-first-image.webp",
        "width": 1200,
        "height": 630
      },
      "mainEntityOfPage": {
        "@id": "https://www.morenews.org/uk/starmer-reeves-the-pm-denies-misleading-the-cabinet-or-voters#webpage"
      }
    }

  ]
}
</script>

<style>
  /* Apply styles to center the content */
.writer-block {
    font-family: "Noto Serif JP", serif;
  max-width: 540px;
  margin: 15px auto 10px auto;
  padding: 0px 0px;
  line-height: 1.7;
  color: #222;
}

/* Additional styles for mobile and desktop responsiveness */
.writer-date,
.writer-credit {
    margin-top: 10px;
    margin-bottom: 10px;
}

/* Optional: Adjustments for mobile view */
@media screen and (max-width: 768px) {
    .writer-block {
        padding: 10px;
    }
}

</style>

</head>


<body>

<!-- header -->
<?php include '../header.php'; ?>



    <div class="main-container">
        
        <section class="headline-rail">
        </section>
        <div class="article-header">
            <h1 class="article-headline">
               Starmer-Reeves : The PM denies misleading the cabinet or voters while insisting he is "proud" of the budget
            </h1>

            <div class="article-breadcrumb">
                <a href="../uk/uk.php" title="uk" class="crumb-link">UK</a> ›
                <span class="crumb-current">Starmer-Reeves : The PM denies misleading the cabinet or voters while insisting he is "proud" of the budget</span>
            </div>

            <!--socail icon-->
            <?php include '../social.php'; ?>
            <div class="writer-block">
            <div class="author-info">
                <?php include '../uk-author.php'; ?>
            </div>
            <div class="writer-date" itemprop="datePublished" content="2025-12-01">Published Date: 1 December 2025</div>
            </div>
            
        </div>
        <div class="image-wrapper">
            <img src="../images/starmer-reeves-the-pm-denies-misleading-the-cabinet-first-image.webp" alt="What’s new in this month’s redesigned UK passports? first image">
        </div>
        <div class="writer-block">
      

            <div class="story-text-wrap">
               
                <p>
                   There have been strong denials of claims that Prime Minister Keir Starmer or Chancellor Rachel Reeves lied to ministers or the public about the real state of the national finances before the 2025 Budget. He said he was "proud" of what the government gave. The Office for Budget Responsibility (OBR) said that the public finances were on track for a £4.2 billion surplus based on its own predictions that were sent to the Treasury on October 31. This started the argument. Reeves and Starmer said that a big deficit made it hard to choose taxes, which was different from this.
                </p>

                <p>
                This could force the government to break important promises made in the manifesto, like those about income tax. Still, she said that taxes would go up by £26 billion, the biggest increase in almost ten years. The OBR's strange choice to make the data it gave the Treasury public to stop rumors caused an immediate political backlash, raising questions about the truth of the story told to the Cabinet and the openness of the highest levels of government.
                </p>
                <p>
                  Starmer has stuck to his claim that there was "no misleading," saying that the government needed to be ready for a range of budgetary outcomes, especially since productivity projections were lowered earlier this year. He said that ministers were focused on making sure that long-term stability could be achieved and that financial stability could be rebuilt. Reeves has also denied any wrongdoing, saying that she acted properly and that the Budget accurately reflected the country's serious economic problems.
                </p>
                <p>
                  The OBR's revelations had a bigger effect when the chair of the watchdog stepped down, taking responsibility for what has been called the biggest breach in its 15-year history. The early release of the estimates, which happened just hours before Reeves was at the dispatch box, led to political fallout and criticism of how the government handled sensitive financial information. Since then, opposition parties have called for a full parliamentary investigation, saying that the public has a right to know if the government made the situation seem worse than it was to justify big tax increases.
              </p>
                
            </div>

        </div>
        <div class="image-wrapper">
            <img loading="lazy" src="../images/starmer-reeves-the-pm-denies-misleading-the-cabinet-second-image.webp" alt="What’s new in this month’s redesigned UK passports? second image">
        </div>
        <div class="writer-block">

            <div class="story-text-wrap">
                <p>
                   Even though there was a lot of noise, Starmer has continued to support the main ideas of the Budget and Reeves's approach. He has called it an important step in what he calls "national renewal." He says that the UK needs to deal with the economic effects of Brexit, improve its relationship with the EU, and fix the structural problems that have been holding back growth. Reeves has made the same point, saying that the Budget is part of a longer-term plan to stabilize public finances, improve public services, and give the government more room to spend money in case of future economic shocks.
                 </p>

                <p>
                 The OBR's most recent pre-Budget forecast, which came out on November 26, said that fiscal headroom had grown to £21.7 billion. This number was much higher than what had been predicted before. Analysts and leaders of the opposition say that this raises valid questions about whether officials made the task seem harder than it really was. The administration, on the other hand, says that the extra headroom is necessary for stability and trust. The episode has led to a larger conversation about the need for more government openness, trust in financial institutions, and the political consequences of actions taken during times of extreme economic hardship. In the next few weeks, there will be more scrutiny as ministers are told to be clear about what they knew and when.
                   </p>
                
            </div>

        </div>
        

        
        <div class="writer-block">
            <div class="suggested-box">
                <h3 class="suggested-heading">UK News</h3>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/when-the-ceo-was-listed-as-a-uae-resident-revolut-failed-to-notify-uk-regulators-first-image.webp"
                         alt="When the CEO was listed as a UAE resident, Revolut failed to notify UK regulators" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../uk/when-the-ceo-was-listed-as-a-uae-resident-revolut-failed-to-notify-uk-regulators.php" title="When the CEO was listed as a UAE resident, Revolut failed to notify UK regulators" class="suggested-title">When the CEO was listed as a UAE resident, Revolut failed to notify UK regulators</a>
                        <span class="suggested-date">1 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/us-and-uk-agree-to-zero-pharmaceutical-tariffs-first-image.webp"
                         alt="US and UK agree to zero pharmaceutical tariffs first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../uk/us-and-uk-agree-to-zero-pharmaceutical-tariffs.php" title="US and UK agree to zero pharmaceutical tariffs" class="suggested-title">US and UK agree to zero pharmaceutical tariffs</a>
                        <span class="suggested-date">1 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/uk-wanted-to-rejoin-erasmus-student-exchange-first-image.webp" 
                        alt="UK wanted to rejoin Erasmus student exchange first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../uk/uk-wanted-to-rejoin-erasmus-student-exchange.php" title="UK wanted to rejoin Erasmus student exchange" class="suggested-title">UK wanted to rejoin Erasmus student exchange</a>
                        <span class="suggested-date">1 December 2025</span>
                    </div>
                </div>
            </div>

            
        </div>
        
<!-- popular and other news -->
     <?php include '../popular-other-news.php'; ?>

<!-- footer -->
<?php include '../footer.php'; ?>

    </div>
    <button onclick="window.scrollTo({top:0, behavior:'smooth'});" class="scrollup-btn" aria-label="Scroll to top">
    <i class="fa-solid fa-chevron-up" aria-hidden="true"></i>
    </button>
    <!-- <script src="../js/style.js"></script> -->
</body>

</html>