<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Title -->
    <title>Darren Jones backs Reeves over handling of tax rise claims</title>
    <meta name="title" content="Darren Jones backs Reeves over handling of tax rise claims">

    <meta name="author" content="James Thornton">
    <!-- Meta Description -->
    <meta name="description"
        content="Darren Jones defends Chancellor Rachel Reeves after claims she misrepresented looming tax rises to cabinet colleagues amid scrutiny of budget decisions.">

    <!-- Canonical -->
    <link rel="canonical"
        href="https://www.morenews.org/uk/darren-jones-defends-rachel-reeves-for-misrepresenting-tax-increases-to-cabinet">

    <!-- Open Graph -->
    <meta property="og:title" content="Darren Jones backs Reeves over handling of tax rise claims">
    <meta property="og:description"
        content="Darren Jones defends Chancellor Rachel Reeves after claims she misrepresented looming tax rises to cabinet colleagues amid scrutiny of budget decisions.">
    <meta property="og:url"
        content="https://www.morenews.org/uk/darren-jones-defends-rachel-reeves-for-misrepresenting-tax-increases-to-cabinet">
    <meta property="og:image"
        content="https://www.morenews.org/images/darren-jones-defends-rachel-reeves-for-misrepresenting-first-image.webp">
    <meta property="og:site_name" content="More News">
    <meta property="og:type" content="article">
    <meta property="og:locale" content="en_GB">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">

    <!-- Twitter Cards -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Darren Jones backs Reeves over handling of tax rise claims">
    <meta name="twitter:description"
        content="Darren Jones defends Chancellor Rachel Reeves after claims she misrepresented looming tax rises to cabinet colleagues amid scrutiny of budget decisions.">
    <meta name="twitter:image"
        content="https://www.morenews.org/images/darren-jones-defends-rachel-reeves-for-misrepresenting-first-image.webp">
    <meta name="twitter:url"
        content="https://www.morenews.org/uk/darren-jones-defends-rachel-reeves-for-misrepresenting-tax-increases-to-cabinet">
    <meta name="twitter:site" content="@morenews">
    <meta name="twitter:creator" content="@morenews">

    <!-- Styles -->
    <link rel="preload" href="../css/style.css" as="style">
    <link rel="stylesheet" href="../css/style.css">

    <!-- Google Fonts Optimized -->
    <link rel="preload" href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" as="style">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" rel="stylesheet">

    <!-- Font Awesome (Optimized) -->
    <link rel="preload" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css" as="style">
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css"
          media="print"
          onload="this.media='all'">
    <noscript>
        <link rel="stylesheet"
              href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
    </noscript>

    <!-- Favicon -->
     <link rel="shortcut icon" href="../images/icon.svg" type="image/x-icon">
    

    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "WebSite",
      "@id": "https://www.morenews.org/#website",
      "url": "https://www.morenews.org/",
      "name": "More News"
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.morenews.org/#publisher",
      "name": "More News",
      "url": "https://www.morenews.org/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/logo.webp",
        "width": 512,
        "height": 512
      },
      "address": {
        "@type": "PostalAddress",
        "addressCountry": "GB"
      }
    },

    {
      "@type": "Person",
      "@id": "https://www.morenews.org/author/james-thornton#author",
      "name": "James Thornton",
      "url": "https://www.morenews.org/author/james-thornton",
      "jobTitle": "UK Reporter",
      "worksFor": {
        "@id": "https://www.morenews.org/#publisher"
      }
    },

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.morenews.org/uk/darren-jones-defends-rachel-reeves-for-misrepresenting-tax-increases-to-cabinet#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.morenews.org/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "UK",
          "item": "https://www.morenews.org/uk/uk"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "name": "Darren Jones backs Reeves over handling of tax rise claims",
          "item": "https://www.morenews.org/uk/darren-jones-defends-rachel-reeves-for-misrepresenting-tax-increases-to-cabinet"
        }
      ]
    },

    {
      "@type": "WebPage",
      "@id": "https://www.morenews.org/uk/darren-jones-defends-rachel-reeves-for-misrepresenting-tax-increases-to-cabinet#webpage",
      "url": "https://www.morenews.org/uk/darren-jones-defends-rachel-reeves-for-misrepresenting-tax-increases-to-cabinet",
      "name": "Darren Jones backs Reeves over handling of tax rise claims",
      "description": "Darren Jones defends Chancellor Rachel Reeves after claims she misrepresented looming tax rises to cabinet colleagues amid scrutiny of budget decisions.",
      "inLanguage": "en-GB",
      "isPartOf": {
        "@id": "https://www.morenews.org/#website"
      },
      "primaryImageOfPage": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/darren-jones-defends-rachel-reeves-for-misrepresenting-first-image.webp",
        "width": 1200,
        "height": 630
      },
      "breadcrumb": {
        "@id": "https://www.morenews.org/uk/darren-jones-defends-rachel-reeves-for-misrepresenting-tax-increases-to-cabinet#breadcrumb"
      }
    },

    {
      "@type": "NewsArticle",
      "@id": "https://www.morenews.org/uk/darren-jones-defends-rachel-reeves-for-misrepresenting-tax-increases-to-cabinet#article",
      "headline": "Darren Jones backs Reeves over handling of tax rise claims",
      "description": "Darren Jones defends Chancellor Rachel Reeves after claims she misrepresented looming tax rises to cabinet colleagues amid scrutiny of budget decisions.",
      "datePublished": "2025-12-01",
      "dateModified": "2025-12-01",
      "articleSection": "UK",
      "inLanguage": "en-GB",
      "author": {
        "@id": "https://www.morenews.org/author/uk-reporter#author"
      },
      "publisher": {
        "@id": "https://www.morenews.org/#publisher"
      },
      "image": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/darren-jones-defends-rachel-reeves-for-misrepresenting-first-image.webp",
        "width": 1200,
        "height": 630
      },
      "mainEntityOfPage": {
        "@id": "https://www.morenews.org/uk/darren-jones-defends-rachel-reeves-for-misrepresenting-tax-increases-to-cabinet#webpage"
      }
    }

  ]
}
</script>
<style>
  /* Apply styles to center the content */
.writer-block {
    font-family: "Noto Serif JP", serif;
  max-width: 540px;
  margin: 15px auto 10px auto;
  padding: 0px 0px;
  line-height: 1.7;
  color: #222;
}

/* Additional styles for mobile and desktop responsiveness */
.writer-date,
.writer-credit {
    margin-top: 10px;
    margin-bottom: 10px;
}

/* Optional: Adjustments for mobile view */
@media screen and (max-width: 768px) {
    .writer-block {
        padding: 10px;
    }
}

</style>

</head>


<body>

<!-- header -->
<?php include '../header.php'; ?>


    <div class="main-container">
        
        <section class="headline-rail">       
        </section>
        <div class="article-header">
            <h1 class="article-headline">
                Darren Jones defends Rachel Reeves for misrepresenting tax increases to cabinet
            </h1>

            <div class="article-breadcrumb">
                <a href="../uk/uk.php" title="uk" class="crumb-link">UK</a> ›
                <span class="crumb-current">Darren Jones defends Rachel Reeves for misrepresenting tax increases to cabinet</span>
            </div>

            <!--socail icon-->
            <?php include '../social.php'; ?>
            <div class="writer-block">
            <div class="author-info">
                <?php include '../uk-author.php'; ?>
            </div>
            <div class="writer-date" itemprop="datePublished" content="2025-12-01">Published Date: 1 December 2025</div>
            </div>
            
        </div>
        <div class="image-wrapper">
            <img src="../images/darren-jones-defends-rachel-reeves-for-misrepresenting-first-image.webp" alt="Darren Jones defends Rachel Reeves for misrepresenting tax increases to cabinet first image">
        </div>
        <div class="writer-block">


            <div class="story-text-wrap">
                <?php include '../share.php'; ?>
                <p>
                    Chancellor Rachel Reeves did not "mislead" Prime Minister Keir Starmer's chief secretary, Darren Jones, "in the slightest."
                </p>

                <p>
                    Reeves was accused of not informing the Cabinet and public that the OBR predicted a government surplus. This suggests she exaggerated the budgetary challenge to justify historic tax increases. OBR data released on Friday show that the watchdog notified the Treasury on October 31 that the spending deficit had been filled and the government was on pace for a £4.2 billion surplus.
                </p>
                <p>
                    Still, Reeves and Starmer warned for weeks that the state finances were so terrible they might not be able to implement campaign promises like decreasing income tax. Reeves' £26 billion budget included the largest tax rises in almost ten years. In an uncommon move, the OBR issued its budget estimates early to calm public finances concerns.
                </p>
                <p>
                    Jones told Mornings with Ridge and Frost listeners that Reeves was "right all along" about needing more money. He claimed early OBR estimates didn't account for the government's projected revenue to safeguard the economy from shocks.
                </p>
            </div>

        </div>
        <div class="image-wrapper">
            <img loading="lazy" src="../images/darren-jones-defends-rachel-reeves-for-misrepresenting-second-image.webp" alt="Darren Jones defends Rachel Reeves for misrepresenting tax increases to cabinet second image">
        </div>
        <div class="writer-block">

            <div class="story-text-wrap">

                <p>
                   He said, "The numbers kept changing before the budget; you don't know the final number until the end." "The chancellor increased it from £10 billion to around £20 billion because we needed more space."
                </p>

                <p>
                    Jones intervened after The Times reported that ministers were concerned Reeves hadn't addressed "the reality" of OBR forecasts. Opposition parties believe she misled voters and upended markets about the budget.
                </p>
                <p>
                    "Of course I didn't [lie]." Reeves told. She stated that the state budget was in peril and required harsh decisions.
                </p>
            </div>

        </div>
        <div class="image-wrapper">
            <img loading="lazy" src="../images/darren-jones-defends-rachel-reeves-for-misrepresenting-third-image.webp" alt="Darren Jones defends Rachel Reeves for misrepresenting tax increases to cabinet third image">
        </div>
        <div class="writer-block">
            <div class="story-text-wrap">
                <p>
                    Last budget day, the OBR predicted fiscal headroom would climb to £21.7 billion, above Treasury expectations. Reeves thinks the government needs this cushion to respond promptly to economic shocks.
                </p>

                <p>
                    When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper
                    surface of the impenetrable foliage of my trees, and but a few stray gleams steal into the inner
                    sanctuary, I throw myself down among the tall grass by the trickling stream; and, as I lie close to
                    the earth, a thousand unknown plants are noticed by me: when I hear the buzz.
                </p>
                <p>
                    Prime Minister Sir Keir Starmer will defend the budget on Monday. He will argue it "moves forward the government's program of national renewal" and restores UK economic policy after years of disarray.
                </p>
                
            </div>

        </div>
        
        <div class="writer-block">
            
            <div class="suggested-box">
                <h3 class="suggested-heading">UK News</h3>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/uk-special-forces-accused-of-policy-to-kill-afghan-first-image.webp"
                            alt="UK special forces accused of policy to kill Afghan fighting-age men" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../uk/uk-special-forces-accused-of-policy-to-kill-afghan-fighting-age-men.php" title="UK special forces accused of policy to kill Afghan fighting-age men" class="suggested-title">UK special forces accused of policy to kill Afghan fighting-age men</a>
                        <span class="suggested-date">1 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/whats-new-in-this-months-redesigned-uk-passports-first-image.webp"
                            alt="What’s new in this month’s redesigned UK passports?" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../uk/whats-new-in-this-months-redesigned-uk-passports.php" title="What’s new in this month’s redesigned UK passports?" class="suggested-title">What’s new in this month’s redesigned UK passports?</a>
                        <span class="suggested-date">1 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/starmer-reeves-the-pm-denies-misleading-the-cabinet-first-image.webp"
                            alt="Starmer-Reeves : The PM denies misleading the cabinet or voters while insisting he is proud of the budget" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../uk/starmer-reeves-the-pm-denies-misleading-the-cabinet-or-voters.php" title="Starmer-Reeves : The PM denies misleading the cabinet or voters while insisting he is proud of the budget" class="suggested-title">Starmer-Reeves : The PM denies misleading the cabinet or voters while insisting he is "proud" of the budget</a>
                        <span class="suggested-date">1 December 2025</span>
                    </div>
                </div>
            </div>

            
        </div>
 <!-- popular and other news -->
     <?php include '../popular-other-news.php'; ?>

<!-- footer -->
<?php include '../footer.php'; ?>       


    </div>
    <button onclick="window.scrollTo({top:0, behavior:'smooth'});" class="scrollup-btn" aria-label="Scroll to top">
    <i class="fa-solid fa-chevron-up" aria-hidden="true"></i>
    </button>
    <!-- <script src="../js/style.js"></script> -->
</body>

</html>