<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Title -->
    <title>MBDA UK wins £316m laser anti drone deal for Navy</title>
    <meta name="title" content="MBDA UK wins £316m laser anti drone deal for Navy">

    <meta name="author" content="Oliver Grant">
    <!-- Meta Description -->
    <meta name="description"
        content="MBDA UK has secured a £316 million contract to deliver laser based anti drone technology for the Royal Navy, strengthening defences against emerging aerial threats.">

    <!-- Canonical -->
    <link rel="canonical"
        href="https://www.morenews.org/tech/mbda-uk-wins-316-million-contract-for-laser-based-anti-drone-technology-for-the-royal-navy">

    <!-- Open Graph -->
    <meta property="og:title" content="MBDA UK wins £316m laser anti drone deal for Navy">
    <meta property="og:description"
        content="MBDA UK has secured a £316 million contract to deliver laser based anti drone technology for the Royal Navy, strengthening defences against emerging aerial threats.">
    <meta property="og:url"
        content="https://www.morenews.org/tech/mbda-uk-wins-316-million-contract-for-laser-based-anti-drone-technology-for-the-royal-navy">
    <meta property="og:image"
        content="https://www.morenews.org/images/mbda-uk-wins-316-million-contract-for-laser-based-anti-drone-technology.webp">
    <meta property="og:site_name" content="More News">
    <meta property="og:type" content="article">
    <meta property="og:locale" content="en_GB">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">

    <!-- Twitter Cards -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="MBDA UK wins £316m laser anti drone deal for Navy">
    <meta name="twitter:description"
        content="MBDA UK has secured a £316 million contract to deliver laser based anti drone technology for the Royal Navy, strengthening defences against emerging aerial threats.">
    <meta name="twitter:image"
        content="https://www.morenews.org/images/mbda-uk-wins-316-million-contract-for-laser-based-anti-drone-technology.webp">
    <meta name="twitter:url"
        content="https://www.morenews.org/tech/mbda-uk-wins-316-million-contract-for-laser-based-anti-drone-technology-for-the-royal-navy">
    <meta name="twitter:site" content="@morenews">
    <meta name="twitter:creator" content="@morenews">

    <!-- Styles -->
    <link rel="preload" href="../css/style.css" as="style">
    <link rel="stylesheet" href="../css/style.css">

    <!-- Google Fonts Optimized -->
    <link rel="preload" href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" as="style">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" rel="stylesheet">

    <!-- Font Awesome (Optimized) -->
    <link rel="preload" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css" as="style">
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css"
          media="print"
          onload="this.media='all'">
    <noscript>
        <link rel="stylesheet"
              href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
    </noscript>

    <!-- Favicon -->
    <link rel="shortcut icon" href="../favicon.ico" type="image/x-icon">

    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "WebSite",
      "@id": "https://www.morenews.org/#website",
      "url": "https://www.morenews.org/",
      "name": "More News"
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.morenews.org/#publisher",
      "name": "More News",
      "url": "https://www.morenews.org/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/logo.webp",
        "width": 512,
        "height": 512
      },
      "address": {
        "@type": "PostalAddress",
        "addressCountry": "GB"
      }
    },

    {
      "@type": "Person",
      "@id": "https://www.morenews.org/author/oliver-grant#author",
      "name": "Oliver Grant",
      "url": "https://www.morenews.org/author/oliver-grant",
      "jobTitle": "Technology Reporter",
      "worksFor": {
        "@id": "https://www.morenews.org/#publisher"
      }
    },

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.morenews.org/tech/mbda-uk-wins-316-million-contract-for-laser-based-anti-drone-technology-for-the-royal-navy#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.morenews.org/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Tech",
          "item": "https://www.morenews.org/tech/tech"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "name": "MBDA UK wins £316m laser anti drone deal for Navy",
          "item": "https://www.morenews.org/tech/mbda-uk-wins-316-million-contract-for-laser-based-anti-drone-technology-for-the-royal-navy"
        }
      ]
    },

    {
      "@type": "WebPage",
      "@id": "https://www.morenews.org/tech/mbda-uk-wins-316-million-contract-for-laser-based-anti-drone-technology-for-the-royal-navy#webpage",
      "url": "https://www.morenews.org/tech/mbda-uk-wins-316-million-contract-for-laser-based-anti-drone-technology-for-the-royal-navy",
      "name": "MBDA UK wins £316m laser anti drone deal for Navy",
      "description": "MBDA UK has secured a £316 million contract to deliver laser based anti drone technology for the Royal Navy, strengthening defences against emerging aerial threats.",
      "inLanguage": "en-GB",
      "isPartOf": {
        "@id": "https://www.morenews.org/#website"
      },
      "primaryImageOfPage": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/mbda-uk-wins-316-million-contract-for-laser-based-anti-drone-technology.webp",
        "width": 1200,
        "height": 630
      },
      "breadcrumb": {
        "@id": "https://www.morenews.org/tech/mbda-uk-wins-316-million-contract-for-laser-based-anti-drone-technology-for-the-royal-navy#breadcrumb"
      }
    },

    {
      "@type": "NewsArticle",
      "@id": "https://www.morenews.org/tech/mbda-uk-wins-316-million-contract-for-laser-based-anti-drone-technology-for-the-royal-navy#article",
      "headline": "MBDA UK wins £316m laser anti drone deal for Navy",
      "description": "MBDA UK has secured a £316 million contract to deliver laser based anti drone technology for the Royal Navy, strengthening defences against emerging aerial threats.",
      "datePublished": "2025-12-10",
      "dateModified": "2025-12-10",
      "articleSection": "Tech",
      "inLanguage": "en-GB",
      "author": {
        "@id": "https://www.morenews.org/author/oliver-grant#author"
      },
      "publisher": {
        "@id": "https://www.morenews.org/#publisher"
      },
      "image": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/mbda-uk-wins-316-million-contract-for-laser-based-anti-drone-technology.webp",
        "width": 1200,
        "height": 630
      },
      "mainEntityOfPage": {
        "@id": "https://www.morenews.org/tech/mbda-uk-wins-316-million-contract-for-laser-based-anti-drone-technology-for-the-royal-navy#webpage"
      }
    }

  ]
}
</script>

<style>
  /* Apply styles to center the content */
.writer-block {
    font-family: "Noto Serif JP", serif;
  max-width: 540px;
  margin: 15px auto 10px auto;
  padding: 0px 0px;
  line-height: 1.7;
  color: #222;
}

/* Additional styles for mobile and desktop responsiveness */
.writer-date,
.writer-credit {
    margin-top: 10px;
    margin-bottom: 10px;
}

/* Optional: Adjustments for mobile view */
@media screen and (max-width: 768px) {
    .writer-block {
        padding: 10px;
    }
}

</style>

</head>


<body>

<!-- header -->
<?php include '../header.php'; ?>


    <div class="main-container">
        
        <section class="headline-rail">       
        </section>
        <div class="article-header">
            <h1 class="article-headline">
                MBDA UK wins £316 million contract for laser-based anti-drone technology for the Royal Navy
            </h1>

            <div class="article-breadcrumb">
                <a href="../tech/tech.php" title="tech" class="crumb-link">Tech</a> ›
                <span class="crumb-current">MBDA UK wins £316 million contract for laser-based anti-drone technology for the Royal Navy</span>
            </div>

            <!--socail icon-->
            <?php include '../social.php'; ?>
            <div class="writer-block">
            <div class="author-info">
                <?php include '../tech-author.php'; ?>
            </div>
            <div class="writer-date" itemprop="datePublished" content="2025-12-10">Published Date: 10 December 2025</div>
            </div>
            
        </div>
        <div class="image-wrapper">
            <img src="../images/mbda-uk-wins-316-million-contract-for-laser-based-anti-drone-technology.webp" alt="MBDA UK wins £316 million contract for laser-based anti-drone technology for the Royal Navy">
        </div>
        <div class="writer-block">
            

            <div class="story-text-wrap">
                <p>
                    The UK government has awarded defence manufacturer MBDA UK a £316 million contract to deliver the first operational batch of its DragonFire laser weapon system, marking a major step forward in the military’s efforts to counter fast-emerging drone threats.
                </p>

                <p>
                    The system, which has been in development for several years through a partnership involving MBDA, Leonardo UK and QinetiQ, will form part of a wider modernisation programme aimed at strengthening Britain’s defensive capabilities against low-cost, high-speed aerial attacks.
                </p>

                <h3>A new tool against drone warfare</h3>
                <p>
                    Laser-based weapons are viewed as a significant shift in defence strategy. Instead of firing missiles costing hundreds of thousands of pounds, DragonFire uses a highly focused beam of light to disable or destroy hostile drones. Once installed — currently expected by 2027 on a Type 45 destroyer — the system will be able to track and neutralise targets at long range.
                </p>
                <p>
                    Defense officials say that one of the main benefits is the low cost.   Each firing costs about £10, which is a lot less than the cost of traditional interceptors.   This could change how the Royal Navy responds to swarm attacks and other asymmetric threats, since the service is dealing with more and more erratic drone activity in disputed waters.
                </p>
            </div>

        </div>
        <div class="image-wrapper">
            <img loading="lazy" src="../images/mbda-uk-wins-316-million-contract-for-laser-based-anti-drone-technology-second-image.webp" alt="MBDA UK wins £316 million contract for laser-based anti-drone technology for the Royal Navy second image">
        </div>
        <div class="writer-block">

            <div class="story-text-wrap">
                <h3>A step forward for the UK's defense sector</h3>
                <p>
                   The contract is also expected to help hundreds of specialized engineering and manufacturing jobs in the UK.   The government wants to make Britain a leader in the growing global market for directed-energy weapons by investing in systems like DragonFire.
                </p>

                <p>
                    Industry analysts say the programme will feed research into related technologies — including advanced sensors, power-storage systems and tracking software — which could later find civilian applications in fields such as aviation, energy and robotics.
                </p>
                <h3>Why it matters</h3>
                <p>
                    The deal underscores how quickly modern warfare is changing. With drones becoming cheaper, more agile and more widely used in conflict zones, the UK is under pressure to find cost-effective ways to defend ships, bases and critical infrastructure.
                </p>
                <p>
                    DragonFire represents one of the most ambitious attempts yet to produce a home-grown high-energy laser weapon capable of front-line service. If successful, it could reshape the Royal Navy’s defensive toolkit — and signal that Britain intends to remain a serious technological player in the next era of military innovation.
                </p>
            </div>

        </div>
        
        
        <div class="writer-block">
            
            <div class="suggested-box">
                <h3 class="suggested-heading">Tech</h3>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/ai-adoption-slashes-workloads-at-uk-firms-first-image.webp"
                            alt="AI adoption slashes workloads at UK firms – and may offer a long-awaited boost to national productivity" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../tech/ai-adoption-slashes-workloads-at-uk-firms.php"
                             title="AI adoption slashes workloads at UK firms – and may offer a long-awaited boost to national productivity" class="suggested-title">AI adoption slashes workloads at UK firms – and may offer a long-awaited boost to national productivity</a>
                        <span class="suggested-date">11 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/nhs-trials-next-generation-medical-technologies-from-ai-diagnostics-first-image.webp"
                            alt="NHS Trials Next-Generation Medical Technologies, from AI Diagnostics to 3D Imaging first iamge" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../tech/nhs-trials-next-generation-medical-technologies-from-ai-diagnostics.php" 
                            title="NHS Trials Next-Generation Medical Technologies, from AI Diagnostics to 3D Imaging" class="suggested-title">NHS Trials Next-Generation Medical Technologies, from AI Diagnostics to 3D Imaging</a>
                        <span class="suggested-date">11 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/uk-defence-tech-accelerates-with-breakthroughn-in-robotics-first-image.webp"
                            alt="UK Defence Tech Accelerates with Breakthroughs in Robotics, Undersea Systems and AI first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../tech/uk-defence-tech-accelerates-with-breakthroughn-in-robotics.php"
                             title="UK Defence Tech Accelerates with Breakthroughs in Robotics, Undersea Systems and AI" class="suggested-title">UK Defence Tech Accelerates with Breakthroughs in Robotics, Undersea Systems and AI</a>
                        <span class="suggested-date">11 December 2025</span>
                    </div>
                </div>
            </div>

            
        </div>
        
<!-- popular and other news -->
     <?php include '../popular-other-news.php'; ?>

<!-- footer -->
<?php include '../footer.php'; ?>

    </div>
    <button onclick="window.scrollTo({top:0, behavior:'smooth'});" class="scrollup-btn" aria-label="Scroll to top">
    <i class="fa-solid fa-chevron-up" aria-hidden="true"></i>
    </button>
    <!-- <script src="../js/style.js"></script> -->
</body>

</html>