<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- SEO -->
    <title>Sports News – UK Football, F1, Cricket & Global Sport</title>
    <meta name="title" content="Sports News – UK Football, F1, Cricket & Global Sport">

    <!-- Meta Description (155 chars) -->
    <meta name="description"
        content="Latest sports news from the UK and around the world covering football, Formula 1, cricket, cycling, darts and major global sporting events.">

    <!-- Canonical -->
    <link rel="canonical" href="https://www.morenews.org/sports/sports">

    <!-- Open Graph -->
    <meta property="og:title" content="Sports News – UK Football, F1, Cricket & Global Sport">
    <meta property="og:description"
        content="Latest sports news from the UK and around the world covering football, Formula 1, cricket, cycling, darts and major global sporting events.">
    <meta property="og:url" content="https://www.morenews.org/sports/sports">
    <meta property="og:image" content="https://www.morenews.org/images/sports-category.webp">
    <meta property="og:site_name" content="More News">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_GB">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">

    <!-- Twitter Cards -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Sports News – UK Football, F1, Cricket & Global Sport">
    <meta name="twitter:description"
        content="Latest sports news from the UK and around the world covering football, Formula 1, cricket, cycling, darts and major global sporting events.">
    <meta name="twitter:url" content="https://www.morenews.org/sports/sports">
    <meta name="twitter:image" content="https://www.morenews.org/images/sports-category.webp">
    <meta name="twitter:site" content="@morenews">
    <meta name="twitter:creator" content="@morenews">

    <!-- Fonts -->
    <link rel="preload" href="../css/style.css" as="style">
    <link rel="stylesheet" href="../css/style.css">

    <!-- Google Fonts Optimized -->
    <link rel="preload" href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" as="style">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" rel="stylesheet">

    <!-- Font Awesome (Optimized) -->
    <link rel="preload" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css" as="style">
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css"
          media="print"
          onload="this.media='all'">
    <noscript>
        <link rel="stylesheet"
              href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
    </noscript>

    <!-- Favicon -->
    <link rel="shortcut icon" href="../favicon.ico" type="image/x-icon">

    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "WebSite",
      "@id": "https://www.morenews.org/#website",
      "url": "https://www.morenews.org/",
      "name": "More News",
      "publisher": {
        "@id": "https://www.morenews.org/#publisher"
      }
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.morenews.org/#publisher",
      "name": "More News",
      "url": "https://www.morenews.org/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/logo.webp",
        "width": 512,
        "height": 512
      }
    },

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.morenews.org/sports/sports#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.morenews.org/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Sports",
          "item": "https://www.morenews.org/sports/sports"
        }
      ]
    },

    {
      "@type": "CollectionPage",
      "@id": "https://www.morenews.org/sports/sports#collection",
      "name": "Sports News – UK Football, F1, Cricket & Global Sport",
      "description": "Latest sports news from the UK and around the world covering football, Formula 1, cricket, cycling, darts and major global sporting events.",
      "url": "https://www.morenews.org/sports/sports",
      "inLanguage": "en-GB",
      "isPartOf": {
        "@id": "https://www.morenews.org/#website"
      },
      "address": {
        "@type": "PostalAddress",
        "addressCountry": "GB"
      }
    },

    {
      "@type": "WebPage",
      "@id": "https://www.morenews.org/sports/sports#webpage",
      "url": "https://www.morenews.org/sports/sports",
      "name": "Sports News – UK Football, F1, Cricket & Global Sport",
      "description": "Independent sports reporting covering football, motorsport, cricket, cycling, darts and major international sporting competitions.",
      "inLanguage": "en-GB",
      "primaryImageOfPage": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/sports-category.webp",
        "width": 1200,
        "height": 630
      },
      "dateModified": "2025-12-15",
      "breadcrumb": {
        "@id": "https://www.morenews.org/sports/sports#breadcrumb"
      },
      "isPartOf": {
        "@id": "https://www.morenews.org/#website"
      }
    },

    {
      "@type": "ItemList",
      "@id": "https://www.morenews.org/sports/sports#itemlist",
      "name": "Sports Category Articles",
      "itemListOrder": "http://schema.org/ItemListOrderDescending",
      "itemListElement": [

        {
          "@type": "ListItem",
          "position": 1,
          "url": "https://www.morenews.org/sports/british-drivers-reflect-at-fia-prize-giving-as-formula-one-season",
          "name": "British Drivers Reflect at FIA Prize Giving as Formula 1 Season Draws to a Close"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "url": "https://www.morenews.org/sports/team-gb-cyclists-set-sights-on-2026-season-as-british-cycling",
          "name": "Team GB Cyclists Set Sights on 2026 Season as British Cycling Outlines New Targets"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "url": "https://www.morenews.org/sports/fa-to-raise-world-cup-ticket-concerns-with-fifa",
          "name": "FA to Raise World Cup Ticket Concerns with FIFA"
        },
        {
          "@type": "ListItem",
          "position": 4,
          "url": "https://www.morenews.org/sports/world-darts-championship-under-way-at-alexandra-palace",
          "name": "World Darts Championship Under Way at Alexandra Palace"
        }

      ]
    }

  ]
}
</script>

</head>



<body>

<!-- header -->
<?php include '../header.php'; ?>

    <div class="main-container">

        <section class="headline-rail">
 
        </section>
        <div class="world-header-shell">
            <div class="world-headline-box">
                <h1 class="world-headline-text">Sports</h1>
            </div>
        </div>
        <div class="news-wrapper-unique">
            <div class="news-grid-unique">

                <div class="main-article-unique">
                    <img src="../images/british-drivers-reflect-at-fia-prize-giving-as-formula-one-season-first-image.webp"
                        alt="British Drivers Reflect at FIA Prize Giving as Formula 1 Season Draws to a Close first image">
                    <div class="main-sec">
                        <h2><a href="../sports/british-drivers-reflect-at-fia-prize-giving-as-formula-one-season.php" title="British Drivers Reflect at FIA Prize Giving as Formula 1 Season Draws to a Close" class="title-link">British Drivers Reflect at FIA Prize Giving as Formula 1 Season Draws to a Close</a></h2>
                        <div class="main-article-meta">
                            <span>Sports</span> | <span>Callum Fraser</span>
                        </div>
                    </div>
                </div>
                

                <div class="side-articles-unique">

                    <div class="side-article-unique">
                        <div class="side-article-text">
                            <h3><a href="../sports/team-gb-cyclists-set-sights-on-2026-season-as-british-cycling.php" title="Team GB Cyclists Set Sights on 2026 Season as British Cycling Outlines New Targets" class="title-link">Team GB Cyclists Set Sights on 2026 Season as British Cycling Outlines New Targets</a></h3>
                            
                            <div class="side-meta"><span>Sports</span> Callum Fraser</div>
                        </div>
                        <img loading="lazy" src="../images/team-gb-cyclists-set-sights-on-2026-season-as-british-cycling-first-image.webp"
                        alt="Team GB Cyclists Set Sights on 2026 Season as British Cycling Outlines New Targets first image">
                    </div>

                    <div class="side-article-unique">
                        <div class="side-article-text">
                            <h3><a href="../sports/fa-to-raise-world-cup-ticket-concerns-with-fifa.php" title="FA to raise World Cup ticket concerns with FIFA" class="title-link">FA to raise World Cup ticket concerns with FIFA</a></h3>
                
                            <div class="side-meta"><span>Sports</span> Callum Fraser</div>
                        </div>
                        <img loading="lazy" src="../images/fa-to-raise-world-cup-ticket-concerns-with-fifa-first-image.webp"
                            alt="FA to raise World Cup ticket concerns with FIFA first image">
                    </div>

                    <div class="side-article-unique">
                        <div class="side-article-text">
                            <h3><a href="../sports/world-darts-championship-under-way-at-alexandra-palace.php" title="World Darts Championship Under Way at Alexandra Palace" class="title-link">World Darts Championship Under Way at Alexandra Palace</a></h3>
     
                            <div class="side-meta"><span>Sports</span> Callum Fraser</div>
                        </div>
                        <img loading="lazy" src="../images/world-darts-championship-under-way-at-alexandra-palace-first-image.webp"
                            alt="World Darts Championship Under Way at Alexandra Palace first image">
                    </div>

                     
                   
                    

                </div>
            </div>
        </div>


        


        <!-- footer -->
        <?php include '../footer.php'; ?>


    </div>
    <button onclick="window.scrollTo({top:0, behavior:'smooth'});" class="scrollup-btn" aria-label="Scroll to top">
    <i class="fa-solid fa-chevron-up" aria-hidden="true"></i>
    </button>
    <!-- <script src="../js/style.js"></script> -->
</body>

</html>