<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Title -->
    <title>FA to raise World Cup ticket concerns with FIFA body UK</title>
    <meta name="title" content="FA to raise World Cup ticket concerns with FIFA body UK">

    <!-- Meta Description (155 chars) -->
    <meta name="description"
        content="The FA will raise concerns with FIFA over World Cup ticket prices, warning that rising costs could price England supporters out of attending matches soon!">

        <meta name="author" content="Callum Fraser">
    <!-- Canonical -->
    <link rel="canonical"
        href="https://www.morenews.org/sports/fa-to-raise-world-cup-ticket-concerns-with-fifa">

    <!-- Open Graph -->
    <meta property="og:title" content="FA to raise World Cup ticket concerns with FIFA body UK">
    <meta property="og:description"
        content="The FA will raise concerns with FIFA over World Cup ticket prices, warning that rising costs could price England supporters out of attending matches soon!">
    <meta property="og:url"
        content="https://www.morenews.org/sports/fa-to-raise-world-cup-ticket-concerns-with-fifa">
    <meta property="og:image"
        content="https://www.morenews.org/images/fa-to-raise-world-cup-ticket-concerns-with-fifa-first-image.webp">
    <meta property="og:site_name" content="More News">
    <meta property="og:type" content="article">
    <meta property="og:locale" content="en_GB">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">

    <!-- Twitter Cards -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="FA to raise World Cup ticket concerns with FIFA body UK">
    <meta name="twitter:description"
        content="The FA will raise concerns with FIFA over World Cup ticket prices, warning that rising costs could price England supporters out of attending matches soon!">
    <meta name="twitter:image"
        content="https://www.morenews.org/images/fa-to-raise-world-cup-ticket-concerns-with-fifa-first-image.webp">
    <meta name="twitter:url"
        content="https://www.morenews.org/sports/fa-to-raise-world-cup-ticket-concerns-with-fifa">
    <meta name="twitter:site" content="@morenews">
    <meta name="twitter:creator" content="@morenews">

    <!-- Fonts -->
    <link rel="preload" href="../css/style.css" as="style">
    <link rel="stylesheet" href="../css/style.css">

    <!-- Google Fonts Optimized -->
    <link rel="preload" href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" as="style">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" rel="stylesheet">

    <!-- Font Awesome (Optimized) -->
    <link rel="preload" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css" as="style">
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css"
          media="print"
          onload="this.media='all'">
    <noscript>
        <link rel="stylesheet"
              href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
    </noscript>

    <!-- Favicon -->
    <link rel="shortcut icon" href="../favicon.ico" type="image/x-icon">

    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "WebSite",
      "@id": "https://www.morenews.org/#website",
      "url": "https://www.morenews.org/",
      "name": "More News"
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.morenews.org/#publisher",
      "name": "More News",
      "url": "https://www.morenews.org/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/logo.webp",
        "width": 512,
        "height": 512
      },
      "address": {
        "@type": "PostalAddress",
        "addressCountry": "GB"
      }
    },

    {
      "@type": "Person",
      "@id": "https://www.morenews.org/author/callum-fraser#author",
      "name": "Callum Fraser",
      "url": "https://www.morenews.org/author/callum-fraser",
      "jobTitle": "Sports Reporter",
      "worksFor": {
        "@id": "https://www.morenews.org/#publisher"
      }
    },

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.morenews.org/sports/fa-to-raise-world-cup-ticket-concerns-with-fifa#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.morenews.org/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Sports",
          "item": "https://www.morenews.org/sports/sports"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "name": "FA to raise World Cup ticket concerns with FIFA body UK",
          "item": "https://www.morenews.org/sports/fa-to-raise-world-cup-ticket-concerns-with-fifa"
        }
      ]
    },

    {
      "@type": "WebPage",
      "@id": "https://www.morenews.org/sports/fa-to-raise-world-cup-ticket-concerns-with-fifa#webpage",
      "url": "https://www.morenews.org/sports/fa-to-raise-world-cup-ticket-concerns-with-fifa",
      "name": "FA to raise World Cup ticket concerns with FIFA body UK",
      "description": "The FA will raise concerns with FIFA over World Cup ticket prices, warning that rising costs could price England supporters out of attending matches soon!",
      "inLanguage": "en-GB",
      "isPartOf": {
        "@id": "https://www.morenews.org/#website"
      },
      "primaryImageOfPage": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/fa-to-raise-world-cup-ticket-concerns-with-fifa-first-image.webp",
        "width": 1200,
        "height": 630
      },
      "breadcrumb": {
        "@id": "https://www.morenews.org/sports/fa-to-raise-world-cup-ticket-concerns-with-fifa#breadcrumb"
      }
    },

    {
      "@type": "NewsArticle",
      "@id": "https://www.morenews.org/sports/fa-to-raise-world-cup-ticket-concerns-with-fifa#article",
      "headline": "FA to raise World Cup ticket concerns with FIFA body UK",
      "description": "The FA will raise concerns with FIFA over World Cup ticket prices, warning that rising costs could price England supporters out of attending matches soon!",
      "datePublished": "2025-12-13",
      "dateModified": "2025-12-13",
      "articleSection": "Sports",
      "inLanguage": "en-GB",
      "author": {
        "@id": "https://www.morenews.org/author/callum-fraser#author"
      },
      "publisher": {
        "@id": "https://www.morenews.org/#publisher"
      },
      "image": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/fa-to-raise-world-cup-ticket-concerns-with-fifa-first-image.webp",
        "width": 1200,
        "height": 630
      },
      "mainEntityOfPage": {
        "@id": "https://www.morenews.org/sports/fa-to-raise-world-cup-ticket-concerns-with-fifa#webpage"
      }
    }

  ]
}
</script>

<style>
  /* Apply styles to center the content */
.writer-block {
    font-family: "Noto Serif JP", serif;
  max-width: 540px;
  margin: 15px auto 10px auto;
  padding: 0px 0px;
  line-height: 1.7;
  color: #222;
}

/* Additional styles for mobile and desktop responsiveness */
.writer-date,
.writer-credit {
    margin-top: 10px;
    margin-bottom: 10px;
}

/* Optional: Adjustments for mobile view */
@media screen and (max-width: 768px) {
    .writer-block {
        padding: 10px;
    }
}

</style>

</head>


<body>

<?php include '../header.php'; ?>


    <div class="main-container">
        
        <section class="headline-rail">       
        </section>
        <div class="article-header">
            <h1 class="article-headline">
               FA to raise World Cup ticket concerns with FIFA
            </h1>

            <div class="article-breadcrumb">
                <a href="../sports/sports.php" title="sports" class="crumb-link">Sports</a> ›
                <span class="crumb-current">FA to raise World Cup ticket concerns with FIFA</span>
            </div>

            <!--socail icon-->
            <?php include '../social.php'; ?>
            <div class="writer-block">
            <div class="author-info">
                <?php include '../sports-author.php'; ?>
            </div>
            <div class="writer-date" itemprop="datePublished" content="2025-12-13">Published Date: 13 December 2025</div>
            </div>
            
        </div>
        <div class="image-wrapper">
            <img src="../images/fa-to-raise-world-cup-ticket-concerns-with-fifa-first-image.webp" alt="FA to raise World Cup ticket concerns with FIFA first image">
        </div>
        <div class="writer-block">
           

            <div class="story-text-wrap">
                <
                <p>
                The Football Association is set to formally raise concerns with FIFA over the cost of tickets for the 2026 World Cup, following growing frustration among England supporters worried they may be priced out of the tournament.
            </p>

                <p>
               Fans have voiced anger over early indications that ticket prices for the expanded World Cup — which will be hosted across the United States, Canada and Mexico — could be significantly higher than previous editions. Supporters’ groups say the rising costs risk turning football’s biggest tournament into an event only accessible to wealthier fans.
            </p>
                <p>
                The FA confirmed it plans to reflect these concerns directly to FIFA, stressing the importance of affordability and fair access for travelling supporters. Officials are understood to be particularly worried about the impact on loyal fans who regularly follow England abroad but may struggle with soaring ticket prices alongside accommodation and travel costs.
            </p>
                <p>
            An FA spokesperson said the organisation was “listening carefully to supporters” and recognised that cost remains a major barrier. “England fans play a huge role in creating the atmosphere at major tournaments,” the spokesperson said. “It’s important that their voices are heard.”
            </p>
        <p>
        The 2026 World Cup will be the largest in the competition’s history, featuring 48 teams and matches spread across multiple cities. While FIFA has argued that the scale of the event brings higher operational costs, critics say supporters should not shoulder the financial burden.
        </p>
            </div>

        </div>
        <div class="image-wrapper">
            <img loading="lazy" src="../images/fa-to-raise-world-cup-ticket-concerns-with-fifa-second-image.webp" alt="FA to raise World Cup ticket concerns with FIFA second image">
        </div>
        <div class="writer-block">

            <div class="story-text-wrap">
                <p>
               Supporter groups have warned that high prices could undermine the spirit of the tournament. “Fans are the lifeblood of football,” one England supporters’ representative said. “If ordinary supporters can’t afford to attend, the World Cup risks losing what makes it special.”
            </p>

                <p>
                    Ticket pricing has long been a sensitive issue in international football. At recent tournaments, supporters have complained of rising costs and complex ticketing systems, with some fans paying hundreds of pounds for single matches.
                </p>
                <p>
                    The FA’s intervention reflects broader concern across European football associations, many of which are facing similar pressure from fans. While the FA does not control ticket pricing, its role as a member association allows it to lobby FIFA on behalf of supporters.
                </p>
                <p>
                   FIFA has yet to confirm final ticket prices for the 2026 tournament, though details are expected to be released next year. In the meantime, the FA says it will continue discussions to ensure fan interests are represented.
                </p>
                <p>
                    For England supporters dreaming of following their team on the world’s biggest stage, the hope is that football’s governing bodies can strike a balance between commercial realities and keeping the game accessible.
                </p>
                <p>
                    As one fan put it: “The World Cup should be about football, not bank balances.”
                </p>    

            </div>

        </div>


        
        <div class="writer-block">
            
            <div class="suggested-box">
                <h3 class="suggested-heading">Sports</h3>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/world-darts-championship-under-way-at-alexandra-palace-first-image.webp"
                            alt="World Darts Championship Under Way at Alexandra Palace first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../sports/world-darts-championship-under-way-at-alexandra-palace.php" title="World Darts Championship Under Way at Alexandra Palace" class="suggested-title">World Darts Championship Under Way at Alexandra Palace</a>
                        <span class="suggested-date">11 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/british-drivers-reflect-at-fia-prize-giving-as-formula-one-season-first-image.webp"
                        alt="British Drivers Reflect at FIA Prize Giving as Formula 1 Season Draws to a Close first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../sports/british-drivers-reflect-at-fia-prize-giving-as-formula-one-season.php" title="British Drivers Reflect at FIA Prize Giving as Formula 1 Season Draws to a Close" class="suggested-title">British Drivers Reflect at FIA Prize Giving as Formula 1 Season Draws to a Close</a>
                        <span class="suggested-date">14 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/team-gb-cyclists-set-sights-on-2026-season-as-british-cycling-first-image.webp"
                        alt="Team GB Cyclists Set Sights on 2026 Season as British Cycling Outlines New Targets first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../sports/team-gb-cyclists-set-sights-on-2026-season-as-british-cycling.php" title="Team GB Cyclists Set Sights on 2026 Season as British Cycling Outlines New Targets" class="suggested-title">Team GB Cyclists Set Sights on 2026 Season as British Cycling Outlines New Targets</a>
                        <span class="suggested-date">14 December 2025</span>
                    </div>
                </div>
            </div>

        </div>
        


<!-- footer -->
<?php include '../footer.php'; ?>

    </div>
    <button onclick="window.scrollTo({top:0, behavior:'smooth'});" class="scrollup-btn" aria-label="Scroll to top">
    <i class="fa-solid fa-chevron-up" aria-hidden="true"></i>
    </button>
    <!-- <script src="../js/style.js"></script> -->
</body>

</html>