<!-- SHARE DROPDOWN -->
                <div class="share-dropdown-x">
                  <button class="share-trigger-x" aria-label="Share article">
                    <img src="../images/shares.webp" width="25px" height="25px" alt="Share">
                  </button>
                  <div class="share-menu-x">
                    <a href="#" data-share="twitter" aria-label="Share on X">
                      <img src="../images/x.webp" height="25px" width="25px" alt="X">
                    </a>
                    <a href="#" data-share="facebook" aria-label="Share on Facebook">
                      <img src="../images/facebook.webp" height="25px" width="25px" alt="Facebook">
                    </a>
                    <a href="#" data-share="linkedin" aria-label="Share on LinkedIn">
                      <img src="../images/linkedin.webp" height="25px" width="25px" alt="LinkedIn">
                    </a>
                    <a href="#" data-share="reddit" aria-label="Share on Reddit">
                      <img src="../images/reddit.webp" height="25px" width="25px" alt="Reddit">
                    </a>
                  </div>
                </div>


<!-- SHARE DROPDOWN SCRIPT -->
 <script>
(function () {
  if (window.__shareInit) return;
  window.__shareInit = true;

  document.addEventListener("click", function (e) {
    const btn = e.target.closest(".share-trigger-x");
    const dropdown = btn?.closest(".share-dropdown-x");
    const menu = dropdown?.querySelector(".share-menu-x");

    // Toggle dropdown
    if (btn && menu) {
      e.stopPropagation();

      const rect = btn.getBoundingClientRect();

      menu.style.top = rect.bottom + 8 + "px";
      menu.style.left = rect.left + "px";

      menu.classList.toggle("active");
      return;
    }

    // Share links
    const link = e.target.closest(".share-menu-x a");
    if (link) {
      e.preventDefault();

      const url = encodeURIComponent(window.location.href);
      const title = encodeURIComponent(document.title);
      let shareUrl = "";

      switch (link.dataset.share) {
        case "twitter":
          shareUrl = `https://twitter.com/intent/tweet?text=${title}&url=${url}`;
          break;
        case "facebook":
          shareUrl = `https://www.facebook.com/sharer/sharer.php?u=${url}`;
          break;
        case "linkedin":
          shareUrl = `https://www.linkedin.com/sharing/share-offsite/?url=${url}`;
          break;
        case "reddit":
          shareUrl = `https://www.reddit.com/submit?url=${url}&title=${title}`;
          break;
      }

      if (shareUrl) {
        window.open(shareUrl, "_blank", "noopener,noreferrer,width=600,height=600");
      }

      document.querySelectorAll(".share-menu-x.active")
        .forEach(m => m.classList.remove("active"));
      return;
    }

    // Click outside → close
    document.querySelectorAll(".share-menu-x.active")
      .forEach(m => m.classList.remove("active"));
  });

  window.addEventListener("scroll", () => {
    document.querySelectorAll(".share-menu-x.active")
      .forEach(m => m.classList.remove("active"));
  });
})();
</script>  