<!DOCTYPE html>
<html lang="en">


<head>
  <meta charset="UTF-8">
  <meta name="robots" content="index, follow">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <!-- SEO Title (55 chars) -->
  <title>Privacy Policy – How More News Protects Your Data</title>
  <meta name="title" content="Privacy Policy – How More News Protects Your Data">

  <!-- Meta Description (155 chars) -->
  <meta name="description"
    content="Read the Privacy Policy of More News to understand how we collect, use, store and protect personal data across our independent UK news platform.">

  <!-- Canonical -->
  <link rel="canonical" href="https://www.morenews.org/privacy-policy">

  <!-- Open Graph -->
  <meta property="og:title" content="Privacy Policy – How More News Protects Your Data">
  <meta property="og:description"
    content="Read the Privacy Policy of More News to understand how we collect, use, store and protect personal data across our independent UK news platform.">
  <meta property="og:url" content="https://www.morenews.org/privacy-policy">
  <meta property="og:image" content="https://www.morenews.org/images/morenews-about.webp">
  <meta property="og:site_name" content="More News">
  <meta property="og:type" content="website">
  <meta property="og:locale" content="en_GB">
  <meta property="og:image:width" content="1200">
  <meta property="og:image:height" content="630">

  <!-- Twitter Card -->
  <meta name="twitter:card" content="summary_large_image">
  <meta name="twitter:title" content="Privacy Policy – How More News Protects Your Data">
  <meta name="twitter:description"
    content="Read the Privacy Policy of More News to understand how we collect, use, store and protect personal data across our independent UK news platform.">
  <meta name="twitter:url" content="https://www.morenews.org/privacy-policy">
  <meta name="twitter:image" content="https://www.morenews.org/images/morenews-about.webp">
  <meta name="twitter:site" content="@morenews">
  <meta name="twitter:creator" content="@morenews">

  <!-- Fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@100..900&display=swap" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=UnifrakturMaguntia&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@100..900&family=Noto+Serif+JP:wght@200..900&display=swap" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@400..900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css"
        integrity="sha512-DxV+EoADOkOygM4IR9yXP8Sb2qwgidEmeqAEmDKIOfPRQZOWbXCzLC6vjbZyy0vPisbH2SyW27+ddLVCN+OMzQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />

  <!-- Styles -->
  <link rel="preload" href="css/style.css" as="style">
  <link rel="stylesheet" href="css/style.css">

  <!-- Favicon -->
  <link rel="shortcut icon" href="favicon.ico" type="image/x-icon">

  <!-- Schema -->
  <script type="application/ld+json">
  {
    "@context": "https://schema.org",
    "@graph": [
      {
        "@type": "WebSite",
        "@id": "https://www.morenews.org/#website",
        "url": "https://www.morenews.org/",
        "name": "More News"
      },
      {
        "@type": "NewsMediaOrganization",
        "@id": "https://www.morenews.org/#publisher",
        "name": "More News",
        "url": "https://www.morenews.org/",
        "logo": {
          "@type": "ImageObject",
          "url": "https://www.morenews.org/images/logo.webp",
          "width": 512,
          "height": 512
        },
        "address": {
          "@type": "PostalAddress",
          "addressCountry": "GB"
        }
      },
      {
        "@type": "WebPage",
        "@id": "https://www.morenews.org/privacy-policy#webpage",
        "url": "https://www.morenews.org/privacy-policy",
        "name": "Privacy Policy – How More News Protects Your Data",
        "description": "Read the Privacy Policy of More News to understand how we collect, use, store and protect personal data across our independent UK news platform.",
        "inLanguage": "en-GB",
        "isPartOf": {
          "@id": "https://www.morenews.org/#website"
        }
      }
    ]
  }
  </script>
</head>


<body>

  <!-- Header -->
  <?php include 'index-header.php'; ?>

  <div class="main-container">
    <section class="headline-rail">

        </section>

    <div class="story-wrapper">
      <div class="story-grid">

        <!-- MAIN CONTENT -->
        <div class="primary-feed">

          <!-- PAGE HEADER -->
          <div class="article-header">
            <div class="article-breadcrumb">
              <a href="index.php" title="home" class="crumb-link">Home</a> /
              <span class="crumb-current">Privacy Policy</span>
            </div>

            <h1 class="article-headline">Privacy Policy</h1>
          </div>

          <!-- HERO IMAGE -->
          <!-- <div class="image-wrapper">
            <img src="images/morenews-about.webp" alt="More News Privacy Policy">
          </div> -->

          <!-- POLICY CONTENT -->
          <div class="writer-block">
            <div class="story-text-wrap">

              <p><strong>Last Updated: November 2026</strong></p>

              <p>
                <strong>More News</strong> is an independent UK-based digital news publication.
                We value reader trust and are committed to transparency about how we collect,
                use, store, and protect personal information.
              </p>

              <h3>1. Scope of This Privacy Policy</h3>
              <p>
                This Privacy Policy applies to all users of More News, including readers who
                browse articles, subscribe to newsletters, submit forms, comment, or interact
                with advertising on our website.
              </p>

              <p>
                This policy does not apply to third-party websites, social media platforms,
                or services that link to or integrate with our content.
              </p>

              <h3>2. Information We Collect</h3>

              <p><strong>A. Information You Provide Directly</strong></p>
              <p>
                You may voluntarily provide personal information such as your name, email address,
                newsletter preferences, comments, or messages submitted through contact forms.
              </p>

              <p><strong>B. Information Collected Automatically</strong></p>
              <p>
                When you use our services, we automatically collect technical and usage data,
                including IP address, browser type, device information, operating system,
                pages viewed, time spent on pages, referral links, and interaction patterns.
              </p>

              <p><strong>C. Information from Third Parties</strong></p>
              <p>
                We may receive aggregated or anonymised data from analytics providers,
                advertising partners, or social media platforms when you interact with our content.
              </p>

              <h3>3. How We Use Information</h3>
              <p>
                We use collected information to operate and improve our services, publish and
                distribute journalism, analyse traffic and engagement, respond to enquiries,
                personalise content, prevent fraud, and comply with legal obligations.
              </p>

              <h3>4. Cookies and Tracking Technologies</h3>
              <p>
                More News uses cookies, pixels, and similar technologies to remember user
                preferences, analyse performance, measure engagement, and deliver relevant
                advertising. You may manage cookie preferences through your browser settings.
              </p>

              <h3>5. Analytics and Advertising</h3>
              <p>
                We use analytics tools such as Google Analytics to understand how users engage
                with our site. Advertising partners may use anonymised data to deliver
                interest-based advertisements.
              </p>

              <h3>6. Sharing Information</h3>
              <p>
                We do not sell personal information. We may share limited data with service
                providers, analytics partners, advertisers, or legal authorities when required
                by law or to protect users and our organisation.
              </p>

              <h3>7. Children’s Privacy</h3>
              <p>
                More News does not knowingly collect personal data from children under the age
                of 13. Any such information discovered will be deleted promptly.
              </p>

              <h3>8. External Links</h3>
              <p>
                Our site may contain links to external websites or third-party tools.
                We are not responsible for the privacy practices of those services.
              </p>

              <h3>9. Data Retention</h3>
              <p>
                We retain personal information only for as long as necessary to provide services,
                meet legal requirements, resolve disputes, and maintain security.
              </p>

              <h3>10. Data Security</h3>
              <p>
                We use appropriate technical and organisational safeguards to protect information.
                However, no digital system can be guaranteed to be completely secure.
              </p>

              <h3>11. International Users</h3>
              <p>
                More News operates primarily in the United Kingdom. Users accessing the site
                from outside the UK acknowledge that their data may be processed under UK
                data protection laws.
              </p>

              <h3>12. Changes to This Policy</h3>
              <p>
                This Privacy Policy may be updated periodically. Any changes will be reflected
                by the “Last Updated” date at the top of this page.
              </p>

              <h3>13. Contact Us</h3>
              <p>
                For privacy-related enquiries, please contact us at:<br>
                <strong>Email:</strong> privacy@morenews.co.uk
              </p>

            </div>
          </div>

        </div>

        <!-- SIDEBAR -->
        <div class="side-railbox">
          <br>
          <div class="side-adunit">
            <a href="https://www.venture-hive.com/" title="venture hive"><img src="images/venture-hive.webp"
                        alt="venture-hive"></a>
          </div>

          <div class="side-socialpanel">
            <h4>Follow Us</h4>
            <ul>
                        <a href="https://x.com/More_NewsMN" title="twitter"><i class="fa-brands fa-x-twitter" style="color: #000000;"></i></a>
                    <a href="https://www.instagram.com/morewnews_/" title="instagram"><img src="images/instagram.webp" alt="instagram" height="20px" width="20px"></a>
                        
                        <a href="https://www.quora.com/profile/More-News-6" title="quora"><i class="fa-brands fa-quora" style="color: #000000;"></i></i></a>
                        <a href="https://flipboard.com/@more_news" title="flipboard"><i class="fa-brands fa-flipboard" style="color: #000000;"></i></a>
                        <a href="https://medium.com/@more_news" title="medium"><img src="images/medium.webp" alt="medium" height="20px" width="20px"></i></i></a>
                        <a href="https://substack.com/@morenewsmn" title="substack"><img src="images/substack.webp" alt="substack" height="19px" width="19px"></a>
                    </ul>
          </div>
        </div>

      </div>
    </div>

    <?php include 'index-footer.php'; ?>

  </div>

  <button onclick="window.scrollTo({top:0, behavior:'smooth'});" class="scrollup-btn">
    <i class="fa-solid fa-chevron-up" aria-hidden="true"></i>
  </button>

  <script src="js/style.js"></script>

</body>
</html>
