<!DOCTYPE html>
<html lang="en">


<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Title -->
    <title>The OBR chair quits after an investigation into how the budget draft was sent out early</title>
    <meta name="title" content="The OBR chair quits after an investigation into how the budget draft was sent out early">

    <!-- Meta Description -->
    <meta name="description"
        content="Richard Hughes, head of the Office for Budget Responsibility, resigns following a major breach in budget publication before the Chancellor's announcement.">

        <meta name="author" content="Emily Hargreaves">
    <!-- Canonical -->
    <link rel="canonical"
        href="https://www.morenews.org/politics/the-obr-chair-quits-after-an-investigation-into-how-the-budget-draft-was-sent-out-early">

    <!-- Open Graph -->
    <meta property="og:title" content="The OBR chair quits after an investigation into how the budget draft was sent out early">
    <meta property="og:description"
        content="Richard Hughes resigns after the OBR accidentally published the government's budget forecasts early, causing major concerns.">
    <meta property="og:url"
        content="https://www.morenews.org/politics/the-obr-chair-quits-after-an-investigation-into-how-the-budget-draft-was-sent-out-early">
    <meta property="og:image"
        content="https://www.morenews.org/images/the-obr-chair-quits-after-an-investigation-into-how-the-budget-draft-was-sent-out-early-first-iamge.webp">
    <meta property="og:site_name" content="More News">
    <meta property="og:type" content="article">
    <meta property="og:locale" content="en_GB">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">

    <!-- Twitter Cards -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="The OBR chair quits after an investigation into how the budget draft was sent out early">
    <meta name="twitter:description"
        content="Richard Hughes resigns after the OBR accidentally published the government's budget forecasts early, causing major concerns.">
    <meta name="twitter:image"
        content="https://www.morenews.org/images/the-obr-chair-quits-after-an-investigation-into-how-the-budget-draft-was-sent-out-early-first-iamge.webp">
    <meta name="twitter:url"
        content="https://www.morenews.org/politics/the-obr-chair-quits-after-an-investigation-into-how-the-budget-draft-was-sent-out-early">
    <meta name="twitter:site" content="@morenews">
    <meta name="twitter:creator" content="@morenews">

    <!-- Fonts -->
    <link rel="preload" href="../css/style.css" as="style">
    <link rel="stylesheet" href="../css/style.css">

    <!-- Google Fonts Optimized -->
    <link rel="preload" href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" as="style">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" rel="stylesheet">

    <!-- Font Awesome (Optimized) -->
    <link rel="preload" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css" as="style">
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css"
          media="print"
          onload="this.media='all'">
    <noscript>
        <link rel="stylesheet"
              href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
    </noscript>


    <!-- Favicon -->
    <link rel="shortcut icon" href="../favicon.ico" type="image/x-icon">

    <!-- JSON-LD -->
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "WebSite",
      "@id": "https://www.morenews.org/#website",
      "url": "https://www.morenews.org/",
      "name": "More News"
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.morenews.org/#publisher",
      "name": "More News",
      "url": "https://www.morenews.org/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/logo.webp",
        "width": 512,
        "height": 512
      },
      "address": {
        "@type": "PostalAddress",
        "addressCountry": "GB"
      }
    },

    {
      "@type": "Person",
      "@id": "https://www.morenews.org/author/emily-hargreaves#author",
      "name": "Emily Hargreaves",
      "url": "https://www.morenews.org/author/emily-hargreaves",
      "jobTitle": "Political Correspondent",
      "worksFor": {
        "@id": "https://www.morenews.org/#publisher"
      }
    },

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.morenews.org/politics/the-obr-chair-quits-after-an-investigation-into-how-the-budget-draft-was-sent-out-early#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.morenews.org/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Politics",
          "item": "https://www.morenews.org/politics/politics"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "name": "The OBR chair quits after an investigation into how the budget draft was sent out early",
          "item": "https://www.morenews.org/politics/the-obr-chair-quits-after-an-investigation-into-how-the-budget-draft-was-sent-out-early"
        }
      ]
    },

    {
      "@type": "WebPage",
      "@id": "https://www.morenews.org/politics/the-obr-chair-quits-after-an-investigation-into-how-the-budget-draft-was-sent-out-early#webpage",
      "url": "https://www.morenews.org/politics/the-obr-chair-quits-after-an-investigation-into-how-the-budget-draft-was-sent-out-early",
      "name": "The OBR chair quits after an investigation into how the budget draft was sent out early",
      "description": "Richard Hughes, head of the Office for Budget Responsibility, resigns following a major breach in budget publication before the Chancellor's announcement.",
      "inLanguage": "en-GB",
      "isPartOf": {
        "@id": "https://www.morenews.org/#website"
      },
      "primaryImageOfPage": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/the-obr-chair-quits-after-an-investigation-into-how-the-budget-draft-was-sent-out-early-first-iamge.webp",
        "width": 1200,
        "height": 630
      },
      "breadcrumb": {
        "@id": "https://www.morenews.org/politics/the-obr-chair-quits-after-an-investigation-into-how-the-budget-draft-was-sent-out-early#breadcrumb"
      }
    },

    {
      "@type": "NewsArticle",
      "@id": "https://www.morenews.org/politics/the-obr-chair-quits-after-an-investigation-into-how-the-budget-draft-was-sent-out-early#article",
      "headline": "The OBR chair quits after an investigation into how the budget draft was sent out early",
      "description": "Richard Hughes resigns after the OBR accidentally published the government's budget forecasts early, causing major concerns.",
      "datePublished": "2025-12-02",
      "dateModified": "2025-12-02",
      "articleSection": "Politics",
      "inLanguage": "en-GB",
      "author": {
        "@id": "https://www.morenews.org/author/emily-hargreaves#author"
      },
      "publisher": {
        "@id": "https://www.morenews.org/#publisher"
      },
      "image": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/the-obr-chair-quits-after-an-investigation-into-how-the-budget-draft-was-sent-out-early-first-iamge.webp",
        "width": 1200,
        "height": 630
      },
      "mainEntityOfPage": {
        "@id": "https://www.morenews.org/politics/the-obr-chair-quits-after-an-investigation-into-how-the-budget-draft-was-sent-out-early#webpage"
      }
    }

  ]
}
</script>

<style>
  /* Apply styles to center the content */
.writer-block {
    font-family: "Noto Serif JP", serif;
  max-width: 540px;
  margin: 15px auto 10px auto;
  padding: 0px 0px;
  line-height: 1.7;
  color: #222;
}

/* Additional styles for mobile and desktop responsiveness */
.writer-date,
.writer-credit {
    margin-top: 10px;
    margin-bottom: 10px;
}

/* Optional: Adjustments for mobile view */
@media screen and (max-width: 768px) {
    .writer-block {
        padding: 10px;
    }
}

</style>
</head>


<body>

<!-- header -->
<?php include '../header.php'; ?>


    <div class="main-container">
        
        <section class="headline-rail">       
        </section>
        <div class="article-header">
            <h1 class="article-headline">
              The OBR chair quits after an investigation into how the budget draft was sent out early
            </h1>

            <div class="article-breadcrumb">
                <a href="../politics/politics.php" title="politics" class="crumb-link">Politics</a> ›
                <span class="crumb-current">The OBR chair quits after an investigation into how the budget draft was sent out early</span>
            </div>

            
            <!--socail icon-->
            <?php include '../social.php'; ?>
            <div class="writer-block">
            <div class="author-info">
                <?php include '../politics-author.php'; ?>
            </div>
            <div class="writer-date" itemprop="datePublished" content="2025-12-02">Published Date: 2 December 2025</div>
            </div>
            
        </div>
        <div class="image-wrapper">
            <img src="../images/the-obr-chair-quits-after-an-investigation-into-how-the-budget-draft-was-sent-out-early-first-iamge.webp" alt="The OBR chair quits after an investigation into how the budget draft was sent out early first image">
        </div>
        <div class="writer-block">
            

            <div class="story-text-wrap">
      
                <p>
                 Richard Hughes, the head of the Office for Budget Responsibility, quit after an internal investigation found that the watchdog had made one of the biggest mistakes in its history when it accidentally put the government's secret budget forecasts online before the Chancellor's announcement.
                 </p>

                <p>
                   The investigation found that a technical problem with the OBR's publication system made the whole economic outlook, including growth forecasts, tax assumptions, and budgetary estimates, public about an hour before Rachel Reeves's Budget presentation.The study says that this was the worst security breach since the OBR was set up in 2010.
                </p>
                <p>
                 Hughes said he had to leave to restore faith in the body's independence and integrity, and he took "full responsibility" for the mistake.  In a letter to the Chancellor and the Treasury Committee, he said that the early release had hurt people's faith in the budgeting process and caused unnecessary problems on a day when there were important financial changes.The Treasury confirmed that he had left and said that the search for a new person to take his place would begin right away.
                </p>
            </div>

        </div>
        <div class="image-wrapper">
            <img loading="lazy" src="../images/the-obr-chair-quits-after-an-investigation-into-how-the-budget-draft-was-sent-out-early-second-iamge.webp" alt="The OBR chair quits after an investigation into how the budget draft was sent out early second image">
        </div>
        <div class="writer-block">

            <div class="story-text-wrap">
                
                <p>
                 A WordPress feature that wasn't set up right caused the breach. This made the paper available to people outside of OBR through a live URL that OBR authorities thought was private.An investigation showed that the same security hole had led to an earlier, undetected breach in March, which raised more questions about the watchdog's own systems' reliability.
                <p>
                 Some people say that the leak made the government's plans for taxes and spending even less clear, which made political tensions worse before Reeves's first budget.  Opposition parties used the crisis to compare Hughes's resignation to Reeves's refusal to step down after being accused of lying about the state of public finances, a charge the government denies.
                </p>
            </div>

        </div>
        
        <div class="writer-block">
            <div class="story-text-wrap">
                
                <p>
                 Prime Minister Keir Starmer backed the Chancellor, saying that the OBR's mistake was "serious" but not related to government duty.  He stressed that fixing the structural problems with the fiscal watchdog is now a top priority.Hughes was supposed to talk to MPs about the budget forecasts, but he won't be going.  The OBR board has said that it will take steps right away to stop the problem from happening again.These steps include stricter publication protections and changes to how data is handled.
                </p>
            </div>

        </div>
        
        <div class="writer-block">
            
            <div class="suggested-box">
                <h3 class="suggested-heading">Politics</h3>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/angela-rayner-stressed-labours-commitment-to-workers-rights-from-the-start-first-image.webp"
                         alt="Angela Rayner stressed Labour's commitment to workers' rights from the start during major employment changes first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../politics/angela-rayner-stressed-labours-commitment-to-workers-rights-from-the-start.php" title="Angela Rayner will propose a change to expedite the workers' rights bill" class="suggested-title">Angela Rayner will propose a change to expedite the workers' rights bill</a>
                        <span class="suggested-date">2 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/despite-business-concerns-the-uk-will-move-forward-first-image.webp"
                         alt="Despite business concerns, the UK will move forward with the 2027 Carbon Border Tax first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../politics/despite-business-concerns-the-uk-will-move-forward-with-the-2027-carbon-border-tax.php" title="Despite business concerns, the UK will move forward with the 2027 Carbon Border Tax" class="suggested-title">Despite business concerns, the UK will move forward with the 2027 Carbon Border Tax</a>
                        <span class="suggested-date">4 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/watchdog-discovered-serious-shortcomings-in-vetting-and-misconduct-checks-first-image.webp" 
                        alt="watchdog discovered serious shortcomings in vetting and misconduct checks, Met Police is under increased scrutiny first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../politics/watchdog-discovered-serious-shortcomings-in-vetting-and-misconduct-checks.php" title="watchdog discovered serious shortcomings in vetting and misconduct checks, Met Police is under increased scrutiny" class="suggested-title">watchdog discovered serious shortcomings in vetting and misconduct checks, Met Police is under increased scrutiny</a>
                        <span class="suggested-date">4 December 2025</span>
                    </div>
                </div>
            </div>

            
        </div>
        
<!-- popular and other news -->
     <?php include '../popular-other-news.php'; ?>

<!-- footer -->
<?php include '../footer.php'; ?>

    </div>
    <button onclick="window.scrollTo({top:0, behavior:'smooth'});" class="scrollup-btn" aria-label="Scroll to top">
    <i class="fa-solid fa-chevron-up" aria-hidden="true"></i>
    </button>
    <!-- <script src="../js/style.js"></script> -->
</body>

</html>