<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Title (55 characters including spaces) -->
    <title>Burnham’s Return to Parliament Sparks Labour Divisions</title>
    <meta name="title" content="Burnham’s Return to Parliament Sparks Labour Divisions">

    <meta name="author" content="Emily Hargreaves">

    <!-- Meta Description (155 characters including spaces) -->
    <meta name="description" content="Keir Starmer’s allies launch a campaign to block Burnham’s return to Parliament amid Gorton by-election tensions. Will Burnham challenge Starmer’s leadership?">

    <!-- Canonical URL -->
    <link rel="canonical" href="https://www.morenews.org/politics/labour-struggles-gorton-by-election-burnham-starmer">

    <!-- Open Graph (Facebook) -->
    <meta property="og:title" content="Burnham’s Return to Parliament Sparks Labour Divisions">
    <meta property="og:description" content="Keir Starmer’s allies launch a campaign to block Burnham’s return to Parliament amid Gorton by-election tensions. Will Burnham challenge Starmer’s leadership?">
    <meta property="og:url" content="https://www.morenews.org/politics/labour-struggles-gorton-by-election-burnham-starmer">
    <meta property="og:image" content="https://www.morenews.org/images/labour-struggles-gorton-by-election-burnham-starmer.webp">
    <meta property="og:site_name" content="More News">
    <meta property="og:type" content="article">
    <meta property="og:locale" content="en_GB">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">

    <!-- Twitter Cards -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Burnham’s Return to Parliament Sparks Labour Divisions">
    <meta name="twitter:description" content="Keir Starmer’s allies launch a campaign to block Burnham’s return to Parliament amid Gorton by-election tensions. Will Burnham challenge Starmer’s leadership?">
    <meta name="twitter:image" content="https://www.morenews.org/images/labour-struggles-gorton-by-election-burnham-starmer.webp">
    <meta name="twitter:url" content="https://www.morenews.org/politics/labour-struggles-gorton-by-election-burnham-starmer">
    <meta name="twitter:site" content="@morenews">
    <meta name="twitter:creator" content="@morenews">

    <!-- Keywords (for SEO Ranking) -->
    <meta name="keywords" content="Gorton by-election, Burnham, Labour Party, Keir Starmer, Gorton politics, Burnham leadership challenge, Labour divisions">

    <!-- Fonts -->
    <link rel="preload" href="../css/style.css" as="style">
    <link rel="stylesheet" href="../css/style.css">

    <!-- Google Fonts -->
    <link rel="preload" href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" as="style">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" rel="stylesheet">

    <!-- Font Awesome -->
    <link rel="preload" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css" as="style">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css" media="print" onload="this.media='all'">
    <noscript><link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css"></noscript>

    <!-- Favicon -->
    <link rel="shortcut icon" href="../favicon.ico" type="image/x-icon">

    <!-- JSON-LD -->
    <script type="application/ld+json">
        {
            "@context": "https://schema.org",
            "@graph": [
                {
                    "@type": "WebSite",
                    "@id": "https://www.morenews.org/#website",
                    "url": "https://www.morenews.org/",
                    "name": "More News"
                },
                {
                    "@type": "NewsMediaOrganization",
                    "@id": "https://www.morenews.org/#publisher",
                    "name": "More News",
                    "url": "https://www.morenews.org/",
                    "logo": {
                        "@type": "ImageObject",
                        "url": "https://www.morenews.org/images/logo.webp",
                        "width": 512,
                        "height": 512
                    },
                    "address": {
                        "@type": "PostalAddress",
                        "addressCountry": "GB"
                    }
                },
                {
                    "@type": "Person",
                    "@id": "https://www.morenews.org/author/emily-hargreaves#author",
                    "name": "Emily Hargreaves",
                    "url": "https://www.morenews.org/author/emily-hargreaves",
                    "jobTitle": "Political Correspondent",
                    "worksFor": {
                        "@id": "https://www.morenews.org/#publisher"
                    }
                },
                {
                    "@type": "BreadcrumbList",
                    "@id": "https://www.morenews.org/politics/labour-struggles-gorton-by-election-burnham-starmer#breadcrumb",
                    "itemListElement": [
                        {
                            "@type": "ListItem",
                            "position": 1,
                            "name": "Home",
                            "item": "https://www.morenews.org/"
                        },
                        {
                            "@type": "ListItem",
                            "position": 2,
                            "name": "Politics",
                            "item": "https://www.morenews.org/politics/politics"
                        },
                        {
                            "@type": "ListItem",
                            "position": 3,
                            "name": "Burnham’s Potential Return to Parliament Sparks Labour Party Divisions",
                            "item": "https://www.morenews.org/politics/labour-struggles-gorton-by-election-burnham-starmer"
                        }
                    ]
                },
                {
                    "@type": "WebPage",
                    "@id": "https://www.morenews.org/politics/labour-struggles-gorton-by-election-burnham-starmer#webpage",
                    "url": "https://www.morenews.org/politics/labour-struggles-gorton-by-election-burnham-starmer",
                    "name": "Burnham’s Potential Return to Parliament Sparks Labour Party Divisions",
                    "description": "Keir Starmer’s allies launch a campaign to block Burnham’s return to Parliament amid Gorton by-election tensions. Will Burnham challenge Starmer’s leadership?",
                    "inLanguage": "en-GB",
                    "isPartOf": {
                        "@id": "https://www.morenews.org/#website"
                    },
                    "primaryImageOfPage": {
                        "@type": "ImageObject",
                        "url": "https://www.morenews.org/images/labour-struggles-gorton-by-election-burnham-starmer.webp",
                        "width": 1200,
                        "height": 630
                    },
                    "breadcrumb": {
                        "@id": "https://www.morenews.org/politics/labour-struggles-gorton-by-election-burnham-starmer#breadcrumb"
                    }
                },
                {
                    "@type": "NewsArticle",
                    "@id": "https://www.morenews.org/politics/labour-struggles-gorton-by-election-burnham-starmer#article",
                    "headline": "Burnham’s Potential Return to Parliament Sparks Labour Party Divisions",
                    "description": "Keir Starmer’s allies launch a campaign to block Burnham’s return to Parliament amid Gorton by-election tensions. Will Burnham challenge Starmer’s leadership?",
                    "datePublished": "2026-01-23",
                    "dateModified": "2026-01-23",
                    "articleSection": "Politics",
                    "inLanguage": "en-GB",
                    "author": {
                        "@id": "https://www.morenews.org/author/emily-hargreaves#author"
                    },
                    "publisher": {
                        "@id": "https://www.morenews.org/#publisher"
                    },
                    "image": {
                        "@type": "ImageObject",
                        "url": "https://www.morenews.org/images/labour-struggles-gorton-by-election-burnham-starmer.webp",
                        "width": 1200,
                        "height": 630
                    },
                    "mainEntityOfPage": {
                        "@id": "https://www.morenews.org/politics/labour-struggles-gorton-by-election-burnham-starmer#webpage"
                    }
                }
            ]
        }
    </script>

<style>
  /* Apply styles to center the content */
.writer-block {
    font-family: "Noto Serif JP", serif;
  max-width: 540px;
  margin: 15px auto 10px auto;
  padding: 0px 0px;
  line-height: 1.7;
  color: #222;
}

/* Additional styles for mobile and desktop responsiveness */
.writer-date,
.writer-credit {
    margin-top: 10px;
    margin-bottom: 10px;
}

/* Optional: Adjustments for mobile view */
@media screen and (max-width: 768px) {
    .writer-block {
        padding: 10px;
    }
}

</style>
</head>


<body>

<!-- header -->
<?php include '../header.php'; ?>


    <div class="main-container">
        
        <section class="headline-rail">       
        </section>
        <div class="article-header">
            <h1 class="article-headline">
               Burnham’s Potential Return to Parliament Sparks Labour Party Divisions

            </h1>

            <div class="article-breadcrumb">
                <a href="../politics/politics.php" title="politics" class="crumb-link">Politics</a> ›
                <span class="crumb-current"> Burnham’s Potential Return to Parliament Sparks Labour Party Divisions</span>
            </div>

            <!--socail icon-->
            <?php include '../social.php'; ?>
            <div class="writer-block">
            <div class="author-info">
                <?php include '../politics-author.php'; ?>
            </div>
            <div class="writer-date" itemprop="datePublished" content="2026-01-23">Published Date: 23 January 2026</div>
            </div>
            
        </div>
        <div class="image-wrapper">
            <img src="../images/labour-struggles-gorton-by-election-burnham-starmer.webp" alt="Burnham’s Potential Return to Parliament Sparks Labour Party Divisions first image">
        </div>
        <div class="writer-block">

            <div class="story-text-wrap">
                <?php include '../share.php'; ?>
                
                <p>
                 Keir Starmer's supporters have launched a "Stop Andy Burnham" campaign to prevent the Labour mayor from returning to parliament following a Manchester MP's resignation, which caused a by-election. Members of the Labour Party's ruling National Executive Committee (NEC) have expressed concern that Burnham may struggle to advance through the selection process due to the committee's large number of Starmer loyalists who want to avoid a leadership challenge.
                </p>

                <p>
                  According to reports, the NEC may vote to deny Burnham's candidacy, citing personal hostility as well as concerns about the financial pressure a Greater Manchester mayoral byelection would put on the party's finances. The party is concerned about the impact on Labour's finances and resources if Mayor Burnham calls a byelection to return to Parliament.
                </p>
                <p>
                  Burnham has been very open about wanting to go back to Parliament, and some people close to him think he will run against Starmer for leader if the chance comes up. Burnham's approval ratings are high, but Starmer's are falling. But Burnham's comeback would be very hard because he would need NEC sanction and to win the Gorton and Denton by-elections. Burnham will need the support of 80 Labour MPs to beat Starmer if he decides to run. Some Labour MPs don't believe Burnham's plans, even if he said he would only run for leader if it felt right.
                </p>
            </div>

        </div>
        <div class="image-wrapper">
            <img loading="lazy" src="../images/labour-struggles-gorton-by-election-burnham-starmer-si.webp" alt="Burnham’s Potential Return to Parliament Sparks Labour Party Divisions second image">
        </div>
        <div class="writer-block">

            <div class="story-text-wrap">
                <p>
                 There has been a lot of talk in the Labour Party about the Gorton and Denton by-election, which could let Andy Burnham return to Parliament. Burnham is still popular, but his campaign could make the party more divided and hurt its strategy before important elections. Someone might run against Keir Starmer for the leadership, but it's not clear if Burnham can get the support he needs to do so. The Labour Party is feeling the heat from both inside and outside the party as Reform UK and pro-Gaza independents gain ground in Gorton and Denton. If Burnham runs, he will have to deal with both the party's internal opposition and the growing threat from outside groups that want to take the seat away from Labour.
                </p>

                <p>
                  Starmer's friends primarily run the NEC, which has the power to uphold the party's selection process. People who support Burnham are worried that the NEC would make an all-female shortlist, which would mean that he can't run. The NEC is worried that Burnham's return could lead to a costly mayoral byelection in Greater Manchester, which would take resources away from other important contests.
                </p>
                <p>
                    Unions, which have a lot of power on the NEC, are now staying neutral, but people who know say they would be worried about any signs of interference from No. 10 in the nomination process. The Fire Brigades Union (FBU), a major player on the NEC, has publicly condemned any effort to stop Burnham from running, calling it a "democratic outrage" and pledging to fight any moves. Other Labour leaders have defended Burnham by saying that stopping him from running would cause a lot of problems within the party and make people think less of politics that are run from the top down.
                </p>
                <p>
                    Andrew Gwynne's resignation due to illness has resulted in a by-election in his constituency of Gorton and Denton, allowing Burnham to return to Parliament. Gwynne traditionally held the constituency with a substantial Labour majority, but the rise of Reform UK and pro-Gaza independents threatens Labour's control on the seat.
                </p>
                <p>
                    If Burnham runs, he will face stiff competition from Reform UK, which is expected to make a serious effort, leveraging support in the Tameside community. Burnham supporters claim that he is still one of Labour's most visible and popular characters, capable of uniting the party and challenging right-wing opponents like Nigel Farage in a way that Starmer cannot. A poll taken before Labour's conference last year found that Burnham would outperform Starmer, with 28% feeling Burnham would be a better Prime Minister than Starmer.
                </p>
            </div>
            <div class="story-text-wrap">
                <p>
                 If Burnham runs, he will face stiff competition from Reform UK, which is expected to make a serious effort, leveraging support in the Tameside community. Burnham supporters claim that he is still one of Labour's most visible and popular characters, capable of uniting the party and challenging right-wing opponents like Nigel Farage in a way that Starmer cannot. A poll taken before Labour's conference last year found that Burnham would outperform Starmer, with 28% feeling Burnham would be a better Prime Minister than Starmer.
                </p>

                <p>
                 His resignation forces a by-election in the constituency, which Labour won with a 13,000 majority in the last election. Gwynne's resignation from Parliament is expected to cause a ripple effect as Labour MPs and members consider a leadership challenge. It could be controversial who the next Labour candidate in Gorton and Denton is, especially if Starmer's friends get involved.
                </p>
                <p>
                   Friends of Sir Keir Starmer are worried that Burnham's return to Parliament could make the party unstable and waste resources, hurting Labour's chances in future elections. The NEC's role in picking the candidate for the by-election could become a point of contention, especially if it insists on an all-female shortlist, which would keep Burnham from running.
                </p>
                <h3 class="suggested-heading">Reform UK and Pro-Gaza Independents Challenge Labour’s Grip on Gorton and Denton</h3>
                <p>
                    Andrew Gwynne's resignation due to illness has resulted in a by-election in his constituency of Gorton and Denton, allowing Burnham to return to Parliament. Gwynne traditionally held the constituency with a substantial Labour majority, but the rise of Reform UK and pro-Gaza independents threatens Labour's control on the seat.
               Burnham's supporters have speculated that his return to Parliament could be a prelude to a future leadership bid against Starmer. However, such a challenge would require the support of 80 Labour MPs, which is questionable. Burnham has not ruled out running for president, but he insists that his current duty as mayor of Greater Manchester is his top priority. His political future remains uncertain, as many in the Labour Party regard him as one of the few personalities with the potential to revitalize the party.
Unions, especially the FBU, have come out strongly in favor of Burnham, saying that stopping him from running would cause a backlash and hurt Labour's democratic process. Left-wing Labour MPs have also backed Burnham, saying that rejecting his candidacy would hurt the party's democratic ideals and make divisions within the party worse. Labour is having a lot of trouble in Gorton and Denton because Reform UK is getting more popular there and pro-Gaza independents are coming out. If Burnham runs, he will have to deal with issues in his own party as well as issues in the world outside of politics. The NEC, for example, is likely to be against his candidacy.
Some Labour Party members want a new leader to improve the party's chances in future elections, which is why people are talking about Burnham possibly running against Starmer. But taking on such a challenge would be very dangerous and could hurt the party when it needs to be strong before important elections. Winning the next local and devolved elections is still the party's main goal, but Burnham's goals may make this harder.
 </p>

            </div>
        </div>


        
        <div class="writer-block">
            
            <div class="suggested-box">
                <h3 class="suggested-heading">Politics</h3>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/david-lammy-is-anticipated-to-modify-his-plans-to-eliminate-the-majority-of-jury-trials-first-image.webp" 
                    alt="David Lammy is anticipated to modify his plans to eliminate the majority of jury trials first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../politics/david-lammy-is-anticipated-to-modify-his-plans-to-eliminate-the-majority-of-jury-trials.php" title="David Lammy is anticipated to modify his plans to eliminate the majority of jury trials" class="suggested-title">David Lammy is anticipated to modify his plans to eliminate the majority of jury trials</a>
                        <span class="suggested-date">6 September 2021</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/the-obr-chair-quits-after-an-investigation-into-how-the-budget-draft-was-sent-out-early-first-iamge.webp" 
                        alt="The OBR chair quits after an investigation into how the budget draft was sent out early first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../politics/the-obr-chair-quits-after-an-investigation-into-how-the-budget-draft-was-sent-out-early.php"
                             title="The OBR chair quits after an investigation into how the budget draft was sent out early" class="suggested-title">The OBR chair quits after an investigation into how the budget draft was sent out early</a>
                        <span class="suggested-date">2 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/angela-rayner-stressed-labours-commitment-to-workers-rights-from-the-start-first-image.webp"
                         alt="Angela Rayner stressed Labour's commitment to workers' rights from the start during major employment changes first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../politics/angela-rayner-stressed-labours-commitment-to-workers-rights-from-the-start.php" title="Angela Rayner will propose a change to expedite the workers' rights bill" class="suggested-title">Angela Rayner will propose a change to expedite the workers' rights bill</a>
                        <span class="suggested-date">2 December 2025</span>
                    </div>
                </div>
            </div>

            
        </div>
        
<!-- popular and other news -->
     <?php include '../popular-other-news.php'; ?>

<!-- footer -->
<?php include '../footer.php'; ?>

    </div>
    <button onclick="window.scrollTo({top:0, behavior:'smooth'});" class="scrollup-btn" aria-label="Scroll to top">
    <i class="fa-solid fa-chevron-up" aria-hidden="true"></i>
    </button>
    <!-- <script src="../js/style.js"></script> -->
</body>

</html>