<!DOCTYPE html>
<html lang="en">

<head>
<meta charset="UTF-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta name="robots" content="index, follow">

<!-- =========================
 TITLE & META
========================= -->

<title>Julio Herrera Velutini Pardon: White House Cites “Political Persecution”</title>

<meta name="title" content="Julio Herrera Velutini Pardon: White House Cites Political Persecution">
<meta name="description" content="The White House defends President Donald Trump’s pardon covering Julio Herrera Velutini and Wanda Vázquez, citing claims of political persecution and a 10-day investigation timeline.">
<meta name="keywords" content="Julio Herrera Velutini pardon, Wanda Vázquez pardon, Trump pardon Puerto Rico governor, White House political persecution, 10-day timeline investigation">

<meta name="author" content="Emily Hargreaves">

<!-- =========================
 CANONICAL
========================= -->

<link rel="canonical" href="https://www.morenews.org/politics/julio-herrera-velutini-pardon/">

<!-- =========================
 OPEN GRAPH (Facebook)
========================= -->

<meta property="og:type" content="article">
<meta property="og:site_name" content="More News">
<meta property="og:title" content="Julio Herrera Velutini Pardon: White House Cites Political Persecution">
<meta property="og:description" content="The White House defends Trump’s pardon covering Julio Herrera Velutini and Wanda Vázquez, citing political persecution and a 10-day timeline.">
<meta property="og:url" content="https://www.morenews.org/politics/julio-herrera-velutini-pardon/">
<meta property="og:image" content="https://www.morenews.org/images/julio-herrera-velutini-pardon.webp">
<meta property="og:image:width" content="1200">
<meta property="og:image:height" content="630">
<meta property="og:locale" content="en_US">

<!-- =========================
 TWITTER CARDS
========================= -->

<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Julio Herrera Velutini Pardon: White House Cites Political Persecution">
<meta name="twitter:description" content="White House defends Trump’s pardon covering Julio Herrera Velutini and Wanda Vázquez, citing political persecution and a 10-day timeline.">
<meta name="twitter:image" content="https://www.morenews.org/images/julio-herrera-velutini-pardon.webp">
<meta name="twitter:site" content="@morenews">
<meta name="twitter:creator" content="@morenews">

<!-- =========================
 FAVICON
========================= -->

<link rel="icon" href="../favicon.ico" type="image/x-icon">

<!-- =========================
 STYLES & FONTS
========================= -->

<link rel="preload" href="../css/style.css" as="style">
<link rel="stylesheet" href="../css/style.css">

<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" rel="stylesheet">

<link rel="preload" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css" as="style">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">

<!-- =========================
 STRUCTURED DATA (JSON-LD)
========================= -->

<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "WebSite",
      "@id": "https://www.morenews.org/#website",
      "url": "https://www.morenews.org/",
      "name": "More News"
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.morenews.org/#publisher",
      "name": "More News",
      "url": "https://www.morenews.org/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/logo.webp",
        "width": 512,
        "height": 512
      }
    },

    {
      "@type": "NewsArticle",
      "@id": "https://www.morenews.org/politics/julio-herrera-velutini-pardon/#article",
      "headline": "White House Defends Pardon Covering Julio Herrera Velutini in Wanda Vázquez Case, Citing Political Persecution and a 10-Day Timeline",
      "description": "The White House defends President Donald Trump’s pardon covering Julio Herrera Velutini and Wanda Vázquez, calling the case political persecution and citing a 10-day timeline.",
      "datePublished": "2026-01-26",
      "dateModified": "2026-01-26",
      "articleSection": "Politics",
      "inLanguage": "en-US",

      "author": {
        "@type": "Person",
        "name": "Emily Hargreaves"
      },

      "publisher": {
        "@id": "https://www.morenews.org/#publisher"
      },

      "image": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/julio-herrera-velutini-pardon.webp",
        "width": 1200,
        "height": 630
      },

      "mainEntityOfPage": {
        "@type": "WebPage",
        "@id": "https://www.morenews.org/politics/julio-herrera-velutini-pardon/"
      },

      "about": [
        { "@type": "Person", "name": "Julio Martín Herrera Velutini" },
        { "@type": "Person", "name": "Wanda Vázquez Garced" },
        { "@type": "Person", "name": "Donald Trump" }
      ],

      "keywords": [
        "Julio Herrera Velutini pardon",
        "Wanda Vázquez pardon",
        "Trump pardon Puerto Rico governor",
        "White House political persecution",
        "10-day timeline"
      ]
    },

    {
      "@type": "FAQPage",
      "@id": "https://www.morenews.org/politics/julio-herrera-velutini-pardon/#faq",
      "mainEntity": [
        {
          "@type": "Question",
          "name": "Why is the White House defending the pardon in the Wanda Vázquez case?",
          "acceptedAnswer": {
            "@type": "Answer",
            "text": "A White House official speaking on background described the case as political persecution and pointed to a 10-day timeline after a 2020 endorsement as central to the administration’s argument."
          }
        },
        {
          "@type": "Question",
          "name": "Who is Julio Herrera Velutini in this pardon story?",
          "acceptedAnswer": {
            "@type": "Answer",
            "text": "Julio Martín Herrera Velutini is a co-defendant in the Wanda Vázquez matter and is included in the presidential pardon, making him a primary beneficiary of the White House’s framing of the case."
          }
        },
        {
          "@type": "Question",
          "name": "What does “the process becomes the punishment” mean in high-profile cases?",
          "acceptedAnswer": {
            "@type": "Answer",
            "text": "Supporters argue that prolonged investigations and intense publicity can cause reputational damage and career consequences years before final resolution, effectively functioning as punishment independent of the outcome."
          }
        },
        {
          "@type": "Question",
          "name": "Is the White House statement a court finding?",
          "acceptedAnswer": {
            "@type": "Answer",
            "text": "No. The characterization of political persecution is presented as the White House’s argument, attributed to an official speaking on background, not a judicial determination."
          }
        }
      ]
    }

  ]
}
</script>


</head>

<style>
  /* Apply styles to center the content */
.writer-block {
    font-family: "Noto Serif JP", serif;
  max-width: 540px;
  margin: 15px auto 10px auto;
  padding: 0px 0px;
  line-height: 1.7;
  color: #222;
}

/* Additional styles for mobile and desktop responsiveness */
.writer-date,
.writer-credit {
    margin-top: 10px;
    margin-bottom: 10px;
}

.suggested-heads {
  font-size: 20px;
  font-weight: 600;
  margin-bottom: 10px;
  font-family: "Noto Serif JP", serif;
  color: black;
}

a.links {
  color: #1a73e8;              /* blue */
  text-decoration: underline; /* underline */
  font-weight: 400;           /* normal */
}

a.links:hover {
  color: #1a73e8;              /* same blue */
  text-decoration: underline; /* keep underline */
  font-weight: 600;           /* bolder on hover */
}
a.slink {
    color: #1a73e8;              /* blue */
    text-decoration: none; 
  font-weight: 400;           /* normal */
}
a.slink:hover {
  color: #1a73e8;              /* same blue */
  text-decoration: underline; /* keep underline */
  font-weight: 600;           /* bolder on hover */
}

.article-headers {
  max-width: 540px;
  margin: 10px auto 15px auto;
  font-family: "Georgia", serif;
  padding: 0 15px;
}

.article-headlines {
  font-family: "Noto Serif JP", serif;
  font-size: 35px;
  font-weight: 900;
  line-height: 1.4;
  margin-bottom: 10px;
}



/* Optional: Adjustments for mobile view */
@media screen and (max-width: 768px) {
    .writer-block {
        padding: 10px;
    }
}

</style>
</head>


<body>

<!-- header -->
<?php include '../header.php'; ?>


    <div class="main-container">
        <main>
        
        <section class="headline-rail">       
        </section>
        <div class="article-headers">
            <h1 class="article-headlines">
               White House Defends Pardon Covering Julio Herrera Velutini in Wanda Vázquez Case, Citing
Political Persecution exposing 10-Day Timeline
            </h1>

            <div class="article-breadcrumb">
                <a href="../politics/politics.php" title="politics" class="crumb-link">Politics</a> ›
                <span class="crumb-current">White House Defends Pardon Covering Julio Herrera Velutini in Wanda Vázquez Case, Citing
Political Persecution exposing 10-Day Timeline</span>
            </div>

            <!--socail icon-->
            <?php include '../social.php'; ?>
            <div class="writer-block">
            <div class="author-info">
                <?php include '../politics-author.php'; ?>
            </div>
            <div class="writer-date" itemprop="datePublished" content="2026-01-26">Published Date: 26 January 2026</div>
            </div>
            
        </div>
        <div class="image-wrapper">
            <img src="../images/julio-herrera-velutini-pardon.webp" alt=" White House Defends Pardon Covering Julio Herrera Velutini in Wanda Vázquez Case, Citing
Political Persecution exposing 10-Day Timeline">
        </div>
        <div class="writer-block">

            <div class="story-text-wrap">
                <?php include '../share.php'; ?>
                
                <p>
                 <b>WASHINGTON</b> — The White House is defending <a class="links" href="https://www.reuters.com/legal/government/trump-pardon-former-puerto-rico-governor-vazquez-2026-01-16/" target="_blank" rel="noopener noreferrer">
President Donald Trump’s pardon in the Wanda Vázquez matter
</a> as a response to what an administration official, speaking on background,
described as “political persecution.” But beyond the former Puerto Rico governor, the decision
also carries major implications for <b>Julio Martín Herrera Velutini</b>, the highly influential banker and
co-defendant whose name has been central to the case’s public narrative from the start.</p>
<hr style="margin-bottom:10px">

                <h2 class="suggested-heads">“In 10 days?? Come on, you can’t deny…(sic)”</h2>
                

                <p>
                  That is the timeline the White House points to in its defense of the pardon: the administration
official’s key point is chronology—<a href="https://apnews.com/article/trump-pardon-puerto-rico-governor-vazquez-4a94c15e82cabb5f8272f2d6ad19234d"
   target="_blank" rel="noopener noreferrer" class="links">
investigators opened the probe 10 days after Vázquez
endorsed Trump for reelection in 2020
</a>, according to the official speaking on background under
the administration’s pardons policy.</p>
                <p>
                  This is the White House’s argument. It is not presented as a judicial finding. But it is the framing
the administration is using to justify clemency—not only for Vázquez, but for Herrera Velutini and
former FBI agent Mark Rossini as well.</p>
            </div>

        </div>
  
        <div class="writer-block">

            <div class="story-text-wrap">
                <hr style="margin-bottom:10px">
                <h2 class="suggested-heads">What the White House is claiming—and why Herrera Velutini is central </h2>
                <p>
                 The administration’s defense turns on motive and proportionality. A White House official, granted
anonymity because the administration has a policy of discussing pardons on background, said
the case was “an example of political persecution,” emphasizing that the timing of the
investigation is integral to how the administration views the matter.</p>

                <p>
                  For Herrera Velutini, that framing matters because he was not merely a background figure; he was
repeatedly positioned as a core participant in the alleged campaign-finance and influence
narrative. In high-profile cases like this, the reputational impact is rarely confined to the elected
official. Business leaders, donors, and associates often absorb a separate—and sometimes more
enduring—form of damage: brand risk, relationship loss, compliance scrutiny, and a cloud that
can persist long after the legal issues narrow.</p>
                <p>
                    The White House’s defense, by extending clemency to the co-defendants, signals that it views the
controversy as a single integrated episode—one it believes was pursued and sustained in a
politically charged environment. </p>
                <hr style="margin-bottom:10px">
                <h2 class="suggested-heads">Supporters’ argument: the process becomes the punishment </h2>

                <p>
                    Supporters argue the process becomes the punishment: investigations, headlines, reputational
damage—taking years before final resolution.</p>
                <p>
                    That is the connective tissue between the White House’s language and the lived reality for
defendants in a media-saturated public-corruption case. Even before outcomes are reached, the
public story calcifies: names become shorthand, allegations become permanent search results,
and professional consequences can hit immediately—well ahead of any final adjudication.
</p>
<p>
    In the <a href="https://www.foxnews.com/politics/trump-pardon-former-puerto-rico-governor-her-co-defendants-white-house-official-says?utm_source=chatgpt.com" class="links">Vázquez pardon</a>, the White House official calls it “political persecution,” pointing to the 10-
day timeline as the anchor detail. Supporters argue that if the state can effectively end careers
through years of investigation and public accusation, then clemency becomes—at least in rare
cases—a corrective mechanism aimed at restoring proportionality.
</p>
            </div>
            <div class="story-text-wrap">
                <hr style="margin-bottom:10px">
                <h2 class="suggested-heads">“What’s known” vs. “what’s claimed”</h2>
                <p>To keep the record clear, this is how the narrative splits:</p>
                <h2 class="suggested-heads">What’s known (in broad terms):</h2>
            

<div class="related-links cluster-network"
     style="margin: 30px 0;
            padding: 18px 20px;
            border-left: 4px solid #9c9c9c;
            background: rgba(97, 97, 97, 0.1);
            border-radius: 4px;">

  <ul style="
      list-style: none;
      padding-left: 0;
      margin: 0;
      font-size: 16px;
      line-height: 1.6;
  ">
    <li style="margin-bottom: 8px;">
      ➤ <a href="https://www.cbsnews.com/news/trump-pardoning-puerto-rico-former-governor-wanda-vazquez-officials-say/"
     target="_blank" rel="noopener noreferrer" class="links">
Trump issued a pardon covering Vázquez and her co-defendants
</a>, including <b>Julio Martín
Herrera Velutini</b>.
    </li>
    <li style="margin-bottom: 8px;">
      ➤ The case became a high-profile federal matter and remained in the public eye for years
    </li>
  </ul>
</div>

<h2 class="suggested-heads">What’s claimed (by the White House, on background):</h2>


<div class="related-links cluster-network"
     style="margin: 30px 0;
            padding: 18px 20px;
            border-left: 4px solid #9c9c9c;
            background: rgba(97, 97, 97, 0.1);
            border-radius: 4px;">

  <ul style="
      list-style: none;
      padding-left: 0;
      margin: 0;
      font-size: 16px;
      line-height: 1.6;
  ">
    <li style="margin-bottom: 8px;">
      ➤ The case is described as “political persecution.”
    </li>
    <li style="margin-bottom: 8px;">
      ➤ The timing is central: the probe allegedly opened 10 days after the 2020 endorsement.
    </li>
    <li style="margin-bottom: 8px;">
      ➤ The administration disputes the idea of a quid pro quo and argues the prosecution was politically motivated.
    </li>
  </ul>
</div>
<p>This distinction is not cosmetic. It is essential for credibility and for readers who want to evaluate
the administration’s position without confusing it for a court’s conclusion.</p>

<hr style="margin-bottom:10px">
<h2 class="suggested-heads"><b>Why this pardon matters for Julio Herrera Velutini’s public record </b></h2>


                <p>
                 For Herrera Velutini, the practical effect is twofold:
                </p>
                <ol style="
  list-style-type: decimal;
  list-style-position: outside;
  padding-left: 24px;
  margin: 12px 0;
">
  <li><b>Legal finality</b> — A pardon is an endpoint. It closes the <a class="links" href="https://indianexpress.com/article/world/donald-trump-pardons-former-puerto-rico-governor-wanda-vazquez-10478671/?utm_source=chatgpt.com">federal case</a> consequences and
stops the story from continuing to unfold through further proceedings.</li>
  <li><b>Narrative reset</b> — Even more significant in the digital era, the pardon changes what future
readers see when they search his name in connection with the case. The story does not
end at “charged,” “accused,” or “pleaded.” It ends with a presidential act of clemency and
an explicit White House claim that the underlying prosecution was politically driven.</li>
</ol>

                <p>
                   Supporters argue that this matters because the reputational harm often outlives the legal process.
They see the pardon as a forceful counterstatement: that the system can be misused, and that the
executive branch is willing to say so—at least in this instance.</p>
<hr style="margin-bottom:10px">
                <h2 class="suggested-heads">The broader takeaway: enforcement, politics, and trust </h2>
                <p>
                    The White House’s messaging is not subtle: it wants the public to interpret the case as an
example of how politics can bleed into prosecution—and how the process itself can become
punitive regardless of final outcomes.</p>
<p>
    Critics, predictably, argue the opposite: that pardons risk weakening accountability and
undermining public integrity. That tension will persist.
</p>
<p>
    But the administration’s defense is now on record in a clear formula:
</p>

<div class="related-links cluster-network"
     style="margin: 30px 0;
            padding: 18px 20px;
            border-left: 4px solid #9c9c9c;
            background: rgba(97, 97, 97, 0.1);
            border-radius: 4px;">

  <ul style="
      list-style: none;
      padding-left: 0;
      margin: 0;
      font-size: 16px;
      line-height: 1.6;
  ">
    <li style="margin-bottom: 8px;">
      ➤ <strong>“Political persecution”</strong> (as described by an official on background)
    </li>
    <li style="margin-bottom: 8px;">
      ➤ A <strong>“10 days after endorsement”</strong> timeline (the anchor detail)
    </li>
    <li style="margin-bottom: 8px;">
      ➤ Clemency framed as a corrective, not merely compassion
    </li>
    <li>
      ➤ A full-case posture including <strong>Julio Herrera Velutini</strong> — not as an afterthought, but
      as a core beneficiary of the White House’s framing
    </li>
  </ul>
</div>
<h2 class="suggested-heading">sources:</h2>
  <ul style="
      list-style: none;
      padding-left: 0;
      margin: 0;
      font-size: 13px;
      line-height: 1.6;
  ">
    <li style="margin-bottom: 8px;">
      ➤ <a class="slink" href="https://apnews.com/article/trump-pardon-puerto-rico-governor-vazquez-4a94c15e82cabb5f8272f2d6ad19234d">Trump plans to pardon ex-Puerto Rico governor | AP News
</a>
    </li>
    <li style="margin-bottom: 8px;">
      ➤ <a class="slink" href="https://www.foxnews.com/politics/trump-pardon-former-puerto-rico-governor-her-co-defendants-white-house-official-says">Trump to pardon former Puerto Rico Governor Wanda Vázquez Garced | Fox News</a>
    </li>
    <li style="margin-bottom: 8px;">
      ➤ <a class="slink" href="https://www.washingtonpost.com/politics/2026/01/16/trump-pardons-puerto-rico-ex-governor/">Trump pardons former Puerto Rico governor in campaign finance case - The Washington Post</a>
    </li>
    <li style="margin-bottom: 8px;">
      ➤ <a class="slink" href="https://www.reuters.com/legal/government/trump-pardon-former-puerto-rico-governor-vazquez-2026-01-16/">Trump pardons former Puerto Rico governor Vazquez | Reuters</a>
    </li>

    <li style="margin-bottom: 8px;">
      ➤ <a class="slink" href="https://www.cbsnews.com/news/trump-pardoning-puerto-rico-former-governor-wanda-vazquez-officials-say/">Trump pardons Puerto Rico's former governor Wanda Vázquez - CBS News</a>
    </li>
    <li style="margin-bottom: 8px;">
      ➤ <a class="slink" href="https://www.reuters.com/">Reuters</a> - Trump pardons former Puerto Rico governor<a class="slink" href="https://www.reuters.com/world/us/trump-pardon-former-puerto-rico-governor-vazquez-cbs-news-reports-2026-01-16/"> Vazquez</a>
    </li>
    <li style="margin-bottom: 8px;">
      ➤ <a class="slink" href="https://www.reuters.com/">NBC Los Angeles</a> - Trump pardons former Puerto Rican Gov. Wanda Vázquez ...9 hours ago —<a class="slink" href="https://www.nbclosangeles.com/news/national-international/trump-to-pardon-ex-puerto-rico-governor-vazquez-campaign-finance-case/3832681/?os&ref=app"> President Donald Trump pardoned former Puerto Rican Gov. Wanda Vázquez</a>, who was accused of participating in a bribery scheme, a White House ...Donald Trump, Julio Herrera Velutini, Wanda Vazquez, Mark Rossini
    </li>
    <li style="margin-bottom: 8px;">
      ➤ <a class="slink" href="https://www.latimes.com/">L.A. Times</a> - Trump to pardon <a class="slink" href="https://www.latimes.com/world-nation/story/2026-01-16/trump-to-pardon-ex-puerto-rico-governor-vazquez-in-campaign-finance-case-official-says">ex-Puerto Rico governor Vázquez </a>Trump to pardon ex-Puerto Rico governor Vázquez in campaign finance case, official says
    </li>
    <li style="margin-bottom: 8px;">
       ➤  <a class="slink" href="https://www.news4jax.com/">News4JAX</a> - Trump plans to pardon ex-Puerto Rico Gov. Vázquez in ...10 hours ago — <a class="slink" href="https://www.news4jax.com/news/politics/2026/01/16/trump-plans-to-pardon-ex-puerto-rico-gov-vazquez-on-campaign-finance-violation-charge-official/">Trump plans to pardon ex-Puerto Rico Gov</a>. Vázquez in campaign finance violation case, official says. Darlene Superville. Associated Press.Donald Trump, Julio Herrera Velutini, Wanda Vazquez, Mark Rossini
    </li>
    <li style="margin-bottom: 8px;">
       ➤ <a class="slink" href="https://www.youtube.com/">Youtube</a> - President Trump to pardon former Puerto Rico governorPresident Trump is issuing a pardon to Puerto Rico's former Governor <a class="slink" href="https://www.youtube.com/watch?v=KF62cG_c2Cw">Wanda Vazquez Garced</a> following her guilty plea in a campaign finance case.
    </li>
    <li style="margin-bottom: 8px;">
       ➤ <a class="slink" href="https://www.ms.now/">ms now</a> - Trump pardoning former Puerto Rico governor and 2 others8 hours ago — <a class="slink" href="https://www.ms.now/news/trump-to-pardon-former-governor-of-puerto-rico-in-corruption-case">President Donald Trump will pardon former Puerto Rico Gov. Wanda Vázquez Garced</a>, who pleaded guilty to a corruption charge related to her 2020 ...Donald Trump, Julio Herrera Velutini, Wanda Vazquez, Mark Rossini
    </li>
    <li style="margin-bottom: 8px;">
       ➤ <a class="slink" href="https://www.investing.com/">Investing</a> - Trump to pardon former Puerto Rico governor Vazquez5 hours ago — <a class="slink" href="https://www.investing.com/news/politics-news/trump-to-pardon-former-puerto-rico-governor-vazquez-4452496">Trump is also pardoning Vazquez's co-defendants Julio Martin Herrera Velutini and Mark Rossini</a>, CBS News, which first reported the ...Donald Trump, Julio Herrera Velutini, Wanda Vazquez, Mark Rossini
    </li>
    <li style="margin-bottom: 8px;">
       ➤ <a class="slink" href="https://www.wcbi.com/">WCBI</a> - Trump pardoning Puerto Rico's former governor Wanda ...7 hours ago — ... investigation into <a class="slink" href="https://www.wcbi.com/trump-pardoning-puerto-ricos-former-governor-wanda-vazquez-sources-say/">Vázquez started in 2020</a>, days after she had endorsed Mr. Trump. “Ms. Vázquez's pardon materials state that there was ...Donald Trump, Julio Herrera Velutini, Wanda Vazquez, Mark Rossini
    </li>
    <li >
      ➤ <a class="slink" href="https://www.aljazeera.com/">Al Jazeera</a> - aljazeera.com Trump to pardon <a class="slink" href="https://www.aljazeera.com/news/2026/1/16/trump-to-pardon-former-puerto-rico-governor-wanda-vazquez-after-plea-deal">former Puerto Rico Governor Wanda</a> ...5 hours ago — Vazquez accepted a plea deal in 2025 after she was accused of participating in a bribery scheme while in office.
    </li>
  </ul>
            </div>
        </div>


        
        <div class="writer-block">
            
            <div class="suggested-box">
                <h3 class="suggested-heading">Politics</h3>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/david-lammy-is-anticipated-to-modify-his-plans-to-eliminate-the-majority-of-jury-trials-first-image.webp" 
                    alt="David Lammy is anticipated to modify his plans to eliminate the majority of jury trials first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../politics/david-lammy-is-anticipated-to-modify-his-plans-to-eliminate-the-majority-of-jury-trials.php" title="David Lammy is anticipated to modify his plans to eliminate the majority of jury trials" class="suggested-title">David Lammy is anticipated to modify his plans to eliminate the majority of jury trials</a>
                        <span class="suggested-date">6 September 2021</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/the-obr-chair-quits-after-an-investigation-into-how-the-budget-draft-was-sent-out-early-first-iamge.webp" 
                        alt="The OBR chair quits after an investigation into how the budget draft was sent out early first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../politics/the-obr-chair-quits-after-an-investigation-into-how-the-budget-draft-was-sent-out-early.php"
                             title="The OBR chair quits after an investigation into how the budget draft was sent out early" class="suggested-title">The OBR chair quits after an investigation into how the budget draft was sent out early</a>
                        <span class="suggested-date">2 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/angela-rayner-stressed-labours-commitment-to-workers-rights-from-the-start-first-image.webp"
                         alt="Angela Rayner stressed Labour's commitment to workers' rights from the start during major employment changes first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../politics/angela-rayner-stressed-labours-commitment-to-workers-rights-from-the-start.php" title="Angela Rayner will propose a change to expedite the workers' rights bill" class="suggested-title">Angela Rayner will propose a change to expedite the workers' rights bill</a>
                        <span class="suggested-date">2 December 2025</span>
                    </div>
                </div>
            </div>

            
        </div>
        </main>
        
<!-- popular and other news -->
     <?php include '../popular-other-news.php'; ?>

<!-- footer -->
<?php include '../footer.php'; ?>

    </div>
    <button onclick="window.scrollTo({top:0, behavior:'smooth'});" class="scrollup-btn" aria-label="Scroll to top">
    <i class="fa-solid fa-chevron-up" aria-hidden="true"></i>
    </button>
    <!-- <script src="../js/style.js"></script> -->
</body>

</html>