<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Title -->
    <title>David Lammy Expected to Modify Plans on Jury Trials</title>
    <meta name="title" content="David Lammy Expected to Modify Plans on Jury Trials">

    <!-- Meta Description -->
    <meta name="description"
        content="Justice Secretary David Lammy is expected to soften proposals to limit jury trials following criticism from lawyers and senior politicians.">

        <meta name="author" content="Emily Hargreaves">
    <!-- Canonical -->
    <link rel="canonical"
        href="https://www.morenews.org/politics/david-lammy-is-anticipated-to-modify-his-plans-to-eliminate-the-majority-of-jury-trials">

    <!-- Open Graph -->
    <meta property="og:title" content="David Lammy Expected to Modify Plans on Jury Trials">
    <meta property="og:description"
        content="David Lammy is set to revise plans to curb jury trials after warnings that reforms could undermine confidence in the justice system.">
    <meta property="og:url"
        content="https://www.morenews.org/politics/david-lammy-is-anticipated-to-modify-his-plans-to-eliminate-the-majority-of-jury-trials">
    <meta property="og:image"
        content="https://www.morenews.org/images/david-lammy-is-anticipated-to-modify-his-plans-to-eliminate-the-majority-of-jury-trials-first-image.webp">
    <meta property="og:site_name" content="More News">
    <meta property="og:type" content="article">
    <meta property="og:locale" content="en_GB">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">

    <!-- Twitter Cards -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="David Lammy Expected to Modify Plans on Jury Trials">
    <meta name="twitter:description"
        content="Justice Secretary David Lammy is expected to revise proposals to limit jury trials after legal and political backlash.">
    <meta name="twitter:image"
        content="https://www.morenews.org/images/david-lammy-is-anticipated-to-modify-his-plans-to-eliminate-the-majority-of-jury-trials-first-image.webp">
    <meta name="twitter:url"
        content="https://www.morenews.org/politics/david-lammy-is-anticipated-to-modify-his-plans-to-eliminate-the-majority-of-jury-trials">
    <meta name="twitter:site" content="@morenews">
    <meta name="twitter:creator" content="@morenews">

    <!-- Fonts -->
    <link rel="preload" href="../css/style.css" as="style">
    <link rel="stylesheet" href="../css/style.css">

    <!-- Google Fonts Optimized -->
    <link rel="preload" href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" as="style">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" rel="stylesheet">

    <!-- Font Awesome (Optimized) -->
    <link rel="preload" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css" as="style">
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css"
          media="print"
          onload="this.media='all'">
    <noscript>
        <link rel="stylesheet"
              href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
    </noscript>

    <!-- Favicon -->
    <link rel="shortcut icon" href="../favicon.ico" type="image/x-icon">

    <!-- JSON-LD -->
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "WebSite",
      "@id": "https://www.morenews.org/#website",
      "url": "https://www.morenews.org/",
      "name": "More News"
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.morenews.org/#publisher",
      "name": "More News",
      "url": "https://www.morenews.org/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/logo.webp",
        "width": 512,
        "height": 512
      },
      "address": {
        "@type": "PostalAddress",
        "addressCountry": "GB"
      }
    },

    {
      "@type": "Person",
      "@id": "https://www.morenews.org/author/emily-hargreaves#author",
      "name": "Emily Hargreaves",
      "url": "https://www.morenews.org/author/emily-hargreaves",
      "jobTitle": "Political Correspondent",
      "worksFor": {
        "@id": "https://www.morenews.org/#publisher"
      }
    },

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.morenews.org/politics/david-lammy-is-anticipated-to-modify-his-plans-to-eliminate-the-majority-of-jury-trials#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.morenews.org/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Politics",
          "item": "https://www.morenews.org/politics/politics"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "name": "David Lammy Expected to Modify Plans on Jury Trials",
          "item": "https://www.morenews.org/politics/david-lammy-is-anticipated-to-modify-his-plans-to-eliminate-the-majority-of-jury-trials"
        }
      ]
    },

    {
      "@type": "WebPage",
      "@id": "https://www.morenews.org/politics/david-lammy-is-anticipated-to-modify-his-plans-to-eliminate-the-majority-of-jury-trials#webpage",
      "url": "https://www.morenews.org/politics/david-lammy-is-anticipated-to-modify-his-plans-to-eliminate-the-majority-of-jury-trials",
      "name": "David Lammy Expected to Modify Plans on Jury Trials",
      "description": "Justice Secretary David Lammy is expected to revise proposals to limit jury trials following criticism from the legal profession.",
      "inLanguage": "en-GB",
      "isPartOf": {
        "@id": "https://www.morenews.org/#website"
      },
      "primaryImageOfPage": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/david-lammy-is-anticipated-to-modify-his-plans-to-eliminate-the-majority-of-jury-trials-first-image.webp",
        "width": 1200,
        "height": 630
      },
      "breadcrumb": {
        "@id": "https://www.morenews.org/politics/david-lammy-is-anticipated-to-modify-his-plans-to-eliminate-the-majority-of-jury-trials#breadcrumb"
      }
    },

    {
      "@type": "NewsArticle",
      "@id": "https://www.morenews.org/politics/david-lammy-is-anticipated-to-modify-his-plans-to-eliminate-the-majority-of-jury-trials#article",
      "headline": "David Lammy Expected to Modify Plans on Jury Trials",
      "description": "David Lammy is expected to amend proposals to restrict jury trials amid warnings about justice and court backlogs.",
      "datePublished": "2025-12-02",
      "dateModified": "2025-12-02",
      "articleSection": "Politics",
      "inLanguage": "en-GB",
      "author": {
        "@id": "https://www.morenews.org/author/emily-hargreaves#author"
      },
      "publisher": {
        "@id": "https://www.morenews.org/#publisher"
      },
      "image": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/david-lammy-is-anticipated-to-modify-his-plans-to-eliminate-the-majority-of-jury-trials-first-image.webp",
        "width": 1200,
        "height": 630
      },
      "mainEntityOfPage": {
        "@id": "https://www.morenews.org/politics/david-lammy-is-anticipated-to-modify-his-plans-to-eliminate-the-majority-of-jury-trials#webpage"
      }
    }

  ]
}
</script>
<style>
  /* Apply styles to center the content */
.writer-block {
    font-family: "Noto Serif JP", serif;
  max-width: 540px;
  margin: 15px auto 10px auto;
  padding: 0px 0px;
  line-height: 1.7;
  color: #222;
}

/* Additional styles for mobile and desktop responsiveness */
.writer-date,
.writer-credit {
    margin-top: 10px;
    margin-bottom: 10px;
}

/* Optional: Adjustments for mobile view */
@media screen and (max-width: 768px) {
    .writer-block {
        padding: 10px;
    }
}

</style>

</head>


<body>

<!-- header -->
<?php include '../header.php'; ?>


    <div class="main-container">
        
        <section class="headline-rail">       
        </section>
        <div class="article-header">
            <h1 class="article-headline">
               David Lammy is anticipated to modify his plans to eliminate the majority of jury trials
            </h1>

            <div class="article-breadcrumb">
                <a href="../politics/politics.php" title="politics" class="crumb-link">Politics</a> ›
                <span class="crumb-current">David Lammy is anticipated to modify his plans to eliminate the majority of jury trials</span>
            </div>

            <!--socail icon-->
            <?php include '../social.php'; ?>
            <div class="writer-block">
            <div class="author-info">
                <?php include '../politics-author.php'; ?>
            </div>
            <div class="writer-date" itemprop="datePublished" content="2025-12-02">Published Date: 2 December 2025</div>
            </div>
            
        </div>
        <div class="image-wrapper">
            <img src="../images/david-lammy-is-anticipated-to-modify-his-plans-to-eliminate-the-majority-of-jury-trials-first-image.webp" alt="David Lammy is anticipated to modify his plans to eliminate the majority of jury trials first image">
        </div>
        <div class="writer-block">


            <div class="story-text-wrap">
                <p>
                  Justice Secretary David Lammy is getting ready to change plans that would have gotten rid of jury trials in most criminal cases because of concerns raised by well-known lawyers and cabinet members.
                </p>

                <p>
                  Lammy had been thinking about making a big change that would have made juries only available for the most serious crimes. However, he is now expected to follow the more cautious advice of former judge Sir Brian Leveson. That way, juries would still hear more serious cases, but magistrates or a new judge-only court division would hear "either-way" offenses with a possible sentence of three years or less.
                </p>
                <p>
                 The change in course comes at a time when there is more and more pressure to deal with what Lammy has called a "courts emergency," with the number of criminal cases waiting to be heard expected to reach 100,000. Ministers say that sending less serious cases to magistrates could make victims wait less time for trials.
                </p>
            </div>

        </div>
        <div class="image-wrapper">
            <img loading="lazy" src="../images/david-lammy-is-anticipated-to-modify-his-plans-to-eliminate-the-majority-of-jury-trials-second-image.webp" alt="David Lammy is anticipated to modify his plans to eliminate the majority of jury trials second image">
        </div>
        <div class="writer-block">

            <div class="story-text-wrap">
                
                <p>
                 The Criminal Bar Association, the Bar Council, and MPs have all spoken out against the idea of drastically lowering jury trials. They say that taking away defendants' long-standing right to a jury trial could make people lose faith in the legal system.</p>

                <p>
                  Before giving a speech to Parliament, Lammy said that he still strongly supported jury trials, but that changes were needed to keep the system from "grinding to a halt."
                </p>
            </div>

        </div>
        
        <div class="writer-block">
            <div class="story-text-wrap">
                
                <p>
                 Critics say that having more judge-only hearings could raise doubts about justice, especially for defendants who are weak or belong to a minority group. They also say that the government hasn't shown that limiting jury trials would significantly reduce the backlog.
                </p>

                <p>
                  Lammy is expected to present the updated ideas to MPs later this week.
                </p>
            </div>

        </div>
        
        <div class="writer-block">
            
            <div class="suggested-box">
                <h3 class="suggested-heading">Politics</h3>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/the-obr-chair-quits-after-an-investigation-into-how-the-budget-draft-was-sent-out-early-first-iamge.webp" 
                        alt="The OBR chair quits after an investigation into how the budget draft was sent out early first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../politics/the-obr-chair-quits-after-an-investigation-into-how-the-budget-draft-was-sent-out-early.php"
                             title="The OBR chair quits after an investigation into how the budget draft was sent out early" class="suggested-title">The OBR chair quits after an investigation into how the budget draft was sent out early</a>
                        <span class="suggested-date">2 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/angela-rayner-stressed-labours-commitment-to-workers-rights-from-the-start-first-image.webp"
                         alt="Angela Rayner stressed Labour's commitment to workers' rights from the start during major employment changes first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../politics/angela-rayner-stressed-labours-commitment-to-workers-rights-from-the-start.php" title="Angela Rayner will propose a change to expedite the workers' rights bill" class="suggested-title">Angela Rayner will propose a change to expedite the workers' rights bill</a>
                        <span class="suggested-date">2 December 2025</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/despite-business-concerns-the-uk-will-move-forward-first-image.webp"
                         alt="Despite business concerns, the UK will move forward with the 2027 Carbon Border Tax first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../politics/despite-business-concerns-the-uk-will-move-forward-with-the-2027-carbon-border-tax.php" title="Despite business concerns, the UK will move forward with the 2027 Carbon Border Tax" class="suggested-title">Despite business concerns, the UK will move forward with the 2027 Carbon Border Tax</a>
                        <span class="suggested-date">4 December 2025</span>
                    </div>
                </div>
            </div>

            
        </div>
        
<!-- popular and other news -->
     <?php include '../popular-other-news.php'; ?>

<!-- footer -->
<?php include '../footer.php'; ?>

    </div>
    <button onclick="window.scrollTo({top:0, behavior:'smooth'});" class="scrollup-btn" aria-label="Scroll to top">
    <i class="fa-solid fa-chevron-up" aria-hidden="true"></i>
    </button>
    <!-- <script src="../js/style.js"></script> -->
</body>

</html>