<!DOCTYPE html>
<html lang="en">



<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Title -->
    <title>ECHR Challenges UK Decision on Shamima Begum Citizenship</title>
    <meta name="title" content="ECHR Challenges UK Decision on Shamima Begum Citizenship">

    <!-- Meta Description -->
    <meta name="description"
        content="The European Court of Human Rights examines the UK’s decision to remove Shamima Begum’s citizenship, raising questions over security, justice and human rights.">

        <meta name="author" content="Daniel Rowcroft">
    <!-- Canonical -->
    <link rel="canonical"
        href="https://www.morenews.org/investigation/echr-challenges-uk-shamima-begum-citizenship">

    <!-- Open Graph -->
    <meta property="og:title" content="ECHR Challenges UK Decision on Shamima Begum Citizenship">
    <meta property="og:description"
        content="ECHR reviews the UK’s removal of Shamima Begum’s citizenship, reopening debate on national security and human rights obligations.">
    <meta property="og:url"
        content="https://www.morenews.org/investigation/echr-challenges-uk-shamima-begum-citizenship">
    <meta property="og:image"
        content="https://www.morenews.org/images/echr-challenges-uk-shamima-begum-citizenship.webp">
    <meta property="og:site_name" content="More News">
    <meta property="og:type" content="article">
    <meta property="og:locale" content="en_GB">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">

    <!-- Twitter Cards -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="ECHR Challenges UK Decision on Shamima Begum Citizenship">
    <meta name="twitter:description"
        content="The ECHR examines the UK’s decision to strip Shamima Begum of citizenship, raising questions over law, security and rights.">
    <meta name="twitter:image"
        content="https://www.morenews.org/images/echr-challenges-uk-shamima-begum-citizenship.webp">
    <meta name="twitter:url"
        content="https://www.morenews.org/investigation/echr-challenges-uk-shamima-begum-citizenship">
    <meta name="twitter:site" content="@morenews">
    <meta name="twitter:creator" content="@morenews">

    <!-- Fonts -->
    <link rel="preload" href="../css/style.css" as="style">
    <link rel="stylesheet" href="../css/style.css">

    <!-- Google Fonts Optimized -->
    <link rel="preload" href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" as="style">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" rel="stylesheet">

    <!-- Font Awesome (Optimized) -->
    <link rel="preload" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css" as="style">
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css"
          media="print"
          onload="this.media='all'">
    <noscript>
        <link rel="stylesheet"
              href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
    </noscript>

    <!-- Favicon -->
    <link rel="shortcut icon" href="../favicon.ico" type="image/x-icon">

    <!-- JSON-LD -->
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "WebSite",
      "@id": "https://www.morenews.org/#website",
      "url": "https://www.morenews.org/",
      "name": "More News"
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.morenews.org/#publisher",
      "name": "More News",
      "url": "https://www.morenews.org/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/logo.webp",
        "width": 512,
        "height": 512
      },
      "address": {
        "@type": "PostalAddress",
        "addressCountry": "GB"
      }
    },

    {
      "@type": "Person",
      "@id": "https://www.morenews.org/author/daniel-rowcroft.php#author",
      "name": "Daniel Rowcroft",
      "url": "https://www.morenews.org/author/daniel-rowcroft.php",
      "jobTitle": "Investigations Correspondent",
      "worksFor": {
        "@id": "https://www.morenews.org/#publisher"
      }
    },

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.morenews.org/investigation/echr-challenges-uk-shamima-begum-citizenship.php#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.morenews.org/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Investigation",
          "item": "https://www.morenews.org/investigation/investigation.php"
        },
        {
          "@type": "ListItem",
          "position": 3,
          "name": "ECHR Challenges UK Decision on Shamima Begum Citizenship",
          "item": "https://www.morenews.org/investigation/echr-challenges-uk-shamima-begum-citizenship.php"
        }
      ]
    },

    {
      "@type": "WebPage",
      "@id": "https://www.morenews.org/investigation/echr-challenges-uk-shamima-begum-citizenship.php#webpage",
      "url": "https://www.morenews.org/investigation/echr-challenges-uk-shamima-begum-citizenship.php",
      "name": "ECHR Challenges UK Decision on Shamima Begum Citizenship",
      "description": "The European Court of Human Rights examines the UK’s decision to revoke Shamima Begum’s citizenship.",
      "inLanguage": "en-GB",
      "isPartOf": {
        "@id": "https://www.morenews.org/#website"
      },
      "primaryImageOfPage": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/echr-challenges-uk-shamima-begum-citizenship.webp",
        "width": 1200,
        "height": 630
      },
      "breadcrumb": {
        "@id": "https://www.morenews.org/investigation/echr-challenges-uk-shamima-begum-citizenship.php#breadcrumb"
      }
    },

    {
      "@type": "NewsArticle",
      "@id": "https://www.morenews.org/investigation/echr-challenges-uk-shamima-begum-citizenship.php#article",
      "headline": "ECHR Challenges UK Decision on Shamima Begum Citizenship",
      "description": "The ECHR reviews the UK’s removal of Shamima Begum’s citizenship, raising fresh questions over security and human rights.",
      "datePublished": "2026-01-06",
      "dateModified": "2026-01-06",
      "articleSection": "Investigation",
      "inLanguage": "en-GB",
      "author": {
        "@id": "https://www.morenews.org/author/daniel-rowcroft.php#author"
      },
      "publisher": {
        "@id": "https://www.morenews.org/#publisher"
      },
      "image": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/echr-challenges-uk-shamima-begum-citizenship.webp",
        "width": 1200,
        "height": 630
      },
      "mainEntityOfPage": {
        "@id": "https://www.morenews.org/investigation/echr-challenges-uk-shamima-begum-citizenship.php#webpage"
      }
    }

  ]
}
</script>

<style>
  /* Apply styles to center the content */
.writer-block {
    font-family: "Noto Serif JP", serif;
  max-width: 540px;
  margin: 15px auto 10px auto;
  padding: 0px 0px;
  line-height: 1.7;
  color: #222;
}

/* Additional styles for mobile and desktop responsiveness */
.writer-date,
.writer-credit {
    margin-top: 10px;
    margin-bottom: 10px;
}

/* Optional: Adjustments for mobile view */
@media screen and (max-width: 768px) {
    .writer-block {
        padding: 10px;
    }
}

</style>

</head>


<body>

<!-- header -->
<?php include '../header.php'; ?>


    <div class="main-container">
        
        <section class="headline-rail">       
        </section>
        <div class="article-header">
            <h1 class="article-headline">
               Police Scotland Seize £80m in Drugs in Major Crime Crackdown
            </h1>

            <div class="article-breadcrumb">
                <a href="../investigation/investigation.php" title="investigation" class="crumb-link">Investigation</a> ›
                <span class="crumb-current">Police Scotland Seize £80m in Drugs in Major Crime Crackdown</span>
            </div>

            <!--socail icon-->
            <?php include '../social.php'; ?>
            <div class="writer-block">
            <div class="author-info">
                <?php include '../investigation-author.php'; ?>
            </div>
            <div class="writer-date" itemprop="datePublished" content="2026-01-06">Published Date: 6 December 2026</div>
            </div>
            
        </div>
        <div class="image-wrapper">
            <img src="../images/police-scotland-seize-80m-drugs-organised-crime-crackdown.webp" alt="Police Scotland Seize £80m in Drugs in Major Crime Crackdown">
        </div>
        <div class="writer-block">
            

            <div class="story-text-wrap">
                
                <p>
                   Police Scotland has carried out one of the biggest anti-drug operations in the country's history as part of a statewide effort to fight organized crime. They seized about £80 million worth of illegal drugs.
                  </p>

                <p>
                 After months of focused intelligence-led operations aimed at taking down major and organized crime gangs in Scotland, the number of seizures was confirmed at the end of the year. Officers say that the action has broken up a number of criminal networks that were involved in the large-scale drug trade and led to many arrests.
                </p>
                <p>
                  The operation took a lot of cocaine, cannabis, and other illegal drugs off the market. Senior officers said this was a big blow to organized crime. In addition to large amounts of Class A drugs being sent to communities across the country, several valuable cannabis farms were also found.
                </p>
                <p>
                    Police Scotland says that the crackdown was part of ongoing enforcement efforts all year long, not just one operation. To keep an eye on supply routes, find key people, and take assets linked to criminal groups, investigators worked with specialized teams.
                  </p>
            </div>

        </div>
        <div class="image-wrapper">
            <img loading="lazy" src="../images/police-scotland-seize-80m-drugs-organised-crime-crackdown-second-image.webp" alt="Police Scotland Seize £80m in Drugs in Major Crime Crackdown second image">
        </div>
        <div class="writer-block">

            <div class="story-text-wrap">
                

                <p>
                    Detectives say that the size of the seizures shows that organized crime is still a threat and that long-term policing strategies work. A high-ranking officer said, "Every seizure means drugs that won't get to our streets and criminals who will face justice."
                  </p>
                <p>
                     As part of the operation, officers used their authority to seize money, cars, and other things that were connected to illegal activities. They also went after the gangs' financial networks. Police say that cutting off illegal income is very important for making organized groups weaker over time.
                    </p>
                    <p>
                        Community leaders have praised the raid, saying that it shows that organized crime won't be allowed. Police did say, though, that enforcement alone isn't enough to solve the problem. They stressed the need for ongoing funding for support, education, and prevention programs.
                    </p>
                    <p>
                      The £80 million figure is one of the largest amounts ever recorded in a single year in Scotland, based on the estimated street value of the drugs that were seized. Police Scotland says that more charges are likely to come as investigations and arrests go on.
                    </p>
            </div>

        </div>


        
        <div class="writer-block">
            
            <div class="suggested-box">
                <h3 class="suggested-heading">Investigation</h3>

                <div class="suggested-item">
                    <img loading="lazy" src="../images/echr-challenges-uk-shamima-begum-citizenship.webp"
                         alt="Despite business concerns, the UK will move forward with the 2027 Carbon Border Tax first image" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../investigation/echr-challenges-uk-shamima-begum-citizenship.php" title="ECHR Challenges UK Decision on Shamima Begum Citizenship" class="suggested-title">ECHR Challenges UK Decision on Shamima Begum Citizenship</a>
                        <span class="suggested-date">6 January 2026</span>
                    </div>
                </div>

                <div class="suggested-item">
                    <img loading="lazy" src="../julio-herrera-velutini/images/julio-herrera-velutini-public-record-examination-global-banking-oversight-legal-review.webp"
                         alt="Julio Herrera Velutini: Public-Record Examination of Global Banking Oversight & Legal Review" class="suggested-thumb">
                    <div class="suggested-text">
                        <a href="../investigation/julio-herrera-velutini-public-record-examination-global-banking-oversight-legal-review.php" title="Julio Herrera Velutini: Public-Record Examination of Global Banking Oversight & Legal Review" class="suggested-title">Julio Herrera Velutini: Public-Record Examination of Global Banking Oversight & Legal Review</a>
                        <span class="suggested-date">9 January 2026</span>
                    </div>
                </div>

                
            </div>

            
        </div>
        
<!-- popular and other news -->
     <?php include '../popular-other-news.php'; ?>

<!-- footer -->
<?php include '../footer.php'; ?>


    </div>
    <button onclick="window.scrollTo({top:0, behavior:'smooth'});" class="scrollup-btn" aria-label="Scroll to top">
    <i class="fa-solid fa-chevron-up" aria-hidden="true"></i>
    </button>
    <!-- <script src="../js/style.js"></script> -->
</body>

</html>