<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- SEO -->
    <title>Investigation News – UK Inquiries, Law & Accountability</title>
    <meta name="title" content="Investigation News – UK Inquiries, Law & Accountability">

    <!-- Meta Description -->
    <meta name="description"
        content="In-depth UK investigation news covering public inquiries, legal cases, corruption probes and accountability reporting.">

    <!-- Canonical -->
    <link rel="canonical" href="https://www.morenews.org/investigation/investigation">

    <!-- Open Graph -->
    <meta property="og:title" content="Investigation News – UK Inquiries, Law & Accountability">
    <meta property="og:description"
        content="In-depth UK investigation news covering public inquiries, legal cases, corruption probes and accountability reporting.">
    <meta property="og:url" content="https://www.morenews.org/investigation/investigation">
    <meta property="og:image" content="https://www.morenews.org/images/logo.webp">
    <meta property="og:site_name" content="More News">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_GB">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">

    <!-- Twitter Cards -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Investigation News – UK Inquiries, Law & Accountability">
    <meta name="twitter:description"
        content="In-depth UK investigation reporting on public inquiries, courts, corruption and accountability.">
    <meta name="twitter:url" content="https://www.morenews.org/investigation/investigation">
    <meta name="twitter:image" content="https://www.morenews.org/images/logo.webp">
    <meta name="twitter:site" content="@morenews">
    <meta name="twitter:creator" content="@morenews">

    <!-- Fonts -->
    <link rel="preload" href="../css/style.css" as="style">
    <link rel="stylesheet" href="../css/style.css">

    <!-- Google Fonts Optimized -->
    <link rel="preload" href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" as="style">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@300;400;500;700&family=Noto+Serif+JP:wght@400;700&display=swap" rel="stylesheet">

    <!-- Font Awesome (Optimized) -->
    <link rel="preload" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css" as="style">
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css"
          media="print"
          onload="this.media='all'">
    <noscript>
        <link rel="stylesheet"
              href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.0/css/all.min.css">
    </noscript>

    <!-- Favicon -->
    <link rel="shortcut icon" href="../favicon.ico" type="image/x-icon">

    <!-- JSON-LD -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [

    {
      "@type": "WebSite",
      "@id": "https://www.morenews.org/#website",
      "url": "https://www.morenews.org/",
      "name": "More News",
      "publisher": {
        "@id": "https://www.morenews.org/#publisher"
      }
    },

    {
      "@type": "NewsMediaOrganization",
      "@id": "https://www.morenews.org/#publisher",
      "name": "More News",
      "url": "https://www.morenews.org/",
      "logo": {
        "@type": "ImageObject",
        "url": "https://www.morenews.org/images/logo.webp",
        "width": 512,
        "height": 512
      }
    },

    {
      "@type": "BreadcrumbList",
      "@id": "https://www.morenews.org/investigation/investigation#breadcrumb",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "https://www.morenews.org/"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Investigation",
          "item": "https://www.morenews.org/investigation/investigation"
        }
      ]
    },

    {
      "@type": "CollectionPage",
      "@id": "https://www.morenews.org/investigation/investigation#collection",
      "name": "Investigation News – UK Inquiries, Law & Accountability",
      "description": "In-depth UK investigation news covering public inquiries, legal cases, corruption probes and accountability reporting.",
      "url": "https://www.morenews.org/investigation/investigation",
      "inLanguage": "en-GB",
      "isPartOf": {
        "@id": "https://www.morenews.org/#website"
      }
    },

    {
      "@type": "WebPage",
      "@id": "https://www.morenews.org/investigation/investigation#webpage",
      "url": "https://www.morenews.org/investigation/investigation",
      "name": "Investigation News – UK Inquiries, Law & Accountability",
      "description": "Latest UK investigation news covering courts, public inquiries and accountability journalism.",
      "inLanguage": "en-GB",
      "breadcrumb": {
        "@id": "https://www.morenews.org/investigation/investigation#breadcrumb"
      },
      "isPartOf": {
        "@id": "https://www.morenews.org/#website"
      }
    },

    {
      "@type": "ItemList",
      "@id": "https://www.morenews.org/investigation/investigation#itemlist",
      "name": "Investigation Category Articles",
      "itemListOrder": "http://schema.org/ItemListOrderDescending",
      "itemListElement": [

        {
          "@type": "ListItem",
          "position": 1,
          "url": "https://www.morenews.org/investigation/echr-challenges-uk-shamima-begum-citizenship",
          "name": "ECHR Challenges UK Decision on Shamima Begum Citizenship"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "url": "https://www.morenews.org/investigation/police-scotland-seize-80m-drugs-organised-crime-crackdown",
          "name": "Police Scotland Seize £80m in Drugs in Major Crime Crackdown"
        }
        ,
        {
          "@type": "ListItem",
          "position": 3,
          "url": "https://www.morenews.org/investigation/julio-herrera-velutini-public-record-examination-global-banking-oversight-legal-review.php",
          "name": "Julio Herrera Velutini: Public-Record Examination of Global Banking Oversight & Legal Review"
        }

      ]
    }

  ]
}
</script>


</head>


<body>

<!-- header -->
<?php include '../header.php'; ?>

    <div class="main-container">

        <section class="headline-rail">

        </section> 
        <div class="world-header-shell">
            <div class="world-headline-box">
                <h1 class="world-headline-text">Investigation</h1>
            </div>
        </div>
        <div class="news-wrapper-unique">
            <div class="news-grid-unique">

                <div class="main-article-unique">
                    <img src="../images/echr-challenges-uk-shamima-begum-citizenship.webp" alt="ECHR Challenges UK Decision on Shamima Begum Citizenship">
                    <div class="main-sec">
                        <h2><a href="../investigation/echr-challenges-uk-shamima-begum-citizenship.php" title="ECHR Challenges UK Decision on Shamima Begum Citizenship">ECHR Challenges UK Decision on Shamima Begum Citizenship</a></h2>
                        <div class="main-article-meta">
                            <span>Investigation</span> | <span>Daniel Rowcroft</span>
                        </div>
                    </div>
                </div>
                

                <div class="side-articles-unique">

                    <div class="side-article-unique">
                        <div class="side-article-text">
                            <h3><a href="../investigation/police-scotland-seize-80m-drugs-organised-crime-crackdown.php"
                             title="Police Scotland Seize £80m in Drugs in Major Crime Crackdown" class="title-link">Police Scotland Seize £80m in Drugs in Major Crime Crackdown</a></h3>
                            
                            <div class="side-meta"><span>Investigation</span> Daniel Rowcroft</div>
                        </div>
                        <img src="../images/police-scotland-seize-80m-drugs-organised-crime-crackdown.webp" 
                        alt="Police Scotland Seize £80m in Drugs in Major Crime Crackdown">
                    </div>

                    <div class="side-article-unique">
                        <div class="side-article-text">
                            <h3><a href="../investigation/julio-herrera-velutini-public-record-examination-global-banking-oversight-legal-review.php"
                             title="Julio Herrera Velutini: Public-Record Examination of Global Banking Oversight & Legal Review" class="title-link">Julio Herrera Velutini: Public-Record Examination of Global Banking Oversight & Legal Review</a></h3>
                             
                            <div class="side-meta"><span>Investigation</span> Daniel Rowcroft</div>
                        </div>
                        <img src="../julio-herrera-velutini/images/julio-herrera-velutini-public-record-examination-global-banking-oversight-legal-review.webp" 
                        alt="Julio Herrera Velutini: Public-Record Examination of Global Banking Oversight & Legal Review">
                    </div>

                     
                   
                    
 
                </div>
            </div>
        </div>


        


        <!-- footer -->
        <?php include '../footer.php'; ?>


    </div>
    <button onclick="window.scrollTo({top:0, behavior:'smooth'});" class="scrollup-btn" aria-label="Scroll to top">
    <i class="fa-solid fa-chevron-up" aria-hidden="true"></i>
    </button>
    <!-- <script src="../js/style.js"></script> -->
</body>

</html>